/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.asm.AnnotationVisitor;
import org.apache.hadoop.shaded.org.mockito.asm.Attribute;
import org.apache.hadoop.shaded.org.mockito.asm.ClassAdapter;
import org.apache.hadoop.shaded.org.mockito.asm.ClassReader;
import org.apache.hadoop.shaded.org.mockito.asm.ClassVisitor;
import org.apache.hadoop.shaded.org.mockito.asm.FieldVisitor;
import org.apache.hadoop.shaded.org.mockito.asm.MethodVisitor;
import org.apache.hadoop.shaded.org.mockito.asm.Type;
import org.apache.hadoop.shaded.org.mockito.asm.tree.ClassNode;
import org.apache.hadoop.shaded.org.mockito.asm.tree.MethodNode;
import org.apache.hadoop.shaded.org.mockito.asm.tree.TryCatchBlockNode;
import org.apache.hadoop.shaded.org.mockito.asm.tree.analysis.Analyzer;
import org.apache.hadoop.shaded.org.mockito.asm.tree.analysis.Frame;
import org.apache.hadoop.shaded.org.mockito.asm.tree.analysis.SimpleVerifier;
import org.apache.hadoop.shaded.org.mockito.asm.util.CheckAnnotationAdapter;
import org.apache.hadoop.shaded.org.mockito.asm.util.CheckFieldAdapter;
import org.apache.hadoop.shaded.org.mockito.asm.util.CheckMethodAdapter;
import org.apache.hadoop.shaded.org.mockito.asm.util.TraceMethodVisitor;

public class CheckClassAdapter
extends ClassAdapter {
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader cr = args[0].endsWith(".class") ? new ClassReader(new FileInputStream(args[0])) : new ClassReader(args[0]);
        CheckClassAdapter.verify(cr, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader cr, boolean dump, PrintWriter pw) {
        ClassNode cn = new ClassNode();
        cr.accept(new CheckClassAdapter(cn), 2);
        Type syperType = cn.superName == null ? null : Type.getObjectType(cn.superName);
        List methods = cn.methods;
        for (int i = 0; i < methods.size(); ++i) {
            int j;
            MethodNode method = (MethodNode)methods.get(i);
            Analyzer a = new Analyzer(new SimpleVerifier(Type.getObjectType(cn.name), syperType, false));
            try {
                a.analyze(cn.name, method);
                if (!dump) {
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace(pw);
            }
            Frame[] frames = a.getFrames();
            TraceMethodVisitor mv = new TraceMethodVisitor();
            pw.println(method.name + method.desc);
            for (j = 0; j < method.instructions.size(); ++j) {
                method.instructions.get(j).accept(mv);
                StringBuffer s = new StringBuffer();
                Frame f = frames[j];
                if (f == null) {
                    s.append('?');
                } else {
                    int k;
                    for (k = 0; k < f.getLocals(); ++k) {
                        s.append(CheckClassAdapter.getShortName(f.getLocal(k).toString())).append(' ');
                    }
                    s.append(" : ");
                    for (k = 0; k < f.getStackSize(); ++k) {
                        s.append(CheckClassAdapter.getShortName(f.getStack(k).toString())).append(' ');
                    }
                }
                while (s.length() < method.maxStack + method.maxLocals + 1) {
                    s.append(' ');
                }
                pw.print(Integer.toString(j + 100000).substring(1));
                pw.print(" " + s + " : " + mv.buf);
            }
            for (j = 0; j < method.tryCatchBlocks.size(); ++j) {
                ((TryCatchBlockNode)method.tryCatchBlocks.get(j)).accept(mv);
                pw.print(" " + mv.buf);
            }
            pw.println();
        }
        pw.flush();
    }

    private static String getShortName(String name) {
        int n = name.lastIndexOf(47);
        int k = name.length();
        if (name.charAt(k - 1) == ';') {
            --k;
        }
        return n == -1 ? name : name.substring(n + 1, k);
    }

    public CheckClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 161329);
        if (name == null || !name.endsWith("package-info")) {
            CheckMethodAdapter.checkInternalName(name, "class name");
        }
        if ("java/lang/Object".equals(name)) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(superName, "super class name");
        }
        if (signature != null) {
            CheckMethodAdapter.checkClassSignature(signature);
        }
        if ((access & 0x200) != 0 && !"java/lang/Object".equals(superName)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                CheckMethodAdapter.checkInternalName(interfaces[i], "interface name at index " + i);
            }
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String file, String debug) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        this.cv.visitSource(file, debug);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.outer = true;
        if (owner == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (desc != null) {
            CheckMethodAdapter.checkMethodDesc(desc);
        }
        this.cv.visitOuterClass(owner, name, desc);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(name, "class name");
        if (outerName != null) {
            CheckMethodAdapter.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            CheckMethodAdapter.checkIdentifier(innerName, "inner class name");
        }
        CheckClassAdapter.checkAccess(access, 30239);
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 151775);
        CheckMethodAdapter.checkIdentifier(name, "field name");
        CheckMethodAdapter.checkDesc(desc, false);
        if (signature != null) {
            CheckMethodAdapter.checkFieldSignature(signature);
        }
        if (value != null) {
            CheckMethodAdapter.checkConstant(value);
        }
        FieldVisitor av = this.cv.visitField(access, name, desc, signature, value);
        return new CheckFieldAdapter(av);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 138751);
        CheckMethodAdapter.checkMethodIdentifier(name, "method name");
        CheckMethodAdapter.checkMethodDesc(desc);
        if (signature != null) {
            CheckMethodAdapter.checkMethodSignature(signature);
        }
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                CheckMethodAdapter.checkInternalName(exceptions[i], "exception name at index " + i);
            }
        }
        return new CheckMethodAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkState();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.cv.visitAnnotation(desc, visible));
    }

    public void visitAttribute(Attribute attr) {
        this.checkState();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.cv.visitAttribute(attr);
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        int abs;
        int pro;
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int pub = (access & 1) == 0 ? 0 : 1;
        int pri = (access & 2) == 0 ? 0 : 1;
        int n = pro = (access & 4) == 0 ? 0 : 1;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access);
        }
        int fin = (access & 0x10) == 0 ? 0 : 1;
        int n2 = abs = (access & 0x400) == 0 ? 0 : 1;
        if (fin + abs > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }
}

