/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.common.base.Strings;
import org.apache.hadoop.util.NodeHealthScriptRunner;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;

public class NodeHealthCheckerService
extends CompositeService {
    private NodeHealthScriptRunner nodeHealthScriptRunner;
    private LocalDirsHandlerService dirsHandler;
    private Exception nodeHealthException;
    private long nodeHealthExceptionReportTime;
    static final String SEPARATOR = ";";

    public NodeHealthCheckerService(NodeHealthScriptRunner scriptRunner, LocalDirsHandlerService dirHandlerService) {
        super(NodeHealthCheckerService.class.getName());
        this.nodeHealthScriptRunner = scriptRunner;
        this.dirsHandler = dirHandlerService;
        this.nodeHealthException = null;
        this.nodeHealthExceptionReportTime = 0L;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (this.nodeHealthScriptRunner != null) {
            this.addService((Service)this.nodeHealthScriptRunner);
        }
        this.addService((Service)this.dirsHandler);
        super.serviceInit(conf);
    }

    String getHealthReport() {
        String scriptReport = Strings.emptyToNull(this.nodeHealthScriptRunner == null ? null : this.nodeHealthScriptRunner.getHealthReport());
        String discReport = Strings.emptyToNull((String)this.dirsHandler.getDisksHealthReport(false));
        String exceptionReport = Strings.emptyToNull(this.nodeHealthException == null ? null : this.nodeHealthException.getMessage());
        return Joiner.on((String)SEPARATOR).skipNulls().join((Object)scriptReport, (Object)discReport, new Object[]{exceptionReport});
    }

    boolean isHealthy() {
        boolean scriptHealthy = this.nodeHealthScriptRunner == null || this.nodeHealthScriptRunner.isHealthy();
        return this.nodeHealthException == null && scriptHealthy && this.dirsHandler.areDisksHealthy();
    }

    long getLastHealthReportTime() {
        return Collections.max(Arrays.asList(this.dirsHandler.getLastDisksCheckTime(), this.nodeHealthScriptRunner == null ? 0L : this.nodeHealthScriptRunner.getLastReportedTime(), this.nodeHealthExceptionReportTime));
    }

    public LocalDirsHandlerService getDiskHandler() {
        return this.dirsHandler;
    }

    NodeHealthScriptRunner getNodeHealthScriptRunner() {
        return this.nodeHealthScriptRunner;
    }

    void reportException(Exception ex) {
        this.nodeHealthException = ex;
        this.nodeHealthExceptionReportTime = System.currentTimeMillis();
    }
}

