/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeLabelsUtils;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsMappingProvider;

public class RMDelegatedNodeLabelsUpdater
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(RMDelegatedNodeLabelsUpdater.class);
    public static final long DISABLE_DELEGATED_NODE_LABELS_UPDATE = -1L;
    private Timer nodeLabelsScheduler;
    @VisibleForTesting
    public long nodeLabelsUpdateInterval = 30000L;
    private Set<NodeId> newlyRegisteredNodes = new HashSet<NodeId>();
    private Object lock = new Object();
    private long lastAllNodesLabelUpdateMills = 0L;
    private long allNodesLabelUpdateInterval;
    private RMNodeLabelsMappingProvider rmNodeLabelsMappingProvider;
    private RMContext rmContext;

    public RMDelegatedNodeLabelsUpdater(RMContext rmContext) {
        super("RMDelegatedNodeLabelsUpdater");
        this.rmContext = rmContext;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.allNodesLabelUpdateInterval = conf.getLong("yarn.resourcemanager.node-labels.provider.fetch-interval-ms", 1800000L);
        this.rmNodeLabelsMappingProvider = this.createRMNodeLabelsMappingProvider(conf);
        this.addService((Service)this.rmNodeLabelsMappingProvider);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.nodeLabelsScheduler = new Timer("RMDelegatedNodeLabelsUpdater-Timer", true);
        RMDelegatedNodeLabelsUpdaterTimerTask delegatedNodeLabelsUpdaterTimerTask = new RMDelegatedNodeLabelsUpdaterTimerTask();
        this.nodeLabelsScheduler.scheduleAtFixedRate((TimerTask)delegatedNodeLabelsUpdaterTimerTask, this.nodeLabelsUpdateInterval, this.nodeLabelsUpdateInterval);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.nodeLabelsScheduler != null) {
            this.nodeLabelsScheduler.cancel();
        }
        super.serviceStop();
    }

    private void updateNodeLabelsInternal(Set<NodeId> nodes) throws IOException {
        Map<NodeId, Set<NodeLabel>> labelsUpdated = this.rmNodeLabelsMappingProvider.getNodeLabels(nodes);
        if (labelsUpdated != null && labelsUpdated.size() != 0) {
            HashMap<NodeId, Set<String>> nodeToLabels = new HashMap<NodeId, Set<String>>(labelsUpdated.size());
            for (Map.Entry<NodeId, Set<NodeLabel>> entry : labelsUpdated.entrySet()) {
                nodeToLabels.put(entry.getKey(), NodeLabelsUtils.convertToStringSet(entry.getValue()));
            }
            this.rmContext.getNodeLabelManager().replaceLabelsOnNode(nodeToLabels);
        }
    }

    private RMNodeLabelsMappingProvider createRMNodeLabelsMappingProvider(Configuration conf) throws IOException {
        RMNodeLabelsMappingProvider nodeLabelsMappingProvider = null;
        try {
            Class labelsProviderClass = conf.getClass("yarn.resourcemanager.node-labels.provider", null, RMNodeLabelsMappingProvider.class);
            if (labelsProviderClass != null) {
                nodeLabelsMappingProvider = (RMNodeLabelsMappingProvider)((Object)labelsProviderClass.newInstance());
            }
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException e) {
            LOG.error((Object)"Failed to create RMNodeLabelsMappingProvider based on Configuration", (Throwable)e);
            throw new IOException("Failed to create RMNodeLabelsMappingProvider : " + e.getMessage(), e);
        }
        if (nodeLabelsMappingProvider == null) {
            String msg = "RMNodeLabelsMappingProvider should be configured when delegated-centralized node label configuration is enabled";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RM Node labels mapping provider class is : " + ((Object)((Object)nodeLabelsMappingProvider)).getClass().toString()));
        }
        return nodeLabelsMappingProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodeLabels(NodeId node) {
        Object object = this.lock;
        synchronized (object) {
            this.newlyRegisteredNodes.add(node);
        }
    }

    private class RMDelegatedNodeLabelsUpdaterTimerTask
    extends TimerTask {
        private RMDelegatedNodeLabelsUpdaterTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                Object object;
                long elapsedTimeSinceLastUpdate;
                Set nodesToUpdateLabels = null;
                boolean isUpdatingAllNodes = false;
                if (RMDelegatedNodeLabelsUpdater.this.allNodesLabelUpdateInterval != -1L && (elapsedTimeSinceLastUpdate = System.currentTimeMillis() - RMDelegatedNodeLabelsUpdater.this.lastAllNodesLabelUpdateMills) > RMDelegatedNodeLabelsUpdater.this.allNodesLabelUpdateInterval) {
                    nodesToUpdateLabels = Collections.unmodifiableSet(RMDelegatedNodeLabelsUpdater.this.rmContext.getRMNodes().keySet());
                    isUpdatingAllNodes = true;
                }
                if (nodesToUpdateLabels == null && !RMDelegatedNodeLabelsUpdater.this.newlyRegisteredNodes.isEmpty()) {
                    object = RMDelegatedNodeLabelsUpdater.this.lock;
                    synchronized (object) {
                        if (!RMDelegatedNodeLabelsUpdater.this.newlyRegisteredNodes.isEmpty()) {
                            nodesToUpdateLabels = new HashSet(RMDelegatedNodeLabelsUpdater.this.newlyRegisteredNodes);
                        }
                    }
                }
                try {
                    if (nodesToUpdateLabels == null || nodesToUpdateLabels.isEmpty()) break block12;
                    RMDelegatedNodeLabelsUpdater.this.updateNodeLabelsInternal(nodesToUpdateLabels);
                    if (isUpdatingAllNodes) {
                        RMDelegatedNodeLabelsUpdater.this.lastAllNodesLabelUpdateMills = System.currentTimeMillis();
                    }
                    object = RMDelegatedNodeLabelsUpdater.this.lock;
                    synchronized (object) {
                        RMDelegatedNodeLabelsUpdater.this.newlyRegisteredNodes.removeAll(nodesToUpdateLabels);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to update node Labels", (Throwable)e);
                }
            }
        }
    }
}

