/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.shaded.org.apache.commons.collections.IteratorUtils;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSetUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.ResourceRequestUpdateResult;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;

public class LocalityAppPlacementAllocator<N extends SchedulerNode>
implements AppPlacementAllocator<N> {
    private static final Log LOG = LogFactory.getLog(LocalityAppPlacementAllocator.class);
    private final Map<String, ResourceRequest> resourceRequestMap = new ConcurrentHashMap<String, ResourceRequest>();
    private AppSchedulingInfo appSchedulingInfo;
    private volatile String primaryRequestedPartition = "";
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public LocalityAppPlacementAllocator(AppSchedulingInfo info) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.appSchedulingInfo = info;
    }

    @Override
    public Iterator<N> getPreferredNodeIterator(CandidateNodeSet<N> candidateNodeSet) {
        N singleNode = CandidateNodeSetUtils.getSingleNode(candidateNodeSet);
        if (null != singleNode) {
            return IteratorUtils.singletonIterator(singleNode);
        }
        return IteratorUtils.emptyIterator();
    }

    private boolean hasRequestLabelChanged(ResourceRequest requestOne, ResourceRequest requestTwo) {
        String requestOneLabelExp = requestOne.getNodeLabelExpression();
        String requestTwoLabelExp = requestTwo.getNodeLabelExpression();
        if (null == requestOneLabelExp && null != requestTwoLabelExp) {
            return true;
        }
        return null != requestOneLabelExp && !requestOneLabelExp.equals(requestTwoLabelExp);
    }

    private void updateNodeLabels(ResourceRequest request) {
        String resourceName = request.getResourceName();
        if (resourceName.equals("*")) {
            ResourceRequest previousAnyRequest = this.getResourceRequest(resourceName);
            if (null == previousAnyRequest || this.hasRequestLabelChanged(previousAnyRequest, request)) {
                for (ResourceRequest r : this.resourceRequestMap.values()) {
                    if (r.getResourceName().equals("*")) continue;
                    r.setNodeLabelExpression(request.getNodeLabelExpression());
                }
            }
        } else {
            ResourceRequest anyRequest = this.getResourceRequest("*");
            if (anyRequest != null) {
                request.setNodeLabelExpression(anyRequest.getNodeLabelExpression());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceRequestUpdateResult updateResourceRequests(Collection<ResourceRequest> requests, boolean recoverPreemptedRequestForAContainer) {
        try {
            this.writeLock.lock();
            ResourceRequestUpdateResult updateResult = null;
            for (ResourceRequest request : requests) {
                String partition;
                String resourceName = request.getResourceName();
                this.updateNodeLabels(request);
                ResourceRequest lastRequest = this.resourceRequestMap.get(resourceName);
                if (recoverPreemptedRequestForAContainer && lastRequest != null) {
                    request.setNumContainers(lastRequest.getNumContainers() + 1);
                }
                this.resourceRequestMap.put(resourceName, request);
                if (!resourceName.equals("*")) continue;
                this.primaryRequestedPartition = partition = request.getNodeLabelExpression() == null ? "" : request.getNodeLabelExpression();
                this.appSchedulingInfo.addRequestedPartition(partition);
                updateResult = new ResourceRequestUpdateResult(lastRequest, request);
            }
            Iterator<ResourceRequest> iterator = updateResult;
            return iterator;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Map<String, ResourceRequest> getResourceRequests() {
        return this.resourceRequestMap;
    }

    private ResourceRequest getResourceRequest(String resourceName) {
        return this.resourceRequestMap.get(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingAsk getPendingAsk(String resourceName) {
        try {
            this.readLock.lock();
            ResourceRequest request = this.getResourceRequest(resourceName);
            if (null == request) {
                PendingAsk pendingAsk = PendingAsk.ZERO;
                return pendingAsk;
            }
            PendingAsk pendingAsk = new PendingAsk(request.getCapability(), request.getNumContainers());
            return pendingAsk;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutstandingAsksCount(String resourceName) {
        try {
            this.readLock.lock();
            ResourceRequest request = this.getResourceRequest(resourceName);
            if (null == request) {
                int n = 0;
                return n;
            }
            int n = request.getNumContainers();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void decrementOutstanding(SchedulerRequestKey schedulerRequestKey, ResourceRequest offSwitchRequest) {
        int numOffSwitchContainers = offSwitchRequest.getNumContainers() - 1;
        offSwitchRequest.setNumContainers(numOffSwitchContainers);
        if (numOffSwitchContainers == 0) {
            this.appSchedulingInfo.getSchedulerKeys().remove(schedulerRequestKey);
            this.appSchedulingInfo.checkForDeactivation();
            this.resourceRequestMap.remove("*");
            if (this.resourceRequestMap.isEmpty()) {
                this.appSchedulingInfo.removeAppPlacement(schedulerRequestKey);
            }
        }
        this.appSchedulingInfo.decPendingResource(offSwitchRequest.getNodeLabelExpression(), offSwitchRequest.getCapability());
    }

    public ResourceRequest cloneResourceRequest(ResourceRequest request) {
        ResourceRequest newRequest = ResourceRequest.newBuilder().priority(request.getPriority()).allocationRequestId(request.getAllocationRequestId()).resourceName(request.getResourceName()).capability(request.getCapability()).numContainers(1).relaxLocality(request.getRelaxLocality()).nodeLabelExpression(request.getNodeLabelExpression()).build();
        return newRequest;
    }

    private void allocateRackLocal(SchedulerRequestKey schedulerKey, SchedulerNode node, ResourceRequest rackLocalRequest, List<ResourceRequest> resourceRequests) {
        this.decResourceRequest(node.getRackName(), rackLocalRequest);
        ResourceRequest offRackRequest = this.resourceRequestMap.get("*");
        this.decrementOutstanding(schedulerKey, offRackRequest);
        resourceRequests.add(this.cloneResourceRequest(rackLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(offRackRequest));
    }

    private void allocateOffSwitch(SchedulerRequestKey schedulerKey, ResourceRequest offSwitchRequest, List<ResourceRequest> resourceRequests) {
        this.decrementOutstanding(schedulerKey, offSwitchRequest);
        resourceRequests.add(this.cloneResourceRequest(offSwitchRequest));
    }

    private void allocateNodeLocal(SchedulerRequestKey schedulerKey, SchedulerNode node, ResourceRequest nodeLocalRequest, List<ResourceRequest> resourceRequests) {
        this.decResourceRequest(node.getNodeName(), nodeLocalRequest);
        ResourceRequest rackLocalRequest = this.resourceRequestMap.get(node.getRackName());
        this.decResourceRequest(node.getRackName(), rackLocalRequest);
        ResourceRequest offRackRequest = this.resourceRequestMap.get("*");
        this.decrementOutstanding(schedulerKey, offRackRequest);
        resourceRequests.add(this.cloneResourceRequest(nodeLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(rackLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(offRackRequest));
    }

    private void decResourceRequest(String resourceName, ResourceRequest request) {
        request.setNumContainers(request.getNumContainers() - 1);
        if (request.getNumContainers() == 0) {
            this.resourceRequestMap.remove(resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAllocate(NodeType type, SchedulerNode node) {
        try {
            this.readLock.lock();
            ResourceRequest r = this.resourceRequestMap.get("*");
            if (r == null || r.getNumContainers() <= 0) {
                boolean bl = false;
                return bl;
            }
            if (type == NodeType.RACK_LOCAL || type == NodeType.NODE_LOCAL) {
                r = this.resourceRequestMap.get(node.getRackName());
                if (r == null || r.getNumContainers() <= 0) {
                    boolean bl = false;
                    return bl;
                }
                if (type == NodeType.NODE_LOCAL && ((r = this.resourceRequestMap.get(node.getNodeName())) == null || r.getNumContainers() <= 0)) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDelayTo(String resourceName) {
        try {
            this.readLock.lock();
            ResourceRequest request = this.getResourceRequest(resourceName);
            boolean bl = request == null || request.getRelaxLocality();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean acceptNodePartition(String nodePartition, SchedulingMode schedulingMode) {
        String nodePartitionToLookAt = schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY ? nodePartition : "";
        return this.primaryRequestedPartition.equals(nodePartitionToLookAt);
    }

    @Override
    public String getPrimaryRequestedNodePartition() {
        return this.primaryRequestedPartition;
    }

    @Override
    public int getUniqueLocationAsks() {
        return this.resourceRequestMap.size();
    }

    @Override
    public void showRequests() {
        for (ResourceRequest request : this.resourceRequestMap.values()) {
            if (request.getNumContainers() <= 0) continue;
            LOG.debug((Object)("\tRequest=" + request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceRequest> allocate(SchedulerRequestKey schedulerKey, NodeType type, SchedulerNode node) {
        try {
            this.writeLock.lock();
            ArrayList<ResourceRequest> resourceRequests = new ArrayList<ResourceRequest>();
            ResourceRequest request = type == NodeType.NODE_LOCAL ? this.resourceRequestMap.get(node.getNodeName()) : (type == NodeType.RACK_LOCAL ? this.resourceRequestMap.get(node.getRackName()) : this.resourceRequestMap.get("*"));
            if (type == NodeType.NODE_LOCAL) {
                this.allocateNodeLocal(schedulerKey, node, request, resourceRequests);
            } else if (type == NodeType.RACK_LOCAL) {
                this.allocateRackLocal(schedulerKey, node, request, resourceRequests);
            } else {
                this.allocateOffSwitch(schedulerKey, request, resourceRequests);
            }
            ArrayList<ResourceRequest> arrayList = resourceRequests;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Iterator<String> getAcceptedResouceNames() {
        try {
            this.readLock.lock();
            Iterator<String> iterator = this.resourceRequestMap.keySet().iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

