/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceRequestInfo;
import org.apache.hadoop.yarn.server.webapp.AppAttemptBlock;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class RMAppAttemptBlock
extends AppAttemptBlock {
    private final ResourceManager rm;
    protected Configuration conf;

    @Inject
    RMAppAttemptBlock(View.ViewContext ctx, ResourceManager rm, Configuration conf) {
        super(null, ctx);
        this.rm = rm;
        this.conf = conf;
    }

    private void createResourceRequestsTable(HtmlBlock.Block html) {
        AppInfo app = new AppInfo(this.rm, (RMApp)this.rm.getRMContext().getRMApps().get(this.appAttemptId.getApplicationId()), true, WebAppUtils.getHttpSchemePrefix((Configuration)this.conf));
        List<ResourceRequestInfo> resourceRequests = app.getResourceRequests();
        if (resourceRequests == null || resourceRequests.isEmpty()) {
            return;
        }
        Hamlet.DIV div = html.div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)div.h3("Total Outstanding Resource Requests: " + this.getTotalResource(resourceRequests)).table("#resourceRequests").thead().tr().th(".priority", "Priority").th(".resource", "ResourceName").th(".capacity", "Capability").th(".containers", "NumContainers").th(".relaxlocality", "RelaxLocality").th(".labelexpression", "NodeLabelExpression").__()).__()).tbody();
        StringBuilder resourceRequestTableData = new StringBuilder("[\n");
        for (ResourceRequestInfo resourceRequest : resourceRequests) {
            if (resourceRequest.getNumContainers() == 0) continue;
            resourceRequestTableData.append("[\"").append(String.valueOf(resourceRequest.getPriority())).append("\",\"").append(resourceRequest.getResourceName()).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)String.valueOf(resourceRequest.getCapability())))).append("\",\"").append(String.valueOf(resourceRequest.getNumContainers())).append("\",\"").append(String.valueOf(resourceRequest.getRelaxLocality())).append("\",\"").append(resourceRequest.getNodeLabelExpression() == null ? "N/A" : resourceRequest.getNodeLabelExpression()).append("\"],\n");
        }
        if (resourceRequestTableData.charAt(resourceRequestTableData.length() - 2) == ',') {
            resourceRequestTableData.delete(resourceRequestTableData.length() - 2, resourceRequestTableData.length() - 1);
        }
        resourceRequestTableData.append("]");
        html.script().$type("text/javascript").__(new Object[]{"var resourceRequestsTableData=" + resourceRequestTableData}).__();
        ((Hamlet.TABLE)tbody.__()).__();
        div.__();
    }

    private Resource getTotalResource(List<ResourceRequestInfo> requests) {
        Resource totalResource = Resource.newInstance((int)0, (int)0);
        if (requests == null) {
            return totalResource;
        }
        for (ResourceRequestInfo request : requests) {
            if (request.getNumContainers() == 0 || !request.getResourceName().equals("*")) continue;
            Resources.addTo((Resource)totalResource, (Resource)Resources.multiply((Resource)request.getCapability().getResource(), (double)request.getNumContainers()));
        }
        return totalResource;
    }

    private void createContainerLocalityTable(HtmlBlock.Block html) {
        RMAppAttemptMetrics attemptMetrics = null;
        RMAppAttempt attempt = this.getRMAppAttempt();
        if (attempt != null) {
            attemptMetrics = attempt.getRMAppAttemptMetrics();
        }
        if (attemptMetrics == null) {
            return;
        }
        Hamlet.DIV div = html.div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.h3("Total Allocated Containers: " + attemptMetrics.getTotalAllocatedContainers()).h3("Each table cell represents the number of NodeLocal/RackLocal/OffSwitch containers satisfied by NodeLocal/RackLocal/OffSwitch resource requests.").table("#containerLocality");
        table.tr().th(".ui-state-default", "").th(".ui-state-default", "Node Local Request").th(".ui-state-default", "Rack Local Request").th(".ui-state-default", "Off Switch Request").__();
        String[] containersType = new String[]{"Num Node Local Containers (satisfied by)", "Num Rack Local Containers (satisfied by)", "Num Off Switch Containers (satisfied by)"};
        boolean odd = false;
        for (int i = 0; i < attemptMetrics.getLocalityStatistics().length; ++i) {
            odd = !odd;
            table.tr(odd ? ".odd" : ".even").td(containersType[i]).td(String.valueOf(attemptMetrics.getLocalityStatistics()[i][0])).td(i == 0 ? "" : String.valueOf(attemptMetrics.getLocalityStatistics()[i][1])).td(i <= 1 ? "" : String.valueOf(attemptMetrics.getLocalityStatistics()[i][2])).__();
        }
        table.__();
        div.__();
    }

    private boolean isApplicationInFinalState(YarnApplicationAttemptState state) {
        return state == YarnApplicationAttemptState.FINISHED || state == YarnApplicationAttemptState.FAILED || state == YarnApplicationAttemptState.KILLED;
    }

    protected void createAttemptHeadRoomTable(HtmlBlock.Block html) {
        RMAppAttempt attempt = this.getRMAppAttempt();
        if (attempt != null && !this.isApplicationInFinalState(YarnApplicationAttemptState.valueOf((String)attempt.getAppAttemptState().toString()))) {
            RMAppAttemptMetrics metrics = attempt.getRMAppAttemptMetrics();
            Hamlet.DIV pdiv = html.__(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
            this.info("Application Attempt Overview").clear();
            this.info("Application Attempt Metrics").__("Application Attempt Headroom : ", (Object)(metrics == null ? "N/A" : metrics.getApplicationAttemptHeadroom()));
            pdiv.__();
        }
    }

    private RMAppAttempt getRMAppAttempt() {
        ApplicationId appId = this.appAttemptId.getApplicationId();
        RMAppAttempt attempt = null;
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(appId);
        if (rmApp != null) {
            attempt = rmApp.getAppAttempts().get(this.appAttemptId);
        }
        return attempt;
    }

    protected void generateOverview(ApplicationAttemptReport appAttemptReport, Collection<ContainerReport> containers, AppAttemptInfo appAttempt, String node) {
        RMAppAttempt rmAppAttempt = this.getRMAppAttempt();
        String appBlacklistedNodes = this.getNodeString(rmAppAttempt.getBlacklistedNodes());
        String rmBlackListedNodes = this.getNodeString(rmAppAttempt.getAMBlacklistManager().getBlacklistUpdates().getBlacklistAdditions());
        this.info("Application Attempt Overview").__("Application Attempt State:", (Object)(appAttempt.getAppAttemptState() == null ? "N/A" : appAttempt.getAppAttemptState())).__("Started:", (Object)Times.format((long)appAttempt.getStartedTime())).__("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)appAttempt.getStartedTime(), (long)appAttempt.getFinishedTime()))).__("AM Container:", appAttempt.getAmContainerId() == null || containers == null || !this.hasAMContainer(appAttemptReport.getAMContainerId(), containers) ? null : this.root_url(new String[]{"container", appAttempt.getAmContainerId()}), (Object)(appAttempt.getAmContainerId() == null ? "N/A" : String.valueOf(appAttempt.getAmContainerId()))).__("Node:", (Object)node).__("Tracking URL:", appAttempt.getTrackingUrl() == null || appAttempt.getTrackingUrl().equals("N/A") ? null : this.root_url(new String[]{appAttempt.getTrackingUrl()}), (Object)(appAttempt.getTrackingUrl() == null || appAttempt.getTrackingUrl().equals("N/A") ? "Unassigned" : (appAttempt.getAppAttemptState() == YarnApplicationAttemptState.FINISHED || appAttempt.getAppAttemptState() == YarnApplicationAttemptState.FAILED || appAttempt.getAppAttemptState() == YarnApplicationAttemptState.KILLED ? "History" : "ApplicationMaster"))).__("Diagnostics Info:", (Object)(appAttempt.getDiagnosticsInfo() == null ? "" : appAttempt.getDiagnosticsInfo())).__("Nodes blacklisted by the application:", (Object)appBlacklistedNodes).__("Nodes blacklisted by the system:", (Object)rmBlackListedNodes);
    }

    private String getNodeString(Collection<String> nodes) {
        String concatinatedString = "-";
        if (null != nodes && !nodes.isEmpty()) {
            concatinatedString = org.apache.hadoop.shaded.org.apache.commons.lang.StringUtils.join(nodes, (String)", ");
        }
        return concatinatedString;
    }

    protected void createTablesForAttemptMetrics(HtmlBlock.Block html) {
        this.createContainerLocalityTable(html);
        this.createResourceRequestsTable(html);
    }

    protected List<ContainerReport> getContainers(GetContainersRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getContainers(request).getContainerList();
    }

    protected ApplicationAttemptReport getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getApplicationAttemptReport(request).getApplicationAttemptReport();
    }
}

