/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryDiffListFactory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;

@InterfaceAudience.Private
public class DirectoryWithSnapshotFeature
implements INode.Feature {
    private final DirectoryDiffList diffs;

    private static Map<INode, INode> cloneDiffList(List<INode> diffList) {
        if (diffList == null || diffList.size() == 0) {
            return null;
        }
        HashMap<INode, INode> map = new HashMap<INode, INode>(diffList.size());
        for (INode node : diffList) {
            map.put(node, node);
        }
        return map;
    }

    public static void destroyDstSubtree(INode.ReclaimContext reclaimContext, INode inode, int snapshot, int prior) {
        Preconditions.checkArgument((prior != -1 ? 1 : 0) != 0);
        if (inode.isReference()) {
            if (inode instanceof INodeReference.WithName && snapshot != 0x7FFFFFFE) {
                inode.cleanSubtree(reclaimContext, snapshot, prior);
            } else {
                DirectoryWithSnapshotFeature.destroyDstSubtree(reclaimContext, inode.asReference().getReferredINode(), snapshot, prior);
            }
        } else if (inode.isFile()) {
            inode.cleanSubtree(reclaimContext, snapshot, prior);
        } else if (inode.isDirectory()) {
            Map<INode, INode> excludedNodes = null;
            INodeDirectory dir = inode.asDirectory();
            DirectoryWithSnapshotFeature sf = dir.getDirectoryWithSnapshotFeature();
            if (sf != null) {
                DirectoryDiffList diffList = sf.getDiffs();
                DirectoryDiff priorDiff = (DirectoryDiff)diffList.getDiffById(prior);
                if (priorDiff != null && priorDiff.getSnapshotId() == prior) {
                    List<INode> dList = priorDiff.diff.getDeletedUnmodifiable();
                    excludedNodes = DirectoryWithSnapshotFeature.cloneDiffList(dList);
                }
                if (snapshot != 0x7FFFFFFE) {
                    diffList.deleteSnapshotDiff(reclaimContext, snapshot, prior, dir);
                }
                if ((priorDiff = (DirectoryDiff)diffList.getDiffById(prior)) != null && priorDiff.getSnapshotId() == prior) {
                    priorDiff.diff.destroyCreatedList(reclaimContext, dir);
                }
            }
            for (INode child : inode.asDirectory().getChildrenList(prior)) {
                if (excludedNodes != null && excludedNodes.containsKey(child)) continue;
                DirectoryWithSnapshotFeature.destroyDstSubtree(reclaimContext, child, snapshot, prior);
            }
        }
    }

    private static void cleanDeletedINode(INode.ReclaimContext reclaimContext, INode inode, int post, int prior) {
        ArrayDeque<INode> queue = new ArrayDeque<INode>();
        queue.addLast(inode);
        while (!queue.isEmpty()) {
            DirectoryDiff priorDiff;
            INode topNode = (INode)queue.pollFirst();
            if (topNode instanceof INodeReference.WithName) {
                INodeReference.WithName wn = (INodeReference.WithName)topNode;
                if (wn.getLastSnapshotId() < post) continue;
                INodeReference.WithCount wc = (INodeReference.WithCount)wn.getReferredINode();
                if (wc.getLastWithName() == wn && wc.getParentReference() == null) {
                    queue.add(wc.getReferredINode());
                    continue;
                }
                wn.cleanSubtree(reclaimContext, post, prior);
                continue;
            }
            if (topNode.isFile() && topNode.asFile().isWithSnapshot()) {
                INodeFile file = topNode.asFile();
                file.getDiffs().deleteSnapshotDiff(reclaimContext, post, prior, file);
                continue;
            }
            if (!topNode.isDirectory()) continue;
            INodeDirectory dir = topNode.asDirectory();
            ChildrenDiff priorChildrenDiff = null;
            DirectoryWithSnapshotFeature sf = dir.getDirectoryWithSnapshotFeature();
            if (sf != null && (priorDiff = (DirectoryDiff)sf.getDiffs().getDiffById(prior)) != null && priorDiff.getSnapshotId() == prior) {
                priorChildrenDiff = priorDiff.getChildrenDiff();
                priorChildrenDiff.destroyCreatedList(reclaimContext, dir);
            }
            for (INode child : dir.getChildrenList(prior)) {
                if (priorChildrenDiff != null && priorChildrenDiff.getDeleted(child.getLocalNameBytes()) != null) continue;
                queue.addLast(child);
            }
        }
    }

    public DirectoryWithSnapshotFeature(DirectoryDiffList diffs) {
        this.diffs = diffs != null ? diffs : new DirectoryDiffList();
    }

    public int getLastSnapshotId() {
        return this.diffs.getLastSnapshotId();
    }

    public DirectoryDiffList getDiffs() {
        return this.diffs;
    }

    public void getSnapshotDirectory(List<INodeDirectory> snapshotDir) {
        for (DirectoryDiff sdiff : this.diffs) {
            sdiff.getChildrenDiff().getDirsInDeleted(snapshotDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChild(INodeDirectory parent, INode inode, boolean setModTime, int latestSnapshotId) {
        ChildrenDiff diff = ((DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latestSnapshotId, parent)).diff;
        int undoInfo = diff.create(inode);
        boolean added = false;
        try {
            added = parent.addChild(inode, setModTime, 0x7FFFFFFE);
        }
        finally {
            if (!added) {
                diff.undoCreate(inode, undoInfo);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(INodeDirectory parent, INode child, int latestSnapshotId) {
        ChildrenDiff diff = ((DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latestSnapshotId, parent)).diff;
        Diff.UndoInfo<INode> undoInfo = diff.delete(child);
        boolean removed = false;
        try {
            removed = parent.removeChild(child);
        }
        finally {
            if (!removed) {
                diff.undoDelete(child, undoInfo);
            }
        }
        return removed;
    }

    public ReadOnlyList<INode> getChildrenList(INodeDirectory currentINode, int snapshotId) {
        DirectoryDiff diff = (DirectoryDiff)this.diffs.getDiffById(snapshotId);
        return diff != null ? diff.getChildrenList(currentINode) : currentINode.getChildrenList(0x7FFFFFFE);
    }

    public INode getChild(INodeDirectory currentINode, byte[] name, int snapshotId) {
        DirectoryDiff diff = (DirectoryDiff)this.diffs.getDiffById(snapshotId);
        return diff != null ? diff.getChild(name, true, currentINode) : currentINode.getChild(name, 0x7FFFFFFE);
    }

    public INode saveChild2Snapshot(INodeDirectory currentINode, INode child, int latestSnapshotId, INode snapshotCopy) {
        Preconditions.checkArgument((!child.isDirectory() ? 1 : 0) != 0, (String)"child is a directory, child=%s", (Object[])new Object[]{child});
        Preconditions.checkArgument((latestSnapshotId != 0x7FFFFFFE ? 1 : 0) != 0);
        DirectoryDiff diff = (DirectoryDiff)this.diffs.checkAndAddLatestSnapshotDiff(latestSnapshotId, currentINode);
        if (diff.getChild(child.getLocalNameBytes(), false, currentINode) != null) {
            return child;
        }
        diff.diff.modify(snapshotCopy, child);
        return child;
    }

    public void clear(INode.ReclaimContext reclaimContext, INodeDirectory currentINode) {
        for (DirectoryDiff diff : this.diffs) {
            diff.destroyDiffAndCollectBlocks(reclaimContext, currentINode);
        }
        this.diffs.clear();
    }

    public QuotaCounts computeQuotaUsage4CurrentDirectory(BlockStoragePolicySuite bsps, byte storagePolicyId) {
        QuotaCounts counts = new QuotaCounts.Builder().build();
        for (DirectoryDiff d : this.diffs) {
            for (INode deleted : d.getChildrenDiff().getDeletedUnmodifiable()) {
                byte childPolicyId = deleted.getStoragePolicyIDForQuota(storagePolicyId);
                counts.add(deleted.computeQuotaUsage(bsps, childPolicyId, false, 0x7FFFFFFE));
            }
        }
        return counts;
    }

    public void computeContentSummary4Snapshot(BlockStoragePolicySuite bsps, ContentCounts counts) throws AccessControlException {
        ContentSummaryComputationContext summary = new ContentSummaryComputationContext(bsps);
        for (DirectoryDiff d : this.diffs) {
            for (INode deleted : d.getChildrenDiff().getDeletedUnmodifiable()) {
                deleted.computeContentSummary(0x7FFFFFFE, summary);
            }
        }
        counts.addContents(summary.getCounts());
    }

    boolean computeDiffBetweenSnapshots(Snapshot fromSnapshot, Snapshot toSnapshot, ChildrenDiff diff, INodeDirectory currentINode) {
        int[] diffIndexPair = this.diffs.changedBetweenSnapshots(fromSnapshot, toSnapshot);
        if (diffIndexPair == null) {
            return false;
        }
        int earlierDiffIndex = diffIndexPair[0];
        int laterDiffIndex = diffIndexPair[1];
        boolean dirMetadataChanged = false;
        INodeDirectoryAttributes dirCopy = null;
        List<DirectoryDiff> difflist = this.diffs.getDiffListBetweenSnapshots(earlierDiffIndex, laterDiffIndex, currentINode);
        for (DirectoryDiff sdiff : difflist) {
            diff.combinePosterior(sdiff.diff, null);
            if (dirMetadataChanged || sdiff.snapshotINode == null) continue;
            if (dirCopy == null) {
                dirCopy = (INodeDirectoryAttributes)sdiff.snapshotINode;
                continue;
            }
            if (dirCopy.metadataEquals((INodeDirectoryAttributes)sdiff.snapshotINode)) continue;
            dirMetadataChanged = true;
        }
        if (!diff.isEmpty() || dirMetadataChanged) {
            return true;
        }
        if (dirCopy != null) {
            for (int i = laterDiffIndex; i < difflist.size(); ++i) {
                if (dirCopy.metadataEquals((INodeDirectoryAttributes)difflist.get((int)i).snapshotINode)) continue;
                return true;
            }
            return !dirCopy.metadataEquals(currentINode);
        }
        return false;
    }

    public void cleanDirectory(INode.ReclaimContext reclaimContext, INodeDirectory currentINode, int snapshot, int prior) {
        Map<INode, INode> priorCreated = null;
        Map<INode, INode> priorDeleted = null;
        QuotaCounts old = reclaimContext.quotaDelta().getCountsCopy();
        if (snapshot == 0x7FFFFFFE) {
            currentINode.recordModification(prior);
            DirectoryDiff lastDiff = (DirectoryDiff)this.diffs.getLast();
            if (lastDiff != null) {
                lastDiff.diff.destroyCreatedList(reclaimContext, currentINode);
            }
            currentINode.cleanSubtreeRecursively(reclaimContext, snapshot, prior, null);
        } else {
            DirectoryDiff priorDiff;
            prior = this.getDiffs().updatePrior(snapshot, prior);
            if (prior != -1 && (priorDiff = (DirectoryDiff)this.getDiffs().getDiffById(prior)) != null && priorDiff.getSnapshotId() == prior) {
                priorCreated = DirectoryWithSnapshotFeature.cloneDiffList(priorDiff.diff.getCreatedUnmodifiable());
                priorDeleted = DirectoryWithSnapshotFeature.cloneDiffList(priorDiff.diff.getDeletedUnmodifiable());
            }
            this.getDiffs().deleteSnapshotDiff(reclaimContext, snapshot, prior, currentINode);
            currentINode.cleanSubtreeRecursively(reclaimContext, snapshot, prior, priorDeleted);
            if (prior != -1 && (priorDiff = (DirectoryDiff)this.getDiffs().getDiffById(prior)) != null && priorDiff.getSnapshotId() == prior) {
                if (priorCreated != null) {
                    for (INode cNode : priorDiff.diff.getCreatedUnmodifiable()) {
                        if (!priorCreated.containsKey(cNode)) continue;
                        cNode.cleanSubtree(reclaimContext, snapshot, -1);
                    }
                }
                for (INode dNode : priorDiff.diff.getDeletedUnmodifiable()) {
                    if (priorDeleted != null && priorDeleted.containsKey(dNode)) continue;
                    DirectoryWithSnapshotFeature.cleanDeletedINode(reclaimContext, dNode, snapshot, prior);
                }
            }
        }
        QuotaCounts current = reclaimContext.quotaDelta().getCountsCopy();
        current.subtract(old);
        if (currentINode.isQuotaSet()) {
            reclaimContext.quotaDelta().addQuotaDirUpdate(currentINode, current);
        }
    }

    public static class DirectoryDiffList
    extends AbstractINodeDiffList<INodeDirectory, INodeDirectoryAttributes, DirectoryDiff> {
        @Override
        DirectoryDiff createDiff(int snapshot, INodeDirectory currentDir) {
            return new DirectoryDiff(snapshot, currentDir);
        }

        @Override
        INodeDirectoryAttributes createSnapshotCopy(INodeDirectory currentDir) {
            return currentDir.isQuotaSet() ? new INodeDirectoryAttributes.CopyWithQuota(currentDir) : new INodeDirectoryAttributes.SnapshotCopy(currentDir);
        }

        @Override
        DiffList<DirectoryDiff> newDiffs() {
            return DirectoryDiffListFactory.createDiffList(2);
        }

        public boolean replaceCreatedChild(INode oldChild, INode newChild) {
            DiffList diffList = this.asList();
            for (int i = diffList.size() - 1; i >= 0; --i) {
                ChildrenDiff diff = ((DirectoryDiff)diffList.get(i)).diff;
                if (!diff.replaceCreated(oldChild, newChild)) continue;
                return true;
            }
            return false;
        }

        public boolean removeDeletedChild(INode child) {
            DiffList diffList = this.asList();
            for (int i = diffList.size() - 1; i >= 0; --i) {
                ChildrenDiff diff = ((DirectoryDiff)diffList.get(i)).diff;
                if (!diff.removeDeleted(child)) continue;
                return true;
            }
            return false;
        }

        public int findSnapshotDeleted(INode child) {
            DiffList diffList = this.asList();
            for (int i = diffList.size() - 1; i >= 0; --i) {
                DirectoryDiff diff = (DirectoryDiff)diffList.get(i);
                if (!diff.getChildrenDiff().containsDeleted(child)) continue;
                return diff.getSnapshotId();
            }
            return -1;
        }

        List<DirectoryDiff> getDiffListBetweenSnapshots(int fromIndex, int toIndex, INodeDirectory dir) {
            return this.asList().getMinListForRange(fromIndex, toIndex, dir);
        }
    }

    public static class DirectoryDiff
    extends AbstractINodeDiff<INodeDirectory, INodeDirectoryAttributes, DirectoryDiff> {
        private final int childrenSize;
        private final ChildrenDiff diff;
        private boolean isSnapshotRoot = false;

        private DirectoryDiff(int snapshotId, INodeDirectory dir) {
            this(snapshotId, dir, new ChildrenDiff());
        }

        public DirectoryDiff(int snapshotId, INodeDirectory dir, ChildrenDiff diff) {
            super(snapshotId, null, null);
            this.childrenSize = dir.getChildrenList(0x7FFFFFFE).size();
            this.diff = diff;
        }

        DirectoryDiff(int snapshotId, INodeDirectoryAttributes snapshotINode, DirectoryDiff posteriorDiff, int childrenSize, List<INode> createdList, List<INode> deletedList, boolean isSnapshotRoot) {
            super(snapshotId, snapshotINode, posteriorDiff);
            this.childrenSize = childrenSize;
            this.diff = new ChildrenDiff(createdList, deletedList);
            this.isSnapshotRoot = isSnapshotRoot;
        }

        public ChildrenDiff getChildrenDiff() {
            return this.diff;
        }

        void setSnapshotRoot(INodeDirectoryAttributes root) {
            this.snapshotINode = root;
            this.isSnapshotRoot = true;
        }

        boolean isSnapshotRoot() {
            return this.isSnapshotRoot;
        }

        @Override
        void combinePosteriorAndCollectBlocks(final INode.ReclaimContext reclaimContext, INodeDirectory currentDir, DirectoryDiff posterior) {
            this.diff.combinePosterior(posterior.diff, new Diff.Processor<INode>(){

                @Override
                public void process(INode inode) {
                    if (inode != null) {
                        inode.destroyAndCollectBlocks(reclaimContext);
                    }
                }
            });
        }

        private ReadOnlyList<INode> getChildrenList(final INodeDirectory currentDir) {
            return new ReadOnlyList<INode>(){
                private List<INode> children = null;

                private List<INode> initChildren() {
                    if (this.children == null) {
                        ChildrenDiff combined = new ChildrenDiff();
                        DirectoryDiffList directoryDiffList = currentDir.getDirectoryWithSnapshotFeature().diffs;
                        int diffIndex = directoryDiffList.getDiffIndexById(this.getSnapshotId());
                        List<DirectoryDiff> diffList = directoryDiffList.getDiffListBetweenSnapshots(diffIndex, directoryDiffList.asList().size(), currentDir);
                        for (DirectoryDiff d : diffList) {
                            combined.combinePosterior(d.diff, null);
                        }
                        this.children = combined.apply2Current(ReadOnlyList.Util.asList(currentDir.getChildrenList(0x7FFFFFFE)));
                    }
                    return this.children;
                }

                @Override
                public Iterator<INode> iterator() {
                    return this.initChildren().iterator();
                }

                @Override
                public boolean isEmpty() {
                    return childrenSize == 0;
                }

                @Override
                public int size() {
                    return childrenSize;
                }

                @Override
                public INode get(int i) {
                    return this.initChildren().get(i);
                }
            };
        }

        INode getChild(byte[] name, boolean checkPosterior, INodeDirectory currentDir) {
            DirectoryDiff d = this;
            Diff.Container returned;
            while ((returned = d.diff.accessPrevious(name)) == null) {
                if (!checkPosterior) {
                    return null;
                }
                if (d.getPosterior() == null) {
                    return currentDir.getChild(name, 0x7FFFFFFE);
                }
                d = (DirectoryDiff)d.getPosterior();
            }
            return (INode)returned.getElement();
        }

        @Override
        public String toString() {
            return super.toString() + " childrenSize=" + this.childrenSize + ", " + this.diff;
        }

        int getChildrenSize() {
            return this.childrenSize;
        }

        @Override
        void write(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            this.writeSnapshot(out);
            out.writeInt(this.childrenSize);
            out.writeBoolean(this.isSnapshotRoot);
            if (!this.isSnapshotRoot) {
                if (this.snapshotINode != null) {
                    out.writeBoolean(true);
                    FSImageSerialization.writeINodeDirectoryAttributes((INodeDirectoryAttributes)this.snapshotINode, out);
                } else {
                    out.writeBoolean(false);
                }
            }
            this.diff.write(out, referenceMap);
        }

        @Override
        void destroyDiffAndCollectBlocks(INode.ReclaimContext reclaimContext, INodeDirectory currentINode) {
            this.diff.destroyDeletedList(reclaimContext);
            INodeDirectoryAttributes snapshotINode = (INodeDirectoryAttributes)this.getSnapshotINode();
            if (snapshotINode != null && snapshotINode.getAclFeature() != null) {
                AclStorage.removeAclFeature(snapshotINode.getAclFeature());
            }
        }
    }

    static class ChildrenDiff
    extends Diff<byte[], INode> {
        ChildrenDiff() {
        }

        private ChildrenDiff(List<INode> created, List<INode> deleted) {
            super(created, deleted);
        }

        private boolean replaceCreated(INode oldChild, INode newChild) {
            List list = this.getCreatedUnmodifiable();
            int i = ChildrenDiff.search(list, oldChild.getLocalNameBytes());
            if (i < 0 || ((INode)list.get(i)).getId() != oldChild.getId()) {
                return false;
            }
            INode removed = this.setCreated(i, newChild);
            Preconditions.checkState((removed == oldChild ? 1 : 0) != 0);
            return true;
        }

        private void destroyCreatedList(INode.ReclaimContext reclaimContext, INodeDirectory currentINode) {
            for (INode c : this.getCreatedUnmodifiable()) {
                c.destroyAndCollectBlocks(reclaimContext);
                currentINode.removeChild(c);
            }
            this.clearCreated();
        }

        private void destroyDeletedList(INode.ReclaimContext reclaimContext) {
            for (INode d : this.getDeletedUnmodifiable()) {
                d.destroyAndCollectBlocks(reclaimContext);
            }
            this.clearDeleted();
        }

        private void writeCreated(DataOutput out) throws IOException {
            List created = this.getCreatedUnmodifiable();
            out.writeInt(created.size());
            for (INode node : created) {
                byte[] name = node.getLocalNameBytes();
                out.writeShort(name.length);
                out.write(name);
            }
        }

        private void writeDeleted(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            List deleted = this.getDeletedUnmodifiable();
            out.writeInt(deleted.size());
            for (INode node : deleted) {
                FSImageSerialization.saveINode2Image(node, out, true, referenceMap);
            }
        }

        private void write(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            this.writeCreated(out);
            this.writeDeleted(out, referenceMap);
        }

        private void getDirsInDeleted(List<INodeDirectory> dirList) {
            for (INode node : this.getDeletedUnmodifiable()) {
                if (!node.isDirectory()) continue;
                dirList.add(node.asDirectory());
            }
        }
    }
}

