/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp.dao;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfEntryInfo;
import org.apache.hadoop.mapreduce.v2.hs.CompletedJob;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;

@XmlRootElement(name="job")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JobInfo {
    @VisibleForTesting
    static final String NA = "N/A";
    protected long submitTime;
    protected long startTime;
    protected long finishTime;
    protected String id;
    protected String name;
    protected String queue;
    protected String user;
    protected String state;
    protected int mapsTotal;
    protected int mapsCompleted;
    protected int reducesTotal;
    protected int reducesCompleted;
    protected Boolean uberized;
    protected String diagnostics;
    protected Long avgMapTime;
    protected Long avgReduceTime;
    protected Long avgShuffleTime;
    protected Long avgMergeTime;
    protected Integer failedReduceAttempts;
    protected Integer killedReduceAttempts;
    protected Integer successfulReduceAttempts;
    protected Integer failedMapAttempts;
    protected Integer killedMapAttempts;
    protected Integer successfulMapAttempts;
    protected ArrayList<ConfEntryInfo> acls;
    @XmlTransient
    protected int numMaps;
    @XmlTransient
    protected int numReduces;

    public JobInfo() {
    }

    public JobInfo(Job job) {
        this.id = MRApps.toString((JobId)job.getID());
        JobReport report = job.getReport();
        this.mapsTotal = job.getTotalMaps();
        this.mapsCompleted = job.getCompletedMaps();
        this.reducesTotal = job.getTotalReduces();
        this.reducesCompleted = job.getCompletedReduces();
        this.submitTime = report.getSubmitTime();
        this.startTime = report.getStartTime();
        this.finishTime = report.getFinishTime();
        this.name = job.getName().toString();
        this.queue = job.getQueueName();
        this.user = job.getUserName();
        this.state = job.getState().toString();
        this.acls = new ArrayList();
        if (job instanceof CompletedJob) {
            Map allacls;
            this.avgMapTime = 0L;
            this.avgReduceTime = 0L;
            this.avgShuffleTime = 0L;
            this.avgMergeTime = 0L;
            this.failedReduceAttempts = 0;
            this.killedReduceAttempts = 0;
            this.successfulReduceAttempts = 0;
            this.failedMapAttempts = 0;
            this.killedMapAttempts = 0;
            this.successfulMapAttempts = 0;
            this.countTasksAndAttempts(job);
            this.uberized = job.isUber();
            this.diagnostics = "";
            List diagnostics = job.getDiagnostics();
            if (diagnostics != null && !diagnostics.isEmpty()) {
                StringBuffer b = new StringBuffer();
                for (String diag : diagnostics) {
                    b.append(diag);
                }
                this.diagnostics = b.toString();
            }
            if ((allacls = job.getJobACLs()) != null) {
                for (Map.Entry entry : allacls.entrySet()) {
                    this.acls.add(new ConfEntryInfo(((JobACL)entry.getKey()).getAclName(), ((AccessControlList)entry.getValue()).getAclString()));
                }
            }
        }
    }

    public long getNumMaps() {
        return this.numMaps;
    }

    public long getNumReduces() {
        return this.numReduces;
    }

    public Long getAvgMapTime() {
        return this.avgMapTime;
    }

    public Long getAvgReduceTime() {
        return this.avgReduceTime;
    }

    public Long getAvgShuffleTime() {
        return this.avgShuffleTime;
    }

    public Long getAvgMergeTime() {
        return this.avgMergeTime;
    }

    public Integer getFailedReduceAttempts() {
        return this.failedReduceAttempts;
    }

    public Integer getKilledReduceAttempts() {
        return this.killedReduceAttempts;
    }

    public Integer getSuccessfulReduceAttempts() {
        return this.successfulReduceAttempts;
    }

    public Integer getFailedMapAttempts() {
        return this.failedMapAttempts;
    }

    public Integer getKilledMapAttempts() {
        return this.killedMapAttempts;
    }

    public Integer getSuccessfulMapAttempts() {
        return this.successfulMapAttempts;
    }

    public ArrayList<ConfEntryInfo> getAcls() {
        return this.acls;
    }

    public int getReducesCompleted() {
        return this.reducesCompleted;
    }

    public int getReducesTotal() {
        return this.reducesTotal;
    }

    public int getMapsCompleted() {
        return this.mapsCompleted;
    }

    public int getMapsTotal() {
        return this.mapsTotal;
    }

    public String getState() {
        return this.state;
    }

    public String getUserName() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public String getQueueName() {
        return this.queue;
    }

    public String getId() {
        return this.id;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getFormattedStartTimeStr(DateFormat dateFormat) {
        String str = NA;
        if (this.startTime >= 0L) {
            str = dateFormat.format(new Date(this.startTime));
        }
        return str;
    }

    public String getStartTimeStr() {
        String str = NA;
        if (this.startTime >= 0L) {
            str = new Date(this.startTime).toString();
        }
        return str;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public Boolean isUber() {
        return this.uberized;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    private void countTasksAndAttempts(Job job) {
        this.numReduces = 0;
        this.numMaps = 0;
        Map tasks = job.getTasks();
        if (tasks == null) {
            return;
        }
        for (Task task : tasks.values()) {
            Map attempts = task.getAttempts();
            for (TaskAttempt attempt : attempts.values()) {
                int successful = 0;
                int failed = 0;
                int killed = 0;
                if (!MRApps.TaskAttemptStateUI.NEW.correspondsTo(attempt.getState()) && !MRApps.TaskAttemptStateUI.RUNNING.correspondsTo(attempt.getState())) {
                    if (MRApps.TaskAttemptStateUI.SUCCESSFUL.correspondsTo(attempt.getState())) {
                        ++successful;
                    } else if (MRApps.TaskAttemptStateUI.FAILED.correspondsTo(attempt.getState())) {
                        ++failed;
                    } else if (MRApps.TaskAttemptStateUI.KILLED.correspondsTo(attempt.getState())) {
                        ++killed;
                    }
                }
                switch (task.getType()) {
                    case MAP: {
                        this.successfulMapAttempts = this.successfulMapAttempts + successful;
                        this.failedMapAttempts = this.failedMapAttempts + failed;
                        this.killedMapAttempts = this.killedMapAttempts + killed;
                        if (attempt.getState() != TaskAttemptState.SUCCEEDED) break;
                        ++this.numMaps;
                        this.avgMapTime = this.avgMapTime + (attempt.getFinishTime() - attempt.getLaunchTime());
                        break;
                    }
                    case REDUCE: {
                        this.successfulReduceAttempts = this.successfulReduceAttempts + successful;
                        this.failedReduceAttempts = this.failedReduceAttempts + failed;
                        this.killedReduceAttempts = this.killedReduceAttempts + killed;
                        if (attempt.getState() != TaskAttemptState.SUCCEEDED) break;
                        ++this.numReduces;
                        this.avgShuffleTime = this.avgShuffleTime + (attempt.getShuffleFinishTime() - attempt.getLaunchTime());
                        this.avgMergeTime = this.avgMergeTime + (attempt.getSortFinishTime() - attempt.getShuffleFinishTime());
                        this.avgReduceTime = this.avgReduceTime + (attempt.getFinishTime() - attempt.getSortFinishTime());
                    }
                }
            }
        }
        if (this.numMaps > 0) {
            this.avgMapTime = this.avgMapTime / (long)this.numMaps;
        }
        if (this.numReduces > 0) {
            this.avgReduceTime = this.avgReduceTime / (long)this.numReduces;
            this.avgShuffleTime = this.avgShuffleTime / (long)this.numReduces;
            this.avgMergeTime = this.avgMergeTime / (long)this.numReduces;
        }
    }
}

