/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.hadoop.shaded.org.apache.jute.BinaryInputArchive;
import org.apache.hadoop.shaded.org.apache.jute.BinaryOutputArchive;
import org.apache.hadoop.shaded.org.apache.jute.InputArchive;
import org.apache.hadoop.shaded.org.apache.jute.OutputArchive;
import org.apache.hadoop.shaded.org.apache.jute.Record;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.Util;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.hadoop.shaded.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnLog
implements TxnLog {
    private static final Logger LOG;
    static long preAllocSize;
    public static final int TXNLOG_MAGIC;
    public static final int VERSION = 2;
    private static final long fsyncWarningThresholdMS;
    long lastZxidSeen;
    volatile BufferedOutputStream logStream = null;
    volatile OutputArchive oa;
    volatile FileOutputStream fos = null;
    File logDir;
    private final boolean forceSync = !System.getProperty("zookeeper.forceSync", "yes").equals("no");
    long dbId;
    private LinkedList<FileOutputStream> streamsToFlush = new LinkedList();
    long currentSize;
    File logFileWrite = null;

    public FileTxnLog(File logDir) {
        this.logDir = logDir;
    }

    public static void setPreallocSize(long size) {
        preAllocSize = size;
    }

    protected Checksum makeChecksumAlgorithm() {
        return new Adler32();
    }

    public synchronized void rollLog() throws IOException {
        if (this.logStream != null) {
            this.logStream.flush();
            this.logStream = null;
            this.oa = null;
        }
    }

    public synchronized void close() throws IOException {
        if (this.logStream != null) {
            this.logStream.close();
        }
        for (FileOutputStream log : this.streamsToFlush) {
            log.close();
        }
    }

    public synchronized boolean append(TxnHeader hdr, Record txn) throws IOException {
        if (hdr != null) {
            if (hdr.getZxid() <= this.lastZxidSeen) {
                LOG.warn("Current zxid " + hdr.getZxid() + " is <= " + this.lastZxidSeen + " for " + hdr.getType());
            }
            if (this.logStream == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Creating new log file: log." + Long.toHexString(hdr.getZxid()));
                }
                this.logFileWrite = new File(this.logDir, "log." + Long.toHexString(hdr.getZxid()));
                this.fos = new FileOutputStream(this.logFileWrite);
                this.logStream = new BufferedOutputStream(this.fos);
                this.oa = BinaryOutputArchive.getArchive(this.logStream);
                FileHeader fhdr = new FileHeader(TXNLOG_MAGIC, 2, this.dbId);
                fhdr.serialize(this.oa, "fileheader");
                this.logStream.flush();
                this.currentSize = this.fos.getChannel().position();
                this.streamsToFlush.add(this.fos);
            }
            this.padFile(this.fos);
            byte[] buf = Util.marshallTxnEntry(hdr, txn);
            if (buf == null || buf.length == 0) {
                throw new IOException("Faulty serialization for header and txn");
            }
            Checksum crc = this.makeChecksumAlgorithm();
            crc.update(buf, 0, buf.length);
            this.oa.writeLong(crc.getValue(), "txnEntryCRC");
            Util.writeTxnBytes(this.oa, buf);
            return true;
        }
        return false;
    }

    private void padFile(FileOutputStream out) throws IOException {
        this.currentSize = Util.padLogFile(out, this.currentSize, preAllocSize);
    }

    public static File[] getLogFiles(File[] logDirList, long snapshotZxid) {
        List<File> files = Util.sortDataDir(logDirList, "log", true);
        long logZxid = 0L;
        for (File f : files) {
            long fzxid = Util.getZxidFromName(f.getName(), "log");
            if (fzxid > snapshotZxid || fzxid <= logZxid) continue;
            logZxid = fzxid;
        }
        ArrayList<File> v = new ArrayList<File>(5);
        for (File f : files) {
            long fzxid = Util.getZxidFromName(f.getName(), "log");
            if (fzxid < logZxid) continue;
            v.add(f);
        }
        return v.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastLoggedZxid() {
        long maxLog;
        File[] files = FileTxnLog.getLogFiles(this.logDir.listFiles(), 0L);
        long zxid = maxLog = files.length > 0 ? Util.getZxidFromName(files[files.length - 1].getName(), "log") : -1L;
        TxnLog.TxnIterator itr = null;
        try {
            try {
                FileTxnLog txn = new FileTxnLog(this.logDir);
                itr = txn.read(maxLog);
                while (itr.next()) {
                    TxnHeader hdr = itr.getHeader();
                    zxid = hdr.getZxid();
                }
                Object var10_8 = null;
                this.close(itr);
            }
            catch (IOException e) {
                LOG.warn("Unexpected exception", (Throwable)e);
                Object var10_9 = null;
                this.close(itr);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.close(itr);
            throw throwable;
        }
        return zxid;
    }

    private void close(TxnLog.TxnIterator itr) {
        if (itr != null) {
            try {
                itr.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error closing file iterator", (Throwable)ioe);
            }
        }
    }

    public synchronized void commit() throws IOException {
        if (this.logStream != null) {
            this.logStream.flush();
        }
        for (FileOutputStream log : this.streamsToFlush) {
            log.flush();
            if (!this.forceSync) continue;
            long startSyncNS = System.nanoTime();
            log.getChannel().force(false);
            long syncElapsedMS = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startSyncNS);
            if (syncElapsedMS <= fsyncWarningThresholdMS) continue;
            LOG.warn("fsync-ing the write ahead log in " + Thread.currentThread().getName() + " took " + syncElapsedMS + "ms which will adversely effect operation latency. " + "See the ZooKeeper troubleshooting guide");
        }
        while (this.streamsToFlush.size() > 1) {
            this.streamsToFlush.removeFirst().close();
        }
    }

    public TxnLog.TxnIterator read(long zxid) throws IOException {
        return new FileTxnIterator(this.logDir, zxid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean truncate(long zxid) throws IOException {
        FileTxnIterator itr = null;
        try {
            itr = new FileTxnIterator(this.logDir, zxid);
            PositionInputStream input = itr.inputStream;
            if (input == null) {
                throw new IOException("No log files found to truncate! This could happen if you still have snapshots from an old setup or log files were deleted accidentally or dataLogDir was changed in zoo.cfg.");
            }
            long pos = input.getPosition();
            RandomAccessFile raf = new RandomAccessFile(itr.logFile, "rw");
            raf.setLength(pos);
            raf.close();
            while (itr.goToNextLog()) {
                if (itr.logFile.delete()) continue;
                LOG.warn("Unable to truncate {}", (Object)itr.logFile);
            }
            Object var9_6 = null;
            this.close(itr);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.close(itr);
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileHeader readHeader(File file) throws IOException {
        FileHeader fileHeader;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            BinaryInputArchive ia = BinaryInputArchive.getArchive(is);
            FileHeader hdr = new FileHeader();
            hdr.deserialize(ia, "fileheader");
            fileHeader = hdr;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                LOG.warn("Ignoring exception during close", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            LOG.warn("Ignoring exception during close", (Throwable)e);
        }
        return fileHeader;
    }

    public long getDbId() throws IOException {
        FileTxnIterator itr = new FileTxnIterator(this.logDir, 0L);
        FileHeader fh = FileTxnLog.readHeader(itr.logFile);
        itr.close();
        if (fh == null) {
            throw new IOException("Unsupported Format.");
        }
        return fh.getDbid();
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    static {
        Long fsyncWarningThreshold;
        preAllocSize = 0x4000000L;
        TXNLOG_MAGIC = ByteBuffer.wrap("ZKLG".getBytes()).getInt();
        LOG = LoggerFactory.getLogger(FileTxnLog.class);
        String size = System.getProperty("zookeeper.preAllocSize");
        if (size != null) {
            try {
                preAllocSize = Long.parseLong(size) * 1024L;
            }
            catch (NumberFormatException e) {
                LOG.warn(size + " is not a valid value for preAllocSize");
            }
        }
        if ((fsyncWarningThreshold = Long.getLong("zookeeper.fsync.warningthresholdms")) == null) {
            fsyncWarningThreshold = Long.getLong("fsync.warningthresholdms", 1000L);
        }
        fsyncWarningThresholdMS = fsyncWarningThreshold;
    }

    public static class FileTxnIterator
    implements TxnLog.TxnIterator {
        File logDir;
        long zxid;
        TxnHeader hdr;
        Record record;
        File logFile;
        InputArchive ia;
        static final String CRC_ERROR = "CRC check failed";
        PositionInputStream inputStream = null;
        private ArrayList<File> storedFiles;

        public FileTxnIterator(File logDir, long zxid) throws IOException {
            this.logDir = logDir;
            this.zxid = zxid;
            this.init();
        }

        void init() throws IOException {
            this.storedFiles = new ArrayList();
            List<File> files = Util.sortDataDir(FileTxnLog.getLogFiles(this.logDir.listFiles(), 0L), "log", false);
            for (File f : files) {
                if (Util.getZxidFromName(f.getName(), "log") >= this.zxid) {
                    this.storedFiles.add(f);
                    continue;
                }
                if (Util.getZxidFromName(f.getName(), "log") >= this.zxid) continue;
                this.storedFiles.add(f);
                break;
            }
            this.goToNextLog();
            if (!this.next()) {
                return;
            }
            while (this.hdr.getZxid() < this.zxid) {
                if (this.next()) continue;
                return;
            }
        }

        private boolean goToNextLog() throws IOException {
            if (this.storedFiles.size() > 0) {
                this.logFile = this.storedFiles.remove(this.storedFiles.size() - 1);
                this.ia = this.createInputArchive(this.logFile);
                return true;
            }
            return false;
        }

        protected void inStreamCreated(InputArchive ia, InputStream is) throws IOException {
            FileHeader header = new FileHeader();
            header.deserialize(ia, "fileheader");
            if (header.getMagic() != TXNLOG_MAGIC) {
                throw new IOException("Transaction log: " + this.logFile + " has invalid magic number " + header.getMagic() + " != " + TXNLOG_MAGIC);
            }
        }

        protected InputArchive createInputArchive(File logFile) throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new PositionInputStream(new BufferedInputStream(new FileInputStream(logFile)));
                LOG.debug("Created new input stream " + logFile);
                this.ia = BinaryInputArchive.getArchive(this.inputStream);
                this.inStreamCreated(this.ia, this.inputStream);
                LOG.debug("Created new input archive " + logFile);
            }
            return this.ia;
        }

        protected Checksum makeChecksumAlgorithm() {
            return new Adler32();
        }

        public boolean next() throws IOException {
            if (this.ia == null) {
                return false;
            }
            try {
                long crcValue = this.ia.readLong("crcvalue");
                byte[] bytes = Util.readTxnBytes(this.ia);
                if (bytes == null || bytes.length == 0) {
                    throw new EOFException("Failed to read " + this.logFile);
                }
                Checksum crc = this.makeChecksumAlgorithm();
                crc.update(bytes, 0, bytes.length);
                if (crcValue != crc.getValue()) {
                    throw new IOException(CRC_ERROR);
                }
                if (bytes == null || bytes.length == 0) {
                    return false;
                }
                this.hdr = new TxnHeader();
                this.record = SerializeUtils.deserializeTxn(bytes, this.hdr);
            }
            catch (EOFException e) {
                LOG.debug("EOF excepton " + e);
                this.inputStream.close();
                this.inputStream = null;
                this.ia = null;
                this.hdr = null;
                if (!this.goToNextLog()) {
                    return false;
                }
                return this.next();
            }
            catch (IOException e) {
                this.inputStream.close();
                throw e;
            }
            return true;
        }

        public TxnHeader getHeader() {
            return this.hdr;
        }

        public Record getTxn() {
            return this.record;
        }

        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }

    static class PositionInputStream
    extends FilterInputStream {
        long position = 0L;

        protected PositionInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int rc = super.read();
            if (rc > -1) {
                ++this.position;
            }
            return rc;
        }

        public int read(byte[] b) throws IOException {
            int rc = super.read(b);
            if (rc > 0) {
                this.position += (long)rc;
            }
            return rc;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int rc = super.read(b, off, len);
            if (rc > 0) {
                this.position += (long)rc;
            }
            return rc;
        }

        public long skip(long n) throws IOException {
            long rc = super.skip(n);
            if (rc > 0L) {
                this.position += rc;
            }
            return rc;
        }

        public long getPosition() {
            return this.position;
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int readLimit) {
            throw new UnsupportedOperationException("mark");
        }

        public void reset() {
            throw new UnsupportedOperationException("reset");
        }
    }
}

