/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http;

import java.util.Locale;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.HttpHeader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.HttpRequestPacket;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.HttpResponsePacketImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.DataChunk;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.Header;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.HttpStatus;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.util.MimeHeaders;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;

public abstract class HttpResponsePacket
extends HttpHeader {
    private HttpRequestPacket request;
    private Locale locale;
    private String contentLanguage;
    protected HttpStatus httpStatus;
    private final DataChunk reasonPhraseC = DataChunk.newInstance();
    private boolean acknowledgment;
    private boolean allowCustomReasonPhrase = true;
    private boolean chunkingAllowed;

    public static Builder builder(HttpRequestPacket request) {
        return new Builder(request);
    }

    protected HttpResponsePacket() {
    }

    public int getStatus() {
        return this.getHttpStatus().getStatusCode();
    }

    public HttpStatus getHttpStatus() {
        if (this.httpStatus == null) {
            this.httpStatus = HttpStatus.OK_200;
        }
        return this.httpStatus;
    }

    public void setStatus(int status) {
        this.httpStatus = HttpStatus.getHttpStatus(status);
    }

    public void setStatus(HttpStatus status) {
        this.httpStatus = status;
    }

    public final boolean isAllowCustomReasonPhrase() {
        return this.allowCustomReasonPhrase;
    }

    public final void setAllowCustomReasonPhrase(boolean allowCustomReasonPhrase) {
        this.allowCustomReasonPhrase = allowCustomReasonPhrase;
    }

    public final DataChunk getReasonPhraseRawDC() {
        return this.reasonPhraseC;
    }

    public final DataChunk getReasonPhraseDC() {
        if (this.isCustomReasonPhraseSet()) {
            return this.reasonPhraseC;
        }
        Buffer b = Buffers.wrap(null, this.httpStatus.getReasonPhraseBytes());
        b.allowBufferDispose(true);
        this.reasonPhraseC.setBuffer(b, b.position(), b.limit());
        return this.reasonPhraseC;
    }

    public final String getReasonPhrase() {
        return this.getReasonPhraseDC().toString();
    }

    public void setReasonPhrase(String message) {
        this.reasonPhraseC.setString(message);
    }

    public void setReasonPhrase(Buffer reason) {
        this.reasonPhraseC.setBuffer(reason, reason.position(), reason.limit());
    }

    public final boolean isCustomReasonPhraseSet() {
        return this.allowCustomReasonPhrase && !this.reasonPhraseC.isNull();
    }

    public HttpRequestPacket getRequest() {
        return this.request;
    }

    public boolean isAcknowledgement() {
        return this.acknowledgment;
    }

    public void setAcknowledgement(boolean acknowledgement) {
        this.acknowledgment = acknowledgement;
    }

    public boolean isChunkingAllowed() {
        return this.chunkingAllowed;
    }

    public void setChunkingAllowed(boolean chunkingAllowed) {
        this.chunkingAllowed = chunkingAllowed;
    }

    public void acknowledged() {
        this.request.requiresAcknowledgement(false);
        this.acknowledgment = false;
        this.httpStatus = null;
        this.reasonPhraseC.recycle();
    }

    @Override
    protected void reset() {
        this.httpStatus = null;
        this.acknowledgment = false;
        this.allowCustomReasonPhrase = true;
        this.reasonPhraseC.recycle();
        this.locale = null;
        this.contentLanguage = null;
        this.request = null;
        super.reset();
    }

    @Override
    public final boolean isRequest() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("HttpResponsePacket (\n  status=").append(this.getStatus()).append("\n  reason=").append(this.getReasonPhrase()).append("\n  protocol=").append(this.getProtocol().getProtocolString()).append("\n  content-length=").append(this.getContentLength()).append("\n  committed=").append(this.isCommitted()).append("\n  headers=[");
        MimeHeaders headersLocal = this.getHeaders();
        for (String name : headersLocal.names()) {
            sb.append("\n      ").append(name).append('=').append(headersLocal.getHeader(name));
        }
        sb.append("]\n)");
        return sb.toString();
    }

    @Override
    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        String result = this.handleGetSpecialHeader(name);
        return result != null ? result : super.getHeader(name);
    }

    @Override
    public String getHeader(Header header) {
        if (header == null) {
            return null;
        }
        String result = this.handleGetSpecialHeader(header);
        return result != null ? result : super.getHeader(header);
    }

    @Override
    public boolean containsHeader(String name) {
        if (name == null) {
            return false;
        }
        String result = this.handleGetSpecialHeader(name);
        return result != null || super.containsHeader(name);
    }

    @Override
    public boolean containsHeader(Header header) {
        if (header == null) {
            return false;
        }
        String result = this.handleGetSpecialHeader(header);
        return result != null || super.containsHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        super.setHeader(name, value);
    }

    @Override
    public void setHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        String name = header.toString();
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        super.setHeader(header, value);
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        super.addHeader(name, value);
    }

    @Override
    public void addHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(header, value)) {
            return;
        }
        super.addHeader(header, value);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        String country;
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0 && (country = locale.getCountry()) != null && country.length() > 0) {
            StringBuilder value = new StringBuilder(this.contentLanguage);
            value.append('-');
            value.append(country);
            this.contentLanguage = value.toString();
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
    }

    public void setRequest(HttpRequestPacket request) {
        this.request = request;
    }

    private String getValueBasedOnHeader(Header header) {
        long value;
        String value2;
        if (Header.ContentType.equals((Object)header) && (value2 = this.getContentType()) != null) {
            return value2;
        }
        if (Header.ContentLength.equals((Object)header) && (value = this.getContentLength()) >= 0L) {
            return Long.toString(value);
        }
        return null;
    }

    private String getValueBasedOnHeader(String name) {
        long value;
        String value2;
        if (Header.ContentType.toString().equalsIgnoreCase(name) && (value2 = this.getContentType()) != null) {
            return value2;
        }
        if (Header.ContentLength.toString().equalsIgnoreCase(name) && (value = this.getContentLength()) >= 0L) {
            return Long.toString(value);
        }
        return null;
    }

    private boolean setValueBasedOnHeader(String name, String value) {
        if (Header.ContentType.toString().equalsIgnoreCase(name)) {
            this.setContentType(value);
            return true;
        }
        if (Header.ContentLength.toString().equalsIgnoreCase(name)) {
            try {
                long cLL = Long.parseLong(value);
                this.setContentLengthLong(cLL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    private boolean setValueBasedOnHeader(Header header, String value) {
        if (Header.ContentType.equals((Object)header)) {
            this.setContentType(value);
            return true;
        }
        if (Header.ContentLength.equals((Object)header)) {
            try {
                long cLL = Long.parseLong(value);
                this.setContentLengthLong(cLL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    private String handleGetSpecialHeader(String name) {
        return this.isSpecialHeader(name) ? this.getValueBasedOnHeader(name) : null;
    }

    private String handleGetSpecialHeader(Header header) {
        return this.isSpecialHeader(header.toString()) ? this.getValueBasedOnHeader(header) : null;
    }

    private boolean handleSetSpecialHeaders(String name, String value) {
        return this.isSpecialHeader(name) && this.setValueBasedOnHeader(name, value);
    }

    private boolean handleSetSpecialHeaders(Header header, String value) {
        return this.isSpecialHeader(header.toString()) && this.setValueBasedOnHeader(header, value);
    }

    private boolean isSpecialHeader(String name) {
        char c = name.charAt(0);
        return c == 'C' || c == 'c';
    }

    public static class Builder
    extends HttpHeader.Builder<Builder> {
        protected Builder(HttpRequestPacket request) {
            this.packet = request.getResponse();
            if (this.packet == null) {
                this.packet = HttpResponsePacketImpl.create();
                ((HttpResponsePacket)this.packet).setRequest(request);
                this.packet.setSecure(request.isSecure());
            }
        }

        public Builder status(int status) {
            ((HttpResponsePacket)this.packet).setStatus(status);
            return this;
        }

        public Builder reasonPhrase(String reasonPhrase) {
            ((HttpResponsePacket)this.packet).setReasonPhrase(reasonPhrase);
            return this;
        }

        public final HttpResponsePacket build() {
            return (HttpResponsePacket)this.packet;
        }
    }
}

