/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerClient;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class DockerCommand {
    private final String command;
    private final Map<String, List<String>> commandArguments;

    protected DockerCommand(String command) {
        String dockerCommandKey = "docker-command";
        this.command = command;
        this.commandArguments = new TreeMap<String, List<String>>();
        this.commandArguments.put(dockerCommandKey, new ArrayList());
        this.commandArguments.get(dockerCommandKey).add(command);
    }

    public final String getCommandOption() {
        return this.command;
    }

    protected final void addCommandArguments(String key, String value) {
        List<String> list = this.commandArguments.get(key);
        if (list != null) {
            list.add(value);
            return;
        }
        list = new ArrayList<String>();
        list.add(value);
        this.commandArguments.put(key, list);
    }

    public Map<String, List<String>> getDockerCommandWithArguments() {
        return Collections.unmodifiableMap(this.commandArguments);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.command);
        for (Map.Entry<String, List<String>> entry : this.commandArguments.entrySet()) {
            ret.append(" ").append(entry.getKey());
            ret.append("=").append(StringUtils.join((CharSequence)",", (Iterable)entry.getValue()));
        }
        return ret.toString();
    }

    public void setClientConfigDir(String clientConfigDir) {
        if (clientConfigDir != null) {
            this.addCommandArguments("docker-config", clientConfigDir);
        }
    }

    public PrivilegedOperation preparePrivilegedOperation(DockerCommand dockerCommand, String containerName, Map<String, String> env, Configuration conf, Context nmContext) throws ContainerExecutionException {
        DockerClient dockerClient = new DockerClient(conf);
        String commandFile = dockerClient.writeCommandToTempFile(dockerCommand, ContainerId.fromString((String)containerName), nmContext);
        PrivilegedOperation dockerOp = new PrivilegedOperation(PrivilegedOperation.OperationType.RUN_DOCKER_CMD);
        dockerOp.appendArgs(commandFile);
        return dockerOp;
    }
}

