/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.DecommissioningNodesWatcher;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeLabelsUtils;
import org.apache.hadoop.yarn.server.resourcemanager.resource.DynamicResourceConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.utils.YarnServerBuilderUtils;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.YarnVersionInfo;

public class ResourceTrackerService
extends AbstractService
implements ResourceTracker {
    private static final Log LOG = LogFactory.getLog(ResourceTrackerService.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final RMContext rmContext;
    private final NodesListManager nodesListManager;
    private final NMLivelinessMonitor nmLivelinessMonitor;
    private final RMContainerTokenSecretManager containerTokenSecretManager;
    private final NMTokenSecretManagerInRM nmTokenSecretManager;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private long nextHeartBeatInterval;
    private Server server;
    private InetSocketAddress resourceTrackerAddress;
    private String minimumNodeManagerVersion;
    private int minAllocMb;
    private int minAllocVcores;
    private DecommissioningNodesWatcher decommissioningWatcher;
    private boolean isDistributedNodeLabelsConf;
    private boolean isDelegatedCentralizedNodeLabelsConf;
    private DynamicResourceConfiguration drConf;
    private final AtomicLong timelineCollectorVersion = new AtomicLong(0L);

    public ResourceTrackerService(RMContext rmContext, NodesListManager nodesListManager, NMLivelinessMonitor nmLivelinessMonitor, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager) {
        super(ResourceTrackerService.class.getName());
        this.rmContext = rmContext;
        this.nodesListManager = nodesListManager;
        this.nmLivelinessMonitor = nmLivelinessMonitor;
        this.containerTokenSecretManager = containerTokenSecretManager;
        this.nmTokenSecretManager = nmTokenSecretManager;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.decommissioningWatcher = new DecommissioningNodesWatcher(rmContext);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.resourceTrackerAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        RackResolver.init((Configuration)conf);
        this.nextHeartBeatInterval = conf.getLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1000L);
        if (this.nextHeartBeatInterval <= 0L) {
            throw new YarnRuntimeException("Invalid Configuration. yarn.resourcemanager.nodemanagers.heartbeat-interval-ms should be larger than 0.");
        }
        this.minAllocMb = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        this.minAllocVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        this.minimumNodeManagerVersion = conf.get("yarn.resourcemanager.nodemanager.minimum.version", "NONE");
        if (YarnConfiguration.areNodeLabelsEnabled((Configuration)conf)) {
            this.isDistributedNodeLabelsConf = YarnConfiguration.isDistributedNodeLabelConfiguration((Configuration)conf);
            this.isDelegatedCentralizedNodeLabelsConf = YarnConfiguration.isDelegatedCentralizedNodeLabelConfiguration((Configuration)conf);
        }
        this.loadDynamicResourceConfiguration(conf);
        this.decommissioningWatcher.init(conf);
        super.serviceInit(conf);
    }

    public void loadDynamicResourceConfiguration(Configuration conf) throws IOException {
        try {
            InputStream drInputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "dynamic-resources.xml");
            this.drConf = drInputStream != null ? new DynamicResourceConfiguration(conf, drInputStream) : new DynamicResourceConfiguration(conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void updateDynamicResourceConfiguration(DynamicResourceConfiguration conf) {
        this.writeLock.lock();
        try {
            this.drConf = conf;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ResourceTracker.class, (Object)this, this.resourceTrackerAddress, conf, null, conf.getInt("yarn.resourcemanager.resource-tracker.client.thread-count", 50));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            InputStream inputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "hadoop-policy.xml");
            if (inputStream != null) {
                conf.addResource(inputStream);
            }
            this.refreshServiceAcls(conf, RMPolicyProvider.getInstance());
        }
        this.server.start();
        conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", this.server.getListenerAddress());
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    void handleNMContainerStatus(NMContainerStatus containerStatus, NodeId nodeId) {
        ApplicationAttemptId appAttemptId = containerStatus.getContainerId().getApplicationAttemptId();
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId());
        if (rmApp == null) {
            LOG.error((Object)("Received finished container : " + containerStatus.getContainerId() + " for unknown application " + appAttemptId.getApplicationId() + " Skipping."));
            return;
        }
        if (rmApp.getApplicationSubmissionContext().getUnmanagedAM()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignoring container completion status for unmanaged AM " + rmApp.getApplicationId()));
            }
            return;
        }
        RMAppAttempt rmAppAttempt = rmApp.getRMAppAttempt(appAttemptId);
        if (rmAppAttempt == null) {
            LOG.info((Object)("Ignoring not found attempt " + appAttemptId));
            return;
        }
        Container masterContainer = rmAppAttempt.getMasterContainer();
        if (masterContainer.getId().equals((Object)containerStatus.getContainerId()) && containerStatus.getContainerState() == ContainerState.COMPLETE) {
            ContainerStatus status = ContainerStatus.newInstance((ContainerId)containerStatus.getContainerId(), (ContainerState)containerStatus.getContainerState(), (String)containerStatus.getDiagnostics(), (int)containerStatus.getContainerExitStatus());
            RMAppAttemptContainerFinishedEvent evt = new RMAppAttemptContainerFinishedEvent(appAttemptId, status, nodeId);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)evt);
        }
    }

    @Override
    public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnException, IOException {
        NodeId nodeId = request.getNodeId();
        String host = nodeId.getHost();
        int cmPort = nodeId.getPort();
        int httpPort = request.getHttpPort();
        Resource capability = request.getResource();
        String nodeManagerVersion = request.getNMVersion();
        Resource physicalResource = request.getPhysicalResource();
        RegisterNodeManagerResponse response = (RegisterNodeManagerResponse)recordFactory.newRecordInstance(RegisterNodeManagerResponse.class);
        if (!this.minimumNodeManagerVersion.equals("NONE")) {
            if (this.minimumNodeManagerVersion.equals("EqualToRM")) {
                this.minimumNodeManagerVersion = YarnVersionInfo.getVersion();
            }
            if (nodeManagerVersion == null || VersionUtil.compareVersions((String)nodeManagerVersion, (String)this.minimumNodeManagerVersion) < 0) {
                String message = "Disallowed NodeManager Version " + nodeManagerVersion + ", is less than the minimum version " + this.minimumNodeManagerVersion + " sending SHUTDOWN signal to NodeManager.";
                LOG.info((Object)message);
                response.setDiagnosticsMessage(message);
                response.setNodeAction(NodeAction.SHUTDOWN);
                return response;
            }
        }
        if (!this.nodesListManager.isValidNode(host) && !this.isNodeInDecommissioning(nodeId)) {
            String message = "Disallowed NodeManager from  " + host + ", Sending SHUTDOWN signal to the NodeManager.";
            LOG.info((Object)message);
            response.setDiagnosticsMessage(message);
            response.setNodeAction(NodeAction.SHUTDOWN);
            return response;
        }
        String nid = nodeId.toString();
        Resource dynamicLoadCapability = this.loadNodeResourceFromDRConfiguration(nid);
        if (dynamicLoadCapability != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Resource for node: " + nid + " is adjusted from: " + capability + " to: " + dynamicLoadCapability + " due to settings in dynamic-resources.xml."));
            }
            capability = dynamicLoadCapability;
            response.setResource(capability);
        }
        if (capability.getMemorySize() < (long)this.minAllocMb || capability.getVirtualCores() < this.minAllocVcores) {
            String message = "NodeManager from  " + host + " doesn't satisfy minimum allocations, Sending SHUTDOWN signal to the NodeManager. Node capabilities are " + capability + "; minimums are " + this.minAllocMb + "mb and " + this.minAllocVcores + " vcores";
            LOG.info((Object)message);
            response.setDiagnosticsMessage(message);
            response.setNodeAction(NodeAction.SHUTDOWN);
            return response;
        }
        response.setContainerTokenMasterKey(this.containerTokenSecretManager.getCurrentKey());
        response.setNMTokenMasterKey(this.nmTokenSecretManager.getCurrentKey());
        RMNodeImpl rmNode = new RMNodeImpl(nodeId, this.rmContext, host, cmPort, httpPort, ResourceTrackerService.resolve(host), capability, nodeManagerVersion, physicalResource);
        RMNode oldNode = this.rmContext.getRMNodes().putIfAbsent(nodeId, rmNode);
        if (oldNode == null) {
            RMNodeStartedEvent startEvent = new RMNodeStartedEvent(nodeId, request.getNMContainerStatuses(), request.getRunningApplications());
            if (request.getLogAggregationReportsForApps() != null && !request.getLogAggregationReportsForApps().isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found the number of previous cached log aggregation status from nodemanager:" + nodeId + " is :" + request.getLogAggregationReportsForApps().size()));
                }
                startEvent.setLogAggregationReportsForApps(request.getLogAggregationReportsForApps());
            }
            this.rmContext.getDispatcher().getEventHandler().handle((Event)startEvent);
        } else {
            LOG.info((Object)("Reconnect from the node at: " + host));
            this.nmLivelinessMonitor.unregister(nodeId);
            if (CollectionUtils.isEmpty(request.getRunningApplications()) && rmNode.getState() != NodeState.DECOMMISSIONING && rmNode.getHttpPort() != oldNode.getHttpPort()) {
                switch (rmNode.getState()) {
                    case RUNNING: {
                        ClusterMetrics.getMetrics().decrNumActiveNodes();
                        break;
                    }
                    case UNHEALTHY: {
                        ClusterMetrics.getMetrics().decrNumUnhealthyNMs();
                        break;
                    }
                    default: {
                        LOG.debug((Object)"Unexpected Rmnode state");
                    }
                }
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
                this.rmContext.getRMNodes().put(nodeId, rmNode);
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeStartedEvent(nodeId, null, null));
            } else {
                oldNode.resetLastNodeHeartBeatResponse();
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeReconnectEvent(nodeId, rmNode, request.getRunningApplications(), request.getNMContainerStatuses()));
            }
        }
        this.nmTokenSecretManager.removeNodeKey(nodeId);
        this.nmLivelinessMonitor.register(nodeId);
        if (!this.rmContext.isWorkPreservingRecoveryEnabled() && !request.getNMContainerStatuses().isEmpty()) {
            LOG.info((Object)("received container statuses on node manager register :" + request.getNMContainerStatuses()));
            for (NMContainerStatus status : request.getNMContainerStatuses()) {
                this.handleNMContainerStatus(status, nodeId);
            }
        }
        Set<String> nodeLabels = NodeLabelsUtils.convertToStringSet(request.getNodeLabels());
        if (this.isDistributedNodeLabelsConf && nodeLabels != null) {
            try {
                this.updateNodeLabelsFromNMReport(nodeLabels, nodeId);
                response.setAreNodeLabelsAcceptedByRM(true);
            }
            catch (IOException ex) {
                response.setDiagnosticsMessage(ex.getMessage());
                response.setAreNodeLabelsAcceptedByRM(false);
            }
        } else if (this.isDelegatedCentralizedNodeLabelsConf) {
            this.rmContext.getRMDelegatedNodeLabelsUpdater().updateNodeLabels(nodeId);
        }
        StringBuilder message = new StringBuilder();
        message.append("NodeManager from node ").append(host).append("(cmPort: ").append(cmPort).append(" httpPort: ");
        message.append(httpPort).append(") ").append("registered with capability: ").append(capability);
        message.append(", assigned nodeId ").append(nodeId);
        if (response.getAreNodeLabelsAcceptedByRM()) {
            message.append(", node labels { ").append(StringUtils.join((CharSequence)",", nodeLabels) + " } ");
        }
        LOG.info((Object)message.toString());
        response.setNodeAction(NodeAction.NORMAL);
        response.setRMIdentifier(ResourceManager.getClusterTimeStamp());
        response.setRMVersion(YarnVersionInfo.getVersion());
        return response;
    }

    @Override
    public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnException, IOException {
        String nid;
        Resource capability;
        NodeStatus remoteNodeStatus = request.getNodeStatus();
        NodeId nodeId = remoteNodeStatus.getNodeId();
        if (!this.nodesListManager.isValidNode(nodeId.getHost()) && !this.isNodeInDecommissioning(nodeId)) {
            String message = "Disallowed NodeManager nodeId: " + nodeId + " hostname: " + nodeId.getHost();
            LOG.info((Object)message);
            return YarnServerBuilderUtils.newNodeHeartbeatResponse(NodeAction.SHUTDOWN, message);
        }
        RMNode rmNode = (RMNode)this.rmContext.getRMNodes().get(nodeId);
        if (rmNode == null) {
            String message = "Node not found resyncing " + remoteNodeStatus.getNodeId();
            LOG.info((Object)message);
            return YarnServerBuilderUtils.newNodeHeartbeatResponse(NodeAction.RESYNC, message);
        }
        this.nmLivelinessMonitor.receivedPing(nodeId);
        this.decommissioningWatcher.update(rmNode, remoteNodeStatus);
        NodeHeartbeatResponse lastNodeHeartbeatResponse = rmNode.getLastNodeHeartBeatResponse();
        if (this.getNextResponseId(remoteNodeStatus.getResponseId()) == lastNodeHeartbeatResponse.getResponseId()) {
            LOG.info((Object)("Received duplicate heartbeat from node " + rmNode.getNodeAddress() + " responseId=" + remoteNodeStatus.getResponseId()));
            return lastNodeHeartbeatResponse;
        }
        if (remoteNodeStatus.getResponseId() != lastNodeHeartbeatResponse.getResponseId()) {
            String message = "Too far behind rm response id:" + lastNodeHeartbeatResponse.getResponseId() + " nm response id:" + remoteNodeStatus.getResponseId();
            LOG.info((Object)message);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.REBOOTING));
            return YarnServerBuilderUtils.newNodeHeartbeatResponse(NodeAction.RESYNC, message);
        }
        if (rmNode.getState() == NodeState.DECOMMISSIONING && this.decommissioningWatcher.checkReadyToBeDecommissioned(rmNode.getNodeID())) {
            String message = "DECOMMISSIONING " + nodeId + " is ready to be decommissioned";
            LOG.info((Object)message);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.DECOMMISSION));
            this.nmLivelinessMonitor.unregister(nodeId);
            return YarnServerBuilderUtils.newNodeHeartbeatResponse(NodeAction.SHUTDOWN, message);
        }
        boolean timelineV2Enabled = YarnConfiguration.timelineServiceV2Enabled((Configuration)this.getConfig());
        if (timelineV2Enabled) {
            this.updateAppCollectorsMap(request);
        }
        NodeHeartbeatResponse nodeHeartBeatResponse = YarnServerBuilderUtils.newNodeHeartbeatResponse(this.getNextResponseId(lastNodeHeartbeatResponse.getResponseId()), NodeAction.NORMAL, null, null, null, null, this.nextHeartBeatInterval);
        rmNode.setAndUpdateNodeHeartbeatResponse(nodeHeartBeatResponse);
        this.populateKeys(request, nodeHeartBeatResponse);
        ConcurrentMap<ApplicationId, ByteBuffer> systemCredentials = this.rmContext.getSystemCredentialsForApps();
        if (!systemCredentials.isEmpty()) {
            nodeHeartBeatResponse.setSystemCredentialsForApps(systemCredentials);
        }
        if (timelineV2Enabled) {
            this.setAppCollectorsMapToResponse(rmNode.getRunningApps(), nodeHeartBeatResponse);
        }
        RMNodeStatusEvent nodeStatusEvent = new RMNodeStatusEvent(nodeId, remoteNodeStatus);
        if (request.getLogAggregationReportsForApps() != null && !request.getLogAggregationReportsForApps().isEmpty()) {
            nodeStatusEvent.setLogAggregationReportsForApps(request.getLogAggregationReportsForApps());
        }
        this.rmContext.getDispatcher().getEventHandler().handle((Event)nodeStatusEvent);
        if (this.isDistributedNodeLabelsConf && request.getNodeLabels() != null) {
            try {
                this.updateNodeLabelsFromNMReport(NodeLabelsUtils.convertToStringSet(request.getNodeLabels()), nodeId);
                nodeHeartBeatResponse.setAreNodeLabelsAcceptedByRM(true);
            }
            catch (IOException ex) {
                nodeHeartBeatResponse.setDiagnosticsMessage(ex.getMessage());
                nodeHeartBeatResponse.setAreNodeLabelsAcceptedByRM(false);
            }
        }
        if ((capability = this.loadNodeResourceFromDRConfiguration(nid = nodeId.toString())) != null) {
            nodeHeartBeatResponse.setResource(capability);
        }
        if (this.rmContext.getNodeManagerQueueLimitCalculator() != null) {
            nodeHeartBeatResponse.setContainerQueuingLimit(this.rmContext.getNodeManagerQueueLimitCalculator().createContainerQueuingLimit());
        }
        return nodeHeartBeatResponse;
    }

    private int getNextResponseId(int responseId) {
        return responseId + 1 & Integer.MAX_VALUE;
    }

    private void setAppCollectorsMapToResponse(List<ApplicationId> runningApps, NodeHeartbeatResponse response) {
        HashMap<ApplicationId, AppCollectorData> liveAppCollectorsMap = new HashMap<ApplicationId, AppCollectorData>();
        ConcurrentMap<ApplicationId, RMApp> rmApps = this.rmContext.getRMApps();
        for (ApplicationId appId : runningApps) {
            RMApp app = (RMApp)rmApps.get(appId);
            if (app == null) continue;
            AppCollectorData appCollectorData = ((RMApp)rmApps.get(appId)).getCollectorData();
            if (appCollectorData != null) {
                liveAppCollectorsMap.put(appId, appCollectorData);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Collector for applicaton: " + appId + " hasn't registered yet!"));
        }
        response.setAppCollectors(liveAppCollectorsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppCollectorsMap(NodeHeartbeatRequest request) {
        Map<ApplicationId, AppCollectorData> registeringCollectorsMap = request.getRegisteringCollectors();
        if (registeringCollectorsMap != null && !registeringCollectorsMap.isEmpty()) {
            ConcurrentMap<ApplicationId, RMApp> rmApps = this.rmContext.getRMApps();
            for (Map.Entry<ApplicationId, AppCollectorData> entry : registeringCollectorsMap.entrySet()) {
                RMApp rmApp;
                ApplicationId appId = entry.getKey();
                AppCollectorData collectorData = entry.getValue();
                if (collectorData == null) continue;
                if (!collectorData.isStamped()) {
                    collectorData.setRMIdentifier(ResourceManager.getClusterTimeStamp());
                    collectorData.setVersion(this.timelineCollectorVersion.getAndIncrement());
                }
                if ((rmApp = (RMApp)rmApps.get(appId)) == null) {
                    LOG.warn((Object)("Cannot update collector info because application ID: " + appId + " is not found in RMContext!"));
                    continue;
                }
                RMApp rMApp = rmApp;
                synchronized (rMApp) {
                    AppCollectorData previousCollectorData = rmApp.getCollectorData();
                    if (AppCollectorData.happensBefore(previousCollectorData, collectorData)) {
                        LOG.info((Object)("Update collector information for application " + appId + " with new address: " + collectorData.getCollectorAddr() + " timestamp: " + collectorData.getRMIdentifier() + ", " + collectorData.getVersion()));
                        ((RMAppImpl)rmApp).setCollectorData(collectorData);
                    }
                }
            }
        }
    }

    private boolean isNodeInDecommissioning(NodeId nodeId) {
        RMNode rmNode = (RMNode)this.rmContext.getRMNodes().get(nodeId);
        return rmNode != null && rmNode.getState().equals((Object)NodeState.DECOMMISSIONING);
    }

    @Override
    public UnRegisterNodeManagerResponse unRegisterNodeManager(UnRegisterNodeManagerRequest request) throws YarnException, IOException {
        UnRegisterNodeManagerResponse response = (UnRegisterNodeManagerResponse)recordFactory.newRecordInstance(UnRegisterNodeManagerResponse.class);
        NodeId nodeId = request.getNodeId();
        RMNode rmNode = (RMNode)this.rmContext.getRMNodes().get(nodeId);
        if (rmNode == null) {
            LOG.info((Object)("Node not found, ignoring the unregister from node id : " + nodeId));
            return response;
        }
        LOG.info((Object)("Node with node id : " + nodeId + " has shutdown, hence unregistering the node."));
        this.nmLivelinessMonitor.unregister(nodeId);
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.SHUTDOWN));
        return response;
    }

    private void updateNodeLabelsFromNMReport(Set<String> nodeLabels, NodeId nodeId) throws IOException {
        try {
            HashMap<NodeId, Set<String>> labelsUpdate = new HashMap<NodeId, Set<String>>();
            labelsUpdate.put(nodeId, nodeLabels);
            this.rmContext.getNodeLabelManager().replaceLabelsOnNode(labelsUpdate);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node Labels {" + StringUtils.join((CharSequence)",", nodeLabels) + "} from Node " + nodeId + " were Accepted from RM"));
            }
        }
        catch (IOException ex) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Node Labels {").append(StringUtils.join((CharSequence)",", nodeLabels)).append("} reported from NM with ID ").append(nodeId).append(" was rejected from RM with exception message as : ").append(ex.getMessage());
            LOG.error((Object)errorMessage, (Throwable)ex);
            throw new IOException(errorMessage.toString(), ex);
        }
    }

    private void populateKeys(NodeHeartbeatRequest request, NodeHeartbeatResponse nodeHeartBeatResponse) {
        MasterKey nextMasterKeyForNode = this.containerTokenSecretManager.getNextKey();
        if (nextMasterKeyForNode != null && request.getLastKnownContainerTokenMasterKey().getKeyId() != nextMasterKeyForNode.getKeyId()) {
            nodeHeartBeatResponse.setContainerTokenMasterKey(nextMasterKeyForNode);
        }
        if ((nextMasterKeyForNode = this.nmTokenSecretManager.getNextKey()) != null && request.getLastKnownNMTokenMasterKey().getKeyId() != nextMasterKeyForNode.getKeyId()) {
            nodeHeartBeatResponse.setNMTokenMasterKey(nextMasterKeyForNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource loadNodeResourceFromDRConfiguration(String nodeId) {
        this.readLock.lock();
        try {
            String[] nodes = this.drConf.getNodes();
            if (nodes != null && Arrays.asList(nodes).contains(nodeId)) {
                Resource resource = Resource.newInstance((int)this.drConf.getMemoryPerNode(nodeId), (int)this.drConf.getVcoresPerNode(nodeId));
                return resource;
            }
            Resource resource = null;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static Node resolve(String hostName) {
        return RackResolver.resolve((String)hostName);
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }
}

