/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongBinaryOperator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTags;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplications;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplicationsNamespace;
import org.apache.log4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AllocationTagsManager {
    private static final Logger LOG = Logger.getLogger(AllocationTagsManager.class);
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private final RMContext rmContext;
    private Map<ApplicationId, TypeToCountedTags> perAppNodeMappings = new HashMap<ApplicationId, TypeToCountedTags>();
    private Map<ApplicationId, TypeToCountedTags> perAppRackMappings = new HashMap<ApplicationId, TypeToCountedTags>();
    private TypeToCountedTags<NodeId> globalNodeMapping = new TypeToCountedTags();
    private TypeToCountedTags<String> globalRackMapping = new TypeToCountedTags();

    @VisibleForTesting
    public Map<ApplicationId, TypeToCountedTags> getPerAppNodeMappings() {
        return this.perAppNodeMappings;
    }

    @VisibleForTesting
    Map<ApplicationId, TypeToCountedTags> getPerAppRackMappings() {
        return this.perAppRackMappings;
    }

    @VisibleForTesting
    TypeToCountedTags getGlobalNodeMapping() {
        return this.globalNodeMapping;
    }

    @VisibleForTesting
    TypeToCountedTags getGlobalRackMapping() {
        return this.globalRackMapping;
    }

    public AllocationTagsManager(RMContext context) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.rmContext = context;
    }

    private TypeToCountedTags aggregateAllocationTags(AllocationTags allocationTags, Map<ApplicationId, TypeToCountedTags> mapping) throws InvalidAllocationTagsQueryException {
        TargetApplicationsNamespace namespace = allocationTags.getNamespace();
        TargetApplications ta = new TargetApplications(allocationTags.getCurrentApplicationId(), this.getApplicationIdToTags());
        namespace.evaluate(ta);
        Set<ApplicationId> appIds = namespace.getNamespaceScope();
        TypeToCountedTags result = new TypeToCountedTags();
        if (appIds != null) {
            if (appIds.size() == 1) {
                return mapping.get(appIds.iterator().next());
            }
            for (ApplicationId applicationId : appIds) {
                TypeToCountedTags appIdTags = mapping.get(applicationId);
                if (appIdTags == null) continue;
                result.absorb(appIdTags.immutableCopy());
            }
        }
        return result;
    }

    public void addContainer(NodeId nodeId, ContainerId containerId, Set<String> allocationTags) {
        if (allocationTags == null || allocationTags.isEmpty()) {
            return;
        }
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        this.addTags(nodeId, applicationId, allocationTags);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added container=" + containerId + " with tags=[" + StringUtils.join(allocationTags, (String)",") + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTags(NodeId nodeId, ApplicationId applicationId, Set<String> allocationTags) {
        this.writeLock.lock();
        try {
            TypeToCountedTags perAppTagsMapping = this.perAppNodeMappings.computeIfAbsent(applicationId, k -> new TypeToCountedTags());
            TypeToCountedTags perAppRackTagsMapping = this.perAppRackMappings.computeIfAbsent(applicationId, k -> new TypeToCountedTags());
            String nodeRack = this.rmContext.getRMNodes() != null && this.rmContext.getRMNodes().get(nodeId) != null ? ((RMNode)this.rmContext.getRMNodes().get(nodeId)).getRackName() : "default-rack";
            perAppTagsMapping.addTags(nodeId, allocationTags);
            perAppRackTagsMapping.addTags(nodeRack, allocationTags);
            ((TypeToCountedTags)this.globalNodeMapping).addTags(nodeId, allocationTags);
            ((TypeToCountedTags)this.globalRackMapping).addTags(nodeRack, allocationTags);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeContainer(NodeId nodeId, ContainerId containerId, Set<String> allocationTags) {
        if (allocationTags == null || allocationTags.isEmpty()) {
            return;
        }
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        this.removeTags(nodeId, applicationId, allocationTags);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removed container=" + containerId + " with tags=[" + StringUtils.join(allocationTags, (String)",") + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTags(NodeId nodeId, ApplicationId applicationId, Set<String> allocationTags) {
        this.writeLock.lock();
        try {
            TypeToCountedTags perAppTagsMapping = this.perAppNodeMappings.get(applicationId);
            TypeToCountedTags perAppRackTagsMapping = this.perAppRackMappings.get(applicationId);
            if (perAppTagsMapping == null) {
                return;
            }
            String nodeRack = this.rmContext.getRMNodes() != null && this.rmContext.getRMNodes().get(nodeId) != null ? ((RMNode)this.rmContext.getRMNodes().get(nodeId)).getRackName() : "default-rack";
            perAppTagsMapping.removeTags(nodeId, allocationTags);
            perAppRackTagsMapping.removeTags(nodeRack, allocationTags);
            ((TypeToCountedTags)this.globalNodeMapping).removeTags(nodeId, allocationTags);
            ((TypeToCountedTags)this.globalRackMapping).removeTags(nodeRack, allocationTags);
            if (perAppTagsMapping.isEmpty()) {
                this.perAppNodeMappings.remove(applicationId);
            }
            if (perAppRackTagsMapping.isEmpty()) {
                this.perAppRackMappings.remove(applicationId);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNodeCardinality(NodeId nodeId, ApplicationId applicationId, String tag) throws InvalidAllocationTagsQueryException {
        this.readLock.lock();
        try {
            if (nodeId == null) {
                throw new InvalidAllocationTagsQueryException("Must specify nodeId/tag to query cardinality");
            }
            TypeToCountedTags mapping = applicationId != null ? this.perAppNodeMappings.get(applicationId) : this.globalNodeMapping;
            if (mapping == null) {
                long l = 0L;
                return l;
            }
            long l = mapping.getCardinality(nodeId, tag);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRackCardinality(String rack, ApplicationId applicationId, String tag) throws InvalidAllocationTagsQueryException {
        this.readLock.lock();
        try {
            if (rack == null) {
                throw new InvalidAllocationTagsQueryException("Must specify rack/tag to query cardinality");
            }
            TypeToCountedTags mapping = applicationId != null ? this.perAppRackMappings.get(applicationId) : this.globalRackMapping;
            if (mapping == null) {
                long l = 0L;
                return l;
            }
            long l = mapping.getCardinality(rack, tag);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean allocationTagExistsOnNode(NodeId nodeId, ApplicationId applicationId, String tag) throws InvalidAllocationTagsQueryException {
        return this.getNodeCardinality(nodeId, applicationId, tag) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNodeCardinalityByOp(NodeId nodeId, AllocationTags tags, LongBinaryOperator op) throws InvalidAllocationTagsQueryException {
        this.readLock.lock();
        try {
            if (nodeId == null || op == null || tags == null) {
                throw new InvalidAllocationTagsQueryException("Must specify nodeId/tags/op to query cardinality");
            }
            TypeToCountedTags mapping = AllocationTagNamespaceType.ALL.equals((Object)tags.getNamespace().getNamespaceType()) ? this.globalNodeMapping : this.aggregateAllocationTags(tags, this.perAppNodeMappings);
            long l = mapping == null ? 0L : mapping.getCardinality(nodeId, tags.getTags(), op);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRackCardinalityByOp(String rack, AllocationTags tags, LongBinaryOperator op) throws InvalidAllocationTagsQueryException {
        this.readLock.lock();
        try {
            if (rack == null || op == null || tags == null) {
                throw new InvalidAllocationTagsQueryException("Must specify nodeId/tags/op to query cardinality");
            }
            TypeToCountedTags mapping = AllocationTagNamespaceType.ALL.equals((Object)tags.getNamespace().getNamespaceType()) ? this.globalRackMapping : this.aggregateAllocationTags(tags, this.perAppRackMappings);
            long l = mapping == null ? 0L : mapping.getCardinality(rack, tags.getTags(), op);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<String, Long> getAllocationTagsWithCount(NodeId nodeId) {
        return this.globalNodeMapping.getTypeToTagsWithCount().get(nodeId);
    }

    private Map<ApplicationId, Set<String>> getApplicationIdToTags() {
        HashMap<ApplicationId, Set<String>> result = new HashMap<ApplicationId, Set<String>>();
        ConcurrentMap<ApplicationId, RMApp> allApps = this.rmContext.getRMApps();
        if (allApps != null) {
            for (Map.Entry app : allApps.entrySet()) {
                if (!this.perAppNodeMappings.containsKey(app.getKey())) continue;
                result.put((ApplicationId)app.getKey(), ((RMApp)app.getValue()).getApplicationTags());
            }
        }
        return result;
    }

    @VisibleForTesting
    public static class TypeToCountedTags<T> {
        private Map<T, Map<String, Long>> typeToTagsWithCount = new HashMap<T, Map<String, Long>>();

        public TypeToCountedTags() {
        }

        private TypeToCountedTags(Map<T, Map<String, Long>> tags) {
            this.typeToTagsWithCount = tags;
        }

        private void addTags(T type, Set<String> tags) {
            Map innerMap = this.typeToTagsWithCount.computeIfAbsent(type, k -> new HashMap());
            for (String tag : tags) {
                Long count = (Long)innerMap.get(tag);
                if (count == null) {
                    innerMap.put(tag, 1L);
                    continue;
                }
                innerMap.put(tag, count + 1L);
            }
        }

        private void addTag(T type, String tag) {
            Map innerMap = this.typeToTagsWithCount.computeIfAbsent(type, k -> new HashMap());
            Long count = (Long)innerMap.get(tag);
            if (count == null) {
                innerMap.put(tag, 1L);
            } else {
                innerMap.put(tag, count + 1L);
            }
        }

        private void removeTagFromInnerMap(Map<String, Long> innerMap, String tag) {
            Long count = innerMap.get(tag);
            if (count > 1L) {
                innerMap.put(tag, count - 1L);
            } else {
                if (count <= 0L) {
                    LOG.warn((Object)"Trying to remove tags from node/rack, however the count already becomes 0 or less, it could be a potential bug.");
                }
                innerMap.remove(tag);
            }
        }

        private void removeTags(T type, Set<String> tags) {
            Map<String, Long> innerMap = this.typeToTagsWithCount.get(type);
            if (innerMap == null) {
                LOG.warn((Object)("Failed to find node/rack=" + type + " while trying to remove tags, please double check."));
                return;
            }
            for (String tag : tags) {
                this.removeTagFromInnerMap(innerMap, tag);
            }
            if (innerMap.isEmpty()) {
                this.typeToTagsWithCount.remove(type);
            }
        }

        private void removeTag(T type, String tag) {
            Map<String, Long> innerMap = this.typeToTagsWithCount.get(type);
            if (innerMap == null) {
                LOG.warn((Object)("Failed to find node/rack=" + type + " while trying to remove tags, please double check."));
                return;
            }
            this.removeTagFromInnerMap(innerMap, tag);
            if (innerMap.isEmpty()) {
                this.typeToTagsWithCount.remove(type);
            }
        }

        private long getCardinality(T type, String tag) {
            Map<String, Long> innerMap = this.typeToTagsWithCount.get(type);
            if (innerMap == null) {
                return 0L;
            }
            Long value = innerMap.get(tag);
            return value == null ? 0L : value;
        }

        private long getCardinality(T type, Set<String> tags, LongBinaryOperator op) {
            Map<String, Long> innerMap = this.typeToTagsWithCount.get(type);
            if (innerMap == null) {
                return 0L;
            }
            long returnValue = 0L;
            boolean firstTag = true;
            if (tags != null && !tags.isEmpty()) {
                for (String tag : tags) {
                    Long value = innerMap.get(tag);
                    if (value == null) {
                        value = 0L;
                    }
                    if (firstTag) {
                        returnValue = value;
                        firstTag = false;
                        continue;
                    }
                    returnValue = op.applyAsLong(returnValue, value);
                }
            } else {
                for (long value : innerMap.values()) {
                    if (firstTag) {
                        returnValue = value;
                        firstTag = false;
                        continue;
                    }
                    returnValue = op.applyAsLong(returnValue, value);
                }
            }
            return returnValue;
        }

        private boolean isEmpty() {
            return this.typeToTagsWithCount.isEmpty();
        }

        @VisibleForTesting
        public Map<T, Map<String, Long>> getTypeToTagsWithCount() {
            return this.typeToTagsWithCount;
        }

        protected void absorb(TypeToCountedTags<T> target) {
            if (target == null || target.getTypeToTagsWithCount() == null) {
                return;
            }
            Map<T, Map<String, Long>> targetMap = target.getTypeToTagsWithCount();
            for (Map.Entry<T, Map<String, Long>> targetEntry : targetMap.entrySet()) {
                HashMap copy = Maps.newHashMap(targetEntry.getValue());
                Map<String, Long> existingMapping = this.typeToTagsWithCount.putIfAbsent(targetEntry.getKey(), copy);
                if (existingMapping == null) continue;
                Map<String, Long> localMap = this.typeToTagsWithCount.get(targetEntry.getKey());
                Map<String, Long> targetValue = targetEntry.getValue();
                for (Map.Entry<String, Long> entry : targetValue.entrySet()) {
                    localMap.merge(entry.getKey(), entry.getValue(), (a, b) -> Long.sum(a, b));
                }
            }
        }

        protected TypeToCountedTags immutableCopy() {
            return new TypeToCountedTags<T>(Collections.unmodifiableMap(this.typeToTagsWithCount));
        }
    }
}

