/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AllocationTagInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AllocationTagsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceUtilizationInfo;

@XmlRootElement(name="node")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NodeInfo {
    protected String rack;
    protected NodeState state;
    private String id;
    protected String nodeHostName;
    protected String nodeHTTPAddress;
    private long lastHealthUpdate;
    protected String version;
    protected String healthReport;
    protected int numContainers;
    protected long usedMemoryMB;
    protected long availMemoryMB;
    protected long usedVirtualCores;
    protected long availableVirtualCores;
    private int numRunningOpportContainers;
    private long usedMemoryOpportGB;
    private long usedVirtualCoresOpport;
    private int numQueuedContainers;
    protected ArrayList<String> nodeLabels = new ArrayList();
    private AllocationTagsInfo allocationTags;
    protected ResourceUtilizationInfo resourceUtilization;
    protected ResourceInfo usedResource;
    protected ResourceInfo availableResource;

    public NodeInfo() {
    }

    public NodeInfo(RMNode ni, ResourceScheduler sched) {
        Set<String> labelSet;
        NodeId id = ni.getNodeID();
        SchedulerNodeReport report = sched.getNodeReport(id);
        this.numContainers = 0;
        this.usedMemoryMB = 0L;
        this.availMemoryMB = 0L;
        if (report != null) {
            this.numContainers = report.getNumContainers();
            this.usedMemoryMB = report.getUsedResource().getMemorySize();
            this.availMemoryMB = report.getAvailableResource().getMemorySize();
            this.usedVirtualCores = report.getUsedResource().getVirtualCores();
            this.availableVirtualCores = report.getAvailableResource().getVirtualCores();
            this.usedResource = new ResourceInfo(report.getUsedResource());
            this.availableResource = new ResourceInfo(report.getAvailableResource());
        }
        this.id = id.toString();
        this.rack = ni.getRackName();
        this.nodeHostName = ni.getHostName();
        this.state = ni.getState();
        this.nodeHTTPAddress = ni.getHttpAddress();
        this.lastHealthUpdate = ni.getLastHealthReportTime();
        this.healthReport = String.valueOf(ni.getHealthReport());
        this.version = ni.getNodeManagerVersion();
        this.numRunningOpportContainers = 0;
        this.usedMemoryOpportGB = 0L;
        this.usedVirtualCoresOpport = 0L;
        this.numQueuedContainers = 0;
        OpportunisticContainersStatus opportStatus = ni.getOpportunisticContainersStatus();
        if (opportStatus != null) {
            this.numRunningOpportContainers = opportStatus.getRunningOpportContainers();
            this.usedMemoryOpportGB = opportStatus.getOpportMemoryUsed();
            this.usedVirtualCoresOpport = opportStatus.getOpportCoresUsed();
            this.numQueuedContainers = opportStatus.getQueuedOpportContainers();
        }
        if ((labelSet = ni.getNodeLabels()) != null) {
            this.nodeLabels.addAll(labelSet);
            Collections.sort(this.nodeLabels);
        }
        this.allocationTags = new AllocationTagsInfo();
        Map<String, Long> allocationTagsInfo = ni.getAllocationTagsWithCount();
        if (allocationTagsInfo != null) {
            allocationTagsInfo.forEach((tag, count) -> this.allocationTags.addAllocationTag(new AllocationTagInfo((String)tag, (long)count)));
        }
        this.resourceUtilization = new ResourceUtilizationInfo(ni);
    }

    public String getRack() {
        return this.rack;
    }

    public String getState() {
        return String.valueOf(this.state);
    }

    public String getNodeId() {
        return this.id;
    }

    public String getNodeHTTPAddress() {
        return this.nodeHTTPAddress;
    }

    public void setNodeHTTPAddress(String nodeHTTPAddress) {
        this.nodeHTTPAddress = nodeHTTPAddress;
    }

    public long getLastHealthUpdate() {
        return this.lastHealthUpdate;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHealthReport() {
        return this.healthReport;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public long getUsedMemory() {
        return this.usedMemoryMB;
    }

    public long getAvailableMemory() {
        return this.availMemoryMB;
    }

    public long getUsedVirtualCores() {
        return this.usedVirtualCores;
    }

    public long getAvailableVirtualCores() {
        return this.availableVirtualCores;
    }

    public int getNumRunningOpportContainers() {
        return this.numRunningOpportContainers;
    }

    public long getUsedMemoryOpportGB() {
        return this.usedMemoryOpportGB;
    }

    public long getUsedVirtualCoresOpport() {
        return this.usedVirtualCoresOpport;
    }

    public int getNumQueuedContainers() {
        return this.numQueuedContainers;
    }

    public ArrayList<String> getNodeLabels() {
        return this.nodeLabels;
    }

    public ResourceInfo getUsedResource() {
        return this.usedResource;
    }

    public void setUsedResource(ResourceInfo used) {
        this.usedResource = used;
    }

    public ResourceInfo getAvailableResource() {
        return this.availableResource;
    }

    public void setAvailableResource(ResourceInfo avail) {
        this.availableResource = avail;
    }

    public ResourceUtilizationInfo getResourceUtilization() {
        return this.resourceUtilization;
    }

    public String getAllocationTagsSummary() {
        return this.allocationTags == null ? "" : this.allocationTags.toString();
    }

    @VisibleForTesting
    public void setId(String id) {
        this.id = id;
    }

    @VisibleForTesting
    public void setLastHealthUpdate(long lastHealthUpdate) {
        this.lastHealthUpdate = lastHealthUpdate;
    }
}

