/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang.text.StrBuilder;

public class ReportCommand
extends Command {
    public ReportCommand(Configuration conf) {
        this(conf, System.out);
    }

    public ReportCommand(Configuration conf, PrintStream ps) {
        super(conf, ps);
        this.addValidCommandParameters("report", "Report volume information of nodes.");
        String desc = String.format("Top number of nodes to be processed. Default: %d", this.getDefaultTop());
        this.addValidCommandParameters("top", desc);
        desc = String.format("Print out volume information for DataNode(s).", new Object[0]);
        this.addValidCommandParameters("node", desc);
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        StrBuilder result = new StrBuilder();
        String outputLine = "Processing report command";
        this.recordOutput(result, outputLine);
        Preconditions.checkState((boolean)cmd.hasOption("report"));
        this.verifyCommandOptions("report", cmd);
        this.readClusterInfo(cmd);
        String nodeFormat = "%d/%d %s[%s:%d] - <%s>: %d volumes with node data density %.2f.";
        String nodeFormatWithoutSequence = "%s[%s:%d] - <%s>: %d volumes with node data density %.2f.";
        String volumeFormat = "[%s: volume-%s] - %.2f used: %d/%d, %.2f free: %d/%d, isFailed: %s, isReadOnly: %s, isSkip: %s, isTransient: %s.";
        if (cmd.hasOption("node")) {
            this.handleNodeReport(cmd, result, "%s[%s:%d] - <%s>: %d volumes with node data density %.2f.", "[%s: volume-%s] - %.2f used: %d/%d, %.2f free: %d/%d, isFailed: %s, isReadOnly: %s, isSkip: %s, isTransient: %s.");
        } else {
            this.handleTopReport(cmd, result, "%d/%d %s[%s:%d] - <%s>: %d volumes with node data density %.2f.");
        }
        this.getPrintStream().println(result.toString());
    }

    private void handleTopReport(CommandLine cmd, StrBuilder result, String nodeFormat) throws IllegalArgumentException {
        Collections.sort(this.getCluster().getNodes(), Collections.reverseOrder());
        this.setTopNodes(this.parseTopNodes(cmd, result));
        String outputLine = String.format("Reporting top %d DataNode(s) benefiting from running DiskBalancer.", this.getTopNodes());
        this.recordOutput(result, outputLine);
        ListIterator<DiskBalancerDataNode> li = this.getCluster().getNodes().listIterator();
        for (int i = 0; i < this.getTopNodes() && li.hasNext(); ++i) {
            DiskBalancerDataNode dbdn = li.next();
            result.appendln(String.format(nodeFormat, i + 1, this.getTopNodes(), dbdn.getDataNodeName(), dbdn.getDataNodeIP(), dbdn.getDataNodePort(), dbdn.getDataNodeUUID(), dbdn.getVolumeCount(), dbdn.getNodeDataDensity()));
        }
    }

    private void handleNodeReport(CommandLine cmd, StrBuilder result, String nodeFormat, String volumeFormat) throws Exception {
        String outputLine = "";
        String nodeVal = cmd.getOptionValue("node");
        if (StringUtils.isBlank((String)nodeVal)) {
            outputLine = "The value for '-node' is neither specified or empty.";
            this.recordOutput(result, outputLine);
        } else {
            outputLine = String.format("Reporting volume information for DataNode(s). These DataNode(s) are parsed from '%s'.", nodeVal);
            this.recordOutput(result, outputLine);
            List<Object> dbdns = Lists.newArrayList();
            try {
                dbdns = this.getNodes(nodeVal);
            }
            catch (DiskBalancerException e) {
                this.recordOutput(result, e.getMessage());
                return;
            }
            if (!dbdns.isEmpty()) {
                for (DiskBalancerDataNode diskBalancerDataNode : dbdns) {
                    this.recordNodeReport(result, diskBalancerDataNode, nodeFormat, volumeFormat);
                    result.append(System.lineSeparator());
                }
            }
        }
    }

    private void recordNodeReport(StrBuilder result, DiskBalancerDataNode dbdn, String nodeFormat, String volumeFormat) throws Exception {
        String trueStr = "True";
        String falseStr = "False";
        this.populatePathNames(dbdn);
        result.appendln(String.format(nodeFormat, dbdn.getDataNodeName(), dbdn.getDataNodeIP(), dbdn.getDataNodePort(), dbdn.getDataNodeUUID(), dbdn.getVolumeCount(), dbdn.getNodeDataDensity()));
        ArrayList volumeList = Lists.newArrayList();
        for (DiskBalancerVolumeSet vset : dbdn.getVolumeSets().values()) {
            for (DiskBalancerVolume vol : vset.getVolumes()) {
                volumeList.add(String.format(volumeFormat, vol.getStorageType(), vol.getPath(), vol.getUsedRatio(), vol.getUsed(), vol.getCapacity(), vol.getFreeRatio(), vol.getFreeSpace(), vol.getCapacity(), vol.isFailed() ? trueStr : falseStr, vol.isReadOnly() ? trueStr : falseStr, vol.isSkip() ? trueStr : falseStr, vol.isTransient() ? trueStr : falseStr));
            }
        }
        Collections.sort(volumeList);
        result.appendln(StringUtils.join((Object[])volumeList.toArray(), (String)System.lineSeparator()));
    }

    @Override
    public void printHelp() {
        String header = "Report command reports the volume information of given datanode(s), or prints out the list of nodes that will benefit from running disk balancer. Top defaults to " + this.getDefaultTop();
        String footer = ". E.g.:\nhdfs diskbalancer -report\nhdfs diskbalancer -report -top 5\nhdfs diskbalancer -report -node <file://> | [<DataNodeID|IP|Hostname>,...]";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("hdfs diskbalancer -fs http://namenode.uri -report [options]", header, DiskBalancerCLI.getReportOptions(), footer);
    }
}

