/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.erasurecode.CodecRegistry;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;

final class FSDirErasureCodingOp {
    private FSDirErasureCodingOp() {
    }

    static ErasureCodingPolicy getErasureCodingPolicyByName(FSNamesystem fsn, String ecPolicyName) throws IOException {
        assert (fsn.hasReadLock());
        ErasureCodingPolicy ecPolicy = fsn.getErasureCodingPolicyManager().getEnabledPolicyByName(ecPolicyName);
        if (ecPolicy == null) {
            String sysPolicies = Arrays.asList(fsn.getErasureCodingPolicyManager().getEnabledPolicies()).stream().map(ErasureCodingPolicy::getName).collect(Collectors.joining(", "));
            String message = String.format("Policy '%s' does not match any enabled erasure coding policies: [%s]. An erasure coding policy can be enabled by enableErasureCodingPolicy API.", ecPolicyName, sysPolicies);
            throw new HadoopIllegalArgumentException(message);
        }
        return ecPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus setErasureCodingPolicy(FSNamesystem fsn, String srcArg, String ecPolicyName, FSPermissionChecker pc, boolean logRetryCache) throws IOException, AccessControlException {
        List<XAttr> xAttrs;
        INodesInPath iip;
        assert (fsn.hasWriteLock());
        String src = srcArg;
        FSDirectory fsd = fsn.getFSDirectory();
        fsd.writeLock();
        try {
            ErasureCodingPolicy ecPolicy = FSDirErasureCodingOp.getErasureCodingPolicyByName(fsn, ecPolicyName);
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE_LINK);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            src = iip.getPath();
            xAttrs = FSDirErasureCodingOp.setErasureCodingPolicyXAttr(fsn, iip, ecPolicy);
        }
        finally {
            fsd.writeUnlock();
        }
        fsn.getEditLog().logSetXAttrs(src, xAttrs, logRetryCache);
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<XAttr> setErasureCodingPolicyXAttr(FSNamesystem fsn, INodesInPath srcIIP, ErasureCodingPolicy ecPolicy) throws IOException {
        XAttr ecXAttr;
        FSDirectory fsd = fsn.getFSDirectory();
        assert (fsd.hasWriteLock());
        Preconditions.checkNotNull((Object)srcIIP, (Object)"INodes cannot be null");
        Preconditions.checkNotNull((Object)ecPolicy, (Object)"EC policy cannot be null");
        String src = srcIIP.getPath();
        INode inode = srcIIP.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("Path not found: " + srcIIP.getPath());
        }
        if (!inode.isDirectory()) {
            throw new IOException("Attempt to set an erasure coding policy for a file " + src);
        }
        DataOutputStream dOut = null;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            dOut = new DataOutputStream(bOut);
            WritableUtils.writeString((DataOutput)dOut, (String)ecPolicy.getName());
            ecXAttr = XAttrHelper.buildXAttr((String)"system.hdfs.erasurecoding.policy", (byte[])bOut.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dOut);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dOut);
        Boolean hasEcXAttr = FSDirErasureCodingOp.getErasureCodingPolicyXAttrForINode(fsn, inode) != null;
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(ecXAttr);
        EnumSet<XAttrSetFlag> flag = hasEcXAttr != false ? EnumSet.of(XAttrSetFlag.REPLACE) : EnumSet.of(XAttrSetFlag.CREATE);
        FSDirXAttrOp.unprotectedSetXAttrs(fsd, srcIIP, xattrs, flag);
        return xattrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus unsetErasureCodingPolicy(FSNamesystem fsn, String srcArg, FSPermissionChecker pc, boolean logRetryCache) throws IOException {
        List<XAttr> xAttrs;
        INodesInPath iip;
        assert (fsn.hasWriteLock());
        String src = srcArg;
        FSDirectory fsd = fsn.getFSDirectory();
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE_LINK);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            src = iip.getPath();
            xAttrs = FSDirErasureCodingOp.removeErasureCodingPolicyXAttr(fsn, iip);
        }
        finally {
            fsd.writeUnlock();
        }
        if (xAttrs != null) {
            fsn.getEditLog().logRemoveXAttrs(src, xAttrs, logRetryCache);
        }
        return fsd.getAuditFileInfo(iip);
    }

    static ErasureCodingPolicy addErasureCodingPolicy(FSNamesystem fsn, ErasureCodingPolicy policy, boolean logRetryCache) {
        Preconditions.checkNotNull((Object)policy);
        ErasureCodingPolicy retPolicy = fsn.getErasureCodingPolicyManager().addPolicy(policy);
        fsn.getEditLog().logAddErasureCodingPolicy(policy, logRetryCache);
        return retPolicy;
    }

    static void removeErasureCodingPolicy(FSNamesystem fsn, String ecPolicyName, boolean logRetryCache) throws IOException {
        Preconditions.checkNotNull((Object)ecPolicyName);
        fsn.getErasureCodingPolicyManager().removePolicy(ecPolicyName);
        fsn.getEditLog().logRemoveErasureCodingPolicy(ecPolicyName, logRetryCache);
    }

    static boolean enableErasureCodingPolicy(FSNamesystem fsn, String ecPolicyName, boolean logRetryCache) throws IOException {
        Preconditions.checkNotNull((Object)ecPolicyName);
        boolean success = fsn.getErasureCodingPolicyManager().enablePolicy(ecPolicyName);
        if (success) {
            fsn.getEditLog().logEnableErasureCodingPolicy(ecPolicyName, logRetryCache);
        }
        return success;
    }

    static boolean disableErasureCodingPolicy(FSNamesystem fsn, String ecPolicyName, boolean logRetryCache) throws IOException {
        Preconditions.checkNotNull((Object)ecPolicyName);
        boolean success = fsn.getErasureCodingPolicyManager().disablePolicy(ecPolicyName);
        if (success) {
            fsn.getEditLog().logDisableErasureCodingPolicy(ecPolicyName, logRetryCache);
        }
        return success;
    }

    private static List<XAttr> removeErasureCodingPolicyXAttr(FSNamesystem fsn, INodesInPath srcIIP) throws IOException {
        FSDirectory fsd = fsn.getFSDirectory();
        assert (fsd.hasWriteLock());
        Preconditions.checkNotNull((Object)srcIIP, (Object)"INodes cannot be null");
        String src = srcIIP.getPath();
        INode inode = srcIIP.getLastINode();
        if (inode == null) {
            throw new FileNotFoundException("Path not found: " + srcIIP.getPath());
        }
        if (!inode.isDirectory()) {
            throw new IOException("Cannot unset an erasure coding policy on a file " + src);
        }
        XAttr ecXAttr = FSDirErasureCodingOp.getErasureCodingPolicyXAttrForINode(fsn, inode);
        if (ecXAttr == null) {
            return null;
        }
        ArrayList xattrs = Lists.newArrayListWithCapacity((int)1);
        xattrs.add(ecXAttr);
        return FSDirXAttrOp.unprotectedRemoveXAttrs(fsd, srcIIP, xattrs);
    }

    static ErasureCodingPolicy getErasureCodingPolicy(FSNamesystem fsn, String src, FSPermissionChecker pc) throws IOException, AccessControlException {
        ErasureCodingPolicy ecPolicy;
        assert (fsn.hasReadLock());
        if (FSDirectory.isExactReservedName(src)) {
            return null;
        }
        FSDirectory fsd = fsn.getFSDirectory();
        INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.READ);
        if (fsn.isPermissionEnabled()) {
            fsn.getFSDirectory().checkPathAccess(pc, iip, FsAction.READ);
        }
        if (iip.isDotSnapshotDir()) {
            ecPolicy = null;
        } else {
            if (iip.getLastINode() == null) {
                throw new FileNotFoundException("Path not found: " + src);
            }
            ecPolicy = FSDirErasureCodingOp.getErasureCodingPolicyForPath(fsd, iip);
        }
        if (ecPolicy != null && ecPolicy.isReplicationPolicy()) {
            ecPolicy = null;
        }
        return ecPolicy;
    }

    static boolean hasErasureCodingPolicy(FSNamesystem fsn, INodesInPath iip) throws IOException {
        return FSDirErasureCodingOp.unprotectedGetErasureCodingPolicy(fsn, iip) != null;
    }

    static ErasureCodingPolicy unprotectedGetErasureCodingPolicy(FSNamesystem fsn, INodesInPath iip) throws IOException {
        assert (fsn.hasReadLock());
        return FSDirErasureCodingOp.getErasureCodingPolicyForPath(fsn.getFSDirectory(), iip);
    }

    static ErasureCodingPolicyInfo[] getErasureCodingPolicies(FSNamesystem fsn) throws IOException {
        assert (fsn.hasReadLock());
        return fsn.getErasureCodingPolicyManager().getPolicies();
    }

    static Map<String, String> getErasureCodingCodecs(FSNamesystem fsn) throws IOException {
        assert (fsn.hasReadLock());
        return CodecRegistry.getInstance().getCodec2CoderCompactMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ErasureCodingPolicy getErasureCodingPolicyForPath(FSDirectory fsd, INodesInPath iip) throws IOException {
        Preconditions.checkNotNull((Object)iip, (Object)"INodes cannot be null");
        fsd.readLock();
        try {
            for (int i = iip.length() - 1; i >= 0; --i) {
                XAttr xattr;
                INode inode = iip.getINode(i);
                if (inode == null) continue;
                if (inode.isFile()) {
                    byte id = inode.asFile().getErasureCodingPolicyID();
                    ErasureCodingPolicy erasureCodingPolicy = id < 0 ? null : fsd.getFSNamesystem().getErasureCodingPolicyManager().getByID(id);
                    return erasureCodingPolicy;
                }
                if (inode.isSymlink()) {
                    ErasureCodingPolicy id = null;
                    return id;
                }
                XAttrFeature xaf = inode.getXAttrFeature(iip.getPathSnapshotId());
                if (xaf == null || (xattr = xaf.getXAttr("system.hdfs.erasurecoding.policy")) == null) continue;
                ByteArrayInputStream bIn = new ByteArrayInputStream(xattr.getValue());
                DataInputStream dIn = new DataInputStream(bIn);
                String ecPolicyName = WritableUtils.readString((DataInput)dIn);
                ErasureCodingPolicy erasureCodingPolicy = fsd.getFSNamesystem().getErasureCodingPolicyManager().getByName(ecPolicyName);
                return erasureCodingPolicy;
            }
        }
        finally {
            fsd.readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XAttr getErasureCodingPolicyXAttrForINode(FSNamesystem fsn, INode inode) throws IOException {
        if (inode == null) {
            return null;
        }
        FSDirectory fsd = fsn.getFSDirectory();
        fsd.readLock();
        try {
            XAttr xattr;
            if (inode.isSymlink()) {
                XAttr xAttr = null;
                return xAttr;
            }
            XAttrFeature xaf = inode.getXAttrFeature();
            if (xaf != null && (xattr = xaf.getXAttr("system.hdfs.erasurecoding.policy")) != null) {
                XAttr xAttr = xattr;
                return xAttr;
            }
        }
        finally {
            fsd.readUnlock();
        }
        return null;
    }
}

