/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.impl.zk;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.registry.client.api.RegistryConstants;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.exceptions.AuthenticationFailedException;
import org.apache.hadoop.registry.client.exceptions.NoChildrenForEphemeralsException;
import org.apache.hadoop.registry.client.exceptions.NoPathPermissionsException;
import org.apache.hadoop.registry.client.exceptions.RegistryIOException;
import org.apache.hadoop.registry.client.impl.zk.BindingInformation;
import org.apache.hadoop.registry.client.impl.zk.ListenerHandle;
import org.apache.hadoop.registry.client.impl.zk.PathListener;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.client.impl.zk.ZKPathDumper;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.org.apache.curator.RetryPolicy;
import org.apache.hadoop.shaded.org.apache.curator.ensemble.EnsembleProvider;
import org.apache.hadoop.shaded.org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.hadoop.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.shaded.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.CreateBuilder;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.DeleteBuilder;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.hadoop.shaded.org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.hadoop.shaded.org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.hadoop.shaded.org.apache.zookeeper.CreateMode;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.ACL;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CuratorService
extends CompositeService
implements RegistryConstants,
RegistryBindingSource {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorService.class);
    private CuratorFramework curator;
    private String registryRoot;
    private final RegistryBindingSource bindingSource;
    private RegistrySecurity registrySecurity;
    private String connectionDescription;
    private String securityConnectionDiagnostics = "";
    private EnsembleProvider ensembleProvider;
    private TreeCache treeCache;

    public CuratorService(String name, RegistryBindingSource bindingSource) {
        super(name);
        this.bindingSource = bindingSource != null ? bindingSource : this;
        this.registrySecurity = new RegistrySecurity("registry security");
    }

    public CuratorService(String name) {
        this(name, null);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.registryRoot = conf.getTrimmed("hadoop.registry.zk.root", "/registry");
        this.addService((Service)this.registrySecurity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating Registry with root {}", (Object)this.registryRoot);
        }
        super.serviceInit(conf);
    }

    public void setKerberosPrincipalAndKeytab(String principal, String keytab) {
        this.registrySecurity.setKerberosPrincipalAndKeytab(principal, keytab);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.curator = this.createCurator();
    }

    protected void serviceStop() throws Exception {
        IOUtils.closeStream((Closeable)this.curator);
        if (this.treeCache != null) {
            this.treeCache.close();
        }
        super.serviceStop();
    }

    private void checkServiceLive() throws ServiceStateException {
        if (!this.isInState(Service.STATE.STARTED)) {
            throw new ServiceStateException("Service " + this.getName() + " is in wrong state: " + this.getServiceState());
        }
    }

    public boolean isSecure() {
        return this.registrySecurity.isSecureRegistry();
    }

    protected RegistrySecurity getRegistrySecurity() {
        return this.registrySecurity;
    }

    protected String buildSecurityDiagnostics() {
        if (!this.isSecure()) {
            return "security disabled";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("secure cluster; ");
        builder.append(this.registrySecurity.buildSecurityDiagnostics());
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CuratorFramework createCurator() throws IOException {
        Configuration conf = this.getConfig();
        this.createEnsembleProvider();
        int sessionTimeout = conf.getInt("hadoop.registry.zk.session.timeout.ms", 60000);
        int connectionTimeout = conf.getInt("hadoop.registry.zk.connection.timeout.ms", 15000);
        int retryTimes = conf.getInt("hadoop.registry.zk.retry.times", 5);
        int retryInterval = conf.getInt("hadoop.registry.zk.retry.interval.ms", 1000);
        int retryCeiling = conf.getInt("hadoop.registry.zk.retry.ceiling.ms", 60000);
        LOG.info("Creating CuratorService with connection {}", (Object)this.connectionDescription);
        Class<CuratorService> clazz = CuratorService.class;
        synchronized (CuratorService.class) {
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
            builder.ensembleProvider(this.ensembleProvider).connectionTimeoutMs(connectionTimeout).sessionTimeoutMs(sessionTimeout).retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetry(retryInterval, retryCeiling, retryTimes));
            this.registrySecurity.applySecurityEnvironment(builder);
            this.securityConnectionDiagnostics = this.buildSecurityDiagnostics();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.securityConnectionDiagnostics);
            }
            CuratorFramework framework = builder.build();
            framework.start();
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return framework;
        }
    }

    public String toString() {
        return super.toString() + " " + this.bindingDiagnosticDetails();
    }

    public String bindingDiagnosticDetails() {
        return " Connection=\"" + this.connectionDescription + "\"" + " root=\"" + this.registryRoot + "\"" + " " + this.securityConnectionDiagnostics;
    }

    protected String createFullPath(String path) throws IOException {
        return RegistryPathUtils.createFullPath(this.registryRoot, path);
    }

    public RegistryBindingSource getBindingSource() {
        return this.bindingSource;
    }

    protected void createEnsembleProvider() {
        BindingInformation binding = this.bindingSource.supplyBindingInformation();
        this.connectionDescription = binding.description + " " + this.securityConnectionDiagnostics;
        this.ensembleProvider = binding.ensembleProvider;
    }

    @Override
    public BindingInformation supplyBindingInformation() {
        BindingInformation binding = new BindingInformation();
        String connectString = this.buildConnectionString();
        binding.ensembleProvider = new FixedEnsembleProvider(connectString);
        binding.description = "fixed ZK quorum \"" + connectString + "\"";
        return binding;
    }

    protected String buildConnectionString() {
        return this.getConfig().getTrimmed("hadoop.registry.zk.quorum", "localhost:2181");
    }

    protected IOException operationFailure(String path, String operation, Exception exception) {
        return this.operationFailure(path, operation, exception, null);
    }

    protected IOException operationFailure(String path, String operation, Exception exception, List<ACL> acls) {
        Object ioe;
        String aclList = "[" + RegistrySecurity.aclsToString(acls) + "]";
        if (exception instanceof KeeperException.NoNodeException) {
            ioe = new PathNotFoundException(path);
        } else if (exception instanceof KeeperException.NodeExistsException) {
            ioe = new FileAlreadyExistsException(path);
        } else if (exception instanceof KeeperException.NoAuthException) {
            ioe = new NoPathPermissionsException(path, "Not authorized to access path; ACLs: " + aclList);
        } else if (exception instanceof KeeperException.NotEmptyException) {
            ioe = new PathIsNotEmptyDirectoryException(path);
        } else if (exception instanceof KeeperException.AuthFailedException) {
            ioe = new AuthenticationFailedException(path, "Authentication Failed: " + exception + "; " + this.securityConnectionDiagnostics, exception);
        } else if (exception instanceof KeeperException.NoChildrenForEphemeralsException) {
            ioe = new NoChildrenForEphemeralsException(path, "Cannot create a path under an ephemeral node: " + exception, exception);
        } else if (exception instanceof KeeperException.InvalidACLException) {
            StringBuilder builder = new StringBuilder();
            builder.append("Path access failure ").append(aclList);
            builder.append(" ");
            builder.append(this.securityConnectionDiagnostics);
            ioe = new NoPathPermissionsException(path, builder.toString());
        } else {
            ioe = new RegistryIOException(path, "Failure of " + operation + " on " + path + ": " + exception.toString(), exception);
        }
        if (ioe.getCause() == null) {
            ioe.initCause(exception);
        }
        return ioe;
    }

    @VisibleForTesting
    public boolean maybeCreate(String path, CreateMode mode, List<ACL> acl, boolean createParents) throws IOException {
        return this.zkMkPath(path, mode, createParents, acl);
    }

    public Stat zkStat(String path) throws IOException {
        Stat stat;
        this.checkServiceLive();
        String fullpath = this.createFullPath(path);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stat {}", (Object)fullpath);
            }
            stat = (Stat)this.curator.checkExists().forPath(fullpath);
        }
        catch (Exception e) {
            throw this.operationFailure(fullpath, "read()", e);
        }
        if (stat == null) {
            throw new PathNotFoundException(path);
        }
        return stat;
    }

    public List<ACL> zkGetACLS(String path) throws IOException {
        List acls;
        this.checkServiceLive();
        String fullpath = this.createFullPath(path);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("GetACLS {}", (Object)fullpath);
            }
            acls = (List)this.curator.getACL().forPath(fullpath);
        }
        catch (Exception e) {
            throw this.operationFailure(fullpath, "read()", e);
        }
        if (acls == null) {
            throw new PathNotFoundException(path);
        }
        return acls;
    }

    public boolean zkPathExists(String path) throws IOException {
        this.checkServiceLive();
        try {
            this.zkStat(path);
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public String zkPathMustExist(String path) throws IOException {
        this.zkStat(path);
        return path;
    }

    public boolean zkMkPath(String path, CreateMode mode, boolean createParents, List<ACL> acls) throws IOException {
        this.checkServiceLive();
        path = this.createFullPath(path);
        if (acls == null || acls.isEmpty()) {
            throw new NoPathPermissionsException(path, "Empty ACL list");
        }
        try {
            RegistrySecurity.AclListInfo aclInfo = new RegistrySecurity.AclListInfo(acls);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating path {} with mode {} and ACL {}", new Object[]{path, mode, aclInfo});
            }
            CreateBuilder createBuilder = this.curator.create();
            ((ACLBackgroundPathAndBytesable)createBuilder.withMode(mode)).withACL(acls);
            if (createParents) {
                createBuilder.creatingParentsIfNeeded();
            }
            createBuilder.forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("path already present: {}", (Object)path, (Object)e);
            }
            return false;
        }
        catch (Exception e) {
            throw this.operationFailure(path, "mkdir() ", e, acls);
        }
        return true;
    }

    public void zkMkParentPath(String path, List<ACL> acl) throws IOException {
        this.zkMkPath(RegistryPathUtils.parentOf(path), CreateMode.PERSISTENT, true, acl);
    }

    public void zkCreate(String path, CreateMode mode, byte[] data, List<ACL> acls) throws IOException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"null data");
        this.checkServiceLive();
        String fullpath = this.createFullPath(path);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating {} with {} bytes of data and ACL {}", new Object[]{fullpath, data.length, new RegistrySecurity.AclListInfo(acls)});
            }
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.curator.create().withMode(mode)).withACL(acls)).forPath(fullpath, data);
        }
        catch (Exception e) {
            throw this.operationFailure(fullpath, "create()", e, acls);
        }
    }

    public void zkUpdate(String path, byte[] data) throws IOException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"null data");
        this.checkServiceLive();
        path = this.createFullPath(path);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating {} with {} bytes", (Object)path, (Object)data.length);
            }
            this.curator.setData().forPath(path, data);
        }
        catch (Exception e) {
            throw this.operationFailure(path, "update()", e);
        }
    }

    public boolean zkSet(String path, CreateMode mode, byte[] data, List<ACL> acl, boolean overwrite) throws IOException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"null data");
        this.checkServiceLive();
        if (!this.zkPathExists(path)) {
            this.zkCreate(path, mode, data, acl);
            return true;
        }
        if (overwrite) {
            this.zkUpdate(path, data);
            return false;
        }
        throw new FileAlreadyExistsException(path);
    }

    public void zkDelete(String path, boolean recursive, BackgroundCallback backgroundCallback) throws IOException {
        this.checkServiceLive();
        String fullpath = this.createFullPath(path);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting {}", (Object)fullpath);
            }
            DeleteBuilder delete = this.curator.delete();
            if (recursive) {
                delete.deletingChildrenIfNeeded();
            }
            if (backgroundCallback != null) {
                delete.inBackground(backgroundCallback);
            }
            delete.forPath(fullpath);
        }
        catch (KeeperException.NoNodeException delete) {
        }
        catch (Exception e) {
            throw this.operationFailure(fullpath, "delete()", e);
        }
    }

    public List<String> zkList(String path) throws IOException {
        this.checkServiceLive();
        String fullpath = this.createFullPath(path);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ls {}", (Object)fullpath);
            }
            GetChildrenBuilder builder = this.curator.getChildren();
            List children = (List)builder.forPath(fullpath);
            return children;
        }
        catch (Exception e) {
            throw this.operationFailure(path, "ls()", e);
        }
    }

    public byte[] zkRead(String path) throws IOException {
        this.checkServiceLive();
        String fullpath = this.createFullPath(path);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading {}", (Object)fullpath);
            }
            return (byte[])this.curator.getData().forPath(fullpath);
        }
        catch (Exception e) {
            throw this.operationFailure(fullpath, "read()", e);
        }
    }

    public ZKPathDumper dumpPath(boolean verbose) {
        return new ZKPathDumper(this.curator, this.registryRoot, verbose);
    }

    public boolean addWriteAccessor(String id, String pass) throws IOException {
        RegistrySecurity security = this.getRegistrySecurity();
        ACL digestACL = new ACL(31, security.toDigestId(security.digest(id, pass)));
        return security.addDigestACL(digestACL);
    }

    public void clearWriteAccessors() {
        this.getRegistrySecurity().resetDigestACLs();
    }

    protected String dumpRegistryRobustly(boolean verbose) {
        try {
            ZKPathDumper pathDumper = this.dumpPath(verbose);
            return pathDumper.toString();
        }
        catch (Exception e) {
            LOG.debug("Ignoring exception:  {}", (Throwable)e);
            return "";
        }
    }

    public ListenerHandle registerPathListener(final PathListener listener) throws Exception {
        final TreeCacheListener pathChildrenCacheListener = new TreeCacheListener(){

            public void childEvent(CuratorFramework curatorFramework, TreeCacheEvent event) throws Exception {
                String path = null;
                if (event != null && event.getData() != null) {
                    path = event.getData().getPath();
                }
                assert (event != null);
                switch (event.getType()) {
                    case NODE_ADDED: {
                        LOG.info("Informing listener of added node {}", (Object)path);
                        listener.nodeAdded(path);
                        break;
                    }
                    case NODE_REMOVED: {
                        LOG.info("Informing listener of removed node {}", (Object)path);
                        listener.nodeRemoved(path);
                        break;
                    }
                    case NODE_UPDATED: {
                        LOG.info("Informing listener of updated node {}", (Object)path);
                        listener.nodeAdded(path);
                        break;
                    }
                }
            }
        };
        this.treeCache.getListenable().addListener((Object)pathChildrenCacheListener);
        return new ListenerHandle(){

            @Override
            public void remove() {
                CuratorService.this.treeCache.getListenable().removeListener((Object)pathChildrenCacheListener);
            }
        };
    }

    public void monitorRegistryEntries() throws Exception {
        String registryPath = this.getConfig().get("hadoop.registry.zk.root", "/registry");
        this.treeCache = new TreeCache(this.curator, registryPath);
        this.treeCache.start();
    }
}

