/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.io.netty.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.shaded.io.netty.util.ResourceLeak;
import org.apache.hadoop.shaded.io.netty.util.ResourceLeakHint;
import org.apache.hadoop.shaded.io.netty.util.ResourceLeakTracker;
import org.apache.hadoop.shaded.io.netty.util.internal.PlatformDependent;
import org.apache.hadoop.shaded.io.netty.util.internal.StringUtil;
import org.apache.hadoop.shaded.io.netty.util.internal.SystemPropertyUtil;
import org.apache.hadoop.shaded.io.netty.util.internal.logging.InternalLogger;
import org.apache.hadoop.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class ResourceLeakDetector<T> {
    private static final String PROP_LEVEL_OLD = "org.apache.hadoop.shaded.io.netty.leakDetectionLevel";
    private static final String PROP_LEVEL = "org.apache.hadoop.shaded.io.netty.leakDetection.level";
    private static final Level DEFAULT_LEVEL;
    private static final String PROP_MAX_RECORDS = "org.apache.hadoop.shaded.io.netty.leakDetection.maxRecords";
    private static final int DEFAULT_MAX_RECORDS = 4;
    private static final String PROP_MAX_SAMPLED_RECORDS = "org.apache.hadoop.shaded.io.netty.leakDetection.maxSampledRecords";
    private static final int MAX_RECORDS;
    private static final int MAX_SAMPLED_RECORDS;
    private static Level level;
    private static final InternalLogger logger;
    static final int DEFAULT_SAMPLING_INTERVAL = 128;
    private final ConcurrentMap<DefaultResourceLeak, LeakEntry> allLeaks = PlatformDependent.newConcurrentHashMap();
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final ConcurrentMap<String, Boolean> reportedLeaks = PlatformDependent.newConcurrentHashMap();
    private final String resourceType;
    private final int samplingInterval;

    @Deprecated
    public static void setEnabled(boolean enabled) {
        ResourceLeakDetector.setLevel(enabled ? Level.SIMPLE : Level.DISABLED);
    }

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > Level.DISABLED.ordinal();
    }

    public static void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        ResourceLeakDetector.level = level;
    }

    public static Level getLevel() {
        return level;
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> resourceType) {
        this(StringUtil.simpleClassName(resourceType));
    }

    @Deprecated
    public ResourceLeakDetector(String resourceType) {
        this(resourceType, 128, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
        this(resourceType, samplingInterval);
    }

    public ResourceLeakDetector(Class<?> resourceType, int samplingInterval) {
        this(StringUtil.simpleClassName(resourceType), samplingInterval, Long.MAX_VALUE);
    }

    @Deprecated
    public ResourceLeakDetector(String resourceType, int samplingInterval, long maxActive) {
        if (resourceType == null) {
            throw new NullPointerException("resourceType");
        }
        this.resourceType = resourceType;
        this.samplingInterval = samplingInterval;
    }

    @Deprecated
    public final ResourceLeak open(T obj) {
        return this.track0(obj);
    }

    public final ResourceLeakTracker<T> track(T obj) {
        return this.track0(obj);
    }

    private DefaultResourceLeak track0(T obj) {
        Level level = ResourceLeakDetector.level;
        if (level == Level.DISABLED) {
            return null;
        }
        if (level.ordinal() < Level.PARANOID.ordinal()) {
            if (PlatformDependent.threadLocalRandom().nextInt(this.samplingInterval) == 0) {
                this.reportLeak();
                return new DefaultResourceLeak(obj);
            }
            return null;
        }
        this.reportLeak();
        return new DefaultResourceLeak(obj);
    }

    private void clearRefQueue() {
        DefaultResourceLeak ref;
        while ((ref = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            ref.dispose();
        }
    }

    private void reportLeak() {
        DefaultResourceLeak ref;
        if (!logger.isErrorEnabled()) {
            this.clearRefQueue();
            return;
        }
        while ((ref = (DefaultResourceLeak)this.refQueue.poll()) != null) {
            String records;
            if (!ref.dispose() || this.reportedLeaks.putIfAbsent(records = ref.toString(), Boolean.TRUE) != null) continue;
            if (records.isEmpty()) {
                this.reportUntracedLeak(this.resourceType);
                continue;
            }
            this.reportTracedLeak(this.resourceType, records);
        }
    }

    protected void reportTracedLeak(String resourceType, String records) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See http://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)resourceType, (Object)records);
    }

    protected void reportUntracedLeak(String resourceType) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See http://netty.io/wiki/reference-counted-objects.html for more information.", resourceType, PROP_LEVEL, Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    @Deprecated
    protected void reportInstancesLeak(String resourceType) {
    }

    static {
        boolean disabled;
        DEFAULT_LEVEL = Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("org.apache.hadoop.shaded.io.netty.noResourceLeakDetection") != null) {
            disabled = SystemPropertyUtil.getBoolean("org.apache.hadoop.shaded.io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)disabled);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)PROP_LEVEL, (Object)DEFAULT_LEVEL.name().toLowerCase());
        } else {
            disabled = false;
        }
        Level defaultLevel = disabled ? Level.DISABLED : DEFAULT_LEVEL;
        String levelStr = SystemPropertyUtil.get(PROP_LEVEL_OLD, defaultLevel.name());
        levelStr = SystemPropertyUtil.get(PROP_LEVEL, levelStr);
        Level level = Level.parseLevel(levelStr);
        MAX_RECORDS = SystemPropertyUtil.getInt(PROP_MAX_RECORDS, 4);
        long maxRecordsSampled = SystemPropertyUtil.getLong(PROP_MAX_SAMPLED_RECORDS, (long)MAX_RECORDS * 10L);
        MAX_SAMPLED_RECORDS = Math.max((int)Math.min(Integer.MAX_VALUE, maxRecordsSampled), MAX_RECORDS);
        ResourceLeakDetector.level = level;
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_LEVEL, (Object)level.name().toLowerCase());
            logger.debug("-D{}: {}", (Object)PROP_MAX_RECORDS, (Object)MAX_RECORDS);
            logger.debug("-D{}: {}", (Object)PROP_MAX_SAMPLED_RECORDS, (Object)MAX_SAMPLED_RECORDS);
        }
    }

    private static final class LeakEntry {
        static final LeakEntry INSTANCE = new LeakEntry();
        private static final int HASH = System.identityHashCode(INSTANCE);

        private LeakEntry() {
        }

        public int hashCode() {
            return HASH;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }
    }

    private static final class Record
    extends Throwable {
        private static final Set<String> STACK_TRACE_ELEMENT_EXCLUSIONS = new HashSet<String>();
        private final String hintString;
        Record next;

        Record(Object hint) {
            this.hintString = hint instanceof ResourceLeakHint ? ((ResourceLeakHint)hint).toHintString() : hint.toString();
        }

        Record() {
            this.hintString = null;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(4096);
            if (this.hintString != null) {
                buf.append("\tHint: ").append(this.hintString).append(StringUtil.NEWLINE);
            }
            StackTraceElement[] array = this.getStackTrace();
            for (int i = 3; i < array.length; ++i) {
                StackTraceElement element = array[i];
                if (STACK_TRACE_ELEMENT_EXCLUSIONS.contains(element.getClassName() + '.' + element.getMethodName())) continue;
                buf.append('\t');
                buf.append(element.toString());
                buf.append(StringUtil.NEWLINE);
            }
            return buf.toString();
        }

        static {
            STACK_TRACE_ELEMENT_EXCLUSIONS.add("org.apache.hadoop.shaded.io.netty.util.ReferenceCountUtil.touch");
            STACK_TRACE_ELEMENT_EXCLUSIONS.add("org.apache.hadoop.shaded.io.netty.buffer.AdvancedLeakAwareByteBuf.touch");
            STACK_TRACE_ELEMENT_EXCLUSIONS.add("org.apache.hadoop.shaded.io.netty.buffer.AbstractByteBufAllocator.toLeakAwareBuffer");
            STACK_TRACE_ELEMENT_EXCLUSIONS.add("org.apache.hadoop.shaded.io.netty.buffer.AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation");
        }
    }

    private final class DefaultResourceLeak
    extends PhantomReference<Object>
    implements ResourceLeakTracker<T>,
    ResourceLeak {
        private final Record head;
        private Record tail;
        private final int trackedHash;
        private int numRecords;
        private int droppedRecords;

        DefaultResourceLeak(Object referent) {
            super(referent, ResourceLeakDetector.this.refQueue);
            assert (referent != null);
            this.trackedHash = System.identityHashCode(referent);
            this.tail = ResourceLeakDetector.getLevel().ordinal() >= Level.ADVANCED.ordinal() ? new Record() : null;
            this.head = this.tail;
            ResourceLeakDetector.this.allLeaks.put(this, LeakEntry.INSTANCE);
        }

        @Override
        public void record() {
            this.record0(null);
        }

        @Override
        public void record(Object hint) {
            this.record0(hint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void record0(Object hint) {
            if (this.head != null && MAX_RECORDS > 0) {
                Record record = this.head;
                synchronized (record) {
                    Record record2;
                    if (this.tail == null) {
                        return;
                    }
                    this.tail.next = record2 = hint == null ? new Record() : new Record(hint);
                    this.tail = record2;
                    if (this.numRecords == MAX_SAMPLED_RECORDS) {
                        this.head.next = this.head.next.next;
                        ++this.droppedRecords;
                    } else {
                        ++this.numRecords;
                    }
                }
            }
        }

        boolean dispose() {
            this.clear();
            return ResourceLeakDetector.this.allLeaks.remove(this, LeakEntry.INSTANCE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close() {
            if (ResourceLeakDetector.this.allLeaks.remove(this, LeakEntry.INSTANCE)) {
                this.clear();
                if (this.head != null) {
                    Record record = this.head;
                    synchronized (record) {
                        this.head.next = null;
                        this.numRecords = 0;
                        this.tail = null;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean close(T trackedObject) {
            assert (this.trackedHash == System.identityHashCode(trackedObject));
            return this.close() && trackedObject != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String[] array;
            String creationRecord;
            int dropped;
            if (this.head == null) {
                return "";
            }
            int idx = 0;
            String last = null;
            Record record = this.head;
            synchronized (record) {
                if (this.tail == null) {
                    return "";
                }
                dropped = this.droppedRecords;
                creationRecord = this.head.toString();
                array = new String[this.numRecords];
                Record record2 = this.head.next;
                while (record2 != null) {
                    String recordStr = record2.toString();
                    if (last == null || !last.equals(recordStr)) {
                        array[idx++] = recordStr;
                        last = recordStr;
                    }
                    record2 = record2.next;
                }
            }
            int removed = idx > MAX_RECORDS ? idx - MAX_RECORDS : 0;
            StringBuilder buf = new StringBuilder(16384).append(StringUtil.NEWLINE);
            if (removed > 0) {
                buf.append("WARNING: ").append(removed).append(" leak records were discarded because the leak record count is limited to ").append(MAX_RECORDS).append(". Use system property ").append(ResourceLeakDetector.PROP_MAX_RECORDS).append(" to increase the limit.").append(StringUtil.NEWLINE);
            }
            if (dropped > 0) {
                buf.append(dropped).append(" leak records were not sampled because the leak record sample count is limited to ").append(MAX_SAMPLED_RECORDS).append(". Use system property ").append(ResourceLeakDetector.PROP_MAX_SAMPLED_RECORDS).append(" to increase the limit.").append(StringUtil.NEWLINE);
            }
            int records = idx - removed;
            buf.append("Recent access records: ").append(records).append(StringUtil.NEWLINE);
            if (records > 0) {
                for (int i = records - 1; i >= 0; --i) {
                    buf.append('#').append(i + 1).append(':').append(StringUtil.NEWLINE).append(array[i]);
                }
            }
            buf.append("Created at:").append(StringUtil.NEWLINE).append(creationRecord);
            buf.setLength(buf.length() - StringUtil.NEWLINE.length());
            return buf.toString();
        }
    }

    public static enum Level {
        DISABLED,
        SIMPLE,
        ADVANCED,
        PARANOID;


        static Level parseLevel(String levelStr) {
            String trimmedLevelStr = levelStr.trim();
            for (Level l : Level.values()) {
                if (!trimmedLevelStr.equalsIgnoreCase(l.name()) && !trimmedLevelStr.equals(String.valueOf(l.ordinal()))) continue;
                return l;
            }
            return DEFAULT_LEVEL;
        }
    }
}

