/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryLocalPathHandler;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxiliaryServiceWithCustomClassLoader;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.FileDeletionTask;
import org.apache.hadoop.yarn.util.FSDownload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuxServices
extends AbstractService
implements ServiceStateChangeListener,
EventHandler<AuxServicesEvent> {
    public static final String NM_AUX_SERVICE_DIR = "nmAuxService";
    public static final FsPermission NM_AUX_SERVICE_DIR_PERM = new FsPermission(448);
    static final String STATE_STORE_ROOT_NAME = "nm-aux-services";
    private static final Logger LOG = LoggerFactory.getLogger(AuxServices.class);
    private static final String DEL_SUFFIX = "_DEL_";
    protected final Map<String, AuxiliaryService> serviceMap;
    protected final Map<String, ByteBuffer> serviceMetaData;
    private final AuxiliaryLocalPathHandler auxiliaryLocalPathHandler;
    private final LocalDirsHandlerService dirsHandler;
    private final DeletionService delService;
    private final UserGroupInformation userUGI;
    private final Pattern p = Pattern.compile("^[A-Za-z_]+[A-Za-z0-9_]*$");

    public AuxServices(AuxiliaryLocalPathHandler auxiliaryLocalPathHandler, Context nmContext, DeletionService deletionService) {
        super(AuxServices.class.getName());
        this.serviceMap = Collections.synchronizedMap(new HashMap());
        this.serviceMetaData = Collections.synchronizedMap(new HashMap());
        this.auxiliaryLocalPathHandler = auxiliaryLocalPathHandler;
        this.dirsHandler = nmContext.getLocalDirsHandler();
        this.delService = deletionService;
        this.userUGI = this.getRemoteUgi();
    }

    protected final synchronized void addService(String name, AuxiliaryService service) {
        LOG.info("Adding auxiliary service " + service.getName() + ", \"" + name + "\"");
        this.serviceMap.put(name, service);
    }

    Collection<AuxiliaryService> getServices() {
        return Collections.unmodifiableCollection(this.serviceMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteBuffer> getMetaData() {
        HashMap<String, ByteBuffer> metaClone = new HashMap<String, ByteBuffer>(this.serviceMetaData.size());
        Map<String, ByteBuffer> map = this.serviceMetaData;
        synchronized (map) {
            for (Map.Entry<String, ByteBuffer> entry : this.serviceMetaData.entrySet()) {
                metaClone.put(entry.getKey(), entry.getValue().duplicate());
            }
        }
        return metaClone;
    }

    public void serviceInit(Configuration conf) throws Exception {
        FsPermission storeDirPerms = new FsPermission(448);
        Path stateStoreRoot = null;
        LocalFileSystem stateStoreFs = null;
        boolean recoveryEnabled = conf.getBoolean("yarn.nodemanager.recovery.enabled", false);
        if (recoveryEnabled) {
            stateStoreRoot = new Path(conf.get("yarn.nodemanager.recovery.dir"), STATE_STORE_ROOT_NAME);
            stateStoreFs = FileSystem.getLocal((Configuration)conf);
        }
        Collection auxNames = conf.getStringCollection("yarn.nodemanager.aux-services");
        for (String sName : auxNames) {
            try {
                boolean useCustomerClassLoader;
                Preconditions.checkArgument((boolean)this.validateAuxServiceName(sName), (Object)("The ServiceName: " + sName + " set in " + "yarn.nodemanager.aux-services" + " is invalid." + "The valid service name should only contain a-zA-Z0-9_ " + "and can not start with numbers"));
                String classKey = String.format("yarn.nodemanager.aux-services.%s.class", sName);
                String className = conf.get(classKey);
                String appLocalClassPath = conf.get(String.format("yarn.nodemanager.aux-services.%s.classpath", sName));
                String appRemoteClassPath = conf.get(String.format("yarn.nodemanager.aux-services.%s.remote-classpath", sName));
                AuxiliaryServiceWithCustomClassLoader s = null;
                boolean bl = useCustomerClassLoader = (appLocalClassPath != null && !appLocalClassPath.isEmpty() || appRemoteClassPath != null && !appRemoteClassPath.isEmpty()) && className != null && !className.isEmpty();
                if (useCustomerClassLoader) {
                    if (appRemoteClassPath == null || appRemoteClassPath.isEmpty()) {
                        s = AuxiliaryServiceWithCustomClassLoader.getInstance(conf, className, appLocalClassPath);
                    } else {
                        Path src;
                        FileContext remoteLFS;
                        FileStatus scFileStatus;
                        if (appLocalClassPath != null && !appLocalClassPath.isEmpty()) {
                            throw new YarnRuntimeException("The aux serivce:" + sName + " has configured local classpath:" + appLocalClassPath + " and remote classpath:" + appRemoteClassPath + ". Only one of them should be configured.");
                        }
                        FileContext localLFS = this.getLocalFileContext(conf);
                        Path nmAuxDir = this.dirsHandler.getLocalPathForWrite("./nmAuxService");
                        if (!localLFS.util().exists(nmAuxDir)) {
                            try {
                                localLFS.mkdir(nmAuxDir, NM_AUX_SERVICE_DIR_PERM, true);
                            }
                            catch (IOException ex) {
                                throw new YarnRuntimeException("Fail to create dir:" + nmAuxDir.toString(), (Throwable)ex);
                            }
                        }
                        if (!(scFileStatus = (remoteLFS = this.getRemoteFileContext((src = new Path(appRemoteClassPath)).toUri(), conf)).getFileStatus(src)).getOwner().equals(this.userUGI.getShortUserName())) {
                            throw new YarnRuntimeException("The remote jarfile owner:" + scFileStatus.getOwner() + " is not the same as the NM user:" + this.userUGI.getShortUserName() + ".");
                        }
                        if ((scFileStatus.getPermission().toShort() & 0x12) != 0) {
                            throw new YarnRuntimeException("The remote jarfile should not be writable by group or others. The current Permission is " + scFileStatus.getPermission().toShort());
                        }
                        Path dest = null;
                        Path downloadDest = new Path(nmAuxDir, className + "_" + scFileStatus.getModificationTime());
                        Path targetDirPath = new Path(downloadDest, scFileStatus.getPath().getName());
                        FileStatus[] allSubDirs = localLFS.util().listStatus(nmAuxDir);
                        boolean reDownload = true;
                        for (FileStatus sub : allSubDirs) {
                            if (sub.getPath().getName().equals(downloadDest.getName())) {
                                reDownload = false;
                                dest = new Path(targetDirPath + "/" + "*");
                                break;
                            }
                            if (!sub.getPath().getName().contains(className) || sub.getPath().getName().endsWith(DEL_SUFFIX)) continue;
                            Path delPath = new Path(sub.getPath().getParent(), sub.getPath().getName() + DEL_SUFFIX);
                            localLFS.rename(sub.getPath(), delPath, new Options.Rename[0]);
                            LOG.info("delete old aux service jar dir:" + delPath.toString());
                            FileDeletionTask deletionTask = new FileDeletionTask(this.delService, null, delPath, null);
                            this.delService.delete(deletionTask);
                        }
                        if (reDownload) {
                            LocalResourceType srcType = null;
                            String lowerDst = StringUtils.toLowerCase((String)src.toString());
                            if (lowerDst.endsWith(".jar")) {
                                srcType = LocalResourceType.FILE;
                            } else if (lowerDst.endsWith(".zip") || lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
                                srcType = LocalResourceType.ARCHIVE;
                            } else {
                                throw new YarnRuntimeException("Can not unpack file from remote-file-path:" + src + "for aux-service:" + ".\n");
                            }
                            LocalResource scRsrc = LocalResource.newInstance((URL)URL.fromURI((URI)src.toUri()), (LocalResourceType)srcType, (LocalResourceVisibility)LocalResourceVisibility.PRIVATE, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
                            FSDownload download = new FSDownload(localLFS, null, conf, downloadDest, scRsrc, null);
                            try {
                                Path downloaded;
                                dest = downloaded = download.call();
                            }
                            catch (Exception ex) {
                                throw new YarnRuntimeException("Exception happend while downloading files for aux-service:" + sName + " and remote-file-path:" + src + ".\n" + ex.getMessage());
                            }
                        }
                        s = AuxiliaryServiceWithCustomClassLoader.getInstance(new Configuration(conf), className, dest.toString());
                    }
                    LOG.info("The aux service:" + sName + " are using the custom classloader");
                } else {
                    Class sClass = conf.getClass(classKey, null, AuxiliaryService.class);
                    if (sClass == null) {
                        throw new RuntimeException("No class defined for " + sName);
                    }
                    s = (AuxiliaryService)ReflectionUtils.newInstance((Class)sClass, (Configuration)new Configuration(conf));
                }
                if (s == null) {
                    throw new RuntimeException("No object created for " + sName);
                }
                if (!sName.equals(s.getName())) {
                    LOG.warn("The Auxiliary Service named '" + sName + "' in the " + "configuration is for " + ((Object)((Object)s)).getClass() + " which has " + "a name of '" + s.getName() + "'. Because these are " + "not the same tools trying to send ServiceData and read " + "Service Meta Data may have issues unless the refer to " + "the name in the config.");
                }
                s.setAuxiliaryLocalPathHandler(this.auxiliaryLocalPathHandler);
                this.addService(sName, s);
                if (recoveryEnabled) {
                    Path storePath = new Path(stateStoreRoot, sName);
                    stateStoreFs.mkdirs(storePath, storeDirPerms);
                    s.setRecoveryPath(storePath);
                }
                s.init(new Configuration(conf));
            }
            catch (RuntimeException e) {
                LOG.error("Failed to initialize " + sName, (Throwable)e);
                throw e;
            }
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        for (Map.Entry<String, AuxiliaryService> entry : this.serviceMap.entrySet()) {
            AuxiliaryService service = entry.getValue();
            String name = entry.getKey();
            service.start();
            service.registerServiceListener((ServiceStateChangeListener)this);
            ByteBuffer meta = service.getMetaData();
            if (meta == null) continue;
            this.serviceMetaData.put(name, meta);
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        try {
            Map<String, AuxiliaryService> map = this.serviceMap;
            synchronized (map) {
                for (Service service : this.serviceMap.values()) {
                    if (service.getServiceState() != Service.STATE.STARTED) continue;
                    service.unregisterServiceListener((ServiceStateChangeListener)this);
                    service.stop();
                }
                this.serviceMap.clear();
                this.serviceMetaData.clear();
            }
        }
        finally {
            super.serviceStop();
        }
    }

    public void stateChanged(Service service) {
        LOG.error("Service " + service.getName() + " changed state: " + service.getServiceState());
        this.stop();
    }

    public void handle(AuxServicesEvent event) {
        LOG.info("Got event " + event.getType() + " for appId " + event.getApplicationID());
        switch ((AuxServicesEventType)event.getType()) {
            case APPLICATION_INIT: {
                LOG.info("Got APPLICATION_INIT for service " + event.getServiceID());
                AuxiliaryService service = null;
                try {
                    service = this.serviceMap.get(event.getServiceID());
                    service.initializeApplication(new ApplicationInitializationContext(event.getUser(), event.getApplicationID(), event.getServiceData()));
                }
                catch (Throwable th) {
                    this.logWarningWhenAuxServiceThrowExceptions(service, AuxServicesEventType.APPLICATION_INIT, th);
                }
                break;
            }
            case APPLICATION_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.stopApplication(new ApplicationTerminationContext(event.getApplicationID()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.APPLICATION_STOP, th);
                    }
                }
                break;
            }
            case CONTAINER_INIT: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.initializeContainer(new ContainerInitializationContext(event.getContainer().getUser(), event.getContainer().getContainerId(), event.getContainer().getResource(), event.getContainer().getContainerTokenIdentifier().getContainerType()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.CONTAINER_INIT, th);
                    }
                }
                break;
            }
            case CONTAINER_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.stopContainer(new ContainerTerminationContext(event.getUser(), event.getContainer().getContainerId(), event.getContainer().getResource(), event.getContainer().getContainerTokenIdentifier().getContainerType()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.CONTAINER_STOP, th);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + event.getType());
            }
        }
    }

    private boolean validateAuxServiceName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        return this.p.matcher(name).matches();
    }

    private void logWarningWhenAuxServiceThrowExceptions(AuxiliaryService service, AuxServicesEventType eventType, Throwable th) {
        LOG.warn((null == service ? "The auxService is null" : "The auxService name is " + service.getName()) + " and it got an error at event: " + (Object)((Object)eventType), th);
    }

    FileContext getLocalFileContext(Configuration conf) {
        try {
            return FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to access local fs");
        }
    }

    FileContext getRemoteFileContext(URI path, Configuration conf) {
        try {
            return FileContext.getFileContext((URI)path, (Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to access remote fs");
        }
    }

    private UserGroupInformation getRemoteUgi() {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(msg);
            throw new YarnRuntimeException(msg);
        }
        return remoteUgi;
    }
}

