/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ConfigurationException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.WindowsSecureContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerPrepareContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerReapContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.DeletionAsUserContext;
import org.apache.hadoop.yarn.server.nodemanager.util.ProcessIdFileReader;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLaunch
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLaunch.class);
    private static final String CONTAINER_PRE_LAUNCH_PREFIX = "prelaunch";
    public static final String CONTAINER_PRE_LAUNCH_STDOUT = "prelaunch.out";
    public static final String CONTAINER_PRE_LAUNCH_STDERR = "prelaunch.err";
    public static final String CONTAINER_SCRIPT = Shell.appendScriptExtension((String)"launch_container");
    public static final String FINAL_CONTAINER_TOKENS_FILE = "container_tokens";
    private static final String PID_FILE_NAME_FMT = "%s.pid";
    private static final String EXIT_CODE_FILE_SUFFIX = ".exitcode";
    protected final Dispatcher dispatcher;
    protected final ContainerExecutor exec;
    protected final Application app;
    protected final Container container;
    private final Configuration conf;
    private final Context context;
    private final ContainerManagerImpl containerManager;
    protected AtomicBoolean containerAlreadyLaunched = new AtomicBoolean(false);
    protected AtomicBoolean shouldPauseContainer = new AtomicBoolean(false);
    protected AtomicBoolean completed = new AtomicBoolean(false);
    private volatile boolean killedBeforeStart = false;
    private long sleepDelayBeforeSigKill = 250L;
    private long maxKillWaitTime = 2000L;
    protected Path pidFilePath = null;
    protected final LocalDirsHandlerService dirsHandler;
    private final Lock containerExecLock = new ReentrantLock();

    public ContainerLaunch(Context context, Configuration configuration, Dispatcher dispatcher, ContainerExecutor exec, Application app, Container container, LocalDirsHandlerService dirsHandler, ContainerManagerImpl containerManager) {
        this.context = context;
        this.conf = configuration;
        this.app = app;
        this.exec = exec;
        this.container = container;
        this.dispatcher = dispatcher;
        this.dirsHandler = dirsHandler;
        this.containerManager = containerManager;
        this.sleepDelayBeforeSigKill = this.conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L);
        this.maxKillWaitTime = this.conf.getLong("yarn.nodemanager.process-kill-wait.ms", 5000L);
    }

    @VisibleForTesting
    public static String expandEnvironment(String var, Path containerLogDir) {
        var = var.replace("<LOG_DIR>", containerLogDir.toString());
        var = var.replace("<CPS>", File.pathSeparator);
        if (Shell.WINDOWS) {
            var = var.replaceAll("(\\{\\{)|(\\}\\})", "%");
        } else {
            var = var.replace("{{", "$");
            var = var.replace("}}", "");
        }
        return var;
    }

    private Map<String, String> expandAllEnvironmentVars(ContainerLaunchContext launchContext, Path containerLogDir) {
        Map environment = launchContext.getEnvironment();
        for (Map.Entry entry : environment.entrySet()) {
            String value = (String)entry.getValue();
            value = ContainerLaunch.expandEnvironment(value, containerLogDir);
            entry.setValue(value);
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        Path containerLogDir;
        if (!this.validateContainerState()) {
            return 0;
        }
        ContainerLaunchContext launchContext = this.container.getLaunchContext();
        ContainerId containerID = this.container.getContainerId();
        String containerIdStr = containerID.toString();
        List command = launchContext.getCommands();
        int ret = -1;
        try {
            Map<Path, List<String>> localResources = this.getLocalizedResources();
            String user = this.container.getUser();
            ArrayList<String> newCmds = new ArrayList<String>(command.size());
            String appIdStr = this.app.getAppId().toString();
            String relativeContainerLogDir = ContainerLaunch.getRelativeContainerLogDir(appIdStr, containerIdStr);
            containerLogDir = this.dirsHandler.getLogPathForWrite(relativeContainerLogDir, false);
            this.recordContainerLogDir(containerID, containerLogDir.toString());
            for (String str : command) {
                newCmds.add(ContainerLaunch.expandEnvironment(str, containerLogDir));
            }
            launchContext.setCommands(newCmds);
            Map<String, String> environment = this.expandAllEnvironmentVars(launchContext, containerLogDir);
            LinkedHashSet<String> nmEnvVars = new LinkedHashSet<String>();
            FileContext lfs = FileContext.getLocalFSFileContext();
            Path nmPrivateContainerScriptPath = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + CONTAINER_SCRIPT);
            Path nmPrivateTokensPath = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format("%s.tokens", containerIdStr));
            Path nmPrivateClasspathJarDir = this.dirsHandler.getLocalPathForWrite(this.getContainerPrivateDir(appIdStr, containerIdStr));
            Path containerWorkDir = this.deriveContainerWorkDir();
            this.recordContainerWorkDir(containerID, containerWorkDir.toString());
            String pidFileSubpath = this.getPidFileSubpath(appIdStr, containerIdStr);
            this.pidFilePath = this.dirsHandler.getLocalPathForWrite(pidFileSubpath);
            List<String> localDirs = this.dirsHandler.getLocalDirs();
            List<String> localDirsForRead = this.dirsHandler.getLocalDirsForRead();
            List<String> logDirs = this.dirsHandler.getLogDirs();
            List<String> filecacheDirs = this.getNMFilecacheDirs(localDirsForRead);
            List<String> userLocalDirs = this.getUserLocalDirs(localDirs);
            List<String> containerLocalDirs = this.getContainerLocalDirs(localDirs);
            List<String> containerLogDirs = this.getContainerLogDirs(logDirs);
            List<String> userFilecacheDirs = this.getUserFilecacheDirs(localDirsForRead);
            List<String> applicationLocalDirs = this.getApplicationLocalDirs(localDirs, appIdStr);
            if (!this.dirsHandler.areDisksHealthy()) {
                ret = -101;
                throw new IOException("Most of the disks failed. " + this.dirsHandler.getDisksHealthReport(false));
            }
            ArrayList<Path> appDirs = new ArrayList<Path>(localDirs.size());
            for (String localDir : localDirs) {
                Path usersdir = new Path(localDir, "usercache");
                Path userdir = new Path(usersdir, user);
                Path appsdir = new Path(userdir, "appcache");
                appDirs.add(new Path(appsdir, appIdStr));
            }
            ContainerLaunch.addToEnvMap(environment, nmEnvVars, "HADOOP_TOKEN_FILE_LOCATION", new Path(containerWorkDir, FINAL_CONTAINER_TOKENS_FILE).toUri().getPath());
            try (FSDataOutputStream containerScriptOutStream = lfs.create(nmPrivateContainerScriptPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);){
                this.sanitizeEnv(environment, containerWorkDir, appDirs, userLocalDirs, containerLogDirs, localResources, nmPrivateClasspathJarDir, nmEnvVars);
                this.prepareContainer(localResources, containerLocalDirs);
                this.exec.writeLaunchEnv((OutputStream)containerScriptOutStream, environment, localResources, launchContext.getCommands(), containerLogDir, user, nmEnvVars);
            }
            var31_35 = null;
            try (FSDataOutputStream tokensOutStream = lfs.create(nmPrivateTokensPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);){
                Credentials creds = this.container.getCredentials();
                creds.writeTokenStorageToStream((DataOutputStream)tokensOutStream);
            }
            catch (Throwable throwable) {
                var31_35 = throwable;
                throw throwable;
            }
            ret = this.launchContainer(new ContainerStartContext.Builder().setContainer(this.container).setLocalizedResources(localResources).setNmPrivateContainerScriptPath(nmPrivateContainerScriptPath).setNmPrivateTokensPath(nmPrivateTokensPath).setUser(user).setAppId(appIdStr).setContainerWorkDir(containerWorkDir).setLocalDirs(localDirs).setLogDirs(logDirs).setFilecacheDirs(filecacheDirs).setUserLocalDirs(userLocalDirs).setContainerLocalDirs(containerLocalDirs).setContainerLogDirs(containerLogDirs).setUserFilecacheDirs(userFilecacheDirs).setApplicationLocalDirs(applicationLocalDirs).build());
        }
        catch (ConfigurationException e) {
            LOG.error("Failed to launch container due to configuration error.", (Throwable)e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            this.context.getNodeStatusUpdater().reportException((Exception)((Object)e));
            Integer n = ret;
            return n;
        }
        catch (Throwable e) {
            LOG.warn("Failed to launch container.", e);
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, e.getMessage()));
            Integer n = ret;
            return n;
        }
        finally {
            this.setContainerCompletedStatus(ret);
        }
        this.handleContainerExitCode(ret, containerLogDir);
        return ret;
    }

    private Path deriveContainerWorkDir() throws IOException {
        String containerWorkDirPath = "usercache/" + this.container.getUser() + "/" + "appcache" + "/" + this.app.getAppId().toString() + "/" + this.container.getContainerId().toString();
        Path containerWorkDir = this.dirsHandler.getLocalPathForWrite(containerWorkDirPath, -1L, false);
        return containerWorkDir;
    }

    private void prepareContainer(Map<Path, List<String>> localResources, List<String> containerLocalDirs) throws IOException {
        this.exec.prepareContainer(new ContainerPrepareContext.Builder().setContainer(this.container).setLocalizedResources(localResources).setUser(this.container.getUser()).setContainerLocalDirs(containerLocalDirs).setCommands(this.container.getLaunchContext().getCommands()).build());
    }

    protected boolean validateContainerState() {
        if (this.container.getContainerState() == ContainerState.KILLING) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(this.container.getContainerId(), ContainerEventType.CONTAINER_KILLED_ON_REQUEST, Shell.WINDOWS ? ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() : ContainerExecutor.ExitCode.TERMINATED.getExitCode(), "Container terminated before launch."));
            return false;
        }
        return true;
    }

    protected List<String> getContainerLogDirs(List<String> logDirs) {
        ArrayList<String> containerLogDirs = new ArrayList<String>(logDirs.size());
        String appIdStr = this.app.getAppId().toString();
        String containerIdStr = this.container.getContainerId().toString();
        String relativeContainerLogDir = ContainerLaunch.getRelativeContainerLogDir(appIdStr, containerIdStr);
        for (String logDir : logDirs) {
            containerLogDirs.add(logDir + "/" + relativeContainerLogDir);
        }
        return containerLogDirs;
    }

    protected List<String> getContainerLocalDirs(List<String> localDirs) {
        ArrayList<String> containerLocalDirs = new ArrayList<String>(localDirs.size());
        String user = this.container.getUser();
        String appIdStr = this.app.getAppId().toString();
        String relativeContainerLocalDir = "usercache/" + user + "/" + "appcache" + "/" + appIdStr + "/";
        for (String localDir : localDirs) {
            containerLocalDirs.add(localDir + "/" + relativeContainerLocalDir);
        }
        return containerLocalDirs;
    }

    protected List<String> getUserLocalDirs(List<String> localDirs) {
        ArrayList<String> userLocalDirs = new ArrayList<String>(localDirs.size());
        String user = this.container.getUser();
        for (String localDir : localDirs) {
            String userLocalDir = localDir + "/" + "usercache" + "/" + user + "/";
            userLocalDirs.add(userLocalDir);
        }
        return userLocalDirs;
    }

    protected List<String> getNMFilecacheDirs(List<String> localDirs) {
        ArrayList<String> filecacheDirs = new ArrayList<String>(localDirs.size());
        for (String localDir : localDirs) {
            String filecacheDir = localDir + "/" + "filecache";
            filecacheDirs.add(filecacheDir);
        }
        return filecacheDirs;
    }

    protected List<String> getUserFilecacheDirs(List<String> localDirs) {
        ArrayList<String> userFilecacheDirs = new ArrayList<String>(localDirs.size());
        String user = this.container.getUser();
        for (String localDir : localDirs) {
            String userFilecacheDir = localDir + "/" + "usercache" + "/" + user + "/" + "filecache";
            userFilecacheDirs.add(userFilecacheDir);
        }
        return userFilecacheDirs;
    }

    protected List<String> getApplicationLocalDirs(List<String> localDirs, String appIdStr) {
        ArrayList<String> applicationLocalDirs = new ArrayList<String>(localDirs.size());
        String user = this.container.getUser();
        for (String localDir : localDirs) {
            String appLocalDir = localDir + "/" + "usercache" + "/" + user + "/" + "appcache" + "/" + appIdStr;
            applicationLocalDirs.add(appLocalDir);
        }
        return applicationLocalDirs;
    }

    protected Map<Path, List<String>> getLocalizedResources() throws YarnException {
        Map<Path, List<String>> localResources = this.container.getLocalizedResources();
        if (localResources == null) {
            throw RPCUtil.getRemoteException((String)("Unable to get local resources when Container " + this.container + " is at " + (Object)((Object)this.container.getContainerState())));
        }
        return localResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int launchContainer(ContainerStartContext ctx) throws IOException, ConfigurationException {
        int launchPrep = this.prepareForLaunch(ctx);
        if (launchPrep == 0) {
            this.containerExecLock.lock();
            try {
                int n = this.exec.launchContainer(ctx);
                return n;
            }
            finally {
                this.containerExecLock.unlock();
            }
        }
        return launchPrep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int relaunchContainer(ContainerStartContext ctx) throws IOException, ConfigurationException {
        int launchPrep = this.prepareForLaunch(ctx);
        if (launchPrep == 0) {
            this.containerExecLock.lock();
            try {
                int n = this.exec.relaunchContainer(ctx);
                return n;
            }
            finally {
                this.containerExecLock.unlock();
            }
        }
        return launchPrep;
    }

    protected int prepareForLaunch(ContainerStartContext ctx) throws IOException {
        ContainerId containerId = this.container.getContainerId();
        if (this.container.isMarkedForKilling()) {
            LOG.info("Container " + containerId + " not launched as it has already " + "been marked for Killing");
            this.killedBeforeStart = true;
            return ContainerExecutor.ExitCode.TERMINATED.getExitCode();
        }
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.CONTAINER_LAUNCHED));
        this.context.getNMStateStore().storeContainerLaunched(containerId);
        if (!this.containerAlreadyLaunched.compareAndSet(false, true)) {
            LOG.info("Container " + containerId + " not launched as " + "cleanup already called");
            return ContainerExecutor.ExitCode.TERMINATED.getExitCode();
        }
        this.exec.activateContainer(containerId, this.pidFilePath);
        return ContainerExecutor.ExitCode.SUCCESS.getExitCode();
    }

    protected void setContainerCompletedStatus(int exitCode) {
        ContainerId containerId = this.container.getContainerId();
        this.completed.set(true);
        this.exec.deactivateContainer(containerId);
        try {
            if (!this.container.shouldRetry(exitCode)) {
                this.context.getNMStateStore().storeContainerCompleted(containerId, exitCode);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to set exit code for container " + containerId);
        }
    }

    protected void handleContainerExitCode(int exitCode, Path containerLogDir) {
        ContainerId containerId = this.container.getContainerId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container " + containerId + " completed with exit code " + exitCode);
        }
        StringBuilder diagnosticInfo = new StringBuilder("Container exited with a non-zero exit code ");
        diagnosticInfo.append(exitCode);
        diagnosticInfo.append(". ");
        if (exitCode == ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() || exitCode == ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerId, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, exitCode, diagnosticInfo.toString()));
        } else if (exitCode != 0) {
            this.handleContainerExitWithFailure(containerId, exitCode, containerLogDir, diagnosticInfo);
        } else {
            LOG.info("Container " + containerId + " succeeded ");
            this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS));
        }
    }

    protected void handleContainerExitWithFailure(ContainerId containerID, int ret, Path containerLogDir, StringBuilder diagnosticInfo) {
        LOG.warn("Container launch failed : " + diagnosticInfo.toString());
        FileSystem fileSystem = null;
        long tailSizeInBytes = this.conf.getLong("yarn.nodemanager.container.stderr.tail.bytes", 4096L);
        try {
            fileSystem = FileSystem.getLocal((Configuration)this.conf).getRaw();
            FileStatus preLaunchErrorFileStatus = fileSystem.getFileStatus(new Path(containerLogDir, CONTAINER_PRE_LAUNCH_STDERR));
            Path errorFile = preLaunchErrorFileStatus.getPath();
            long fileSize = preLaunchErrorFileStatus.getLen();
            diagnosticInfo.append("Error file: ").append(CONTAINER_PRE_LAUNCH_STDERR).append(".\n");
            byte[] tailBuffer = this.tailFile(errorFile, fileSize, tailSizeInBytes);
            diagnosticInfo.append("Last ").append(tailSizeInBytes).append(" bytes of ").append(errorFile.getName()).append(" :\n").append(new String(tailBuffer, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error("Failed to get tail of the container's prelaunch error log file", (Throwable)e);
        }
        String errorFileNamePattern = this.conf.get("yarn.nodemanager.container.stderr.pattern", "{*stderr*,*STDERR*}");
        try {
            FileStatus[] errorFileStatuses;
            if (fileSystem == null) {
                fileSystem = FileSystem.getLocal((Configuration)this.conf).getRaw();
            }
            if ((errorFileStatuses = fileSystem.globStatus(new Path(containerLogDir, errorFileNamePattern))) != null && errorFileStatuses.length != 0) {
                Path errorFile = errorFileStatuses[0].getPath();
                long fileSize = errorFileStatuses[0].getLen();
                if (errorFileStatuses.length > 1) {
                    String[] errorFileNames = new String[errorFileStatuses.length];
                    long latestModifiedTime = errorFileStatuses[0].getModificationTime();
                    errorFileNames[0] = errorFileStatuses[0].getPath().getName();
                    for (int i = 1; i < errorFileStatuses.length; ++i) {
                        errorFileNames[i] = errorFileStatuses[i].getPath().getName();
                        if (errorFileStatuses[i].getModificationTime() <= latestModifiedTime) continue;
                        latestModifiedTime = errorFileStatuses[i].getModificationTime();
                        errorFile = errorFileStatuses[i].getPath();
                        fileSize = errorFileStatuses[i].getLen();
                    }
                    diagnosticInfo.append("Error files: ").append(StringUtils.join((CharSequence)", ", (String[])errorFileNames)).append(".\n");
                }
                byte[] tailBuffer = this.tailFile(errorFile, fileSize, tailSizeInBytes);
                String tailBufferMsg = new String(tailBuffer, StandardCharsets.UTF_8);
                diagnosticInfo.append("Last ").append(tailSizeInBytes).append(" bytes of ").append(errorFile.getName()).append(" :\n").append(tailBufferMsg).append("\n").append(this.analysesErrorMsgOfContainerExitWithFailure(tailBufferMsg));
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get tail of the container's error log file", (Throwable)e);
        }
        this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(containerID, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ret, diagnosticInfo.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] tailFile(Path filePath, long fileSize, long tailSizeInBytes) throws IOException {
        byte[] byArray;
        FSDataInputStream errorFileIS = null;
        FileSystem fileSystem = FileSystem.getLocal((Configuration)this.conf).getRaw();
        try {
            long startPosition = fileSize < tailSizeInBytes ? 0L : fileSize - tailSizeInBytes;
            int bufferSize = (int)(fileSize < tailSizeInBytes ? fileSize : tailSizeInBytes);
            byte[] tailBuffer = new byte[bufferSize];
            errorFileIS = fileSystem.open(filePath);
            errorFileIS.readFully(startPosition, tailBuffer);
            byArray = tailBuffer;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{errorFileIS});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{errorFileIS});
        return byArray;
    }

    private String analysesErrorMsgOfContainerExitWithFailure(String errorMsg) {
        StringBuilder analysis = new StringBuilder();
        if (errorMsg.indexOf("Error: Could not find or load main class org.apache.hadoop.mapreduce") != -1) {
            analysis.append("Please check whether your etc/hadoop/mapred-site.xml contains the below configuration:\n");
            analysis.append("<property>\n").append("  <name>yarn.app.mapreduce.am.env</name>\n").append("  <value>HADOOP_MAPRED_HOME=${full path of your hadoop distribution directory}</value>\n").append("</property>\n<property>\n").append("  <name>mapreduce.map.env</name>\n").append("  <value>HADOOP_MAPRED_HOME=${full path of your hadoop distribution directory}</value>\n").append("</property>\n<property>\n").append("  <name>mapreduce.reduce.env</name>\n").append("  <value>HADOOP_MAPRED_HOME=${full path of your hadoop distribution directory}</value>\n").append("</property>\n");
        }
        return analysis.toString();
    }

    protected String getPidFileSubpath(String appIdStr, String containerIdStr) {
        return this.getContainerPrivateDir(appIdStr, containerIdStr) + "/" + String.format(PID_FILE_NAME_FMT, containerIdStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupContainer() throws IOException {
        boolean alreadyLaunched;
        ContainerId containerId = this.container.getContainerId();
        String containerIdStr = containerId.toString();
        LOG.info("Cleaning up container " + containerIdStr);
        try {
            this.context.getNMStateStore().storeContainerKilled(containerId);
        }
        catch (IOException e) {
            LOG.error("Unable to mark container " + containerId + " killed in store", (Throwable)e);
        }
        boolean bl = alreadyLaunched = !this.containerAlreadyLaunched.compareAndSet(false, true);
        if (!alreadyLaunched) {
            LOG.info("Container " + containerIdStr + " not launched." + " No cleanup needed to be done");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Marking container " + containerIdStr + " as inactive");
        }
        this.exec.deactivateContainer(containerId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting pid for container " + containerIdStr + " to kill" + " from pid file " + (this.pidFilePath != null ? this.pidFilePath.toString() : "null"));
        }
        try {
            String processId = null;
            if (this.pidFilePath != null) {
                processId = this.getContainerPid(this.pidFilePath);
            }
            String user = this.container.getUser();
            if (processId != null) {
                this.signalProcess(processId, user, containerIdStr);
            } else {
                if (!this.completed.get()) {
                    LOG.warn("Container clean up before pid file created " + containerIdStr);
                    this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(this.container.getContainerId(), ContainerEventType.CONTAINER_KILLED_ON_REQUEST, Shell.WINDOWS ? ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() : ContainerExecutor.ExitCode.TERMINATED.getExitCode(), "Container terminated before pid file created."));
                }
                if (DockerLinuxContainerRuntime.isDockerContainerRequested(this.container.getLaunchContext().getEnvironment())) {
                    this.reapDockerContainerNoPid(user);
                }
            }
        }
        catch (Exception e) {
            String message = "Exception when trying to cleanup container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(message);
            this.dispatcher.getEventHandler().handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, message));
        }
        finally {
            if (this.pidFilePath != null) {
                FileContext lfs = FileContext.getLocalFSFileContext();
                lfs.delete(this.pidFilePath, false);
                lfs.delete(this.pidFilePath.suffix(EXIT_CODE_FILE_SUFFIX), false);
            }
        }
        this.containerExecLock.lock();
        try {
            boolean result = this.exec.reapContainer(new ContainerReapContext.Builder().setContainer(this.container).setUser(this.container.getUser()).build());
            if (!result) {
                throw new IOException("Reap container failed for container " + containerIdStr);
            }
            this.cleanupContainerFiles(this.getContainerWorkDir());
        }
        finally {
            this.containerExecLock.unlock();
        }
    }

    public void signalContainer(SignalContainerCommand command) throws IOException {
        boolean alreadyLaunched;
        ContainerId containerId = this.container.getContainerTokenIdentifier().getContainerID();
        String containerIdStr = containerId.toString();
        String user = this.container.getUser();
        ContainerExecutor.Signal signal = ContainerLaunch.translateCommandToSignal(command);
        if (signal.equals((Object)ContainerExecutor.Signal.NULL)) {
            LOG.info("ignore signal command " + command);
            return;
        }
        LOG.info("Sending signal " + command + " to container " + containerIdStr);
        boolean bl = alreadyLaunched = !this.containerAlreadyLaunched.compareAndSet(false, true);
        if (!alreadyLaunched) {
            LOG.info("Container " + containerIdStr + " not launched." + " Not sending the signal");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting pid for container " + containerIdStr + " to send signal to from pid file " + (this.pidFilePath != null ? this.pidFilePath.toString() : "null"));
        }
        try {
            String processId = null;
            if (this.pidFilePath != null) {
                processId = this.getContainerPid(this.pidFilePath);
            }
            if (processId != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending signal to pid " + processId + " as user " + user + " for container " + containerIdStr);
                }
                boolean result = this.exec.signalContainer(new ContainerSignalContext.Builder().setContainer(this.container).setUser(user).setPid(processId).setSignal(signal).build());
                String diagnostics = "Sent signal " + command + " (" + (Object)((Object)signal) + ") to pid " + processId + " as user " + user + " for container " + containerIdStr + ", result=" + (result ? "success" : "failed");
                LOG.info(diagnostics);
                this.dispatcher.getEventHandler().handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, diagnostics));
            }
        }
        catch (Exception e) {
            String message = "Exception when sending signal to container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(message);
        }
    }

    private boolean sendSignal(String user, String processId, ContainerExecutor.Signal signal) throws IOException {
        return this.exec.signalContainer(new ContainerSignalContext.Builder().setContainer(this.container).setUser(user).setPid(processId).setSignal(signal).build());
    }

    private void signalProcess(String processId, String user, String containerIdStr) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending signal to pid " + processId + " as user " + user + " for container " + containerIdStr);
        }
        ContainerExecutor.Signal signal = this.sleepDelayBeforeSigKill > 0L ? ContainerExecutor.Signal.TERM : ContainerExecutor.Signal.KILL;
        boolean result = this.sendSignal(user, processId, signal);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent signal " + (Object)((Object)signal) + " to pid " + processId + " as user " + user + " for container " + containerIdStr + ", result=" + (result ? "success" : "failed"));
        }
        if (this.sleepDelayBeforeSigKill > 0L) {
            new ContainerExecutor.DelayedProcessKiller(this.container, user, processId, this.sleepDelayBeforeSigKill, ContainerExecutor.Signal.KILL, this.exec).start();
        }
    }

    private void reapDockerContainerNoPid(String user) throws IOException {
        String containerIdStr = this.container.getContainerTokenIdentifier().getContainerID().toString();
        LOG.info("Unable to obtain pid, but docker container request detected. Attempting to reap container " + containerIdStr);
        boolean result = this.exec.reapContainer(new ContainerReapContext.Builder().setContainer(this.container).setUser(this.container.getUser()).build());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent signal to docker container " + containerIdStr + " as user " + user + ", result=" + (result ? "success" : "failed"));
        }
    }

    @VisibleForTesting
    public static ContainerExecutor.Signal translateCommandToSignal(SignalContainerCommand command) {
        ContainerExecutor.Signal signal = ContainerExecutor.Signal.NULL;
        switch (command) {
            case OUTPUT_THREAD_DUMP: {
                signal = Shell.WINDOWS ? ContainerExecutor.Signal.NULL : ContainerExecutor.Signal.QUIT;
                break;
            }
            case GRACEFUL_SHUTDOWN: {
                signal = ContainerExecutor.Signal.TERM;
                break;
            }
            case FORCEFUL_SHUTDOWN: {
                signal = ContainerExecutor.Signal.KILL;
            }
        }
        return signal;
    }

    public void pauseContainer() throws IOException {
        ContainerId containerId = this.container.getContainerId();
        String containerIdStr = containerId.toString();
        LOG.info("Pausing the container " + containerIdStr);
        if (!this.shouldPauseContainer.compareAndSet(false, true)) {
            LOG.info("Container " + containerId + " not paused as " + "resume already called");
            return;
        }
        try {
            this.exec.pauseContainer(this.container);
            this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.CONTAINER_PAUSED));
            try {
                this.context.getNMStateStore().storeContainerPaused(this.container.getContainerId());
            }
            catch (IOException e) {
                LOG.warn("Could not store container [" + this.container.getContainerId() + "] state. The Container has been paused.", (Throwable)e);
            }
        }
        catch (Exception e) {
            String message = "Exception when trying to pause container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
            LOG.info(message);
            this.container.handle((Event)new ContainerKillEvent(this.container.getContainerId(), -102, "Container preempted as there was  an exception in pausing it."));
        }
    }

    public void resumeContainer() throws IOException {
        boolean alreadyPaused;
        ContainerId containerId = this.container.getContainerId();
        String containerIdStr = containerId.toString();
        LOG.info("Resuming the container " + containerIdStr);
        boolean bl = alreadyPaused = !this.shouldPauseContainer.compareAndSet(false, true);
        if (!alreadyPaused) {
            LOG.info("Container " + containerIdStr + " not paused." + " No resume necessary");
            return;
        }
        try {
            this.exec.resumeContainer(this.container);
            this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(containerId, ContainerEventType.CONTAINER_RESUMED));
            try {
                this.context.getNMStateStore().removeContainerPaused(this.container.getContainerId());
            }
            catch (IOException e) {
                LOG.warn("Could not store container [" + this.container.getContainerId() + "] state. The Container has been resumed.", (Throwable)e);
            }
        }
        catch (Exception e) {
            String message = "Exception when trying to resume container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
            LOG.info(message);
            this.container.handle((Event)new ContainerKillEvent(this.container.getContainerId(), -102, "Container preempted as there was  an exception in pausing it."));
        }
    }

    private String getContainerPid(Path pidFilePath) throws Exception {
        String containerIdStr = this.container.getContainerId().toString();
        String processId = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Accessing pid for container " + containerIdStr + " from pid file " + pidFilePath);
        }
        int sleepCounter = 0;
        int sleepInterval = 100;
        while (true) {
            if ((processId = ProcessIdFileReader.getProcessId(pidFilePath)) != null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Got pid " + processId + " for container " + containerIdStr);
                break;
            }
            if ((long)(sleepCounter * 100) > this.maxKillWaitTime) {
                LOG.info("Could not get pid for " + containerIdStr + ". Waited for " + this.maxKillWaitTime + " ms.");
                break;
            }
            ++sleepCounter;
            Thread.sleep(100L);
        }
        return processId;
    }

    public static String getRelativeContainerLogDir(String appIdStr, String containerIdStr) {
        return appIdStr + "/" + containerIdStr;
    }

    protected String getContainerPrivateDir(String appIdStr, String containerIdStr) {
        return this.getAppPrivateDir(appIdStr) + "/" + containerIdStr + "/";
    }

    private String getAppPrivateDir(String appIdStr) {
        return "nmPrivate/" + appIdStr;
    }

    Context getContext() {
        return this.context;
    }

    private static void putEnvIfNotNull(Map<String, String> environment, String variable, String value) {
        if (value != null) {
            environment.put(variable, value);
        }
    }

    private static void putEnvIfAbsent(Map<String, String> environment, String variable) {
        if (environment.get(variable) == null) {
            ContainerLaunch.putEnvIfNotNull(environment, variable, System.getenv(variable));
        }
    }

    private static void addToEnvMap(Map<String, String> envMap, Set<String> envSet, String envName, String envValue) {
        envMap.put(envName, envValue);
        envSet.add(envName);
    }

    public void sanitizeEnv(Map<String, String> environment, Path pwd, List<Path> appDirs, List<String> userLocalDirs, List<String> containerLogDirs, Map<Path, List<String>> resources, Path nmPrivateClasspathJarDir, Set<String> nmVars) throws IOException {
        boolean overrideDisable = Boolean.parseBoolean(environment.get(ApplicationConstants.Environment.YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE.name()));
        if (overrideDisable) {
            environment.remove("WORK_DIR");
            return;
        }
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.CONTAINER_ID.name(), this.container.getContainerId().toString());
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.NM_PORT.name(), String.valueOf(this.context.getNodeId().getPort()));
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.NM_HOST.name(), this.context.getNodeId().getHost());
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.NM_HTTP_PORT.name(), String.valueOf(this.context.getHttpPort()));
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.LOCAL_DIRS.name(), StringUtils.join((CharSequence)",", appDirs));
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.LOCAL_USER_DIRS.name(), StringUtils.join((CharSequence)",", userLocalDirs));
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.LOG_DIRS.name(), StringUtils.join((CharSequence)",", containerLogDirs));
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.USER.name(), this.container.getUser());
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.LOGNAME.name(), this.container.getUser());
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.HOME.name(), this.conf.get("yarn.nodemanager.user-home-dir", "/home/"));
        ContainerLaunch.addToEnvMap(environment, nmVars, ApplicationConstants.Environment.PWD.name(), pwd.toString());
        if (!Shell.WINDOWS) {
            ContainerLaunch.addToEnvMap(environment, nmVars, "JVM_PID", "$$");
        }
        String nmAdminUserEnv = this.conf.get("yarn.nodemanager.admin-env", "MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX");
        Apps.setEnvFromInputString(environment, (String)nmAdminUserEnv, (String)File.pathSeparator);
        nmVars.addAll(Apps.getEnvVarsFromInputString((String)nmAdminUserEnv, (String)File.pathSeparator));
        if (Shell.WINDOWS) {
            this.sanitizeWindowsEnv(environment, pwd, resources, nmPrivateClasspathJarDir);
        }
        for (Map.Entry<String, ByteBuffer> meta : this.containerManager.getAuxServiceMetaData().entrySet()) {
            AuxiliaryServiceHelper.setServiceDataIntoEnv((String)meta.getKey(), (ByteBuffer)meta.getValue(), environment);
            nmVars.add(AuxiliaryServiceHelper.getPrefixServiceName((String)meta.getKey()));
        }
    }

    private void sanitizeWindowsEnv(Map<String, String> environment, Path pwd, Map<Path, List<String>> resources, Path nmPrivateClasspathJarDir) throws IOException {
        String inputClassPath = environment.get(ApplicationConstants.Environment.CLASSPATH.name());
        if (inputClassPath != null && !inputClassPath.isEmpty()) {
            boolean preferLocalizedJars = Boolean.parseBoolean(environment.get(ApplicationConstants.Environment.CLASSPATH_PREPEND_DISTCACHE.name()));
            boolean needsSeparator = false;
            StringBuilder newClassPath = new StringBuilder();
            if (!preferLocalizedJars) {
                newClassPath.append(inputClassPath);
                needsSeparator = true;
            }
            for (Map.Entry<Path, List<String>> entry : resources.entrySet()) {
                boolean targetIsDirectory = new File(entry.getKey().toUri().getPath()).isDirectory();
                for (String linkName : entry.getValue()) {
                    if (needsSeparator) {
                        newClassPath.append(File.pathSeparator);
                    } else {
                        needsSeparator = true;
                    }
                    newClassPath.append(pwd.toString()).append("/").append(linkName);
                    if (!targetIsDirectory) continue;
                    newClassPath.append("/");
                }
            }
            if (preferLocalizedJars) {
                if (needsSeparator) {
                    newClassPath.append(File.pathSeparator);
                }
                newClassPath.append(inputClassPath);
            }
            HashMap<String, String> mergedEnv = new HashMap<String, String>(System.getenv());
            mergedEnv.putAll(environment);
            Path jarDir = this.exec instanceof WindowsSecureContainerExecutor ? nmPrivateClasspathJarDir : pwd;
            String[] jarCp = FileUtil.createJarWithClassPath((String)newClassPath.toString(), (Path)jarDir, (Path)pwd, mergedEnv);
            Path localizedClassPathJar = this.exec.localizeClasspathJar(new Path(jarCp[0]), pwd, this.container.getUser());
            String replacementClassPath = localizedClassPathJar.toString() + jarCp[1];
            environment.put(ApplicationConstants.Environment.CLASSPATH.name(), replacementClassPath);
        }
    }

    public static String getExitCodeFile(String pidFile) {
        return pidFile + EXIT_CODE_FILE_SUFFIX;
    }

    private void recordContainerLogDir(ContainerId containerId, String logDir) throws IOException {
        this.container.setLogDir(logDir);
        if (this.container.isRetryContextSet()) {
            this.context.getNMStateStore().storeContainerLogDir(containerId, logDir);
        }
    }

    private void recordContainerWorkDir(ContainerId containerId, String workDir) throws IOException {
        this.container.setWorkDir(workDir);
        if (this.container.isRetryContextSet()) {
            this.context.getNMStateStore().storeContainerWorkDir(containerId, workDir);
        }
    }

    protected Path getContainerWorkDir() throws IOException {
        String containerWorkDir = this.container.getWorkDir();
        if (containerWorkDir == null || !this.dirsHandler.isGoodLocalDir(containerWorkDir)) {
            throw new IOException("Could not find a good work dir " + containerWorkDir + " for container " + this.container);
        }
        return new Path(containerWorkDir);
    }

    protected void cleanupContainerFiles(Path containerWorkDir) {
        LOG.debug("cleanup container {} files", (Object)containerWorkDir);
        this.deleteAsUser(new Path(containerWorkDir, CONTAINER_SCRIPT));
        this.deleteAsUser(new Path(containerWorkDir, FINAL_CONTAINER_TOKENS_FILE));
        try {
            this.exec.cleanupBeforeRelaunch(this.container);
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("{} exec failed to cleanup", (Object)this.container.getContainerId(), (Object)e);
        }
    }

    private void deleteAsUser(Path path) {
        try {
            this.exec.deleteAsUser(new DeletionAsUserContext.Builder().setUser(this.container.getUser()).setSubDir(path).build());
        }
        catch (Exception e) {
            LOG.warn("Failed to delete " + path, (Throwable)e);
        }
    }

    private static final class WindowsShellScriptBuilder
    extends ShellScriptBuilder {
        private void errorCheck() {
            this.line("@if %errorlevel% neq 0 exit /b %errorlevel%");
        }

        private void lineWithLenCheck(String ... commands) throws IOException {
            Shell.checkWindowsCommandLineLength((String[])commands);
            this.line(commands);
        }

        public WindowsShellScriptBuilder() {
            this.line("@setlocal");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) throws IOException {
            this.lineWithLenCheck("@call ", StringUtils.join((CharSequence)" ", command));
            this.errorCheck();
        }

        @Override
        protected void setStdOut(Path stdout) throws IOException {
        }

        @Override
        protected void setStdErr(Path stderr) throws IOException {
        }

        @Override
        public void env(String key, String value) throws IOException {
            this.lineWithLenCheck("@set ", key, "=", value);
            this.errorCheck();
        }

        @Override
        public void whitelistedEnv(String key, String value) throws IOException {
            this.env(key, value);
        }

        @Override
        public void echo(String echoStr) throws IOException {
            this.lineWithLenCheck("@echo \"", echoStr, "\"");
        }

        @Override
        protected void link(Path src, Path dst) throws IOException {
            File srcFile = new File(src.toUri().getPath());
            String srcFileStr = srcFile.getPath();
            String dstFileStr = new File(dst.toString()).getPath();
            this.lineWithLenCheck(String.format("@%s symlink \"%s\" \"%s\"", Shell.getWinUtilsPath(), dstFileStr, srcFileStr));
            this.errorCheck();
        }

        @Override
        protected void mkdir(Path path) throws IOException {
            this.lineWithLenCheck(String.format("@if not exist \"%s\" mkdir \"%s\"", path.toString(), path.toString()));
            this.errorCheck();
        }

        @Override
        public void copyDebugInformation(Path src, Path dest) throws IOException {
            this.line("rem Creating copy of launch script");
            this.lineWithLenCheck(String.format("copy \"%s\" \"%s\"", src.toString(), dest.toString()));
        }

        @Override
        public void listDebugInformation(Path output) throws IOException {
            this.line("rem Determining directory contents");
            this.lineWithLenCheck(String.format("@echo \"dir:\" > \"%s\"", output.toString()));
            this.lineWithLenCheck(String.format("dir >> \"%s\"", output.toString()));
        }

        @Override
        public Set<String> getEnvDependencies(String envVal) {
            if (envVal == null || envVal.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<String> deps = new HashSet<String>();
            int len = envVal.length();
            int i = 0;
            while (i < len && (i = envVal.indexOf(37, i)) >= 0 && i != len - 1) {
                int j;
                if ((j = envVal.indexOf(37, ++i)) == i) {
                    ++i;
                    continue;
                }
                if (j < 0) break;
                int k = envVal.indexOf(58, i);
                if (k >= 0 && k < j) {
                    deps.add(envVal.substring(i, k));
                } else {
                    deps.add(envVal.substring(i, j));
                }
                i = j + 1;
            }
            return deps;
        }
    }

    private static final class UnixShellScriptBuilder
    extends ShellScriptBuilder {
        private void errorCheck() {
            this.line("hadoop_shell_errorcode=$?");
            this.line("if [[ \"$hadoop_shell_errorcode\" -ne 0 ]]");
            this.line("then");
            this.line("  exit $hadoop_shell_errorcode");
            this.line("fi");
        }

        public UnixShellScriptBuilder() {
            this.line("#!/bin/bash");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) {
            this.line("exec /bin/bash -c \"", StringUtils.join((CharSequence)" ", command), "\"");
        }

        @Override
        public void setStdOut(Path stdout) throws IOException {
            this.line("export ", "PRELAUNCH_OUT", "=\"", stdout.toString(), "\"");
            this.line("exec >\"${PRELAUNCH_OUT}\"");
        }

        @Override
        public void setStdErr(Path stderr) throws IOException {
            this.line("export ", "PRELAUNCH_ERR", "=\"", stderr.toString(), "\"");
            this.line("exec 2>\"${PRELAUNCH_ERR}\"");
        }

        @Override
        public void env(String key, String value) throws IOException {
            this.line("export ", key, "=\"", value, "\"");
        }

        @Override
        public void whitelistedEnv(String key, String value) throws IOException {
            this.line("export ", key, "=${", key, ":-", "\"", value, "\"}");
        }

        @Override
        public void echo(String echoStr) throws IOException {
            this.line("echo \"" + echoStr + "\"");
        }

        @Override
        protected void link(Path src, Path dst) throws IOException {
            this.line("ln -sf -- \"", src.toUri().getPath(), "\" \"", dst.toString(), "\"");
        }

        @Override
        protected void mkdir(Path path) throws IOException {
            this.line("mkdir -p ", path.toString());
        }

        @Override
        public void copyDebugInformation(Path src, Path dest) throws IOException {
            this.line("# Creating copy of launch script");
            this.line("cp \"", src.toUri().getPath(), "\" \"", dest.toUri().getPath(), "\"");
            if (dest.isAbsolute()) {
                this.line("chmod 640 \"", dest.toUri().getPath(), "\"");
            }
        }

        @Override
        public void listDebugInformation(Path output) throws IOException {
            this.line("# Determining directory contents");
            this.line("echo \"ls -l:\" 1>\"", output.toString(), "\"");
            this.line("ls -l 1>>\"", output.toString(), "\"");
            this.line("echo \"find -L . -maxdepth 5 -ls:\" 1>>\"", output.toString(), "\"");
            this.line("find -L . -maxdepth 5 -ls 1>>\"", output.toString(), "\"");
            this.line("echo \"broken symlinks(find -L . -maxdepth 5 -type l -ls):\" 1>>\"", output.toString(), "\"");
            this.line("find -L . -maxdepth 5 -type l -ls 1>>\"", output.toString(), "\"");
        }

        @Override
        public void setExitOnFailure() {
            this.line("set -o pipefail -e");
        }

        @Override
        public Set<String> getEnvDependencies(String envVal) {
            if (envVal == null || envVal.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<String> deps = new HashSet<String>();
            boolean inDoubleQuotes = true;
            int len = envVal.length();
            block0: for (int i = 0; i < len; ++i) {
                char c = envVal.charAt(i);
                if (c == '\"') {
                    inDoubleQuotes = !inDoubleQuotes;
                    continue;
                }
                if (c == '\'' && !inDoubleQuotes) {
                    ++i;
                    while (i < len) {
                        c = envVal.charAt(i);
                        if (c == '\\') {
                            ++i;
                        }
                        if (c == '\'') continue block0;
                        ++i;
                    }
                    continue;
                }
                if (c == '\\') {
                    ++i;
                    continue;
                }
                if (c != '$') continue;
                if (++i >= len || (c = envVal.charAt(i)) == '{' && (++i >= len || (c = envVal.charAt(i)) == '#' && ++i >= len)) break;
                int start = i;
                while (i < len && (c = envVal.charAt(i)) != '$' && (i == start && Character.isJavaIdentifierStart(c) || i > start && Character.isJavaIdentifierPart(c))) {
                    ++i;
                }
                if (i <= start) continue;
                deps.add(envVal.substring(start, i));
            }
            return deps;
        }
    }

    public static abstract class ShellScriptBuilder {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final StringBuilder sb = new StringBuilder();
        protected static final String ENV_PRELAUNCH_STDOUT = "PRELAUNCH_OUT";
        protected static final String ENV_PRELAUNCH_STDERR = "PRELAUNCH_ERR";
        private boolean redirectStdOut = false;
        private boolean redirectStdErr = false;

        public static ShellScriptBuilder create() {
            return ShellScriptBuilder.create(Shell.osType);
        }

        @VisibleForTesting
        public static ShellScriptBuilder create(Shell.OSType osType) {
            return osType == Shell.OSType.OS_TYPE_WIN ? new WindowsShellScriptBuilder() : new UnixShellScriptBuilder();
        }

        public abstract void command(List<String> var1) throws IOException;

        public final void stdout(Path stdoutDir, String stdOutFile) throws IOException {
            if (!stdoutDir.isAbsolute()) {
                throw new IOException("Stdout path must be absolute");
            }
            this.redirectStdOut = true;
            this.setStdOut(new Path(stdoutDir, stdOutFile));
        }

        public final void stderr(Path stderrDir, String stdErrFile) throws IOException {
            if (!stderrDir.isAbsolute()) {
                throw new IOException("Stdout path must be absolute");
            }
            this.redirectStdErr = true;
            this.setStdErr(new Path(stderrDir, stdErrFile));
        }

        protected abstract void setStdOut(Path var1) throws IOException;

        protected abstract void setStdErr(Path var1) throws IOException;

        public abstract void env(String var1, String var2) throws IOException;

        public abstract void whitelistedEnv(String var1, String var2) throws IOException;

        public abstract void echo(String var1) throws IOException;

        public final void symlink(Path src, Path dst) throws IOException {
            if (!src.isAbsolute()) {
                throw new IOException("Source must be absolute");
            }
            if (dst.isAbsolute()) {
                throw new IOException("Destination must be relative");
            }
            if (dst.toUri().getPath().indexOf(47) != -1) {
                this.mkdir(dst.getParent());
            }
            this.link(src, dst);
        }

        public abstract void copyDebugInformation(Path var1, Path var2) throws IOException;

        public abstract void listDebugInformation(Path var1) throws IOException;

        public String toString() {
            return this.sb.toString();
        }

        public final void write(PrintStream out) throws IOException {
            out.append(this.sb);
        }

        protected final void buildCommand(String ... command) {
            for (String s : command) {
                this.sb.append(s);
            }
        }

        protected final void linebreak(String ... command) {
            this.sb.append(LINE_SEPARATOR);
        }

        protected final void line(String ... command) {
            this.buildCommand(command);
            this.linebreak(new String[0]);
        }

        public void setExitOnFailure() {
        }

        protected abstract void link(Path var1, Path var2) throws IOException;

        protected abstract void mkdir(Path var1) throws IOException;

        boolean doRedirectStdOut() {
            return this.redirectStdOut;
        }

        boolean doRedirectStdErr() {
            return this.redirectStdErr;
        }

        public Set<String> getEnvDependencies(String envVal) {
            return Collections.emptySet();
        }

        public final Map<String, String> orderEnvByDependencies(Map<String, String> envs) {
            if (envs == null || envs.size() < 2) {
                return envs;
            }
            final LinkedHashMap<String, String> ordered = new LinkedHashMap<String, String>();
            class Env {
                private boolean resolved = false;
                private final Collection<Env> deps = new ArrayList<Env>();
                private final String name;
                private final String value;

                Env(String name, String value) {
                    this.name = name;
                    this.value = value;
                }

                void resolve() {
                    this.resolved = true;
                    for (Env dep : this.deps) {
                        if (dep.resolved) continue;
                        dep.resolve();
                    }
                    ordered.put(this.name, this.value);
                }
            }
            HashMap<String, Env> singletons = new HashMap<String, Env>();
            for (Map.Entry<String, String> e : envs.entrySet()) {
                Env env = (Env)singletons.get(e.getKey());
                if (env == null) {
                    env = new Env(e.getKey(), e.getValue());
                    singletons.put(env.name, env);
                }
                for (String depStr : this.getEnvDependencies(env.value)) {
                    if (!envs.containsKey(depStr)) continue;
                    Env depEnv = (Env)singletons.get(depStr);
                    if (depEnv == null) {
                        depEnv = new Env(depStr, envs.get(depStr));
                        singletons.put(depStr, depEnv);
                    }
                    env.deps.add(depEnv);
                }
            }
            for (Env env : singletons.values()) {
                if (env.resolved) continue;
                env.resolve();
            }
            return ordered;
        }
    }
}

