/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.protobuf.BlockingService;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ConfiguredYarnAuthorizer;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeLabelsUtils;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.resource.DynamicResourceConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;

public class AdminService
extends CompositeService
implements HAServiceProtocol,
ResourceManagerAdministrationProtocol {
    private static final Log LOG = LogFactory.getLog(AdminService.class);
    private final ResourceManager rm;
    private String rmId;
    private boolean autoFailoverEnabled;
    private RPC.Server server;
    private InetSocketAddress masterServiceBindAddress;
    private YarnAuthorizationProvider authorizer;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private UserGroupInformation daemonUser;
    @VisibleForTesting
    boolean isCentralizedNodeLabelConfiguration = true;

    public AdminService(ResourceManager rm) {
        super(AdminService.class.getName());
        this.rm = rm;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.autoFailoverEnabled = this.rm.getRMContext().isHAEnabled() && HAUtil.isAutomaticFailoverEnabled((Configuration)conf);
        this.masterServiceBindAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
        this.daemonUser = UserGroupInformation.getCurrentUser();
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
        this.authorizer.setAdmins(this.getAdminAclList(conf), this.daemonUser);
        this.rmId = conf.get("yarn.resourcemanager.ha.id");
        this.isCentralizedNodeLabelConfiguration = YarnConfiguration.isCentralizedNodeLabelConfiguration((Configuration)conf);
        super.serviceInit(conf);
    }

    private AccessControlList getAdminAclList(Configuration conf) {
        AccessControlList aclList = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        aclList.addUser(this.daemonUser.getShortUserName());
        return aclList;
    }

    protected void serviceStart() throws Exception {
        this.startServer();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopServer();
        super.serviceStop();
    }

    protected void startServer() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = (RPC.Server)rpc.getServer(ResourceManagerAdministrationProtocol.class, (Object)this, this.masterServiceBindAddress, conf, null, conf.getInt("yarn.resourcemanager.admin.client.thread-count", 1));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(this.getConfiguration(conf, "hadoop-policy.xml"), RMPolicyProvider.getInstance());
        }
        if (this.rm.getRMContext().isHAEnabled()) {
            RPC.setProtocolEngine((Configuration)conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
            HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB((HAServiceProtocol)this);
            BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService((HAServiceProtocolProtos.HAServiceProtocolService.BlockingInterface)haServiceProtocolXlator);
            this.server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, HAServiceProtocol.class, (Object)haPbService);
        }
        this.server.start();
        conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.admin.address", "0.0.0.0:8033", this.server.getListenerAddress());
    }

    protected void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private UserGroupInformation checkAccess(String method) throws IOException {
        return RMServerUtils.verifyAdminAccess(this.authorizer, method, LOG);
    }

    private UserGroupInformation checkAcls(String method) throws YarnException {
        try {
            return this.checkAccess(method);
        }
        catch (IOException ioe) {
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
    }

    private void checkHaStateChange(HAServiceProtocol.StateChangeRequestInfo req) throws AccessControlException {
        switch (req.getSource()) {
            case REQUEST_BY_USER: {
                if (!this.autoFailoverEnabled) break;
                throw new AccessControlException("Manual failover for this ResourceManager is disallowed, because automatic failover is enabled.");
            }
            case REQUEST_BY_USER_FORCED: {
                if (!this.autoFailoverEnabled) break;
                LOG.warn((Object)("Allowing manual failover from " + Server.getRemoteAddress() + " even though automatic failover is enabled, because the user " + "specified the force flag"));
                break;
            }
            case REQUEST_BY_ZKFC: {
                if (this.autoFailoverEnabled) break;
                throw new AccessControlException("Request from ZK failover controller at " + Server.getRemoteAddress() + " denied " + "since automatic failover is not enabled");
            }
        }
    }

    private synchronized boolean isRMActive() {
        return HAServiceProtocol.HAServiceState.ACTIVE == this.rm.getRMContext().getHAServiceState();
    }

    private void throwStandbyException() throws StandbyException {
        throw new StandbyException("ResourceManager " + this.rmId + " is not Active!");
    }

    public synchronized void monitorHealth() throws IOException {
        this.checkAccess("monitorHealth");
        if (this.isRMActive() && !this.rm.areActiveServicesRunning()) {
            throw new HealthCheckFailedException("Active ResourceManager services are not running!");
        }
    }

    public synchronized void transitionToActive(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        if (this.isRMActive()) {
            return;
        }
        try {
            this.refreshAdminAcls(false);
        }
        catch (YarnException ex) {
            throw new ServiceFailedException("Can not execute refreshAdminAcls", (Throwable)ex);
        }
        UserGroupInformation user = this.checkAccess("transitionToActive");
        this.checkHaStateChange(reqInfo);
        try {
            this.refreshAll();
        }
        catch (Exception e) {
            this.rm.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMFatalEvent(RMFatalEventType.TRANSITION_TO_ACTIVE_FAILED, e, "failure to refresh configuration settings"));
            throw new ServiceFailedException("Error on refreshAll during transition to Active", (Throwable)e);
        }
        try {
            this.rm.transitionToActive();
        }
        catch (Exception e) {
            RMAuditLogger.logFailure(user.getShortUserName(), "transitionToActive", "", "RM", "Exception transitioning to active");
            throw new ServiceFailedException("Error when transitioning to Active mode", (Throwable)e);
        }
        RMAuditLogger.logSuccess(user.getShortUserName(), "transitionToActive", "RM");
    }

    public synchronized void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws IOException {
        try {
            this.refreshAdminAcls(false);
        }
        catch (YarnException ex) {
            throw new ServiceFailedException("Can not execute refreshAdminAcls", (Throwable)ex);
        }
        UserGroupInformation user = this.checkAccess("transitionToStandby");
        this.checkHaStateChange(reqInfo);
        try {
            this.rm.transitionToStandby(true);
            RMAuditLogger.logSuccess(user.getShortUserName(), "transitionToStandby", "RM");
        }
        catch (Exception e) {
            RMAuditLogger.logFailure(user.getShortUserName(), "transitionToStandby", "", "RM", "Exception transitioning to standby");
            throw new ServiceFailedException("Error when transitioning to Standby mode", (Throwable)e);
        }
    }

    public synchronized HAServiceStatus getServiceStatus() throws IOException {
        this.checkAccess("getServiceState");
        HAServiceProtocol.HAServiceState haState = this.rm.getRMContext().getHAServiceState();
        HAServiceStatus ret = new HAServiceStatus(haState);
        if (this.isRMActive() || haState == HAServiceProtocol.HAServiceState.STANDBY) {
            ret.setReadyToBecomeActive();
        } else {
            ret.setNotReadyToBecomeActive("State is " + haState);
        }
        return ret;
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws YarnException, StandbyException {
        String operation = "refreshQueues";
        String msg = "refresh queues.";
        UserGroupInformation user = this.checkAcls("refreshQueues");
        this.checkRMStatus(user.getShortUserName(), "refreshQueues", "refresh queues.");
        RefreshQueuesResponse response = (RefreshQueuesResponse)this.recordFactory.newRecordInstance(RefreshQueuesResponse.class);
        try {
            if (this.isSchedulerMutable()) {
                throw new IOException("Scheduler configuration is mutable. refreshQueues is not allowed in this scenario.");
            }
            this.refreshQueues();
            RMAuditLogger.logSuccess(user.getShortUserName(), "refreshQueues", "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), "refreshQueues", "refresh queues.");
        }
    }

    protected Configuration loadNewConfiguration() throws IOException, YarnException {
        Configuration conf = this.getConfiguration(new Configuration(false), "yarn-site.xml", "resource-types.xml");
        conf.size();
        return conf;
    }

    @InterfaceAudience.Private
    public void refreshQueues() throws IOException, YarnException {
        Configuration conf = this.loadNewConfiguration();
        this.rm.getRMContext().getScheduler().reinitialize(conf, this.rm.getRMContext());
        ReservationSystem rSystem = this.rm.getRMContext().getReservationSystem();
        if (rSystem != null) {
            rSystem.reinitialize(conf, this.rm.getRMContext());
        }
    }

    private boolean isSchedulerMutable() {
        ResourceScheduler scheduler = this.rm.getRMContext().getScheduler();
        return scheduler instanceof MutableConfScheduler && ((MutableConfScheduler)scheduler).isConfigurationMutable();
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws YarnException, StandbyException {
        String operation = "refreshNodes";
        String msg = "refresh nodes.";
        UserGroupInformation user = this.checkAcls("refreshNodes");
        this.checkRMStatus(user.getShortUserName(), "refreshNodes", "refresh nodes.");
        try {
            Configuration conf = this.getConfiguration(new Configuration(false), "yarn-site.xml");
            switch (request.getDecommissionType()) {
                case NORMAL: {
                    this.rm.getRMContext().getNodesListManager().refreshNodes(conf);
                    break;
                }
                case GRACEFUL: {
                    this.rm.getRMContext().getNodesListManager().refreshNodesGracefully(conf, request.getDecommissionTimeout());
                    break;
                }
                case FORCEFUL: {
                    this.rm.getRMContext().getNodesListManager().refreshNodesForcefully();
                }
            }
            RMAuditLogger.logSuccess(user.getShortUserName(), "refreshNodes", "AdminService");
            return (RefreshNodesResponse)this.recordFactory.newRecordInstance(RefreshNodesResponse.class);
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), "refreshNodes", "refresh nodes.");
        }
    }

    private void refreshNodes() throws IOException, YarnException {
        Configuration conf = this.getConfiguration(new Configuration(false), "yarn-site.xml");
        this.rm.getRMContext().getNodesListManager().refreshNodes(conf);
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws YarnException, IOException {
        String operation = "refreshSuperUserGroupsConfiguration";
        UserGroupInformation user = this.checkAcls("refreshSuperUserGroupsConfiguration");
        this.checkRMStatus(user.getShortUserName(), "refreshSuperUserGroupsConfiguration", "refresh super-user-groups.");
        this.refreshSuperUserGroupsConfiguration();
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshSuperUserGroupsConfiguration", "AdminService");
        return (RefreshSuperUserGroupsConfigurationResponse)this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationResponse.class);
    }

    private void refreshSuperUserGroupsConfiguration() throws IOException, YarnException {
        Configuration conf = this.getConfiguration(new Configuration(false), "core-site.xml", "yarn-site.xml");
        RMServerUtils.processRMProxyUsersConf(conf);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws YarnException, IOException {
        String operation = "refreshUserToGroupsMappings";
        UserGroupInformation user = this.checkAcls("refreshUserToGroupsMappings");
        this.checkRMStatus(user.getShortUserName(), "refreshUserToGroupsMappings", "refresh user-groups.");
        this.refreshUserToGroupsMappings();
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshUserToGroupsMappings", "AdminService");
        return (RefreshUserToGroupsMappingsResponse)this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsResponse.class);
    }

    private void refreshUserToGroupsMappings() throws IOException, YarnException {
        Groups.getUserToGroupsMappingService((Configuration)this.getConfiguration(new Configuration(false), "core-site.xml")).refresh();
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException, IOException {
        return this.refreshAdminAcls(true);
    }

    private RefreshAdminAclsResponse refreshAdminAcls(boolean checkRMHAState) throws YarnException, IOException {
        String operation = "refreshAdminAcls";
        UserGroupInformation user = this.checkAcls("refreshAdminAcls");
        if (checkRMHAState) {
            this.checkRMStatus(user.getShortUserName(), "refreshAdminAcls", "refresh Admin ACLs.");
        }
        Configuration conf = this.getConfiguration(new Configuration(false), "yarn-site.xml");
        this.authorizer.setAdmins(this.getAdminAclList(conf), this.daemonUser);
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshAdminAcls", "AdminService");
        return (RefreshAdminAclsResponse)this.recordFactory.newRecordInstance(RefreshAdminAclsResponse.class);
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException, IOException {
        if (!this.getConfig().getBoolean("hadoop.security.authorization", false)) {
            throw RPCUtil.getRemoteException((Throwable)new IOException("Service Authorization (hadoop.security.authorization) not enabled."));
        }
        String operation = "refreshServiceAcls";
        UserGroupInformation user = this.checkAcls("refreshServiceAcls");
        this.checkRMStatus(user.getShortUserName(), "refreshServiceAcls", "refresh Service ACLs.");
        this.refreshServiceAcls();
        this.refreshActiveServicesAcls();
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshServiceAcls", "AdminService");
        return (RefreshServiceAclsResponse)this.recordFactory.newRecordInstance(RefreshServiceAclsResponse.class);
    }

    private void refreshServiceAcls() throws IOException, YarnException {
        RMPolicyProvider policyProvider = RMPolicyProvider.getInstance();
        Configuration conf = this.getConfiguration(new Configuration(false), "hadoop-policy.xml");
        this.refreshServiceAcls(conf, policyProvider);
    }

    private void refreshActiveServicesAcls() throws IOException, YarnException {
        RMPolicyProvider policyProvider = RMPolicyProvider.getInstance();
        Configuration conf = this.getConfiguration(new Configuration(false), "hadoop-policy.xml");
        this.rm.getRMContext().getClientRMService().refreshServiceAcls(conf, policyProvider);
        this.rm.getRMContext().getApplicationMasterService().refreshServiceAcls(conf, policyProvider);
        this.rm.getRMContext().getResourceTrackerService().refreshServiceAcls(conf, policyProvider);
    }

    private synchronized void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    public String[] getGroupsForUser(String user) throws IOException {
        UserGroupInformation ugi;
        String operation = "getGroupsForUser";
        try {
            ugi = this.checkAcls(operation);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        this.checkRMStatus(ugi.getShortUserName(), operation, "get groups for user");
        return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        String operation = "updateNodeResource";
        UserGroupInformation user = this.checkAcls("updateNodeResource");
        this.checkRMStatus(user.getShortUserName(), "updateNodeResource", "update node resource.");
        Map nodeResourceMap = request.getNodeResourceMap();
        Set nodeIds = nodeResourceMap.keySet();
        for (Object nodeId : nodeIds) {
            RMNode rMNode = (RMNode)this.rm.getRMContext().getRMNodes().get(nodeId);
            if (rMNode != null) continue;
            LOG.error((Object)("Resource update get failed on all nodes due to change resource on an unrecognized node: " + nodeId));
            throw RPCUtil.getRemoteException((String)("Resource update get failed on all nodes due to change resource on an unrecognized node: " + nodeId));
        }
        boolean allSuccess = true;
        for (Map.Entry entry : nodeResourceMap.entrySet()) {
            ResourceOption newResourceOption = (ResourceOption)entry.getValue();
            NodeId nodeId = (NodeId)entry.getKey();
            RMNode node = (RMNode)this.rm.getRMContext().getRMNodes().get(nodeId);
            if (node == null) {
                LOG.warn((Object)("Resource update get failed on an unrecognized node: " + nodeId));
                allSuccess = false;
                continue;
            }
            this.rm.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMNodeResourceUpdateEvent(nodeId, newResourceOption));
            LOG.info((Object)("Update resource on node(" + node.getNodeID() + ") with resource(" + newResourceOption.toString() + ")"));
        }
        if (allSuccess) {
            RMAuditLogger.logSuccess(user.getShortUserName(), "updateNodeResource", "AdminService");
        }
        UpdateNodeResourceResponse response = UpdateNodeResourceResponse.newInstance();
        return response;
    }

    public RefreshNodesResourcesResponse refreshNodesResources(RefreshNodesResourcesRequest request) throws YarnException, StandbyException {
        String operation = "refreshNodesResources";
        UserGroupInformation user = this.checkAcls("refreshNodesResources");
        String msg = "refresh nodes.";
        this.checkRMStatus(user.getShortUserName(), "refreshNodesResources", "refresh nodes.");
        RefreshNodesResourcesResponse response = (RefreshNodesResourcesResponse)this.recordFactory.newRecordInstance(RefreshNodesResourcesResponse.class);
        try {
            Configuration conf = this.getConfig();
            Configuration configuration = new Configuration(conf);
            InputStream drInputStream = this.rm.getRMContext().getConfigurationProvider().getConfigurationInputStream(configuration, "dynamic-resources.xml");
            DynamicResourceConfiguration newConf = drInputStream != null ? new DynamicResourceConfiguration(configuration, drInputStream) : new DynamicResourceConfiguration(configuration);
            if (newConf.getNodes() != null && newConf.getNodes().length != 0) {
                Map<NodeId, ResourceOption> nodeResourceMap = newConf.getNodeResourceMap();
                UpdateNodeResourceRequest updateRequest = UpdateNodeResourceRequest.newInstance(nodeResourceMap);
                this.updateNodeResource(updateRequest);
            }
            this.rm.getRMContext().getResourceTrackerService().updateDynamicResourceConfiguration(newConf);
            RMAuditLogger.logSuccess(user.getShortUserName(), "refreshNodesResources", "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), "refreshNodesResources", "refresh nodes.");
        }
    }

    private synchronized Configuration getConfiguration(Configuration conf, String ... confFileNames) throws YarnException, IOException {
        for (String confFileName : confFileNames) {
            InputStream confFileInputStream = this.rm.getRMContext().getConfigurationProvider().getConfigurationInputStream(conf, confFileName);
            if (confFileInputStream == null) continue;
            conf.addResource(confFileInputStream);
        }
        return conf;
    }

    @VisibleForTesting
    void refreshAll() throws ServiceFailedException {
        try {
            this.checkAcls("refreshAll");
            if (this.isSchedulerMutable()) {
                try {
                    ((MutableConfScheduler)this.rm.getRMContext().getScheduler()).getMutableConfProvider().reloadConfigurationFromStore();
                }
                catch (Exception e) {
                    throw new IOException("Failed to refresh configuration:", e);
                }
            }
            this.refreshQueues();
            this.refreshNodes();
            this.refreshSuperUserGroupsConfiguration();
            this.refreshUserToGroupsMappings();
            if (this.getConfig().getBoolean("hadoop.security.authorization", false)) {
                this.refreshServiceAcls();
            }
            this.refreshClusterMaxPriority();
        }
        catch (Exception ex) {
            throw new ServiceFailedException("RefreshAll operation failed", (Throwable)ex);
        }
    }

    @VisibleForTesting
    public AccessControlList getAccessControlList() {
        return ((ConfiguredYarnAuthorizer)this.authorizer).getAdminAcls();
    }

    @VisibleForTesting
    public RPC.Server getServer() {
        return this.server;
    }

    public AddToClusterNodeLabelsResponse addToClusterNodeLabels(AddToClusterNodeLabelsRequest request) throws YarnException, IOException {
        String operation = "addToClusterNodeLabels";
        String msg = "add labels.";
        UserGroupInformation user = this.checkAcls("addToClusterNodeLabels");
        this.checkRMStatus(user.getShortUserName(), "addToClusterNodeLabels", "add labels.");
        AddToClusterNodeLabelsResponse response = (AddToClusterNodeLabelsResponse)this.recordFactory.newRecordInstance(AddToClusterNodeLabelsResponse.class);
        try {
            this.rm.getRMContext().getNodeLabelManager().addToCluserNodeLabels(request.getNodeLabels());
            RMAuditLogger.logSuccess(user.getShortUserName(), "addToClusterNodeLabels", "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), "addToClusterNodeLabels", "add labels.");
        }
    }

    public RemoveFromClusterNodeLabelsResponse removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest request) throws YarnException, IOException {
        String operation = "removeFromClusterNodeLabels";
        String msg = "remove labels.";
        UserGroupInformation user = this.checkAcls("removeFromClusterNodeLabels");
        this.checkRMStatus(user.getShortUserName(), "removeFromClusterNodeLabels", "remove labels.");
        RemoveFromClusterNodeLabelsResponse response = (RemoveFromClusterNodeLabelsResponse)this.recordFactory.newRecordInstance(RemoveFromClusterNodeLabelsResponse.class);
        try {
            this.rm.getRMContext().getNodeLabelManager().removeFromClusterNodeLabels(request.getNodeLabels());
            RMAuditLogger.logSuccess(user.getShortUserName(), "removeFromClusterNodeLabels", "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), "removeFromClusterNodeLabels", "remove labels.");
        }
    }

    public ReplaceLabelsOnNodeResponse replaceLabelsOnNode(ReplaceLabelsOnNodeRequest request) throws YarnException, IOException {
        ReplaceLabelsOnNodeResponse response;
        UserGroupInformation user;
        block9: {
            String operation = "replaceLabelsOnNode";
            String msg = "set node to labels.";
            try {
                NodeLabelsUtils.verifyCentralizedNodeLabelConfEnabled("replaceLabelsOnNode", this.isCentralizedNodeLabelConfiguration);
            }
            catch (IOException ioe) {
                throw RPCUtil.getRemoteException((Throwable)ioe);
            }
            user = this.checkAcls("replaceLabelsOnNode");
            this.checkRMStatus(user.getShortUserName(), "replaceLabelsOnNode", "set node to labels.");
            response = (ReplaceLabelsOnNodeResponse)this.recordFactory.newRecordInstance(ReplaceLabelsOnNodeResponse.class);
            if (!request.getFailOnUnknownNodes()) break block9;
            ArrayList<NodeId> unknownNodes = new ArrayList<NodeId>();
            for (NodeId requestedNode : request.getNodeToLabels().keySet()) {
                boolean isKnown;
                block11: {
                    block10: {
                        isKnown = false;
                        if (requestedNode.getPort() == 0) break block10;
                        if (!this.rm.getRMContext().getRMNodes().containsKey(requestedNode) && !this.rm.getRMContext().getInactiveRMNodes().containsKey(requestedNode)) break block11;
                        isKnown = true;
                        break block11;
                    }
                    for (NodeId knownNode : this.rm.getRMContext().getRMNodes().keySet()) {
                        if (!knownNode.getHost().equals(requestedNode.getHost())) continue;
                        isKnown = true;
                        break;
                    }
                    if (!isKnown) {
                        for (NodeId knownNode : this.rm.getRMContext().getInactiveRMNodes().keySet()) {
                            if (!knownNode.getHost().equals(requestedNode.getHost())) continue;
                            isKnown = true;
                            break;
                        }
                    }
                }
                if (isKnown) continue;
                unknownNodes.add(requestedNode);
            }
            if (!unknownNodes.isEmpty()) {
                RMAuditLogger.logFailure(user.getShortUserName(), "replaceLabelsOnNode", "", "AdminService", "Failed to replace labels as there are unknown nodes:" + Arrays.toString(unknownNodes.toArray()));
                throw RPCUtil.getRemoteException((Throwable)new IOException("Failed to replace labels as there are unknown nodes:" + Arrays.toString(unknownNodes.toArray())));
            }
        }
        try {
            this.rm.getRMContext().getNodeLabelManager().replaceLabelsOnNode(request.getNodeToLabels());
            RMAuditLogger.logSuccess(user.getShortUserName(), "replaceLabelsOnNode", "AdminService");
            return response;
        }
        catch (IOException ioe) {
            throw this.logAndWrapException(ioe, user.getShortUserName(), "replaceLabelsOnNode", "set node to labels.");
        }
    }

    private void checkRMStatus(String user, String operation, String msg) throws StandbyException {
        if (!this.isRMActive()) {
            RMAuditLogger.logFailure(user, operation, "", "AdminService", "ResourceManager is not active. Can not " + msg);
            this.throwStandbyException();
        }
    }

    private YarnException logAndWrapException(Exception exception, String user, String operation, String msg) throws YarnException {
        LOG.warn((Object)("Exception " + msg), (Throwable)exception);
        RMAuditLogger.logFailure(user, operation, "", "AdminService", "Exception " + msg);
        return RPCUtil.getRemoteException((Throwable)exception);
    }

    public CheckForDecommissioningNodesResponse checkForDecommissioningNodes(CheckForDecommissioningNodesRequest checkForDecommissioningNodesRequest) throws IOException, YarnException {
        String operation = "checkForDecommissioningNodes";
        String msg = "check for decommissioning nodes.";
        UserGroupInformation user = this.checkAcls("checkForDecommissioningNodes");
        this.checkRMStatus(user.getShortUserName(), "checkForDecommissioningNodes", "check for decommissioning nodes.");
        Set<NodeId> decommissioningNodes = this.rm.getRMContext().getNodesListManager().checkForDecommissioningNodes();
        RMAuditLogger.logSuccess(user.getShortUserName(), "checkForDecommissioningNodes", "AdminService");
        CheckForDecommissioningNodesResponse response = (CheckForDecommissioningNodesResponse)this.recordFactory.newRecordInstance(CheckForDecommissioningNodesResponse.class);
        response.setDecommissioningNodes(decommissioningNodes);
        return response;
    }

    public RefreshClusterMaxPriorityResponse refreshClusterMaxPriority(RefreshClusterMaxPriorityRequest request) throws YarnException, IOException {
        String operation = "refreshClusterMaxPriority";
        String msg = "refresh cluster max priority";
        UserGroupInformation user = this.checkAcls("refreshClusterMaxPriority");
        this.checkRMStatus(user.getShortUserName(), "refreshClusterMaxPriority", "refresh cluster max priority");
        try {
            this.refreshClusterMaxPriority();
            RMAuditLogger.logSuccess(user.getShortUserName(), "refreshClusterMaxPriority", "AdminService");
            return (RefreshClusterMaxPriorityResponse)this.recordFactory.newRecordInstance(RefreshClusterMaxPriorityResponse.class);
        }
        catch (YarnException e) {
            throw this.logAndWrapException((Exception)((Object)e), user.getShortUserName(), "refreshClusterMaxPriority", "refresh cluster max priority");
        }
    }

    private void refreshClusterMaxPriority() throws IOException, YarnException {
        Configuration conf = this.getConfiguration(new Configuration(false), "yarn-site.xml");
        this.rm.getRMContext().getScheduler().setClusterMaxPriority(conf);
    }
}

