/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidLabelResourceRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerUtils {
    private static final Log LOG = LogFactory.getLog(SchedulerUtils.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final String RELEASED_CONTAINER = "Container released by application";
    public static final String UPDATED_CONTAINER = "Temporary container killed by application for ExeutionType update";
    public static final String LOST_CONTAINER = "Container released on a *lost* node";
    public static final String PREEMPTED_CONTAINER = "Container preempted by scheduler";
    public static final String COMPLETED_APPLICATION = "Container of a completed application";
    public static final String EXPIRED_CONTAINER = "Container expired since it was unused";
    public static final String UNRESERVED_CONTAINER = "Container reservation no longer required.";

    public static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -100, diagnostics);
    }

    public static ContainerStatus createKilledContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -106, diagnostics);
    }

    public static ContainerStatus createPreemptedContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -102, diagnostics);
    }

    private static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, int exitStatus, String diagnostics) {
        ContainerStatus containerStatus = (ContainerStatus)recordFactory.newRecordInstance(ContainerStatus.class);
        containerStatus.setContainerId(containerId);
        containerStatus.setDiagnostics(diagnostics);
        containerStatus.setExitStatus(exitStatus);
        containerStatus.setState(ContainerState.COMPLETE);
        return containerStatus;
    }

    @VisibleForTesting
    public static void normalizeRequest(ResourceRequest ask, ResourceCalculator resourceCalculator, Resource minimumResource, Resource maximumResource) {
        ask.setCapability(SchedulerUtils.getNormalizedResource(ask.getCapability(), resourceCalculator, minimumResource, maximumResource, minimumResource));
    }

    public static Resource getNormalizedResource(Resource ask, ResourceCalculator resourceCalculator, Resource minimumResource, Resource maximumResource, Resource incrementResource) {
        Resource normalized = Resources.normalize((ResourceCalculator)resourceCalculator, (Resource)ask, (Resource)minimumResource, (Resource)maximumResource, (Resource)incrementResource);
        return normalized;
    }

    private static void normalizeNodeLabelExpressionInRequest(ResourceRequest resReq, QueueInfo queueInfo) {
        String labelExp = resReq.getNodeLabelExpression();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Requested Node Label Expression : " + labelExp));
            LOG.debug((Object)("Queue Info : " + queueInfo));
        }
        if (labelExp == null && queueInfo != null && "*".equals(resReq.getResourceName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting default node label expression : " + queueInfo.getDefaultNodeLabelExpression()));
            }
            labelExp = queueInfo.getDefaultNodeLabelExpression();
        }
        if (labelExp == null && queueInfo != null) {
            labelExp = "";
        }
        if (labelExp != null) {
            resReq.setNodeLabelExpression(labelExp);
        }
    }

    public static void normalizeAndValidateRequest(ResourceRequest resReq, Resource maximumResource, String queueName, YarnScheduler scheduler, boolean isRecovery, RMContext rmContext) throws InvalidResourceRequestException {
        SchedulerUtils.normalizeAndValidateRequest(resReq, maximumResource, queueName, scheduler, isRecovery, rmContext, null);
    }

    public static void normalizeAndValidateRequest(ResourceRequest resReq, Resource maximumResource, String queueName, YarnScheduler scheduler, boolean isRecovery, RMContext rmContext, QueueInfo queueInfo) throws InvalidResourceRequestException {
        String labelExp;
        Configuration conf = rmContext.getYarnConfiguration();
        if (null != conf && !YarnConfiguration.areNodeLabelsEnabled((Configuration)conf) && !"".equals(labelExp = resReq.getNodeLabelExpression()) && null != labelExp) {
            String message = "NodeLabel is not enabled in cluster, but resource request contains a label expression.";
            LOG.warn((Object)message);
            if (!isRecovery) {
                throw new InvalidLabelResourceRequestException("Invalid resource request, node label not enabled but request contains label expression");
            }
        }
        if (null == queueInfo) {
            try {
                queueInfo = scheduler.getQueueInfo(queueName, false, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SchedulerUtils.normalizeNodeLabelExpressionInRequest(resReq, queueInfo);
        if (!isRecovery) {
            SchedulerUtils.validateResourceRequest(resReq, maximumResource, queueInfo, rmContext);
        }
    }

    public static void normalizeAndvalidateRequest(ResourceRequest resReq, Resource maximumResource, String queueName, YarnScheduler scheduler, RMContext rmContext) throws InvalidResourceRequestException {
        SchedulerUtils.normalizeAndvalidateRequest(resReq, maximumResource, queueName, scheduler, rmContext, null);
    }

    public static void normalizeAndvalidateRequest(ResourceRequest resReq, Resource maximumResource, String queueName, YarnScheduler scheduler, RMContext rmContext, QueueInfo queueInfo) throws InvalidResourceRequestException {
        SchedulerUtils.normalizeAndValidateRequest(resReq, maximumResource, queueName, scheduler, false, rmContext, queueInfo);
    }

    private static void validateResourceRequest(ResourceRequest resReq, Resource maximumResource, QueueInfo queueInfo, RMContext rmContext) throws InvalidResourceRequestException {
        Resource requestedResource = resReq.getCapability();
        SchedulerUtils.checkResourceRequestAgainstAvailableResource(requestedResource, maximumResource);
        String labelExp = resReq.getNodeLabelExpression();
        if (!"*".equals(resReq.getResourceName()) && labelExp != null && !labelExp.trim().isEmpty()) {
            throw new InvalidLabelResourceRequestException("Invalid resource request, queue=" + queueInfo.getQueueName() + " specified node label expression in a " + "resource request has resource name = " + resReq.getResourceName());
        }
        if (labelExp != null && labelExp.contains("&&")) {
            throw new InvalidLabelResourceRequestException("Invalid resource request, queue=" + queueInfo.getQueueName() + " specified more than one node label " + "in a node label expression, node label expression = " + labelExp);
        }
        if (labelExp != null && !labelExp.trim().isEmpty() && queueInfo != null) {
            if (!SchedulerUtils.checkQueueLabelExpression(queueInfo.getAccessibleNodeLabels(), labelExp, rmContext)) {
                throw new InvalidLabelResourceRequestException("Invalid resource request, queue=" + queueInfo.getQueueName() + " doesn't have permission to access all labels " + "in resource request. labelExpression of resource request=" + labelExp + ". Queue labels=" + (queueInfo.getAccessibleNodeLabels() == null ? "" : StringUtils.join(queueInfo.getAccessibleNodeLabels().iterator(), (char)',')));
            }
            SchedulerUtils.checkQueueLabelInLabelManager(labelExp, rmContext);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static void checkResourceRequestAgainstAvailableResource(Resource reqResource, Resource availableResource) throws InvalidResourceRequestException {
        for (int i = 0; i < ResourceUtils.getNumberOfKnownResourceTypes(); ++i) {
            ResourceInformation requestedRI = reqResource.getResourceInformation(i);
            String reqResourceName = requestedRI.getName();
            if (requestedRI.getValue() < 0L) {
                SchedulerUtils.throwInvalidResourceException(reqResource, availableResource, reqResourceName);
            }
            ResourceInformation availableRI = availableResource.getResourceInformation(reqResourceName);
            long requestedResourceValue = requestedRI.getValue();
            long availableResourceValue = availableRI.getValue();
            int unitsRelation = UnitsConversionUtil.compareUnits((String)requestedRI.getUnits(), (String)availableRI.getUnits());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Requested resource information: " + requestedRI));
                LOG.debug((Object)("Available resource information: " + availableRI));
                LOG.debug((Object)("Relation of units: " + unitsRelation));
            }
            if (unitsRelation < 0) {
                availableResourceValue = UnitsConversionUtil.convert((String)availableRI.getUnits(), (String)requestedRI.getUnits(), (long)availableRI.getValue());
            } else if (unitsRelation > 0) {
                requestedResourceValue = UnitsConversionUtil.convert((String)requestedRI.getUnits(), (String)availableRI.getUnits(), (long)requestedRI.getValue());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Requested resource value after conversion: " + requestedResourceValue));
                LOG.info((Object)("Available resource value after conversion: " + availableResourceValue));
            }
            if (requestedResourceValue <= availableResourceValue) continue;
            SchedulerUtils.throwInvalidResourceException(reqResource, availableResource, reqResourceName);
        }
    }

    private static void throwInvalidResourceException(Resource reqResource, Resource availableResource, String reqResourceName) throws InvalidResourceRequestException {
        throw new InvalidResourceRequestException("Invalid resource request, requested resource type=[" + reqResourceName + "] < 0 or greater than maximum allowed allocation. Requested " + "resource=" + reqResource + ", maximum allowed allocation=" + availableResource + ", please note that maximum allowed allocation is calculated " + "by scheduler based on maximum resource of registered " + "NodeManagers, which might be less than configured " + "maximum allocation=" + ResourceUtils.getResourceTypesMaximumAllocation());
    }

    private static void checkQueueLabelInLabelManager(String labelExpression, RMContext rmContext) throws InvalidLabelResourceRequestException {
        RMNodeLabelsManager nlm;
        if (null != rmContext && (nlm = rmContext.getNodeLabelManager()) != null && !nlm.containsNodeLabel(labelExpression)) {
            throw new InvalidLabelResourceRequestException("Invalid label resource request, cluster do not contain , label= " + labelExpression);
        }
    }

    public static boolean checkQueueLabelExpression(Set<String> queueLabels, String labelExpression, RMContext rmContext) {
        if (labelExpression == null) {
            return true;
        }
        for (String str : labelExpression.split("&&")) {
            if ((str = str.trim()).trim().isEmpty()) continue;
            if (queueLabels == null) {
                return false;
            }
            if (queueLabels.contains(str) || queueLabels.contains("*")) continue;
            return false;
        }
        return true;
    }

    public static AccessType toAccessType(QueueACL acl) {
        switch (acl) {
            case ADMINISTER_QUEUE: {
                return AccessType.ADMINISTER_QUEUE;
            }
            case SUBMIT_APPLICATIONS: {
                return AccessType.SUBMIT_APP;
            }
        }
        return null;
    }

    private static boolean hasPendingResourceRequest(ResourceCalculator rc, ResourceUsage usage, String partitionToLookAt, Resource cluster) {
        return Resources.greaterThan((ResourceCalculator)rc, (Resource)cluster, (Resource)usage.getPending(partitionToLookAt), (Resource)Resources.none());
    }

    @InterfaceAudience.Private
    public static boolean hasPendingResourceRequest(ResourceCalculator rc, ResourceUsage usage, String nodePartition, Resource cluster, SchedulingMode schedulingMode) {
        String partitionToLookAt = nodePartition;
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY) {
            partitionToLookAt = "";
        }
        return SchedulerUtils.hasPendingResourceRequest(rc, usage, partitionToLookAt, cluster);
    }

    public static RMContainer createOpportunisticRmContainer(RMContext rmContext, Container container, boolean isRemotelyAllocated) {
        SchedulerNode node = ((AbstractYarnScheduler)rmContext.getScheduler()).getNode(container.getNodeId());
        if (node == null) {
            return null;
        }
        Object appAttempt = ((AbstractYarnScheduler)rmContext.getScheduler()).getCurrentAttemptForContainer(container.getId());
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom(container), ((SchedulerApplicationAttempt)appAttempt).getApplicationAttemptId(), container.getNodeId(), ((SchedulerApplicationAttempt)appAttempt).getUser(), rmContext, isRemotelyAllocated);
        ((SchedulerApplicationAttempt)appAttempt).addRMContainer(container.getId(), rmContainer);
        node.allocateContainer(rmContainer);
        return rmContainer;
    }
}

