/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor;

import java.io.IOException;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor.AbstractPlacementProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisabledPlacementProcessor
extends AbstractPlacementProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DisabledPlacementProcessor.class);

    @Override
    public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
        if (request.getPlacementConstraints() != null && !request.getPlacementConstraints().isEmpty()) {
            String message = "Found non empty placement constraints map in RegisterApplicationMasterRequest for application=" + applicationAttemptId.toString() + ", but the configured " + "yarn.resourcemanager.placement-constraints.handler" + " cannot handle placement constraints. Rejecting this " + "registerApplicationMaster operation";
            LOG.warn(message);
            throw new YarnException(message);
        }
        this.nextAMSProcessor.registerApplicationMaster(applicationAttemptId, request, response);
    }

    public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
        if (request.getSchedulingRequests() != null && !request.getSchedulingRequests().isEmpty()) {
            String message = "Found non empty SchedulingRequest in AllocateRequest for application=" + appAttemptId.toString() + ", but the configured " + "yarn.resourcemanager.placement-constraints.handler" + " cannot handle placement constraints. Rejecting this " + "allocate operation";
            LOG.warn(message);
            throw new YarnException(message);
        }
        this.nextAMSProcessor.allocate(appAttemptId, request, response);
    }
}

