/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.Arrays;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.UserMetricsInfo;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class MetricsOverviewTable
extends HtmlBlock {
    private static final long BYTES_IN_MB = 0x100000L;
    private final ResourceManager rm;

    @Inject
    MetricsOverviewTable(ResourceManager rm, View.ViewContext ctx) {
        super(ctx);
        this.rm = rm;
    }

    protected void render(HtmlBlock.Block html) {
        UserMetricsInfo userMetrics;
        html.style(new Object[]{".metrics {margin-bottom:5px}"});
        ClusterMetricsInfo clusterMetrics = new ClusterMetricsInfo(this.rm);
        Hamlet.DIV div = html.div().$class("metrics");
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3("Cluster Metrics").table("#metricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Apps Submitted"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Pending"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Running"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Completed"}).__()).th().$class("ui-state-default").__(new Object[]{"Containers Running"}).__()).th().$class("ui-state-default").__(new Object[]{"Memory Used"}).__()).th().$class("ui-state-default").__(new Object[]{"Memory Total"}).__()).th().$class("ui-state-default").__(new Object[]{"Memory Reserved"}).__()).th().$class("ui-state-default").__(new Object[]{"VCores Used"}).__()).th().$class("ui-state-default").__(new Object[]{"VCores Total"}).__()).th().$class("ui-state-default").__(new Object[]{"VCores Reserved"}).__()).__()).__()).tbody().$class("ui-widget-content").tr().td(String.valueOf(clusterMetrics.getAppsSubmitted())).td(String.valueOf(clusterMetrics.getAppsPending())).td(String.valueOf(clusterMetrics.getAppsRunning())).td(String.valueOf(clusterMetrics.getAppsCompleted() + clusterMetrics.getAppsFailed() + clusterMetrics.getAppsKilled())).td(String.valueOf(clusterMetrics.getContainersAllocated())).td(StringUtils.byteDesc((long)(clusterMetrics.getAllocatedMB() * 0x100000L))).td(StringUtils.byteDesc((long)(clusterMetrics.getTotalMB() * 0x100000L))).td(StringUtils.byteDesc((long)(clusterMetrics.getReservedMB() * 0x100000L))).td(String.valueOf(clusterMetrics.getAllocatedVirtualCores())).td(String.valueOf(clusterMetrics.getTotalVirtualCores())).td(String.valueOf(clusterMetrics.getReservedVirtualCores())).__()).__()).__();
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3("Cluster Nodes Metrics").table("#nodemetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Active Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Decommissioning Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Decommissioned Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Lost Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Unhealthy Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Rebooted Nodes"}).__()).th().$class("ui-state-default").__(new Object[]{"Shutdown Nodes"}).__()).__()).__()).tbody().$class("ui-widget-content").tr().td().a(this.url(new String[]{"nodes"}), String.valueOf(clusterMetrics.getActiveNodes())).__()).td().a(this.url(new String[]{"nodes/decommissioning"}), String.valueOf(clusterMetrics.getDecommissioningNodes())).__()).td().a(this.url(new String[]{"nodes/decommissioned"}), String.valueOf(clusterMetrics.getDecommissionedNodes())).__()).td().a(this.url(new String[]{"nodes/lost"}), String.valueOf(clusterMetrics.getLostNodes())).__()).td().a(this.url(new String[]{"nodes/unhealthy"}), String.valueOf(clusterMetrics.getUnhealthyNodes())).__()).td().a(this.url(new String[]{"nodes/rebooted"}), String.valueOf(clusterMetrics.getRebootedNodes())).__()).td().a(this.url(new String[]{"nodes/shutdown"}), String.valueOf(clusterMetrics.getShutdownNodes())).__()).__()).__()).__();
        String user = this.request().getRemoteUser();
        if (user != null && (userMetrics = new UserMetricsInfo(this.rm, user)).metricsAvailable()) {
            ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3("User Metrics for " + user).table("#usermetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Apps Submitted"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Pending"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Running"}).__()).th().$class("ui-state-default").__(new Object[]{"Apps Completed"}).__()).th().$class("ui-state-default").__(new Object[]{"Containers Running"}).__()).th().$class("ui-state-default").__(new Object[]{"Containers Pending"}).__()).th().$class("ui-state-default").__(new Object[]{"Containers Reserved"}).__()).th().$class("ui-state-default").__(new Object[]{"Memory Used"}).__()).th().$class("ui-state-default").__(new Object[]{"Memory Pending"}).__()).th().$class("ui-state-default").__(new Object[]{"Memory Reserved"}).__()).th().$class("ui-state-default").__(new Object[]{"VCores Used"}).__()).th().$class("ui-state-default").__(new Object[]{"VCores Pending"}).__()).th().$class("ui-state-default").__(new Object[]{"VCores Reserved"}).__()).__()).__()).tbody().$class("ui-widget-content").tr().td(String.valueOf(userMetrics.getAppsSubmitted())).td(String.valueOf(userMetrics.getAppsPending())).td(String.valueOf(userMetrics.getAppsRunning())).td(String.valueOf(userMetrics.getAppsCompleted() + userMetrics.getAppsFailed() + userMetrics.getAppsKilled())).td(String.valueOf(userMetrics.getRunningContainers())).td(String.valueOf(userMetrics.getPendingContainers())).td(String.valueOf(userMetrics.getReservedContainers())).td(StringUtils.byteDesc((long)(userMetrics.getAllocatedMB() * 0x100000L))).td(StringUtils.byteDesc((long)(userMetrics.getPendingMB() * 0x100000L))).td(StringUtils.byteDesc((long)(userMetrics.getReservedMB() * 0x100000L))).td(String.valueOf(userMetrics.getAllocatedVirtualCores())).td(String.valueOf(userMetrics.getPendingVirtualCores())).td(String.valueOf(userMetrics.getReservedVirtualCores())).__()).__()).__();
        }
        SchedulerInfo schedulerInfo = new SchedulerInfo(this.rm);
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3("Scheduler Metrics").table("#schedulermetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default").__(new Object[]{"Scheduler Type"}).__()).th().$class("ui-state-default").__(new Object[]{"Scheduling Resource Type"}).__()).th().$class("ui-state-default").__(new Object[]{"Minimum Allocation"}).__()).th().$class("ui-state-default").__(new Object[]{"Maximum Allocation"}).__()).th().$class("ui-state-default").__(new Object[]{"Maximum Cluster Application Priority"}).__()).__()).__()).tbody().$class("ui-widget-content").tr().td(String.valueOf(schedulerInfo.getSchedulerType())).td(String.valueOf(Arrays.toString(ResourceUtils.getResourcesTypeInfo().toArray(new ResourceTypeInfo[0])))).td(schedulerInfo.getMinAllocation().toString()).td(schedulerInfo.getMaxAllocation().toString()).td(String.valueOf(schedulerInfo.getMaxClusterLevelAppPriority())).__()).__()).__();
        div.__();
    }
}

