/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.AppBlock;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class RMAppBlock
extends AppBlock {
    private final ResourceManager rm;
    private final Configuration conf;

    @Inject
    RMAppBlock(View.ViewContext ctx, Configuration conf, ResourceManager rm) {
        super(null, ctx, conf);
        this.conf = conf;
        this.rm = rm;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        super.render(html);
    }

    @Override
    protected void createApplicationMetricsTable(HtmlBlock.Block html) {
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(this.appID);
        RMAppMetrics appMetrics = rmApp == null ? null : rmApp.getRMAppMetrics();
        RMAppAttemptMetrics attemptMetrics = rmApp == null || null == rmApp.getCurrentAppAttempt() ? null : rmApp.getCurrentAppAttempt().getRMAppAttemptMetrics();
        Resource attemptResourcePreempted = attemptMetrics == null ? Resources.none() : attemptMetrics.getResourcePreempted();
        int attemptNumNonAMContainerPreempted = attemptMetrics == null ? 0 : attemptMetrics.getNumNonAMContainersPreempted();
        Hamlet.DIV pdiv = html.__(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        this.info("Application Overview").clear();
        this.info("Application Metrics").__("Total Resource Preempted:", (Object)(appMetrics == null ? "N/A" : appMetrics.getResourcePreempted())).__("Total Number of Non-AM Containers Preempted:", appMetrics == null ? "N/A" : Integer.valueOf(appMetrics.getNumNonAMContainersPreempted())).__("Total Number of AM Containers Preempted:", appMetrics == null ? "N/A" : Integer.valueOf(appMetrics.getNumAMContainersPreempted())).__("Resource Preempted from Current Attempt:", (Object)attemptResourcePreempted).__("Number of Non-AM Containers Preempted from Current Attempt:", (Object)attemptNumNonAMContainerPreempted).__("Aggregate Resource Allocation:", (Object)(appMetrics == null ? "N/A" : StringHelper.getResourceSecondsString(appMetrics.getResourceSecondsMap()))).__("Aggregate Preempted Resource Allocation:", (Object)(appMetrics == null ? "N/A" : StringHelper.getResourceSecondsString(appMetrics.getPreemptedResourceSecondsMap())));
        pdiv.__();
    }

    @Override
    protected void generateApplicationTable(HtmlBlock.Block html, UserGroupInformation callerUGI, Collection<ApplicationAttemptReport> attempts) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#attempts").thead().tr().th(".id", "Attempt ID").th(".started", "Started").th(".node", "Node").th(".logs", "Logs").th(".appBlacklistednodes", "Nodes blacklisted by the application", "Nodes blacklisted by the app").th(".rmBlacklistednodes", "Nodes blacklisted by the RM for the app", "Nodes blacklisted by the system").__()).__()).tbody();
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(this.appID);
        if (rmApp == null) {
            return;
        }
        StringBuilder attemptsTableData = new StringBuilder("[\n");
        for (ApplicationAttemptReport appAttemptReport : attempts) {
            RMAppAttempt rmAppAttempt = rmApp.getRMAppAttempt(appAttemptReport.getApplicationAttemptId());
            if (rmAppAttempt == null) continue;
            AppAttemptInfo attemptInfo = new AppAttemptInfo(this.rm, rmAppAttempt, rmApp.getUser(), WebAppUtils.getHttpSchemePrefix((Configuration)this.conf));
            Set<String> nodes = rmAppAttempt.getBlacklistedNodes();
            String appBlacklistedNodesCount = String.valueOf(nodes.size());
            String rmBlacklistedNodesCount = String.valueOf(rmAppAttempt.getAMBlacklistManager().getBlacklistUpdates().getBlacklistAdditions().size());
            String nodeLink = attemptInfo.getNodeHttpAddress();
            if (nodeLink != null) {
                nodeLink = WebAppUtils.getHttpSchemePrefix((Configuration)this.conf) + nodeLink;
            }
            String logsLink = attemptInfo.getLogsLink();
            attemptsTableData.append("[\"<a href='").append(this.url(new String[]{"appattempt", rmAppAttempt.getAppAttemptId().toString()})).append("'>").append(String.valueOf(rmAppAttempt.getAppAttemptId())).append("</a>\",\"").append(attemptInfo.getStartTime()).append("\",\"<a ").append(nodeLink == null ? "#" : "href='" + nodeLink).append("'>").append(nodeLink == null ? "N/A" : StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)nodeLink))).append("</a>\",\"<a ").append(logsLink == null ? "#" : "href='" + logsLink).append("'>").append(logsLink == null ? "N/A" : "Logs").append("</a>\",").append("\"").append(appBlacklistedNodesCount).append("\",").append("\"").append(rmBlacklistedNodesCount).append("\"],\n");
        }
        if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
            attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
        }
        attemptsTableData.append("]");
        html.script().$type("text/javascript").__(new Object[]{"var attemptsTableData=" + attemptsTableData}).__();
        ((Hamlet.TABLE)tbody.__()).__();
    }

    @Override
    protected LogAggregationStatus getLogAggregationStatus() {
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(this.appID);
        if (rmApp == null) {
            return null;
        }
        return rmApp.getLogAggregationStatusForAppReport();
    }

    @Override
    protected ContainerReport getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getContainerReport(request).getContainerReport();
    }

    @Override
    protected List<ApplicationAttemptReport> getApplicationAttemptsReport(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getApplicationAttempts(request).getApplicationAttemptList();
    }

    @Override
    protected ApplicationReport getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getApplicationReport(request).getApplicationReport();
    }
}

