/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.hdfs.tools.JMXGet;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCodeConstants;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Charsets;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.base.Strings;
import org.apache.hadoop.shaded.com.google.common.base.Supplier;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.shaded.org.apache.commons.io.FileUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Assume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DFSTestUtil.class);
    private static final Random gen = new Random();
    private static final String[] dirNames = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private final int maxLevels;
    private final int maxSize;
    private final int minSize;
    private final int nFiles;
    private MyFile[] files;

    private DFSTestUtil(int nFiles, int maxLevels, int maxSize, int minSize) {
        this.nFiles = nFiles;
        this.maxLevels = maxLevels;
        this.maxSize = maxSize;
        this.minSize = minSize;
    }

    public DFSTestUtil(String testName, int nFiles, int maxLevels, int maxSize, int minSize) {
        this.nFiles = nFiles;
        this.maxLevels = maxLevels;
        this.maxSize = maxSize;
        this.minSize = minSize;
    }

    public static void formatNameNode(Configuration conf) throws IOException {
        String clusterId = HdfsServerConstants.StartupOption.FORMAT.getClusterId();
        if (clusterId == null || clusterId.isEmpty()) {
            HdfsServerConstants.StartupOption.FORMAT.setClusterId("testClusterID");
        }
        NameNode.format(new Configuration(conf));
    }

    public static Configuration newHAConfiguration(String logicalName) {
        Configuration conf = new Configuration();
        DFSTestUtil.addHAConfiguration(conf, logicalName);
        return conf;
    }

    public static void addHAConfiguration(Configuration conf, String logicalName) {
        String nsIds = conf.get("dfs.nameservices");
        if (nsIds == null) {
            conf.set("dfs.nameservices", logicalName);
        } else {
            conf.set("dfs.nameservices", nsIds + "," + logicalName);
        }
        conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", logicalName), "nn1,nn2");
        conf.set("dfs.client.failover.proxy.provider." + logicalName, ConfiguredFailoverProxyProvider.class.getName());
        conf.setInt("dfs.replication", 1);
    }

    public static void setFakeHttpAddresses(Configuration conf, String logicalName) {
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.http-address", logicalName, "nn1"), "127.0.0.1:12345");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.http-address", logicalName, "nn2"), "127.0.0.1:12346");
    }

    public static void setEditLogForTesting(FSNamesystem fsn, FSEditLog newLog) {
        newLog.restart();
        Whitebox.setInternalState(fsn.getFSImage(), "editLog", newLog);
        Whitebox.setInternalState(fsn.getFSDirectory(), "editLog", newLog);
    }

    public static void enableAllECPolicies(DistributedFileSystem fs) throws IOException {
        for (ErasureCodingPolicy ecPolicy : SystemErasureCodingPolicies.getPolicies()) {
            fs.enableErasureCodingPolicy(ecPolicy.getName());
        }
    }

    public static ErasureCodingPolicyState getECPolicyState(ErasureCodingPolicy policy) {
        Object[] policyInfos;
        for (ErasureCodingPolicyInfo erasureCodingPolicyInfo : policyInfos = ErasureCodingPolicyManager.getInstance().getPolicies()) {
            if (!erasureCodingPolicyInfo.getPolicy().equals((Object)policy)) continue;
            return erasureCodingPolicyInfo.getState();
        }
        throw new IllegalArgumentException("ErasureCodingPolicy <" + policy + "> doesn't exist in the policies:" + Arrays.toString(policyInfos));
    }

    public void createFiles(FileSystem fs, String topdir) throws IOException {
        this.createFiles(fs, topdir, (short)3);
    }

    public static byte[] readFileAsBytes(FileSystem fs, Path fileName) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            IOUtils.copyBytes((InputStream)fs.open(fileName), (OutputStream)os, (int)1024);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public void createFiles(FileSystem fs, String topdir, short replicationFactor) throws IOException {
        this.files = new MyFile[this.nFiles];
        for (int idx = 0; idx < this.nFiles; ++idx) {
            this.files[idx] = new MyFile();
        }
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            DFSTestUtil.createFile(fs, new Path(root, this.files[idx].getName()), this.files[idx].getSize(), replicationFactor, this.files[idx].getSeed());
        }
    }

    public static String readFile(FileSystem fs, Path fileName) throws IOException {
        byte[] buf = DFSTestUtil.readFileBuffer(fs, fileName);
        return new String(buf, 0, buf.length);
    }

    /*
     * Exception decompiling
     */
    public static byte[] readFileBuffer(FileSystem fs, Path fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void createFile(FileSystem fs, Path fileName, long fileLen, short replFactor, long seed) throws IOException {
        DFSTestUtil.createFile(fs, fileName, 1024, fileLen, fs.getDefaultBlockSize(fileName), replFactor, seed);
    }

    public static void createFile(FileSystem fs, Path fileName, int bufferLen, long fileLen, long blockSize, short replFactor, long seed) throws IOException {
        DFSTestUtil.createFile(fs, fileName, false, bufferLen, fileLen, blockSize, replFactor, seed, false);
    }

    public static void createFile(FileSystem fs, Path fileName, boolean isLazyPersist, int bufferLen, long fileLen, long blockSize, short replFactor, long seed, boolean flush) throws IOException {
        DFSTestUtil.createFile(fs, fileName, isLazyPersist, bufferLen, fileLen, blockSize, replFactor, seed, flush, null);
    }

    public static void createFile(FileSystem fs, Path fileName, boolean isLazyPersist, int bufferLen, long fileLen, long blockSize, short replFactor, long seed, boolean flush, InetSocketAddress[] favoredNodes) throws IOException {
        assert (bufferLen > 0);
        if (!fs.mkdirs(fileName.getParent())) {
            throw new IOException("Mkdirs failed to create " + fileName.getParent().toString());
        }
        EnumSet<CreateFlag> createFlags = EnumSet.of(CreateFlag.CREATE);
        createFlags.add(CreateFlag.OVERWRITE);
        if (isLazyPersist) {
            createFlags.add(CreateFlag.LAZY_PERSIST);
        }
        try (HdfsDataOutputStream out = favoredNodes == null ? fs.create(fileName, FsPermission.getFileDefault(), createFlags, fs.getConf().getInt("io.file.buffer.size", 4096), replFactor, blockSize, null) : ((DistributedFileSystem)fs).create(fileName, FsPermission.getDefault(), true, bufferLen, replFactor, blockSize, null, favoredNodes);){
            if (fileLen > 0L) {
                int bytesToWriteNext;
                byte[] toWrite = new byte[bufferLen];
                Random rb = new Random(seed);
                for (long bytesToWrite = fileLen; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                    rb.nextBytes(toWrite);
                    bytesToWriteNext = (long)bufferLen < bytesToWrite ? bufferLen : (int)bytesToWrite;
                    out.write(toWrite, 0, bytesToWriteNext);
                }
                if (flush) {
                    out.hsync();
                }
            }
        }
    }

    public static byte[] calculateFileContentsFromSeed(long seed, int length) {
        Random rb = new Random(seed);
        byte[] val = new byte[length];
        rb.nextBytes(val);
        return val;
    }

    public boolean checkFiles(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            Path fPath = new Path(root, this.files[idx].getName());
            try (FSDataInputStream in = fs.open(fPath);){
                byte[] toRead = new byte[this.files[idx].getSize()];
                byte[] toCompare = new byte[this.files[idx].getSize()];
                Random rb = new Random(this.files[idx].getSeed());
                rb.nextBytes(toCompare);
                in.readFully(0L, toRead);
                for (int i = 0; i < toRead.length; ++i) {
                    if (toRead[i] == toCompare[i]) continue;
                    boolean bl = false;
                    return bl;
                }
                continue;
            }
        }
        return true;
    }

    void setReplication(FileSystem fs, String topdir, short value) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            Path fPath = new Path(root, this.files[idx].getName());
            fs.setReplication(fPath, value);
        }
    }

    public void waitReplication(FileSystem fs, String topdir, short value) throws IOException, InterruptedException, TimeoutException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            DFSTestUtil.waitReplication(fs, new Path(root, this.files[idx].getName()), value);
        }
    }

    public static boolean allBlockReplicasCorrupt(MiniDFSCluster cluster, Path file, int blockNo) throws IOException {
        try (DFSClient client = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), cluster.getConfiguration(0));){
            LocatedBlocks blocks = client.getNamenode().getBlockLocations(file.toString(), 0L, Long.MAX_VALUE);
            boolean bl = blocks.get(blockNo).isCorrupt();
            return bl;
        }
    }

    public static void waitForReplication(MiniDFSCluster cluster, ExtendedBlock b, int racks, int replicas, int neededReplicas) throws TimeoutException, InterruptedException {
        int curRacks = 0;
        int curReplicas = 0;
        int curNeededReplicas = 0;
        int count = 0;
        int ATTEMPTS = 20;
        do {
            Thread.sleep(1000L);
            int[] r = BlockManagerTestUtil.getReplicaInfo(cluster.getNamesystem(), b.getLocalBlock());
            curRacks = r[0];
            curReplicas = r[1];
            curNeededReplicas = r[2];
        } while ((curRacks != racks || curReplicas != replicas || curNeededReplicas != neededReplicas) && ++count < 20);
        if (count == 20) {
            throw new TimeoutException("Timed out waiting for replication. Needed replicas = " + neededReplicas + " Cur needed replicas = " + curNeededReplicas + " Replicas = " + replicas + " Cur replicas = " + curReplicas + " Racks = " + racks + " Cur racks = " + curRacks);
        }
    }

    public static void waitForReplication(final DistributedFileSystem dfs, final Path file, final short replication, int waitForMillis) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    BlockLocation[] locs;
                    FileStatus stat = dfs.getFileStatus(file);
                    for (BlockLocation loc : locs = dfs.getFileBlockLocations(stat, 0L, stat.getLen())) {
                        if (replication == loc.getHosts().length) continue;
                        return false;
                    }
                    return true;
                }
                catch (IOException e) {
                    LOG.info("getFileStatus on path " + file + " failed!", (Throwable)e);
                    return false;
                }
            }
        }, 100, waitForMillis);
    }

    public static void waitCorruptReplicas(FileSystem fs, FSNamesystem ns, Path file, ExtendedBlock b, int corruptRepls) throws TimeoutException, InterruptedException {
        int count = 0;
        int ATTEMPTS = 50;
        int repls = ns.getBlockManager().numCorruptReplicas(b.getLocalBlock());
        block2: while (repls != corruptRepls && count < 50) {
            try {
                IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (int)512, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Waiting for " + corruptRepls + " corrupt replicas");
            ++count;
            for (int i = 0; i < 10; ++i) {
                repls = ns.getBlockManager().numCorruptReplicas(b.getLocalBlock());
                Thread.sleep(100L);
                if (repls == corruptRepls) continue block2;
            }
        }
        if (count == 50) {
            throw new TimeoutException("Timed out waiting for corrupt replicas. Waiting for " + corruptRepls + ", but only found " + repls);
        }
    }

    public static void waitForDecommission(FileSystem fs, String name) throws IOException, InterruptedException, TimeoutException {
        DatanodeInfo dn = null;
        int count = 0;
        int ATTEMPTS = 20;
        do {
            Thread.sleep(1000L);
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            for (DatanodeInfo info : dfs.getDataNodeStats()) {
                if (!name.equals(info.getXferAddr())) continue;
                dn = info;
            }
        } while ((dn == null || dn.isDecommissionInProgress() || !dn.isDecommissioned()) && ++count < 20);
        if (count == 20) {
            throw new TimeoutException("Timed out waiting for datanode " + name + " to decommission.");
        }
    }

    public static int firstDnWithBlock(MiniDFSCluster cluster, ExtendedBlock b) throws IOException {
        int numDatanodes = cluster.getDataNodes().size();
        for (int i = 0; i < numDatanodes; ++i) {
            String blockContent = cluster.readBlockOnDataNode(i, b);
            if (blockContent == null) continue;
            return i;
        }
        return -1;
    }

    public static long getLiveDatanodeCapacity(DatanodeManager dm) {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        dm.fetchDatanodes(live, null, false);
        long capacity = 0L;
        for (DatanodeDescriptor dn : live) {
            capacity += dn.getCapacity();
        }
        return capacity;
    }

    public static long getDatanodeCapacity(DatanodeManager dm, int index) {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        dm.fetchDatanodes(live, null, false);
        return ((DatanodeDescriptor)((Object)live.get(index))).getCapacity();
    }

    public static void waitForDatanodeStatus(DatanodeManager dm, int expectedLive, int expectedDead, long expectedVolFails, long expectedTotalCapacity, long timeout) throws InterruptedException, TimeoutException {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        int ATTEMPTS = 10;
        int count = 0;
        long currTotalCapacity = 0L;
        int volFails = 0;
        do {
            Thread.sleep(timeout);
            live.clear();
            dead.clear();
            dm.fetchDatanodes(live, dead, false);
            currTotalCapacity = 0L;
            volFails = 0;
            for (DatanodeDescriptor dd : live) {
                currTotalCapacity += dd.getCapacity();
                volFails += dd.getVolumeFailures();
            }
        } while ((expectedLive != live.size() || expectedDead != dead.size() || expectedTotalCapacity != currTotalCapacity || expectedVolFails != (long)volFails) && ++count < 10);
        if (count == 10) {
            throw new TimeoutException("Timed out waiting for capacity. Live = " + live.size() + " Expected = " + expectedLive + " Dead = " + dead.size() + " Expected = " + expectedDead + " Total capacity = " + currTotalCapacity + " Expected = " + expectedTotalCapacity + " Vol Fails = " + volFails + " Expected = " + expectedVolFails);
        }
    }

    public static void waitForDatanodeDeath(DataNode dn) throws InterruptedException, TimeoutException {
        int ATTEMPTS = 10;
        int count = 0;
        do {
            Thread.sleep(1000L);
        } while (dn.isDatanodeUp() && ++count < 10);
        if (count == 10) {
            throw new TimeoutException("Timed out waiting for DN to die");
        }
    }

    public String[] getFileNames(String topDir) {
        if (this.nFiles == 0) {
            return new String[0];
        }
        String[] fileNames = new String[this.nFiles];
        for (int idx = 0; idx < this.nFiles; ++idx) {
            fileNames[idx] = topDir + "/" + this.files[idx].getName();
        }
        return fileNames;
    }

    public static void waitReplication(FileSystem fs, Path fileName, short replFactor) throws IOException, InterruptedException, TimeoutException {
        boolean correctReplFactor;
        int ATTEMPTS = 40;
        int count = 0;
        do {
            correctReplFactor = true;
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(fileName), 0L, Long.MAX_VALUE);
            ++count;
            for (int j = 0; j < locs.length; ++j) {
                Object[] hostnames = locs[j].getNames();
                if (hostnames.length == replFactor) continue;
                correctReplFactor = false;
                System.out.println("Block " + j + " of file " + fileName + " has replication factor " + hostnames.length + " (desired " + replFactor + "); locations " + Joiner.on((char)' ').join(hostnames));
                Thread.sleep(1000L);
                break;
            }
            if (!correctReplFactor) continue;
            System.out.println("All blocks of file " + fileName + " verified to have replication factor " + replFactor);
        } while (!correctReplFactor && count < 40);
        if (count == 40) {
            throw new TimeoutException("Timed out waiting for " + fileName + " to reach " + replFactor + " replicas");
        }
    }

    public void cleanup(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        fs.delete(root, true);
        this.files = null;
    }

    public static ExtendedBlock getFirstBlock(FileSystem fs, Path path) throws IOException {
        try (HdfsDataInputStream in = (HdfsDataInputStream)fs.open(path);){
            in.readByte();
            ExtendedBlock extendedBlock = in.getCurrentBlock();
            return extendedBlock;
        }
    }

    public static List<LocatedBlock> getAllBlocks(FSDataInputStream in) throws IOException {
        return ((HdfsDataInputStream)in).getAllBlocks();
    }

    public static List<LocatedBlock> getAllBlocks(FileSystem fs, Path path) throws IOException {
        try (HdfsDataInputStream in = (HdfsDataInputStream)fs.open(path);){
            List list = in.getAllBlocks();
            return list;
        }
    }

    public static Token<BlockTokenIdentifier> getBlockToken(FSDataOutputStream out) {
        return ((DFSOutputStream)out.getWrappedStream()).getBlockToken();
    }

    public static String readFile(File f) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            int c;
            StringBuilder b = new StringBuilder();
            while ((c = in.read()) != -1) {
                b.append((char)c);
            }
            String string = b.toString();
            return string;
        }
    }

    public static byte[] readFileAsBytes(File f) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            IOUtils.copyBytes((InputStream)new FileInputStream(f), (OutputStream)os, (int)1024);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public static void writeFile(FileSystem fs, Path p, byte[] bytes) throws IOException {
        if (fs.exists(p)) {
            fs.delete(p, true);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);
             FSDataOutputStream os = fs.create(p);){
            IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)bytes.length);
        }
    }

    public static void writeFile(FileSystem fs, Path p, byte[] bytes, long blockSize) throws IOException {
        if (fs.exists(p)) {
            fs.delete(p, true);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);
             FSDataOutputStream os = fs.create(p, false, 4096, fs.getDefaultReplication(p), blockSize);){
            IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)bytes.length);
        }
    }

    public static void writeFile(FileSystem fs, Path p, String s) throws IOException {
        DFSTestUtil.writeFile(fs, p, s.getBytes());
    }

    public static void appendFile(FileSystem fs, Path p, String s) throws IOException {
        assert (fs.exists(p));
        try (ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
             FSDataOutputStream os = fs.append(p);){
            IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)s.length());
        }
    }

    public static void appendFile(FileSystem fs, Path p, int length) throws IOException {
        assert (fs.exists(p));
        assert (length >= 0);
        byte[] toAppend = new byte[length];
        Random random = new Random();
        random.nextBytes(toAppend);
        try (FSDataOutputStream out = fs.append(p);){
            out.write(toAppend);
        }
    }

    public static void appendFileNewBlock(DistributedFileSystem fs, Path p, int length) throws IOException {
        assert (length >= 0);
        byte[] toAppend = new byte[length];
        Random random = new Random();
        random.nextBytes(toAppend);
        DFSTestUtil.appendFileNewBlock(fs, p, toAppend);
    }

    public static void appendFileNewBlock(DistributedFileSystem fs, Path p, byte[] bytes) throws IOException {
        assert (fs.exists(p));
        try (FSDataOutputStream out = fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.NEW_BLOCK), 4096, null);){
            out.write(bytes);
        }
    }

    public static String urlGet(URL url) throws IOException {
        return new String(DFSTestUtil.urlGetBytes(url), Charsets.UTF_8);
    }

    public static byte[] urlGetBytes(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        HttpURLConnection hc = (HttpURLConnection)conn;
        Assert.assertEquals((long)200L, (long)hc.getResponseCode());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        return out.toByteArray();
    }

    public static void updateConfWithFakeGroupMapping(Configuration conf, Map<String, String[]> map) {
        if (map != null) {
            MockUnixGroupsMapping.fakeUser2GroupsMap = map;
        }
        conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, ShellBasedUnixGroupsMapping.class);
    }

    public static FileSystem getFileSystemAs(UserGroupInformation ugi, final Configuration conf) throws IOException {
        try {
            return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((Configuration)conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    public static byte[] generateSequentialBytes(int start, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)((start + i) % 127);
        }
        return result;
    }

    public static FileSystem.Statistics getStatistics(FileSystem fs) {
        return FileSystem.getStatistics((String)fs.getUri().getScheme(), fs.getClass());
    }

    public static byte[] loadFile(String filename) throws IOException {
        File file = new File(filename);
        try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
            byte[] content = new byte[(int)file.length()];
            in.readFully(content);
            byte[] byArray = content;
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public static DataTransferProtos.BlockOpResponseProto transferRbw(ExtendedBlock b, DFSClient dfsClient, DatanodeInfo ... datanodes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setFederatedConfiguration(MiniDFSCluster cluster, Configuration conf) {
        HashSet<String> nameservices = new HashSet<String>();
        for (MiniDFSCluster.NameNodeInfo info : cluster.getNameNodeInfos()) {
            assert (info.nameserviceId != null);
            nameservices.add(info.nameserviceId);
            conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", info.nameserviceId), DFSUtil.createUri("hdfs", info.nameNode.getNameNodeAddress()).toString());
            conf.set(DFSUtil.addKeySuffixes("dfs.namenode.servicerpc-address", info.nameserviceId), DFSUtil.createUri("hdfs", info.nameNode.getNameNodeAddress()).toString());
        }
        conf.set("dfs.nameservices", Joiner.on((String)",").join(nameservices));
    }

    public static void setFederatedHAConfiguration(MiniDFSCluster cluster, Configuration conf) {
        HashMap nameservices = Maps.newHashMap();
        for (MiniDFSCluster.NameNodeInfo info : cluster.getNameNodeInfos()) {
            Preconditions.checkState((info.nameserviceId != null ? 1 : 0) != 0);
            List nns = (List)nameservices.get(info.nameserviceId);
            if (nns == null) {
                nns = Lists.newArrayList();
                nameservices.put(info.nameserviceId, nns);
            }
            nns.add(info.nnId);
            conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", info.nameserviceId, info.nnId), DFSUtil.createUri("hdfs", info.nameNode.getNameNodeAddress()).toString());
            conf.set(DFSUtil.addKeySuffixes("dfs.namenode.servicerpc-address", info.nameserviceId, info.nnId), DFSUtil.createUri("hdfs", info.nameNode.getNameNodeAddress()).toString());
        }
        for (Map.Entry entry : nameservices.entrySet()) {
            conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", (String)entry.getKey()), Joiner.on((String)",").join((Iterable)entry.getValue()));
            conf.set("dfs.client.failover.proxy.provider." + (String)entry.getKey(), ConfiguredFailoverProxyProvider.class.getName());
        }
        conf.set("dfs.nameservices", Joiner.on((String)",").join(nameservices.keySet()));
    }

    private static DatanodeID getDatanodeID(String ipAddr) {
        return new DatanodeID(ipAddr, "localhost", UUID.randomUUID().toString(), 9866, 9864, 9865, 9867);
    }

    public static DatanodeID getLocalDatanodeID() {
        return DFSTestUtil.getDatanodeID("127.0.0.1");
    }

    public static DatanodeID getLocalDatanodeID(int port) {
        return new DatanodeID("127.0.0.1", "localhost", UUID.randomUUID().toString(), port, port, port, port);
    }

    public static DatanodeDescriptor getLocalDatanodeDescriptor() {
        return new DatanodeDescriptor(DFSTestUtil.getLocalDatanodeID());
    }

    public static DatanodeInfo getLocalDatanodeInfo() {
        return new DatanodeInfo.DatanodeInfoBuilder().setNodeID(DFSTestUtil.getLocalDatanodeID()).build();
    }

    public static DatanodeInfo getDatanodeInfo(String ipAddr) {
        return new DatanodeInfo.DatanodeInfoBuilder().setNodeID(DFSTestUtil.getDatanodeID(ipAddr)).build();
    }

    public static DatanodeInfo getLocalDatanodeInfo(int port) {
        return new DatanodeInfo.DatanodeInfoBuilder().setNodeID(DFSTestUtil.getLocalDatanodeID(port)).build();
    }

    public static DatanodeInfo getDatanodeInfo(String ipAddr, String host, int port) {
        return new DatanodeInfo.DatanodeInfoBuilder().setNodeID(new DatanodeID(ipAddr, host, UUID.randomUUID().toString(), port, 9864, 9865, 9867)).build();
    }

    public static DatanodeInfo getLocalDatanodeInfo(String ipAddr, String hostname, DatanodeInfo.AdminStates adminState) {
        return new DatanodeInfo.DatanodeInfoBuilder().setIpAddr(ipAddr).setHostName(hostname).setDatanodeUuid("").setXferPort(9866).setInfoPort(9864).setInfoSecurePort(9865).setIpcPort(9867).setCapacity(1L).setDfsUsed(2L).setRemaining(3L).setBlockPoolUsed(4L).setCacheCapacity(0L).setCacheUsed(0L).setLastUpdate(0L).setLastUpdateMonotonic(5L).setXceiverCount(6).setNetworkLocation("local").setAdminState(adminState).build();
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation) {
        return DFSTestUtil.getDatanodeDescriptor(ipAddr, 9866, rackLocation);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, String hostname) {
        return DFSTestUtil.getDatanodeDescriptor(ipAddr, 9866, rackLocation, hostname);
    }

    public static DatanodeStorageInfo createDatanodeStorageInfo(String storageID, String ip) {
        return DFSTestUtil.createDatanodeStorageInfo(storageID, ip, "defaultRack", "host");
    }

    public static DatanodeStorageInfo[] createDatanodeStorageInfos(String[] racks) {
        return DFSTestUtil.createDatanodeStorageInfos(racks, null);
    }

    public static DatanodeStorageInfo[] createDatanodeStorageInfos(String[] racks, String[] hostnames) {
        return DFSTestUtil.createDatanodeStorageInfos(racks.length, racks, hostnames);
    }

    public static DatanodeStorageInfo[] createDatanodeStorageInfos(int n) {
        return DFSTestUtil.createDatanodeStorageInfos(n, null, null);
    }

    public static DatanodeStorageInfo[] createDatanodeStorageInfos(int n, String[] racks, String[] hostnames) {
        return DFSTestUtil.createDatanodeStorageInfos(n, racks, hostnames, null);
    }

    public static DatanodeStorageInfo[] createDatanodeStorageInfos(int n, String[] racks, String[] hostnames, StorageType[] types) {
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[n];
        int i = storages.length;
        while (i > 0) {
            String storageID = "s" + i;
            String ip = i + "." + i + "." + i + "." + i;
            String rack = racks != null && i < racks.length ? racks[--i] : "defaultRack";
            String hostname = hostnames != null && i < hostnames.length ? hostnames[i] : "host";
            StorageType type = types != null && i < types.length ? types[i] : StorageType.DEFAULT;
            storages[i] = DFSTestUtil.createDatanodeStorageInfo(storageID, ip, rack, hostname, type, null);
        }
        return storages;
    }

    public static DatanodeStorageInfo createDatanodeStorageInfo(String storageID, String ip, String rack, String hostname) {
        return DFSTestUtil.createDatanodeStorageInfo(storageID, ip, rack, hostname, StorageType.DEFAULT, null);
    }

    public static DatanodeStorageInfo createDatanodeStorageInfo(String storageID, String ip, String rack, String hostname, StorageType type, String upgradeDomain) {
        DatanodeStorage storage = new DatanodeStorage(storageID, DatanodeStorage.State.NORMAL, type);
        DatanodeDescriptor dn = BlockManagerTestUtil.getDatanodeDescriptor(ip, rack, storage, hostname);
        if (upgradeDomain != null) {
            dn.setUpgradeDomain(upgradeDomain);
        }
        return BlockManagerTestUtil.newDatanodeStorageInfo(dn, storage);
    }

    public static DatanodeDescriptor[] toDatanodeDescriptor(DatanodeStorageInfo[] storages) {
        DatanodeDescriptor[] datanodes = new DatanodeDescriptor[storages.length];
        for (int i = 0; i < datanodes.length; ++i) {
            datanodes[i] = storages[i].getDatanodeDescriptor();
        }
        return datanodes;
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, int port, String rackLocation, String hostname) {
        DatanodeID dnId = new DatanodeID(ipAddr, hostname, UUID.randomUUID().toString(), port, 9864, 9865, 9867);
        return new DatanodeDescriptor(dnId, rackLocation);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, int port, String rackLocation) {
        return DFSTestUtil.getDatanodeDescriptor(ipAddr, port, rackLocation, "host");
    }

    public static DatanodeRegistration getLocalDatanodeRegistration() {
        return new DatanodeRegistration(DFSTestUtil.getLocalDatanodeID(), new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), VersionInfo.getVersion());
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileUtils.copyFile((File)src, (File)dest);
    }

    public static void runOperations(MiniDFSCluster cluster, DistributedFileSystem filesystem, Configuration conf, long blockSize, int nnIndex) throws IOException {
        LocatedBlocks locatedBlocks;
        long mtime;
        FileContext fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)conf);
        Path pathFileCreate = new Path("/file_create");
        FSDataOutputStream s = filesystem.create(pathFileCreate);
        s.close();
        FSDataOutputStream s2 = filesystem.append(pathFileCreate, 4096, null);
        s2.close();
        String updateBlockFile = "/update_blocks";
        FSDataOutputStream fout = filesystem.create(new Path("/update_blocks"), true, 4096, (short)1, 4096L);
        fout.write(1);
        fout.hflush();
        long fileId = ((DFSOutputStream)fout.getWrappedStream()).getFileId();
        DFSClient dfsclient = DFSClientAdapter.getDFSClient(filesystem);
        LocatedBlocks blocks = dfsclient.getNamenode().getBlockLocations("/update_blocks", 0L, Integer.MAX_VALUE);
        dfsclient.getNamenode().abandonBlock(blocks.get(0).getBlock(), fileId, "/update_blocks", dfsclient.clientName);
        fout.close();
        filesystem.setStoragePolicy(pathFileCreate, "HOT");
        Path pathFileMoved = new Path("/file_moved");
        filesystem.rename(pathFileCreate, pathFileMoved);
        filesystem.delete(pathFileMoved, false);
        Path pathDirectoryMkdir = new Path("/directory_mkdir");
        filesystem.mkdirs(pathDirectoryMkdir);
        filesystem.allowSnapshot(pathDirectoryMkdir);
        filesystem.disallowSnapshot(pathDirectoryMkdir);
        String ssName = "snapshot1";
        filesystem.allowSnapshot(pathDirectoryMkdir);
        filesystem.createSnapshot(pathDirectoryMkdir, ssName);
        String ssNewName = "snapshot2";
        filesystem.renameSnapshot(pathDirectoryMkdir, ssName, ssNewName);
        filesystem.deleteSnapshot(pathDirectoryMkdir, ssNewName);
        s = filesystem.create(pathFileCreate);
        s.close();
        filesystem.setReplication(pathFileCreate, (short)1);
        Short permission = 511;
        filesystem.setPermission(pathFileCreate, new FsPermission(permission.shortValue()));
        filesystem.setOwner(pathFileCreate, new String("newOwner"), null);
        long atime = mtime = 1285195527000L;
        filesystem.setTimes(pathFileCreate, mtime, atime);
        filesystem.setQuota(pathDirectoryMkdir, 1000L, Long.MAX_VALUE);
        filesystem.setQuotaByStorageType(pathDirectoryMkdir, StorageType.SSD, 888L);
        fc.rename(pathFileCreate, pathFileMoved, new Options.Rename[]{Options.Rename.NONE});
        Path pathConcatTarget = new Path("/file_concat_target");
        Path[] pathConcatFiles = new Path[]{new Path("/file_concat_0"), new Path("/file_concat_1")};
        long length = blockSize * 3L;
        short replication = 1;
        long seed = 1L;
        DFSTestUtil.createFile((FileSystem)filesystem, pathConcatTarget, length, replication, seed);
        DFSTestUtil.createFile((FileSystem)filesystem, pathConcatFiles[0], length, replication, seed);
        DFSTestUtil.createFile((FileSystem)filesystem, pathConcatFiles[1], length, replication, seed);
        filesystem.concat(pathConcatTarget, pathConcatFiles);
        length = blockSize * 2L;
        DFSTestUtil.createFile((FileSystem)filesystem, pathFileCreate, length, replication, seed);
        filesystem.truncate(pathFileCreate, blockSize);
        Path pathSymlink = new Path("/file_symlink");
        fc.createSymlink(pathConcatTarget, pathSymlink, false);
        String filePath = "/hard-lease-recovery-test";
        byte[] bytes = "foo-bar-baz".getBytes();
        DFSClientAdapter.stopLeaseRenewer(filesystem);
        FSDataOutputStream leaseRecoveryPath = filesystem.create(new Path(filePath));
        leaseRecoveryPath.write(bytes);
        leaseRecoveryPath.hflush();
        cluster.setLeasePeriod(60000L, 1000L, nnIndex);
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((locatedBlocks = DFSClientAdapter.callGetBlockLocations(cluster.getNameNodeRpc(nnIndex), filePath, 0L, bytes.length)).isUnderConstruction());
        filesystem.addCachePool(new CachePoolInfo("pool1"));
        filesystem.modifyCachePool(new CachePoolInfo("pool1").setLimit(Long.valueOf(99L)));
        long id = filesystem.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(new Path("/path")).setReplication(Short.valueOf((short)1)).setPool("pool1").build(), EnumSet.of(CacheFlag.FORCE));
        filesystem.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setReplication(Short.valueOf((short)2)).build(), EnumSet.of(CacheFlag.FORCE));
        filesystem.removeCacheDirective(id);
        filesystem.removeCachePool("pool1");
        ArrayList aclEntryList = Lists.newArrayList();
        aclEntryList.add(new AclEntry.Builder().setPermission(FsAction.READ_WRITE).setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).build());
        aclEntryList.add(new AclEntry.Builder().setName("user").setPermission(FsAction.READ_WRITE).setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).build());
        aclEntryList.add(new AclEntry.Builder().setPermission(FsAction.WRITE).setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).build());
        aclEntryList.add(new AclEntry.Builder().setPermission(FsAction.NONE).setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).build());
        filesystem.setAcl(pathConcatTarget, (List)aclEntryList);
        filesystem.setXAttr(pathConcatTarget, "user.a1", new byte[]{49, 50, 51});
        filesystem.setXAttr(pathConcatTarget, "user.a2", new byte[]{55, 56, 57});
        filesystem.removeXAttr(pathConcatTarget, "user.a2");
        ErasureCodingPolicy newPolicy1 = new ErasureCodingPolicy(ErasureCodeConstants.RS_3_2_SCHEMA, 8192);
        ErasureCodingPolicy[] policyArray = new ErasureCodingPolicy[]{newPolicy1};
        AddErasureCodingPolicyResponse[] responses = filesystem.addErasureCodingPolicies(policyArray);
        newPolicy1 = responses[0].getPolicy();
        HashMap<String, String> extraOptions = new HashMap<String, String>();
        extraOptions.put("dummyKey", "dummyValue");
        ECSchema schema = new ECSchema("rs", 6, 10, extraOptions);
        ErasureCodingPolicy newPolicy2 = new ErasureCodingPolicy(schema, 4096);
        policyArray = new ErasureCodingPolicy[]{newPolicy2};
        responses = filesystem.addErasureCodingPolicies(policyArray);
        newPolicy2 = responses[0].getPolicy();
        filesystem.enableErasureCodingPolicy(newPolicy1.getName());
        filesystem.enableErasureCodingPolicy(newPolicy2.getName());
        filesystem.disableErasureCodingPolicy(newPolicy1.getName());
        filesystem.disableErasureCodingPolicy(newPolicy2.getName());
        filesystem.removeErasureCodingPolicy(newPolicy1.getName());
        filesystem.removeErasureCodingPolicy(newPolicy2.getName());
        Path ecDir = new Path("/ec");
        filesystem.mkdirs(ecDir);
        ErasureCodingPolicy defaultEcPolicy = SystemErasureCodingPolicies.getByID((byte)1);
        ErasureCodingPolicy ecPolicyRS32 = SystemErasureCodingPolicies.getByID((byte)2);
        filesystem.enableErasureCodingPolicy(ecPolicyRS32.getName());
        filesystem.enableErasureCodingPolicy(defaultEcPolicy.getName());
        filesystem.setErasureCodingPolicy(ecDir, defaultEcPolicy.getName());
        try (FSDataOutputStream out = filesystem.createFile(new Path(ecDir, "replicated")).replicate().build();){
            out.write("replicated".getBytes());
        }
        out = ((DistributedFileSystem.HdfsDataOutputStreamBuilder)filesystem.createFile(new Path(ecDir, "RS-3-2")).ecPolicyName(ecPolicyRS32.getName()).blockSize(0x100000L)).build();
        var50_44 = null;
        try {
            out.write("RS-3-2".getBytes());
        }
        catch (Throwable throwable) {
            var50_44 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var50_44 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var50_44.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    public static void abortStream(DFSOutputStream out) throws IOException {
        out.abort();
    }

    public static void setPipeline(DFSOutputStream out, LocatedBlock lastBlock) throws IOException {
        out.getStreamer().setPipelineInConstruction(lastBlock);
    }

    public static byte[] asArray(ByteBuffer buf) {
        byte[] arr = new byte[buf.remaining()];
        buf.duplicate().get(arr);
        return arr;
    }

    public static long verifyExpectedCacheUsage(final long expectedCacheUsed, final long expectedBlocks, final FsDatasetSpi<?> fsd) throws Exception {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){
            private int tries = 0;

            public Boolean get() {
                long curCacheUsed = fsd.getCacheUsed();
                long curBlocks = fsd.getNumBlocksCached();
                if (curCacheUsed != expectedCacheUsed || curBlocks != expectedBlocks) {
                    if (this.tries++ > 10) {
                        LOG.info("verifyExpectedCacheUsage: have " + curCacheUsed + "/" + expectedCacheUsed + " bytes cached; " + curBlocks + "/" + expectedBlocks + " blocks cached. memlock limit = " + NativeIO.POSIX.getCacheManipulator().getMemlockLimit() + ".  Waiting...");
                    }
                    return false;
                }
                LOG.info("verifyExpectedCacheUsage: got " + curCacheUsed + "/" + expectedCacheUsed + " bytes cached; " + curBlocks + "/" + expectedBlocks + " blocks cached. memlock limit = " + NativeIO.POSIX.getCacheManipulator().getMemlockLimit());
                return true;
            }
        }, 100, 120000);
        return expectedCacheUsed;
    }

    public static long roundUpToMultiple(long val, int factor) {
        assert (factor > 1);
        long c = (val + (long)factor - 1L) / (long)factor;
        return c * (long)factor;
    }

    public static void checkComponentsEquals(byte[][] expected, byte[][] actual) {
        Assert.assertEquals((String)("expected: " + DFSUtil.byteArray2PathString(expected) + ", actual: " + DFSUtil.byteArray2PathString(actual)), (long)expected.length, (long)actual.length);
        int i = 0;
        for (byte[] e : expected) {
            byte[] actualComponent = actual[i++];
            Assert.assertTrue((String)("expected: " + DFSUtil.bytes2String(e) + ", actual: " + DFSUtil.bytes2String(actualComponent)), (boolean)Arrays.equals(e, actualComponent));
        }
    }

    public static void verifyFilesEqual(FileSystem fs, Path p1, Path p2, int len) throws IOException {
        try (FSDataInputStream in1 = fs.open(p1);
             FSDataInputStream in2 = fs.open(p2);){
            for (int i = 0; i < len; ++i) {
                Assert.assertEquals((String)("Mismatch at byte " + i), (long)in1.read(), (long)in2.read());
            }
        }
    }

    public static void verifyFilesNotEqual(FileSystem fs, Path p1, Path p2, int len) throws IOException {
        try (FSDataInputStream in1 = fs.open(p1);){
            FSDataInputStream in2 = fs.open(p2);
            Throwable throwable = null;
            try {
                int i = 0;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
        }
    }

    public static boolean verifyFileReplicasOnStorageType(FileSystem fs, DFSClient client, Path path, StorageType storageType) throws IOException {
        if (!fs.exists(path)) {
            LOG.info("verifyFileReplicasOnStorageType: file " + path + "does not exist");
            return false;
        }
        long fileLength = client.getFileInfo(path.toString()).getLen();
        LocatedBlocks locatedBlocks = client.getLocatedBlocks(path.toString(), 0L, fileLength);
        for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
            if (locatedBlock.getStorageTypes()[0] == storageType) continue;
            LOG.info("verifyFileReplicasOnStorageType: for file " + path + ". Expect blk" + locatedBlock + " on Type: " + storageType + ". Actual Type: " + locatedBlock.getStorageTypes()[0]);
            return false;
        }
        return true;
    }

    public static void verifyClientStats(Configuration conf, MiniDFSCluster cluster) throws Exception {
        ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy(conf, cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
        long[] aggregatedStats = cluster.getNameNode().getRpcServer().getStats();
        ReplicatedBlockStats replicatedBlockStats = client.getReplicatedBlockStats();
        ECBlockGroupStats ecBlockGroupStats = client.getECBlockGroupStats();
        Assert.assertEquals((String)"Under replicated stats not matching!", (long)aggregatedStats[3], (long)aggregatedStats[3]);
        Assert.assertEquals((String)"Low redundancy stats not matching!", (long)aggregatedStats[3], (long)(replicatedBlockStats.getLowRedundancyBlocks() + ecBlockGroupStats.getLowRedundancyBlockGroups()));
        Assert.assertEquals((String)"Corrupt blocks stats not matching!", (long)aggregatedStats[4], (long)(replicatedBlockStats.getCorruptBlocks() + ecBlockGroupStats.getCorruptBlockGroups()));
        Assert.assertEquals((String)"Missing blocks stats not matching!", (long)aggregatedStats[5], (long)(replicatedBlockStats.getMissingReplicaBlocks() + ecBlockGroupStats.getMissingBlockGroups()));
        Assert.assertEquals((String)"Missing blocks with replication factor one not matching!", (long)aggregatedStats[6], (long)replicatedBlockStats.getMissingReplicationOneBlocks());
        Assert.assertEquals((String)"Bytes in future blocks stats not matching!", (long)aggregatedStats[7], (long)(replicatedBlockStats.getBytesInFutureBlocks() + ecBlockGroupStats.getBytesInFutureBlockGroups()));
        Assert.assertEquals((String)"Pending deletion blocks stats not matching!", (long)aggregatedStats[8], (long)(replicatedBlockStats.getPendingDeletionBlocks() + ecBlockGroupStats.getPendingDeletionBlocks()));
    }

    public static void createKey(String keyName, MiniDFSCluster cluster, Configuration conf) throws NoSuchAlgorithmException, IOException {
        DFSTestUtil.createKey(keyName, cluster, 0, conf);
    }

    public static void createKey(String keyName, MiniDFSCluster cluster, int idx, Configuration conf) throws NoSuchAlgorithmException, IOException {
        NameNode nn = cluster.getNameNode(idx);
        KeyProviderCryptoExtension provider = nn.getNamesystem().getProvider();
        KeyProvider.Options options = KeyProvider.options((Configuration)conf);
        options.setDescription(keyName);
        options.setBitLength(128);
        provider.createKey(keyName, options);
        provider.flush();
    }

    public static DatanodeDescriptor getExpectedPrimaryNode(NameNode nn, ExtendedBlock blk) {
        BlockManager bm0 = nn.getNamesystem().getBlockManager();
        BlockInfo storedBlock = bm0.getStoredBlock(blk.getLocalBlock());
        Assert.assertTrue((String)("Block " + blk + " should be under construction, got: " + (Object)((Object)storedBlock)), (!storedBlock.isComplete() ? 1 : 0) != 0);
        DatanodeStorageInfo[] storages = storedBlock.getUnderConstructionFeature().getExpectedStorageLocations();
        DatanodeStorageInfo expectedPrimary = storages[0];
        long mostRecentLastUpdate = expectedPrimary.getDatanodeDescriptor().getLastUpdateMonotonic();
        for (int i = 1; i < storages.length; ++i) {
            long lastUpdate = storages[i].getDatanodeDescriptor().getLastUpdateMonotonic();
            if (lastUpdate <= mostRecentLastUpdate) continue;
            expectedPrimary = storages[i];
            mostRecentLastUpdate = lastUpdate;
        }
        return expectedPrimary.getDatanodeDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toolRun(Tool tool, String cmd, int retcode, String contain) throws Exception {
        String[] cmds = StringUtils.split((String)cmd, (char)' ');
        System.out.flush();
        System.err.flush();
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        String output = null;
        int ret = 0;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(1024);
            try (PrintStream out = new PrintStream(bs);){
                System.setOut(out);
                System.setErr(out);
                ret = tool.run(cmds);
                System.out.flush();
                System.err.flush();
            }
            output = bs.toString();
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
        }
        System.out.println("Output for command: " + cmd + " retcode: " + ret);
        if (output != null) {
            System.out.println(output);
        }
        Assert.assertEquals((long)retcode, (long)ret);
        if (contain != null) {
            Assert.assertTrue((String)("The real output is: " + output + ".\n It should contain: " + contain), (boolean)output.contains(contain));
        }
    }

    public static void FsShellRun(String cmd, int retcode, String contain, Configuration conf) throws Exception {
        FsShell shell = new FsShell(new Configuration(conf));
        DFSTestUtil.toolRun((Tool)shell, cmd, retcode, contain);
    }

    public static void DFSAdminRun(String cmd, int retcode, String contain, Configuration conf) throws Exception {
        DFSAdmin admin = new DFSAdmin(new Configuration(conf));
        DFSTestUtil.toolRun((Tool)admin, cmd, retcode, contain);
    }

    public static void FsShellRun(String cmd, Configuration conf) throws Exception {
        DFSTestUtil.FsShellRun(cmd, 0, null, conf);
    }

    public static void addDataNodeLayoutVersion(int lv, String description) throws NoSuchFieldException, IllegalAccessException {
        Preconditions.checkState((lv < DataNodeLayoutVersion.CURRENT_LAYOUT_VERSION ? 1 : 0) != 0);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        Field field = DataNodeLayoutVersion.class.getField("CURRENT_LAYOUT_VERSION");
        field.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.setInt(null, lv);
        field = HdfsServerConstants.class.getField("DATANODE_LAYOUT_VERSION");
        field.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.setInt(null, lv);
        final LayoutVersion.FeatureInfo featureInfo = new LayoutVersion.FeatureInfo(lv, lv + 1, description, false, new LayoutVersion.LayoutFeature[0]);
        LayoutVersion.LayoutFeature feature = new LayoutVersion.LayoutFeature(){

            @Override
            public LayoutVersion.FeatureInfo getInfo() {
                return featureInfo;
            }
        };
        LayoutVersion.updateMap(DataNodeLayoutVersion.FEATURES, new LayoutVersion.LayoutFeature[]{feature});
    }

    public static void waitForDatanodeState(final MiniDFSCluster cluster, final String nodeID, final boolean alive, int waitTime) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                FSNamesystem namesystem = cluster.getNamesystem();
                DatanodeDescriptor dd = BlockManagerTestUtil.getDatanode(namesystem, nodeID);
                return dd.isAlive() == alive;
            }
        }, 100, waitTime);
    }

    public static boolean changeReplicaLength(MiniDFSCluster cluster, ExtendedBlock blk, int dnIndex, int lenDelta) throws IOException {
        File blockFile = cluster.getBlockFile(dnIndex, blk);
        if (blockFile != null && blockFile.exists()) {
            try (RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");){
                raFile.setLength(raFile.length() + (long)lenDelta);
            }
            return true;
        }
        LOG.info("failed to change length of block " + blk);
        return false;
    }

    public static void setNameNodeLogLevel(Level level) {
        GenericTestUtils.setLogLevel(FSNamesystem.LOG, level);
        GenericTestUtils.setLogLevel(BlockManager.LOG, level);
        GenericTestUtils.setLogLevel(LeaseManager.LOG, level);
        GenericTestUtils.setLogLevel(NameNode.LOG, level);
        GenericTestUtils.setLogLevel(NameNode.stateChangeLog, level);
        GenericTestUtils.setLogLevel(NameNode.blockStateChangeLog, level);
    }

    @VisibleForTesting
    public static NamenodeProtocol getNamenodeProtocolProxy(Configuration conf, URI nameNodeUri, UserGroupInformation ugi) throws IOException {
        return (NamenodeProtocol)NameNodeProxies.createNonHAProxy(conf, DFSUtilClient.getNNAddress((URI)nameNodeUri), NamenodeProtocol.class, ugi, false).getProxy();
    }

    @VisibleForTesting
    public static RefreshUserMappingsProtocol getRefreshUserMappingsProtocolProxy(Configuration conf, InetSocketAddress nnAddr) throws IOException {
        return (RefreshUserMappingsProtocol)NameNodeProxies.createNonHAProxy(conf, nnAddr, RefreshUserMappingsProtocol.class, UserGroupInformation.getCurrentUser(), false).getProxy();
    }

    public static void setDatanodeDead(DatanodeInfo dn) {
        dn.setLastUpdate(0L);
        dn.setLastUpdateMonotonic(-4611686018427387904L);
    }

    public static void resetLastUpdatesWithOffset(DatanodeInfo dn, long offset) {
        dn.setLastUpdate(Time.now() + offset);
        dn.setLastUpdateMonotonic(Time.monotonicNow() + offset);
    }

    public static void fillExpectedBuf(LocatedBlocks lbs, byte[] expected) {
        Block[] blks = new Block[lbs.getLocatedBlocks().size()];
        for (int i = 0; i < lbs.getLocatedBlocks().size(); ++i) {
            blks[i] = ((LocatedBlock)lbs.getLocatedBlocks().get(i)).getBlock().getLocalBlock();
        }
        int bufPos = 0;
        for (Block b : blks) {
            for (long blkPos = 0L; blkPos < b.getNumBytes(); ++blkPos) {
                assert (bufPos < expected.length);
                expected[bufPos++] = SimulatedFSDataset.simulatedByte(b, blkPos);
            }
        }
    }

    public static StorageReceivedDeletedBlocks[] makeReportForReceivedBlock(Block block, ReceivedDeletedBlockInfo.BlockStatus blockStatus, DatanodeStorage storage) {
        ReceivedDeletedBlockInfo[] receivedBlocks = new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo(block, blockStatus, null)};
        StorageReceivedDeletedBlocks[] reports = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(storage, receivedBlocks)};
        return reports;
    }

    public static void createStripedFile(MiniDFSCluster cluster, Path file, Path dir, int numBlocks, int numStripesPerBlk, boolean toMkdir) throws Exception {
        DFSTestUtil.createStripedFile(cluster, file, dir, numBlocks, numStripesPerBlk, toMkdir, StripedFileTestUtil.getDefaultECPolicy());
    }

    public static void createStripedFile(MiniDFSCluster cluster, Path file, Path dir, int numBlocks, int numStripesPerBlk, boolean toMkdir, ErasureCodingPolicy ecPolicy) throws Exception {
        DistributedFileSystem dfs;
        block5: {
            dfs = cluster.getFileSystem();
            if (toMkdir) {
                assert (dir != null);
                dfs.mkdirs(dir);
                try {
                    dfs.getClient().setErasureCodingPolicy(dir.toString(), ecPolicy.getName());
                }
                catch (IOException e) {
                    if (e.getMessage().contains("non-empty directory")) break block5;
                    throw e;
                }
            }
        }
        cluster.getNameNodeRpc().create(file.toString(), new FsPermission(493), dfs.getClient().getClientName(), new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), false, (short)1, 0x8000000L, null, null);
        FSNamesystem ns = cluster.getNamesystem();
        FSDirectory fsdir = ns.getFSDirectory();
        INodeFile fileNode = fsdir.getINode4Write(file.toString()).asFile();
        ExtendedBlock previous = null;
        for (int i = 0; i < numBlocks; ++i) {
            Block newBlock = DFSTestUtil.addBlockToFile(true, cluster.getDataNodes(), dfs, ns, file.toString(), fileNode, dfs.getClient().getClientName(), previous, numStripesPerBlk, 0);
            previous = new ExtendedBlock(ns.getBlockPoolId(), newBlock);
        }
        dfs.getClient().namenode.complete(file.toString(), dfs.getClient().getClientName(), previous, fileNode.getId());
    }

    public static Block addBlockToFile(boolean isStripedBlock, List<DataNode> dataNodes, DistributedFileSystem fs, FSNamesystem ns, String file, INodeFile fileNode, String clientName, ExtendedBlock previous, int numStripes, int len) throws Exception {
        fs.getClient().namenode.addBlock(file, clientName, previous, null, fileNode.getId(), null, null);
        BlockInfo lastBlock = fileNode.getLastBlock();
        int groupSize = fileNode.getPreferredBlockReplication();
        assert (dataNodes.size() >= groupSize);
        for (int i = 0; i < groupSize; ++i) {
            StorageReceivedDeletedBlocks[] reports;
            DataNode dn = dataNodes.get(i);
            Block block = new Block(lastBlock.getBlockId() + (long)i, 0L, lastBlock.getGenerationStamp());
            DatanodeStorage storage = new DatanodeStorage(UUID.randomUUID().toString());
            for (StorageReceivedDeletedBlocks report : reports = DFSTestUtil.makeReportForReceivedBlock(block, ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, storage)) {
                ns.processIncrementalBlockReport(dn.getDatanodeId(), report);
            }
        }
        ErasureCodingPolicy ecPolicy = fs.getErasureCodingPolicy(new Path(file));
        long blockSize = isStripedBlock ? (long)(numStripes * ecPolicy.getCellSize()) : (long)len;
        for (int i = 0; i < groupSize; ++i) {
            StorageReceivedDeletedBlocks[] reports;
            DataNode dn = dataNodes.get(i);
            Block block = new Block(lastBlock.getBlockId() + (long)i, blockSize, lastBlock.getGenerationStamp());
            DatanodeStorage storage = new DatanodeStorage(UUID.randomUUID().toString());
            for (StorageReceivedDeletedBlocks report : reports = DFSTestUtil.makeReportForReceivedBlock(block, ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, storage)) {
                ns.processIncrementalBlockReport(dn.getDatanodeId(), report);
            }
        }
        long bytes = isStripedBlock ? (long)(numStripes * ecPolicy.getCellSize() * ecPolicy.getNumDataUnits()) : (long)len;
        lastBlock.setNumBytes(bytes);
        return lastBlock;
    }

    public static boolean replaceBlock(ExtendedBlock block, DatanodeInfo source, DatanodeInfo sourceProxy, DatanodeInfo destination) throws IOException {
        return DFSTestUtil.replaceBlock(block, source, sourceProxy, destination, StorageType.DEFAULT, DataTransferProtos.Status.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceBlock(ExtendedBlock block, DatanodeInfo source, DatanodeInfo sourceProxy, DatanodeInfo destination, StorageType targetStorageType, DataTransferProtos.Status opStatus) throws IOException, SocketException {
        try (Socket sock = new Socket();){
            sock.connect(NetUtils.createSocketAddr((String)destination.getXferAddr()), 60000);
            sock.setKeepAlive(true);
            DataOutputStream out = new DataOutputStream(sock.getOutputStream());
            new Sender(out).replaceBlock(block, targetStorageType, BlockTokenSecretManager.DUMMY_TOKEN, source.getDatanodeUuid(), sourceProxy, null);
            out.flush();
            DataInputStream reply = new DataInputStream(sock.getInputStream());
            DataTransferProtos.BlockOpResponseProto proto = DataTransferProtos.BlockOpResponseProto.parseDelimitedFrom((InputStream)reply);
            while (proto.getStatus() == DataTransferProtos.Status.IN_PROGRESS) {
                proto = DataTransferProtos.BlockOpResponseProto.parseDelimitedFrom((InputStream)reply);
            }
            boolean bl = proto.getStatus() == opStatus;
            return bl;
        }
    }

    public static ExtendedBlock flushInternal(DFSStripedOutputStream out) throws IOException {
        out.flushAllInternals();
        return out.getBlock();
    }

    public static ExtendedBlock flushBuffer(DFSStripedOutputStream out) throws IOException {
        out.flush();
        return out.getBlock();
    }

    public static void waitForMetric(final JMXGet jmx, final String metricName, final int expectedValue) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    int currentValue = Integer.parseInt(jmx.getValue(metricName));
                    LOG.info("Waiting for " + metricName + " to reach value " + expectedValue + ", current value = " + currentValue);
                    return currentValue == expectedValue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Test failed due to unexpected exception", e);
                }
            }
        }, 1000, 60000);
    }

    public static FileSystem login(FileSystem fs, Configuration conf, UserGroupInformation ugi) throws IOException, InterruptedException {
        if (fs != null) {
            fs.close();
        }
        return DFSTestUtil.getFileSystemAs(ugi, conf);
    }

    public static void verifyFilePermission(FileStatus stat, String owner, String group, FsAction u, FsAction g, FsAction o) {
        if (stat != null) {
            if (!Strings.isNullOrEmpty((String)owner)) {
                Assert.assertEquals((Object)owner, (Object)stat.getOwner());
            }
            if (!Strings.isNullOrEmpty((String)group)) {
                Assert.assertEquals((Object)group, (Object)stat.getGroup());
            }
            FsPermission permission = stat.getPermission();
            if (u != null) {
                Assert.assertEquals((Object)u, (Object)permission.getUserAction());
            }
            if (g != null) {
                Assert.assertEquals((Object)g, (Object)permission.getGroupAction());
            }
            if (o != null) {
                Assert.assertEquals((Object)o, (Object)permission.getOtherAction());
            }
        }
    }

    public static void verifyDelete(FsShell shell, FileSystem fs, Path path, boolean shouldExistInTrash) throws Exception {
        Path trashPath = Path.mergePaths((Path)shell.getCurrentTrashDir(path), (Path)path);
        DFSTestUtil.verifyDelete(shell, fs, path, trashPath, shouldExistInTrash);
    }

    public static void verifyDelete(FsShell shell, FileSystem fs, Path path, Path trashPath, boolean shouldExistInTrash) throws Exception {
        Assert.assertTrue((String)(path + " file does not exist"), (boolean)fs.exists(path));
        Path checkTrash = trashPath;
        while (!checkTrash.isRoot() && !checkTrash.getName().equals(".Trash")) {
            checkTrash = checkTrash.getParent();
        }
        Assert.assertEquals((String)("No .Trash component found in trash path " + trashPath), (Object)".Trash", (Object)checkTrash.getName());
        String[] argv = new String[]{"-rm", "-r", path.toString()};
        int res = ToolRunner.run((Tool)shell, (String[])argv);
        Assert.assertEquals((String)"rm failed", (long)0L, (long)res);
        if (shouldExistInTrash) {
            Assert.assertTrue((String)("File not in trash : " + trashPath), (boolean)fs.exists(trashPath));
        } else {
            Assert.assertFalse((String)("File in trash : " + trashPath), (boolean)fs.exists(trashPath));
        }
    }

    public static Map<Path, FSDataOutputStream> createOpenFiles(FileSystem fs, String filePrefix, int numFilesToCreate) throws IOException {
        HashMap<Path, FSDataOutputStream> filesCreated = new HashMap<Path, FSDataOutputStream>();
        byte[] buffer = new byte[1792];
        Random rand = new Random(4276947884L);
        for (int i = 0; i < numFilesToCreate; ++i) {
            Path file = new Path("/" + filePrefix + "-" + i);
            FSDataOutputStream stm = fs.create(file, true, 1024, (short)1, 1024L);
            rand.nextBytes(buffer);
            stm.write(buffer);
            filesCreated.put(file, stm);
        }
        return filesCreated;
    }

    public static HashSet<Path> closeOpenFiles(HashMap<Path, FSDataOutputStream> openFilesMap, int numFilesToClose) throws IOException {
        HashSet<Path> closedFiles = new HashSet<Path>();
        Iterator<Map.Entry<Path, FSDataOutputStream>> it = openFilesMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Path, FSDataOutputStream> entry = it.next();
            LOG.info("Closing file: " + entry.getKey());
            entry.getValue().close();
            closedFiles.add(entry.getKey());
            it.remove();
            if (--numFilesToClose != 0) continue;
            break;
        }
        return closedFiles;
    }

    public static void verifySnapshotDiffReport(DistributedFileSystem fs, Path dir, String from, String to, SnapshotDiffReport.DiffReportEntry ... entries) throws IOException {
        SnapshotDiffReport report = fs.getSnapshotDiffReport(dir, from, to);
        SnapshotDiffReport inverseReport = fs.getSnapshotDiffReport(dir, to, from);
        LOG.info(report.toString());
        LOG.info(inverseReport.toString() + "\n");
        Assert.assertEquals((long)entries.length, (long)report.getDiffList().size());
        Assert.assertEquals((long)entries.length, (long)inverseReport.getDiffList().size());
        for (SnapshotDiffReport.DiffReportEntry entry : entries) {
            if (entry.getType() == SnapshotDiffReport.DiffType.MODIFY) {
                Assert.assertTrue((boolean)report.getDiffList().contains(entry));
                Assert.assertTrue((boolean)inverseReport.getDiffList().contains(entry));
                continue;
            }
            if (entry.getType() == SnapshotDiffReport.DiffType.DELETE) {
                Assert.assertTrue((boolean)report.getDiffList().contains(entry));
                Assert.assertTrue((boolean)inverseReport.getDiffList().contains(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, entry.getSourcePath())));
                continue;
            }
            if (entry.getType() != SnapshotDiffReport.DiffType.CREATE) continue;
            Assert.assertTrue((boolean)report.getDiffList().contains(entry));
            Assert.assertTrue((boolean)inverseReport.getDiffList().contains(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, entry.getSourcePath())));
        }
    }

    public static void waitExpectedStorageType(final String fileName, final StorageType expectedStorageType, final int expectedStorageCount, int timeout, final DistributedFileSystem fs) throws Exception {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                LocatedBlock lb;
                try {
                    lb = fs.getClient().getLocatedBlocks(fileName, 0L).get(0);
                }
                catch (IOException e) {
                    LOG.error("Exception while getting located blocks", (Throwable)e);
                    return false;
                }
                int actualStorageCount = 0;
                for (StorageType type : lb.getStorageTypes()) {
                    if (expectedStorageType != type) continue;
                    ++actualStorageCount;
                }
                LOG.info(expectedStorageType + " replica count, expected=" + expectedStorageCount + " and actual=" + actualStorageCount);
                return expectedStorageCount == actualStorageCount;
            }
        }, 500, timeout);
    }

    public static void waitForXattrRemoved(String srcPath, String xattr, Namesystem ns, int timeout) throws TimeoutException, InterruptedException, UnresolvedLinkException, AccessControlException, ParentNotDirectoryException {
        final INode inode = ns.getFSDirectory().getINode(srcPath);
        final XAttr satisfyXAttr = XAttrHelper.buildXAttr((String)xattr);
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
                return !existingXAttrs.contains(satisfyXAttr);
            }
        }, 100, timeout);
    }

    public static NameNodeConnector getNameNodeConnector(Configuration conf, Path filePath, int namenodeCount, boolean createMoverPath) throws IOException {
        Collection<URI> namenodes = DFSUtil.getInternalNsRpcUris(conf);
        Assert.assertEquals((long)namenodeCount, (long)namenodes.size());
        NameNodeConnector.checkOtherInstanceRunning(createMoverPath);
        while (true) {
            try {
                List<NameNodeConnector> nncs = NameNodeConnector.newNameNodeConnectors(namenodes, StoragePolicySatisfier.class.getSimpleName(), filePath, conf, 5);
                return nncs.get(0);
            }
            catch (IOException e) {
                LOG.warn("Failed to connect with namenode", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public static class ShortCircuitTestContext
    implements Closeable {
        private final String testName;
        private final TemporarySocketDirectory sockDir;
        private boolean closed = false;
        private final boolean formerTcpReadsDisabled;

        public ShortCircuitTestContext(String testName) {
            this.testName = testName;
            this.sockDir = new TemporarySocketDirectory();
            DomainSocket.disableBindPathValidation();
            this.formerTcpReadsDisabled = DFSInputStream.tcpReadsDisabledForTesting;
            Assume.assumeTrue((DomainSocket.getLoadingFailureReason() == null ? 1 : 0) != 0);
        }

        public Configuration newConfiguration() {
            Configuration conf = new Configuration();
            conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
            conf.set("dfs.domain.socket.path", new File(this.sockDir.getDir(), this.testName + "._PORT.sock").getAbsolutePath());
            return conf;
        }

        public String getTestName() {
            return this.testName;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            DFSInputStream.tcpReadsDisabledForTesting = this.formerTcpReadsDisabled;
            this.sockDir.close();
        }
    }

    public static class Builder {
        private int maxLevels = 3;
        private int maxSize = 8192;
        private int minSize = 1;
        private int nFiles = 1;

        public Builder setName(String string) {
            return this;
        }

        public Builder setNumFiles(int nFiles) {
            this.nFiles = nFiles;
            return this;
        }

        public Builder setMaxLevels(int maxLevels) {
            this.maxLevels = maxLevels;
            return this;
        }

        public Builder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder setMinSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public DFSTestUtil build() {
            return new DFSTestUtil(this.nFiles, this.maxLevels, this.maxSize, this.minSize);
        }
    }

    static class MockUnixGroupsMapping
    extends ShellBasedUnixGroupsMapping {
        static Map<String, String[]> fakeUser2GroupsMap;
        private static final List<String> defaultGroups;

        MockUnixGroupsMapping() {
        }

        public List<String> getGroups(String user) throws IOException {
            boolean found = false;
            List<String> l = new ArrayList<String>();
            for (String u : fakeUser2GroupsMap.keySet()) {
                if (!user.equals(u)) continue;
                found = true;
                for (String gr : fakeUser2GroupsMap.get(u)) {
                    l.add(gr);
                }
            }
            if (!found && (l = super.getGroups(user)).size() == 0) {
                System.out.println("failed to get real group for " + user + "; using default");
                return defaultGroups;
            }
            return l;
        }

        static {
            defaultGroups = new ArrayList<String>(1);
            defaultGroups.add("supergroup");
            fakeUser2GroupsMap = new HashMap<String, String[]>();
        }
    }

    private class MyFile {
        private String name = "";
        private final int size;
        private final long seed;

        MyFile() {
            int nLevels = gen.nextInt(DFSTestUtil.this.maxLevels);
            if (nLevels != 0) {
                int[] levels = new int[nLevels];
                for (int idx = 0; idx < nLevels; ++idx) {
                    levels[idx] = gen.nextInt(10);
                }
                StringBuffer sb = new StringBuffer();
                for (int idx = 0; idx < nLevels; ++idx) {
                    sb.append(dirNames[levels[idx]]);
                    sb.append("/");
                }
                this.name = sb.toString();
            }
            long fidx = -1L;
            while (fidx < 0L) {
                fidx = gen.nextLong();
            }
            this.name = this.name + Long.toString(fidx);
            this.size = DFSTestUtil.this.minSize + gen.nextInt(DFSTestUtil.this.maxSize - DFSTestUtil.this.minSize);
            this.seed = gen.nextLong();
        }

        String getName() {
            return this.name;
        }

        int getSize() {
            return this.size;
        }

        long getSeed() {
            return this.seed;
        }
    }
}

