/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.tools.JMXGet;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.base.Supplier;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.shaded.org.hamcrest.core.Is;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazyPersistTestCase {
    static final byte LAZY_PERSIST_POLICY_ID = 15;
    protected static final int BLOCK_SIZE = 0x500000;
    protected static final int BUFFER_LENGTH = 4096;
    private static final long HEARTBEAT_INTERVAL_SEC = 1L;
    private static final int HEARTBEAT_RECHECK_INTERVAL_MSEC = 500;
    private static final String JMX_RAM_DISK_METRICS_PATTERN = "^RamDisk";
    private static final String JMX_SERVICE_NAME = "DataNode";
    protected static final int LAZY_WRITE_FILE_SCRUBBER_INTERVAL_SEC = 3;
    protected static final int LAZY_WRITER_INTERVAL_SEC = 1;
    protected static final Logger LOG;
    protected static final short REPL_FACTOR = 1;
    protected final long osPageSize = NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();
    protected MiniDFSCluster cluster;
    protected DistributedFileSystem fs;
    protected DFSClient client;
    protected JMXGet jmx;
    protected TemporarySocketDirectory sockDir;
    @Rule
    public Timeout timeout = new Timeout(300000);

    @After
    public void shutDownCluster() throws Exception {
        this.printRamDiskJMXMetrics();
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
            this.client = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdownDataNodes();
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.jmx != null) {
            this.jmx = null;
        }
        IOUtils.closeQuietly((Closeable)this.sockDir);
        this.sockDir = null;
    }

    protected final LocatedBlocks ensureFileReplicasOnStorageType(final Path path, final StorageType storageType) throws IOException, TimeoutException, InterruptedException {
        LOG.info("Ensure path: " + path + " is on StorageType: " + storageType);
        Assert.assertThat((Object)this.fs.exists(path), Is.is(true));
        final long fileLength = this.client.getFileInfo(path.toString()).getLen();
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    LocatedBlocks locatedBlocks = LazyPersistTestCase.this.client.getLocatedBlocks(path.toString(), 0L, fileLength);
                    for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
                        if (locatedBlock.getStorageTypes()[0] == storageType) continue;
                        return false;
                    }
                    return true;
                }
                catch (IOException ioe) {
                    LOG.warn("Exception got in ensureFileReplicasOnStorageType()", (Throwable)ioe);
                    return false;
                }
            }
        }, 100, 30000);
        return this.client.getLocatedBlocks(path.toString(), 0L, fileLength);
    }

    protected final void ensureLazyPersistBlocksAreSaved(LocatedBlocks locatedBlocks) throws IOException, InterruptedException {
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        HashSet<Long> persistedBlockIds = new HashSet<Long>();
        try (FsDatasetSpi.FsVolumeReferences volumes = this.cluster.getDataNodes().get(0).getFSDataset().getFsVolumeReferences();){
            while (persistedBlockIds.size() < locatedBlocks.getLocatedBlocks().size()) {
                Thread.sleep(1000L);
                for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                    for (FsVolumeSpi v : volumes) {
                        long blockId;
                        FsVolumeImpl volume;
                        File lazyPersistDir;
                        File targetDir;
                        File blockFile;
                        if (v.isTransientStorage() || !(blockFile = new File(targetDir = DatanodeUtil.idToBlockDir(lazyPersistDir = (volume = (FsVolumeImpl)v).getBlockPoolSlice(bpid).getLazypersistDir(), blockId = lb.getBlock().getBlockId()), lb.getBlock().getBlockName())).exists()) continue;
                        persistedBlockIds.add(blockId);
                    }
                }
            }
        }
        Assert.assertThat((Object)persistedBlockIds.size(), Is.is(locatedBlocks.getLocatedBlocks().size()));
    }

    protected final void makeRandomTestFile(Path path, long length, boolean isLazyPersist, long seed) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.fs, path, isLazyPersist, 4096, length, 0x500000L, (short)1, seed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void makeTestFile(Path path, long length, boolean isLazyPersist) throws IOException {
        EnumSet<CreateFlag> createFlags = EnumSet.of(CreateFlag.CREATE);
        if (isLazyPersist) {
            createFlags.add(CreateFlag.LAZY_PERSIST);
        }
        FSDataOutputStream fos = null;
        try {
            fos = this.fs.create(path, FsPermission.getFileDefault(), createFlags, 4096, (short)1, 0x500000L, null);
            byte[] buffer = new byte[4096];
            int bytesWritten = 0;
            while ((long)bytesWritten < length) {
                fos.write(buffer, 0, buffer.length);
                bytesWritten += buffer.length;
            }
            if (length > 0L) {
                fos.hsync();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    protected final void startUpCluster(int numDatanodes, boolean hasTransientStorage, StorageType[] storageTypes, int ramDiskReplicaCapacity, long ramDiskStorageLimit, long maxLockedMemory, boolean useSCR, boolean useLegacyBlockReaderLocal, boolean disableScrubber) throws IOException {
        StorageType[] storageTypeArray;
        LazyPersistTestCase.initCacheManipulator();
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 0x500000L);
        if (disableScrubber) {
            conf.setInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 0);
        } else {
            conf.setInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 3);
        }
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setInt("dfs.datanode.lazywriter.interval.sec", 1);
        conf.setInt("dfs.namenode.safemode.min.datanodes", 1);
        conf.setLong("dfs.datanode.max.locked.memory", maxLockedMemory);
        if (useSCR) {
            conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
            conf.set("dfs.client.context", UUID.randomUUID().toString());
            conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
            if (useLegacyBlockReaderLocal) {
                conf.setBoolean("dfs.client.use.legacy.blockreader.local", true);
            } else {
                this.sockDir = new TemporarySocketDirectory();
                conf.set("dfs.domain.socket.path", new File(this.sockDir.getDir(), this.getClass().getSimpleName() + "._PORT.sock").getAbsolutePath());
            }
        }
        Preconditions.checkState((ramDiskReplicaCapacity < 0 || ramDiskStorageLimit < 0L ? 1 : 0) != 0, (Object)"Cannot specify non-default values for both ramDiskReplicaCapacity and ramDiskStorageLimit");
        if (hasTransientStorage && ramDiskReplicaCapacity >= 0) {
            ramDiskStorageLimit = (long)ramDiskReplicaCapacity * 0x500000L + 0x4FFFFFL;
        }
        long[] capacities = new long[]{ramDiskStorageLimit, -1L};
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf).numDataNodes(numDatanodes).storageCapacities(capacities);
        if (storageTypes != null) {
            storageTypeArray = storageTypes;
        } else if (hasTransientStorage) {
            StorageType[] storageTypeArray2 = new StorageType[2];
            storageTypeArray2[0] = StorageType.RAM_DISK;
            storageTypeArray = storageTypeArray2;
            storageTypeArray2[1] = StorageType.DEFAULT;
        } else {
            storageTypeArray = null;
        }
        this.cluster = builder.storageTypes(storageTypeArray).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.client = this.fs.getClient();
        try {
            this.jmx = this.initJMX();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed initialize JMX for testing: " + e));
        }
        LOG.info("Cluster startup complete");
    }

    public static void initCacheManipulator() {
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.CacheManipulator(){

            public void mlock(String identifier, ByteBuffer mmap, long length) throws IOException {
                LOG.info("LazyPersistTestCase: faking mlock of " + identifier + " bytes.");
            }

            public long getMemlockLimit() {
                LOG.info("LazyPersistTestCase: fake return 9223372036854775807");
                return Long.MAX_VALUE;
            }

            public boolean verifyCanMlock() {
                LOG.info("LazyPersistTestCase: fake return true");
                return true;
            }
        });
    }

    ClusterWithRamDiskBuilder getClusterBuilder() {
        return new ClusterWithRamDiskBuilder();
    }

    protected final void triggerBlockReport() throws IOException, InterruptedException {
        DataNodeTestUtils.triggerBlockReport(this.cluster.getDataNodes().get(0));
        Thread.sleep(10000L);
    }

    protected final boolean verifyBlockDeletedFromDir(File dir, LocatedBlocks locatedBlocks) {
        for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
            File targetDir = DatanodeUtil.idToBlockDir(dir, lb.getBlock().getBlockId());
            File blockFile = new File(targetDir, lb.getBlock().getBlockName());
            if (blockFile.exists()) {
                LOG.warn("blockFile: " + blockFile.getAbsolutePath() + " exists after deletion.");
                return false;
            }
            File metaFile = new File(targetDir, DatanodeUtil.getMetaName(lb.getBlock().getBlockName(), lb.getBlock().getGenerationStamp()));
            if (!metaFile.exists()) continue;
            LOG.warn("metaFile: " + metaFile.getAbsolutePath() + " exists after deletion.");
            return false;
        }
        return true;
    }

    protected final boolean verifyDeletedBlocks(LocatedBlocks locatedBlocks) throws IOException, InterruptedException {
        LOG.info("Verifying replica has no saved copy after deletion.");
        this.triggerBlockReport();
        while (this.cluster.getFsDatasetTestUtils(0).getPendingAsyncDeletions() > 0L) {
            Thread.sleep(1000L);
        }
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        FsDatasetSpi<?> dataset = this.cluster.getDataNodes().get(0).getFSDataset();
        try (FsDatasetSpi.FsVolumeReferences volumes = dataset.getFsVolumeReferences();){
            for (FsVolumeSpi vol : volumes) {
                File targetDir;
                FsVolumeImpl volume = (FsVolumeImpl)vol;
                File file = targetDir = volume.isTransientStorage() ? volume.getBlockPoolSlice(bpid).getFinalizedDir() : volume.getBlockPoolSlice(bpid).getLazypersistDir();
                if (this.verifyBlockDeletedFromDir(targetDir, locatedBlocks)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    protected final void verifyRamDiskJMXMetric(String metricName, long expectedValue) throws Exception {
        this.waitForMetric(metricName, (int)expectedValue);
        Assert.assertEquals((long)expectedValue, (long)Integer.parseInt(this.jmx.getValue(metricName)));
    }

    protected final boolean verifyReadRandomFile(Path path, int fileLength, int seed) throws IOException {
        byte[] contents = DFSTestUtil.readFileBuffer((FileSystem)this.fs, path);
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(seed, fileLength);
        return Arrays.equals(contents, expected);
    }

    private JMXGet initJMX() throws Exception {
        JMXGet jmx = new JMXGet();
        jmx.setService(JMX_SERVICE_NAME);
        jmx.init();
        return jmx;
    }

    private void printRamDiskJMXMetrics() {
        try {
            if (this.jmx != null) {
                this.jmx.printAllMatchedAttributes(JMX_RAM_DISK_METRICS_PATTERN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void waitForMetric(String metricName, int expectedValue) throws TimeoutException, InterruptedException {
        DFSTestUtil.waitForMetric(this.jmx, metricName, expectedValue);
    }

    protected void triggerEviction(DataNode dn) {
        FsDatasetImpl fsDataset = (FsDatasetImpl)dn.getFSDataset();
        fsDataset.evictLazyPersistBlocks(Long.MAX_VALUE);
    }

    static {
        DFSTestUtil.setNameNodeLogLevel(Level.DEBUG);
        GenericTestUtils.setLogLevel(FsDatasetImpl.LOG, Level.DEBUG);
        LOG = LoggerFactory.getLogger(LazyPersistTestCase.class);
    }

    class ClusterWithRamDiskBuilder {
        private int numDatanodes = 1;
        private StorageType[] storageTypes = null;
        private int ramDiskReplicaCapacity = -1;
        private long ramDiskStorageLimit = -1L;
        private long maxLockedMemory = Shell.getMemlockLimit((Long)Long.MAX_VALUE);
        private boolean hasTransientStorage = true;
        private boolean useScr = false;
        private boolean useLegacyBlockReaderLocal = false;
        private boolean disableScrubber = false;

        ClusterWithRamDiskBuilder() {
        }

        public ClusterWithRamDiskBuilder setNumDatanodes(int numDatanodes) {
            this.numDatanodes = numDatanodes;
            return this;
        }

        public ClusterWithRamDiskBuilder setStorageTypes(StorageType[] storageTypes) {
            this.storageTypes = storageTypes;
            return this;
        }

        public ClusterWithRamDiskBuilder setRamDiskReplicaCapacity(int ramDiskReplicaCapacity) {
            this.ramDiskReplicaCapacity = ramDiskReplicaCapacity;
            return this;
        }

        public ClusterWithRamDiskBuilder setRamDiskStorageLimit(long ramDiskStorageLimit) {
            this.ramDiskStorageLimit = ramDiskStorageLimit;
            return this;
        }

        public ClusterWithRamDiskBuilder setMaxLockedMemory(long maxLockedMemory) {
            this.maxLockedMemory = maxLockedMemory;
            return this;
        }

        public ClusterWithRamDiskBuilder setUseScr(boolean useScr) {
            this.useScr = useScr;
            return this;
        }

        public ClusterWithRamDiskBuilder setHasTransientStorage(boolean hasTransientStorage) {
            this.hasTransientStorage = hasTransientStorage;
            return this;
        }

        public ClusterWithRamDiskBuilder setUseLegacyBlockReaderLocal(boolean useLegacyBlockReaderLocal) {
            this.useLegacyBlockReaderLocal = useLegacyBlockReaderLocal;
            return this;
        }

        public ClusterWithRamDiskBuilder disableScrubber() {
            this.disableScrubber = true;
            return this;
        }

        public void build() throws IOException {
            LazyPersistTestCase.this.startUpCluster(this.numDatanodes, this.hasTransientStorage, this.storageTypes, this.ramDiskReplicaCapacity, this.ramDiskStorageLimit, this.maxLockedMemory, this.useScr, this.useLegacyBlockReaderLocal, this.disableScrubber);
        }
    }
}

