/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;

@InterfaceAudience.Private
public class XAttrPermissionFilter {
    static void checkPermissionForApi(FSPermissionChecker pc, XAttr xAttr, boolean isRawPath) throws AccessControlException {
        boolean isSuperUser = pc.isSuperUser();
        if (xAttr.getNameSpace() == XAttr.NameSpace.USER || xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED && isSuperUser) {
            return;
        }
        if (xAttr.getNameSpace() == XAttr.NameSpace.RAW && isRawPath) {
            return;
        }
        if (XAttrHelper.getPrefixedName((XAttr)xAttr).equals("security.hdfs.unreadable.by.superuser")) {
            if (xAttr.getValue() != null) {
                throw new AccessControlException("Attempt to set a value for 'security.hdfs.unreadable.by.superuser'. Values are not allowed for this xattr.");
            }
            return;
        }
        throw new AccessControlException("User doesn't have permission for xattr: " + XAttrHelper.getPrefixedName((XAttr)xAttr));
    }

    static void checkPermissionForApi(FSPermissionChecker pc, List<XAttr> xAttrs, boolean isRawPath) throws AccessControlException {
        Preconditions.checkArgument((xAttrs != null ? 1 : 0) != 0);
        if (xAttrs.isEmpty()) {
            return;
        }
        for (XAttr xAttr : xAttrs) {
            XAttrPermissionFilter.checkPermissionForApi(pc, xAttr, isRawPath);
        }
    }

    static List<XAttr> filterXAttrsForApi(FSPermissionChecker pc, List<XAttr> xAttrs, boolean isRawPath) {
        assert (xAttrs != null) : "xAttrs can not be null";
        if (xAttrs.isEmpty()) {
            return xAttrs;
        }
        ArrayList filteredXAttrs = Lists.newArrayListWithCapacity((int)xAttrs.size());
        boolean isSuperUser = pc.isSuperUser();
        for (XAttr xAttr : xAttrs) {
            if (xAttr.getNameSpace() == XAttr.NameSpace.USER) {
                filteredXAttrs.add(xAttr);
                continue;
            }
            if (xAttr.getNameSpace() == XAttr.NameSpace.TRUSTED && isSuperUser) {
                filteredXAttrs.add(xAttr);
                continue;
            }
            if (xAttr.getNameSpace() == XAttr.NameSpace.RAW && isRawPath) {
                filteredXAttrs.add(xAttr);
                continue;
            }
            if (!XAttrHelper.getPrefixedName((XAttr)xAttr).equals("security.hdfs.unreadable.by.superuser")) continue;
            filteredXAttrs.add(xAttr);
        }
        return filteredXAttrs;
    }
}

