/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.store.offheap;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.Store;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.BinaryValueHolder;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;

final class BinaryOffHeapValueHolder<V>
extends OffHeapValueHolder<V>
implements BinaryValueHolder {
    private final ByteBuffer binaryValue;
    private final V value;

    BinaryOffHeapValueHolder(long id, V value, ByteBuffer binaryValue, long creationTime, long expireTime, long lastAccessTime, long hits) {
        super(id, creationTime, expireTime);
        this.value = value;
        this.setLastAccessTime(lastAccessTime, TIME_UNIT);
        this.binaryValue = binaryValue;
        this.setHits(hits);
    }

    @Override
    public ByteBuffer getBinaryValue() throws IllegalStateException {
        return this.binaryValue.duplicate();
    }

    @Override
    public boolean isBinaryValueAvailable() {
        return true;
    }

    @Override
    void updateMetadata(Store.ValueHolder<V> valueFlushed) {
        throw new UnsupportedOperationException();
    }

    @Override
    void writeBack() {
        throw new UnsupportedOperationException();
    }

    @Override
    void forceDeserialization() {
        throw new UnsupportedOperationException();
    }

    @Override
    void detach() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V value() {
        return this.value;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException("This subclass of AbstractValueHolder is NOT serializable");
    }
}

