/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.AbstractPreemptableResourceCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class PreemptableResourceCalculator
extends AbstractPreemptableResourceCalculator {
    private static final Log LOG = LogFactory.getLog(PreemptableResourceCalculator.class);

    public PreemptableResourceCalculator(CapacitySchedulerPreemptionContext preemptionContext, boolean isReservedPreemptionCandidatesSelector, boolean allowQueuesBalanceAfterAllQueuesSatisfied) {
        super(preemptionContext, isReservedPreemptionCandidatesSelector, allowQueuesBalanceAfterAllQueuesSatisfied);
    }

    protected void computeIdealResourceDistribution(ResourceCalculator rc, List<TempQueuePerPartition> queues, Resource totalPreemptionAllowed, Resource tot_guarant) {
        ArrayList<TempQueuePerPartition> qAlloc = new ArrayList<TempQueuePerPartition>(queues);
        Resource unassigned = Resources.clone((Resource)tot_guarant);
        HashSet<TempQueuePerPartition> nonZeroGuarQueues = new HashSet<TempQueuePerPartition>();
        HashSet<TempQueuePerPartition> zeroGuarQueues = new HashSet<TempQueuePerPartition>();
        for (TempQueuePerPartition tempQueuePerPartition : qAlloc) {
            if (Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)tempQueuePerPartition.getGuaranteed(), (Resource)Resources.none())) {
                nonZeroGuarQueues.add(tempQueuePerPartition);
                continue;
            }
            zeroGuarQueues.add(tempQueuePerPartition);
        }
        this.computeFixpointAllocation(tot_guarant, new HashSet<TempQueuePerPartition>(nonZeroGuarQueues), unassigned, false);
        if (!zeroGuarQueues.isEmpty() && Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)unassigned, (Resource)Resources.none())) {
            this.computeFixpointAllocation(tot_guarant, zeroGuarQueues, unassigned, true);
        }
        Resource totPreemptionNeeded = Resource.newInstance((int)0, (int)0);
        for (TempQueuePerPartition t : queues) {
            if (!Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)t.getUsed(), (Resource)t.idealAssigned)) continue;
            Resources.addTo((Resource)totPreemptionNeeded, (Resource)Resources.subtract((Resource)t.getUsed(), (Resource)t.idealAssigned));
        }
        float f = 1.0f;
        if (Resources.greaterThan((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)totPreemptionNeeded, (Resource)totalPreemptionAllowed)) {
            f = Resources.divide((ResourceCalculator)rc, (Resource)tot_guarant, (Resource)totalPreemptionAllowed, (Resource)totPreemptionNeeded);
        }
        for (TempQueuePerPartition t : queues) {
            t.assignPreemption(f, rc, tot_guarant);
        }
    }

    protected void recursivelyComputeIdealAssignment(TempQueuePerPartition root, Resource totalPreemptionAllowed) {
        if (root.getChildren() != null && root.getChildren().size() > 0) {
            this.computeIdealResourceDistribution(this.rc, root.getChildren(), totalPreemptionAllowed, root.idealAssigned);
            for (TempQueuePerPartition t : root.getChildren()) {
                this.recursivelyComputeIdealAssignment(t, totalPreemptionAllowed);
            }
        }
    }

    private void calculateResToObtainByPartitionForLeafQueues(Set<String> leafQueueNames, Resource clusterResource) {
        for (String queueName : leafQueueNames) {
            if (this.context.getQueueByPartition((String)queueName, (String)"").preemptionDisabled) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("skipping from queue=" + queueName + " because it's a non-preemptable queue"));
                continue;
            }
            for (TempQueuePerPartition qT : this.context.getQueuePartitions(queueName)) {
                if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)qT.getUsed(), (Resource)Resources.multiply((Resource)qT.getGuaranteed(), (double)(1.0 + this.context.getMaxIgnoreOverCapacity())))) {
                    Resource resToObtain = qT.toBePreempted;
                    if (!this.isReservedPreemptionCandidatesSelector && Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)resToObtain, (Resource)Resource.newInstance((int)0, (int)0))) {
                        resToObtain = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.rc, (Resource)qT.toBePreempted, (double)this.context.getNaturalTerminationFactor(), (Resource)Resource.newInstance((int)1, (int)1));
                    }
                    if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)resToObtain, (Resource)Resources.none()) && LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Queue=" + queueName + " partition=" + qT.partition + " resource-to-obtain=" + resToObtain));
                    }
                    qT.setActuallyToBePreempted(Resources.clone((Resource)resToObtain));
                } else {
                    qT.setActuallyToBePreempted(Resources.none());
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)qT);
            }
        }
    }

    private void updatePreemptableExtras(TempQueuePerPartition cur) {
        if (cur.children == null || cur.children.isEmpty()) {
            cur.updatePreemptableExtras(this.rc);
        } else {
            for (TempQueuePerPartition child : cur.children) {
                this.updatePreemptableExtras(child);
            }
            cur.updatePreemptableExtras(this.rc);
        }
    }

    public void computeIdealAllocation(Resource clusterResource, Resource totalPreemptionAllowed) {
        for (String partition : this.context.getAllPartitions()) {
            TempQueuePerPartition tRoot = this.context.getQueueByPartition("root", partition);
            this.updatePreemptableExtras(tRoot);
            tRoot.initializeRootIdealWithGuarangeed();
            this.recursivelyComputeIdealAssignment(tRoot, totalPreemptionAllowed);
        }
        this.calculateResToObtainByPartitionForLeafQueues(this.context.getLeafQueueNames(), clusterResource);
    }
}

