/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Strings;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.nodelabels.AttributeValue;
import org.apache.hadoop.yarn.nodelabels.NodeAttributeStore;
import org.apache.hadoop.yarn.nodelabels.NodeAttributesManager;
import org.apache.hadoop.yarn.nodelabels.NodeLabelUtil;
import org.apache.hadoop.yarn.nodelabels.RMNodeAttribute;
import org.apache.hadoop.yarn.nodelabels.StringAttributeValue;
import org.apache.hadoop.yarn.server.api.protocolrecords.AttributeMappingOperationType;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeToAttributes;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.FileSystemNodeAttributeStore;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeAttributesStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeAttributesStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAttributesUpdateSchedulerEvent;

public class NodeAttributesManagerImpl
extends NodeAttributesManager {
    protected static final Log LOG = LogFactory.getLog(NodeAttributesManagerImpl.class);
    public static final String EMPTY_ATTRIBUTE_VALUE = "";
    Dispatcher dispatcher;
    NodeAttributeStore store;
    private ConcurrentHashMap<NodeAttributeKey, RMNodeAttribute> clusterAttributes = new ConcurrentHashMap();
    private ConcurrentMap<String, Host> nodeCollections = new ConcurrentHashMap<String, Host>();
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private RMContext rmContext = null;

    public NodeAttributesManagerImpl() {
        super("NodeAttributesManagerImpl");
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    protected void initDispatcher(Configuration conf) {
        this.dispatcher = new AsyncDispatcher("AttributeNodeLabelsManager dispatcher");
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.init(conf);
        asyncDispatcher.setDrainEventsOnStop();
    }

    protected void startDispatcher() {
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        asyncDispatcher.start();
    }

    protected void serviceStart() throws Exception {
        this.initNodeAttributeStore(this.getConfig());
        this.initDispatcher(this.getConfig());
        if (null != this.dispatcher) {
            this.dispatcher.register(NodeAttributesStoreEventType.class, (EventHandler)new ForwardingEventHandler());
        }
        this.startDispatcher();
        super.serviceStart();
    }

    protected void initNodeAttributeStore(Configuration conf) throws Exception {
        this.store = this.getAttributeStoreClass(conf);
        this.store.init(conf, (NodeAttributesManager)this);
        this.store.recover();
    }

    private NodeAttributeStore getAttributeStoreClass(Configuration conf) {
        try {
            return (NodeAttributeStore)ReflectionUtils.newInstance((Class)conf.getClass("yarn.node-attribute.fs-store.impl.class", FileSystemNodeAttributeStore.class, NodeAttributeStore.class), (Configuration)conf);
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Could not instantiate Node Attribute Store ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void internalUpdateAttributesOnNodes(Map<String, Map<NodeAttribute, AttributeValue>> nodeAttributeMapping, AttributeMappingOperationType op, Map<NodeAttributeKey, RMNodeAttribute> newAttributesToBeAdded, String attributePrefix) {
        try {
            this.writeLock.lock();
            StringBuilder logMsg = new StringBuilder(op.name());
            logMsg.append(" attributes on nodes:");
            for (Map.Entry<String, Map<NodeAttribute, AttributeValue>> entry : nodeAttributeMapping.entrySet()) {
                String nodeHost = entry.getKey();
                Map<NodeAttribute, AttributeValue> attributes = entry.getValue();
                Host node = (Host)this.nodeCollections.get(nodeHost);
                if (node == null) {
                    node = new Host(nodeHost);
                    this.nodeCollections.put(nodeHost, node);
                }
                switch (op) {
                    case REMOVE: {
                        this.removeNodeFromAttributes(nodeHost, attributes.keySet());
                        node.removeAttributes(attributes);
                        break;
                    }
                    case ADD: {
                        this.clusterAttributes.putAll(newAttributesToBeAdded);
                        this.addNodeToAttribute(nodeHost, attributes);
                        node.addAttributes(attributes);
                        break;
                    }
                    case REPLACE: {
                        this.clusterAttributes.putAll(newAttributesToBeAdded);
                        this.replaceNodeToAttribute(nodeHost, attributePrefix, node.getAttributes(), attributes);
                        node.replaceAttributes(attributes, attributePrefix);
                        break;
                    }
                }
                logMsg.append(" NM = ");
                logMsg.append(entry.getKey());
                logMsg.append(", attributes=[ ");
                logMsg.append(StringUtils.join(entry.getValue().keySet(), (String)","));
                logMsg.append("] ,");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)logMsg);
            }
            if (null != this.dispatcher && "rm.yarn.io".equals(attributePrefix)) {
                this.dispatcher.getEventHandler().handle((Event)new NodeAttributesStoreEvent(nodeAttributeMapping, op));
            }
            HashMap<String, Set<NodeAttribute>> newNodeToAttributesMap = new HashMap<String, Set<NodeAttribute>>();
            nodeAttributeMapping.forEach((k, v) -> {
                Host node = (Host)this.nodeCollections.get(k);
                newNodeToAttributesMap.put((String)k, node.attributes.keySet());
            });
            if (this.rmContext != null && this.rmContext.getDispatcher() != null) {
                LOG.info((Object)("Updated NodeAttribute event to RM:" + newNodeToAttributesMap));
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new NodeAttributesUpdateSchedulerEvent(newNodeToAttributesMap));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeNodeFromAttributes(String nodeHost, Set<NodeAttribute> attributeMappings) {
        for (NodeAttribute rmAttribute : attributeMappings) {
            RMNodeAttribute host = this.clusterAttributes.get(rmAttribute.getAttributeKey());
            if (host == null) continue;
            host.removeNode(nodeHost);
            if (!host.getAssociatedNodeIds().isEmpty()) continue;
            this.clusterAttributes.remove(rmAttribute.getAttributeKey());
        }
    }

    private void addNodeToAttribute(String nodeHost, Map<NodeAttribute, AttributeValue> attributeMappings) {
        for (Map.Entry<NodeAttribute, AttributeValue> attributeEntry : attributeMappings.entrySet()) {
            RMNodeAttribute rmNodeAttribute = this.clusterAttributes.get(attributeEntry.getKey().getAttributeKey());
            if (rmNodeAttribute != null) {
                rmNodeAttribute.addNode(nodeHost, attributeEntry.getValue());
                continue;
            }
            this.clusterAttributes.put(attributeEntry.getKey().getAttributeKey(), new RMNodeAttribute(attributeEntry.getKey()));
        }
    }

    private void replaceNodeToAttribute(String nodeHost, String prefix, Map<NodeAttribute, AttributeValue> oldAttributeMappings, Map<NodeAttribute, AttributeValue> newAttributeMappings) {
        if (oldAttributeMappings != null) {
            Set toRemoveAttributes = NodeLabelUtil.filterAttributesByPrefix(oldAttributeMappings.keySet(), (String)prefix);
            this.removeNodeFromAttributes(nodeHost, toRemoveAttributes);
        }
        this.addNodeToAttribute(nodeHost, newAttributeMappings);
    }

    protected Map<String, Map<NodeAttribute, AttributeValue>> validate(Map<String, Set<NodeAttribute>> nodeAttributeMapping, Map<NodeAttributeKey, RMNodeAttribute> newAttributesToBeAdded, boolean isRemoveOperation) throws IOException {
        TreeMap<String, Map<NodeAttribute, AttributeValue>> nodeToAttributesMap = new TreeMap<String, Map<NodeAttribute, AttributeValue>>();
        Set<Map.Entry<String, Set<NodeAttribute>>> entrySet = nodeAttributeMapping.entrySet();
        for (Map.Entry<String, Set<NodeAttribute>> nodeToAttrMappingEntry : entrySet) {
            HashMap<NodeAttribute, StringAttributeValue> attributesValues = new HashMap<NodeAttribute, StringAttributeValue>();
            String node = nodeToAttrMappingEntry.getKey().trim();
            if (nodeToAttrMappingEntry.getValue().isEmpty()) continue;
            for (NodeAttribute attribute : nodeToAttrMappingEntry.getValue()) {
                NodeAttributeKey attributeKey = attribute.getAttributeKey();
                String attributeName = attributeKey.getAttributeName().trim();
                NodeLabelUtil.checkAndThrowAttributeName((String)attributeName);
                NodeLabelUtil.checkAndThrowAttributePrefix((String)attributeKey.getAttributePrefix());
                NodeLabelUtil.checkAndThrowAttributeValue((String)attribute.getAttributeValue());
                attributeKey.setAttributeName(attributeName);
                attributeKey.setAttributePrefix(attributeKey.getAttributePrefix().trim());
                if (this.validateForAttributeTypeMismatch(isRemoveOperation, attribute, newAttributesToBeAdded)) {
                    newAttributesToBeAdded.put(attribute.getAttributeKey(), new RMNodeAttribute(attribute));
                }
                StringAttributeValue value = new StringAttributeValue();
                value.validateAndInitializeValue(this.normalizeAttributeValue(attribute.getAttributeValue()));
                attributesValues.put(attribute, value);
            }
            nodeToAttributesMap.put(node, attributesValues);
        }
        return nodeToAttributesMap;
    }

    private boolean validateForAttributeTypeMismatch(boolean isRemoveOperation, NodeAttribute attribute, Map<NodeAttributeKey, RMNodeAttribute> newAttributes) throws IOException {
        NodeAttribute existingAttribute;
        NodeAttributeKey attributeKey = attribute.getAttributeKey();
        if (isRemoveOperation && !this.clusterAttributes.containsKey(attributeKey)) {
            return false;
        }
        NodeAttribute nodeAttribute = this.clusterAttributes.containsKey(attributeKey) ? this.clusterAttributes.get(attributeKey).getAttribute() : (existingAttribute = newAttributes.containsKey(attributeKey) ? newAttributes.get(attributeKey).getAttribute() : null);
        if (existingAttribute == null) {
            return true;
        }
        if (existingAttribute.getAttributeType() != attribute.getAttributeType()) {
            throw new IOException("Attribute name - type is not matching with already configured mapping for the attribute " + attributeKey + " existing : " + existingAttribute.getAttributeType() + ", new :" + attribute.getAttributeType());
        }
        return false;
    }

    protected String normalizeAttributeValue(String value) {
        if (value != null) {
            return value.trim();
        }
        return EMPTY_ATTRIBUTE_VALUE;
    }

    public Set<NodeAttribute> getClusterNodeAttributes(Set<String> prefix) {
        HashSet<NodeAttribute> attributes = new HashSet<NodeAttribute>();
        Set<Map.Entry<NodeAttributeKey, RMNodeAttribute>> allAttributes = this.clusterAttributes.entrySet();
        boolean forAllPrefix = prefix == null || prefix.isEmpty();
        for (Map.Entry<NodeAttributeKey, RMNodeAttribute> current : allAttributes) {
            NodeAttributeKey attrID = current.getKey();
            RMNodeAttribute rmAttr = current.getValue();
            if (!forAllPrefix && !prefix.contains(attrID.getAttributePrefix())) continue;
            attributes.add(rmAttr.getAttribute());
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NodeAttributeKey, Map<String, AttributeValue>> getAttributesToNodes(Set<NodeAttributeKey> attributes) {
        try {
            this.readLock.lock();
            boolean fetchAllAttributes = attributes == null || attributes.isEmpty();
            HashMap<NodeAttributeKey, Map> attributesToNodes = new HashMap<NodeAttributeKey, Map>();
            for (Map.Entry<NodeAttributeKey, RMNodeAttribute> attributeEntry : this.clusterAttributes.entrySet()) {
                if (!fetchAllAttributes && !attributes.contains(attributeEntry.getKey())) continue;
                attributesToNodes.put(attributeEntry.getKey(), attributeEntry.getValue().getAssociatedNodeIds());
            }
            HashMap<NodeAttributeKey, Map> hashMap = attributesToNodes;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Resource getResourceByAttribute(NodeAttribute attribute) {
        try {
            this.readLock.lock();
            Resource resource = this.clusterAttributes.containsKey(attribute.getAttributeKey()) ? this.clusterAttributes.get(attribute.getAttributeKey()).getResource() : Resource.newInstance((int)0, (int)0);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<NodeAttribute, AttributeValue> getAttributesForNode(String hostName) {
        try {
            this.readLock.lock();
            HashMap<NodeAttribute, AttributeValue> hashMap = this.nodeCollections.containsKey(hostName) ? ((Host)this.nodeCollections.get(hostName)).getAttributes() : new HashMap<NodeAttribute, AttributeValue>();
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeToAttributes> getNodeToAttributes(Set<String> prefix) {
        try {
            this.readLock.lock();
            ArrayList<NodeToAttributes> nodeToAttributes = new ArrayList<NodeToAttributes>();
            this.nodeCollections.forEach((k, v) -> {
                ArrayList<Object> attrs;
                if (prefix == null || prefix.isEmpty()) {
                    attrs = new ArrayList(((Host)v).getAttributes().keySet());
                } else {
                    attrs = new ArrayList();
                    for (Map.Entry nodeAttr : ((Host)v).attributes.entrySet()) {
                        if (!prefix.contains(((NodeAttribute)nodeAttr.getKey()).getAttributeKey().getAttributePrefix())) continue;
                        attrs.add(nodeAttr.getKey());
                    }
                }
                nodeToAttributes.add(NodeToAttributes.newInstance((String)k, attrs));
            });
            ArrayList<NodeToAttributes> arrayList = nodeToAttributes;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<NodeAttribute>> getNodesToAttributes(Set<String> hostNames) {
        try {
            this.readLock.lock();
            boolean fetchAllNodes = hostNames == null || hostNames.isEmpty();
            HashMap nodeToAttrs = new HashMap();
            if (fetchAllNodes) {
                this.nodeCollections.forEach((key, value) -> nodeToAttrs.put((String)key, ((Host)value).getAttributes().keySet()));
            } else {
                for (String hostName : hostNames) {
                    Host host = (Host)this.nodeCollections.get(hostName);
                    if (host == null) continue;
                    nodeToAttrs.put(hostName, host.getAttributes().keySet());
                }
            }
            HashMap hashMap = nodeToAttrs;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateNode(NodeId nodeId, Resource resource) {
        try {
            this.writeLock.lock();
            String hostName = nodeId.getHost();
            Host host = (Host)this.nodeCollections.get(hostName);
            if (host == null) {
                host = new Host(hostName);
                this.nodeCollections.put(hostName, host);
            }
            host.activateNode(resource);
            for (NodeAttribute attribute : host.getAttributes().keySet()) {
                this.clusterAttributes.get(attribute.getAttributeKey()).removeNode(resource);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateNode(NodeId nodeId) {
        try {
            this.writeLock.lock();
            Host host = (Host)this.nodeCollections.get(nodeId.getHost());
            for (NodeAttribute attribute : host.getAttributes().keySet()) {
                this.clusterAttributes.get(attribute.getAttributeKey()).removeNode(host.getResource());
            }
            host.deactivateNode();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void updateNodeResource(NodeId node, Resource newResource) {
        this.deactivateNode(node);
        this.activateNode(node, newResource);
    }

    protected void handleStoreEvent(NodeAttributesStoreEvent event) {
        ArrayList mappingList = new ArrayList();
        Map<String, Map<NodeAttribute, AttributeValue>> nodeToAttr = event.getNodeAttributeMappingList();
        nodeToAttr.forEach((k, v) -> mappingList.add(NodeToAttributes.newInstance((String)k, new ArrayList(v.keySet()))));
        try {
            switch (event.getOperation()) {
                case REPLACE: {
                    this.store.replaceNodeAttributes(mappingList);
                    break;
                }
                case ADD: {
                    this.store.addNodeAttributes(mappingList);
                    break;
                }
                case REMOVE: {
                    this.store.removeNodeAttributes(mappingList);
                    break;
                }
                default: {
                    LOG.warn((Object)"Unsupported operation");
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to store attribute modification to storage");
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public void replaceNodeAttributes(String prefix, Map<String, Set<NodeAttribute>> nodeAttributeMapping) throws IOException {
        this.processMapping(nodeAttributeMapping, AttributeMappingOperationType.REPLACE, prefix);
    }

    public void addNodeAttributes(Map<String, Set<NodeAttribute>> nodeAttributeMapping) throws IOException {
        this.processMapping(nodeAttributeMapping, AttributeMappingOperationType.ADD);
    }

    public void removeNodeAttributes(Map<String, Set<NodeAttribute>> nodeAttributeMapping) throws IOException {
        this.processMapping(nodeAttributeMapping, AttributeMappingOperationType.REMOVE);
    }

    private void processMapping(Map<String, Set<NodeAttribute>> nodeAttributeMapping, AttributeMappingOperationType mappingType) throws IOException {
        this.processMapping(nodeAttributeMapping, mappingType, "rm.yarn.io");
    }

    private void processMapping(Map<String, Set<NodeAttribute>> nodeAttributeMapping, AttributeMappingOperationType mappingType, String attributePrefix) throws IOException {
        HashMap<NodeAttributeKey, RMNodeAttribute> newAttributesToBeAdded = new HashMap<NodeAttributeKey, RMNodeAttribute>();
        Map<String, Map<NodeAttribute, AttributeValue>> validMapping = this.validate(nodeAttributeMapping, newAttributesToBeAdded, false);
        if (validMapping.size() > 0) {
            this.internalUpdateAttributesOnNodes(validMapping, mappingType, newAttributesToBeAdded, attributePrefix);
        }
    }

    protected void stopDispatcher() {
        AsyncDispatcher asyncDispatcher = (AsyncDispatcher)this.dispatcher;
        if (null != asyncDispatcher) {
            asyncDispatcher.stop();
        }
    }

    protected void serviceStop() throws Exception {
        this.stopDispatcher();
        if (null != this.store) {
            this.store.close();
        }
    }

    public void setRMContext(RMContext context) {
        this.rmContext = context;
    }

    public void refreshNodeAttributesToScheduler(NodeId nodeId) {
        String hostName = nodeId.getHost();
        HashMap<String, Set<NodeAttribute>> newNodeToAttributesMap = new HashMap<String, Set<NodeAttribute>>();
        Host host = (Host)this.nodeCollections.get(hostName);
        if (host == null || host.attributes == null) {
            return;
        }
        newNodeToAttributesMap.put(hostName, host.attributes.keySet());
        if (this.rmContext != null && this.rmContext.getDispatcher() != null) {
            LOG.info((Object)("Updated NodeAttribute event to RM:" + newNodeToAttributesMap));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new NodeAttributesUpdateSchedulerEvent(newNodeToAttributesMap));
        }
    }

    private final class ForwardingEventHandler
    implements EventHandler<NodeAttributesStoreEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(NodeAttributesStoreEvent event) {
            NodeAttributesManagerImpl.this.handleStoreEvent(event);
        }
    }

    public static class Host {
        private String hostName;
        private Map<NodeAttribute, AttributeValue> attributes;
        private Resource resource;
        private boolean isActive;

        private Map<NodeAttribute, AttributeValue> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<NodeAttribute, AttributeValue> attributes) {
            this.attributes = attributes;
        }

        public void removeAttributes(Map<NodeAttribute, AttributeValue> attributesMapping) {
            for (NodeAttribute attribute : attributesMapping.keySet()) {
                this.attributes.remove(attribute);
            }
        }

        public void replaceAttributes(Map<NodeAttribute, AttributeValue> attributesMapping, String prefix) {
            if (Strings.isNullOrEmpty((String)prefix)) {
                this.attributes.clear();
            } else {
                Iterator<Map.Entry<NodeAttribute, AttributeValue>> it = this.attributes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<NodeAttribute, AttributeValue> current = it.next();
                    if (!prefix.equals(current.getKey().getAttributeKey().getAttributePrefix())) continue;
                    it.remove();
                }
            }
            this.attributes.putAll(attributesMapping);
        }

        public void addAttributes(Map<NodeAttribute, AttributeValue> attributesMapping) {
            this.attributes.putAll(attributesMapping);
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resourceParam) {
            this.resource = resourceParam;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void deactivateNode() {
            this.isActive = false;
            this.resource = Resource.newInstance((int)0, (int)0);
        }

        public void activateNode(Resource r) {
            this.isActive = true;
            this.resource = r;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public Host(String hostName) {
            this(hostName, new HashMap<NodeAttribute, AttributeValue>());
        }

        public Host(String hostName, Map<NodeAttribute, AttributeValue> attributes) {
            this(hostName, attributes, Resource.newInstance((int)0, (int)0), false);
        }

        public Host(String hostName, Map<NodeAttribute, AttributeValue> attributes, Resource resource, boolean isActive) {
            this.attributes = attributes;
            this.resource = resource;
            this.isActive = isActive;
            this.hostName = hostName;
        }
    }
}

