/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.inject.Singleton;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.Client;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientHandler;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.WebResource;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.config.ClientConfig;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.config.DefaultClientConfig;
import org.apache.hadoop.shaded.com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import org.apache.hadoop.shaded.com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import org.apache.hadoop.shaded.com.sun.jersey.core.util.MultivaluedMapImpl;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.javax.ws.rs.DefaultValue;
import org.apache.hadoop.shaded.javax.ws.rs.GET;
import org.apache.hadoop.shaded.javax.ws.rs.Path;
import org.apache.hadoop.shaded.javax.ws.rs.PathParam;
import org.apache.hadoop.shaded.javax.ws.rs.Produces;
import org.apache.hadoop.shaded.javax.ws.rs.QueryParam;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.webapp.LogWebServiceUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v2/applicationlog")
public class LogWebService {
    private static final Logger LOG = LoggerFactory.getLogger(LogWebService.class);
    private static final String RESOURCE_URI_STR_V2 = "/ws/v2/timeline/";
    private static final String NM_DOWNLOAD_URI_STR = "/ws/v1/node/containers";
    private static final Joiner JOINER = Joiner.on((String)"");
    private static Configuration yarnConf = new YarnConfiguration();
    private static LogAggregationFileControllerFactory factory;
    private static String base;
    private static String defaultClusterid;
    private volatile Client webTimelineClient;

    private static void init() {
        factory = new LogAggregationFileControllerFactory(yarnConf);
        base = JOINER.join((Object)WebAppUtils.getHttpSchemePrefix((Configuration)yarnConf), (Object)WebAppUtils.getTimelineReaderWebAppURLWithoutScheme((Configuration)yarnConf), new Object[]{RESOURCE_URI_STR_V2});
        defaultClusterid = yarnConf.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
        LOG.info("Initialized LogWeService with clusterid " + defaultClusterid + " for URI: " + base);
    }

    private Client createTimelineWebClient() {
        DefaultClientConfig cfg = new DefaultClientConfig();
        cfg.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                AuthenticatedURL.Token token = new AuthenticatedURL.Token();
                HttpURLConnection conn = null;
                try {
                    conn = new AuthenticatedURL().openConnection(url, token);
                    LOG.info("LogWeService:Connecetion created.");
                }
                catch (AuthenticationException e) {
                    throw new IOException(e);
                }
                return conn;
            }
        }), (ClientConfig)cfg);
        return client;
    }

    private void initForReadableEndpoints(HttpServletResponse response) {
        response.setContentType(null);
    }

    @GET
    @Path(value="/containers/{containerid}/logs")
    @Produces(value={"application/json", "application/xml"})
    public Response getContainerLogsInfo(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirectedFromNode, @QueryParam(value="clusterid") String clusterId) {
        AppInfo appInfo;
        ContainerId containerId = null;
        this.initForReadableEndpoints(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("invalid container id, " + containerIdStr);
        }
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = this.getApp(req, appId.toString(), clusterId);
        }
        catch (Exception ex) {
            return LogWebServiceUtils.getContainerLogMeta(factory, appId, null, null, containerIdStr, false);
        }
        if (LogWebServiceUtils.isFinishedState(appInfo.getAppState())) {
            return LogWebServiceUtils.getContainerLogMeta(factory, appId, null, null, containerIdStr, false);
        }
        if (LogWebServiceUtils.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress;
            String appOwner;
            block14: {
                appOwner = appInfo.getUser();
                nodeHttpAddress = null;
                if (nmId != null && !nmId.isEmpty()) {
                    try {
                        nodeHttpAddress = LogWebServiceUtils.getNMWebAddressFromRM(yarnConf, nmId);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(ex.getMessage());
                    }
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                ContainerInfo containerInfo;
                try {
                    containerInfo = this.getContainer(req, appId.toString(), containerId.toString(), clusterId);
                }
                catch (Exception ex) {
                    return LogWebServiceUtils.getContainerLogMeta(factory, appId, appOwner, null, containerIdStr, true);
                }
                nodeHttpAddress = containerInfo.getNodeHttpAddress();
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirectedFromNode) {
                    return LogWebServiceUtils.getContainerLogMeta(factory, appId, appOwner, null, containerIdStr, true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs";
            String resURI = JOINER.join((Object)LogWebServiceUtils.getAbsoluteNMWebAddress(yarnConf, nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        throw new NotFoundException("The application is not at Running or Finished State.");
    }

    protected ContainerInfo getContainer(HttpServletRequest req, String appId, String containerId, String clusterId) {
        UserGroupInformation callerUGI = LogWebServiceUtils.getUser(req);
        String cId = clusterId != null ? clusterId : defaultClusterid;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)"INFO");
        final String path = JOINER.join((Object)"clusters/", (Object)cId, new Object[]{"/apps/", appId, "/entities/", TimelineEntityType.YARN_CONTAINER.toString(), "/", containerId});
        TimelineEntity conEntity = null;
        try {
            if (callerUGI == null) {
                conEntity = this.getEntity(path, (MultivaluedMap<String, String>)params);
            } else {
                this.setUserName((MultivaluedMap<String, String>)params, callerUGI.getShortUserName());
                conEntity = (TimelineEntity)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineEntity>((MultivaluedMap)params){
                    final /* synthetic */ MultivaluedMap val$params;
                    {
                        this.val$params = multivaluedMap;
                    }

                    @Override
                    public TimelineEntity run() throws Exception {
                        return LogWebService.this.getEntity(path, (MultivaluedMap<String, String>)this.val$params);
                    }
                });
            }
        }
        catch (Exception e) {
            LogWebServiceUtils.rewrapAndThrowException(e);
        }
        if (conEntity == null) {
            return null;
        }
        String nodeHttpAddress = (String)conEntity.getInfo().get("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS");
        ContainerInfo info = new ContainerInfo(nodeHttpAddress);
        return info;
    }

    protected AppInfo getApp(HttpServletRequest req, String appId, String clusterId) {
        UserGroupInformation callerUGI = LogWebServiceUtils.getUser(req);
        String cId = clusterId != null ? clusterId : defaultClusterid;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"fields", (Object)"INFO");
        final String path = JOINER.join((Object)"clusters/", (Object)cId, new Object[]{"/apps/", appId});
        TimelineEntity appEntity = null;
        try {
            if (callerUGI == null) {
                appEntity = this.getEntity(path, (MultivaluedMap<String, String>)params);
            } else {
                this.setUserName((MultivaluedMap<String, String>)params, callerUGI.getShortUserName());
                appEntity = (TimelineEntity)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineEntity>((MultivaluedMap)params){
                    final /* synthetic */ MultivaluedMap val$params;
                    {
                        this.val$params = multivaluedMap;
                    }

                    @Override
                    public TimelineEntity run() throws Exception {
                        return LogWebService.this.getEntity(path, (MultivaluedMap<String, String>)this.val$params);
                    }
                });
            }
        }
        catch (Exception e) {
            LogWebServiceUtils.rewrapAndThrowException(e);
        }
        if (appEntity == null) {
            return null;
        }
        String appOwner = (String)appEntity.getInfo().get("YARN_APPLICATION_USER");
        String state = (String)appEntity.getInfo().get("YARN_APPLICATION_STATE");
        YarnApplicationState appState = YarnApplicationState.valueOf((String)state);
        AppInfo info = new AppInfo(appState, appOwner);
        return info;
    }

    @GET
    @Path(value="/containers/{containerid}/logs/{filename}")
    @Produces(value={"text/plain"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getContainerLogFile(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") boolean redirectedFromNode, @QueryParam(value="clusterid") String clusterId) {
        return this.getLogs(req, res, containerIdStr, filename, format, size, nmId, redirectedFromNode, clusterId);
    }

    @GET
    @Path(value="/containerlogs/{containerid}/{filename}")
    @Produces(value={"text/plain; charset=utf-8"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getLogs(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirectedFromNode, @QueryParam(value="clusterid") String clusterId) {
        AppInfo appInfo;
        ContainerId containerId;
        this.initForReadableEndpoints(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException ex) {
            return LogWebServiceUtils.createBadResponse(Response.Status.NOT_FOUND, "Invalid ContainerId: " + containerIdStr);
        }
        long length = LogWebServiceUtils.parseLongParam(size);
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = this.getApp(req, appId.toString(), clusterId);
        }
        catch (Exception ex) {
            return LogWebServiceUtils.sendStreamOutputResponse(factory, appId, null, null, containerIdStr, filename, format, length, false);
        }
        String appOwner = appInfo.getUser();
        if (LogWebServiceUtils.isFinishedState(appInfo.getAppState())) {
            return LogWebServiceUtils.sendStreamOutputResponse(factory, appId, appOwner, null, containerIdStr, filename, format, length, false);
        }
        if (LogWebServiceUtils.isRunningState(appInfo.getAppState())) {
            String nodeHttpAddress;
            block14: {
                nodeHttpAddress = null;
                if (nmId != null && !nmId.isEmpty()) {
                    try {
                        nodeHttpAddress = LogWebServiceUtils.getNMWebAddressFromRM(yarnConf, nmId);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(ex.getMessage());
                    }
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                ContainerInfo containerInfo;
                try {
                    containerInfo = this.getContainer(req, appId.toString(), containerId.toString(), clusterId);
                }
                catch (Exception ex) {
                    return LogWebServiceUtils.sendStreamOutputResponse(factory, appId, appOwner, null, containerIdStr, filename, format, length, true);
                }
                nodeHttpAddress = containerInfo.getNodeHttpAddress();
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirectedFromNode) {
                    return LogWebServiceUtils.sendStreamOutputResponse(factory, appId, appOwner, null, containerIdStr, filename, format, length, true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs/" + filename;
            String resURI = JOINER.join((Object)LogWebServiceUtils.getAbsoluteNMWebAddress(yarnConf, nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        return LogWebServiceUtils.createBadResponse(Response.Status.NOT_FOUND, "The application is not at Running or Finished State.");
    }

    @VisibleForTesting
    protected TimelineEntity getEntity(String path, MultivaluedMap<String, String> params) throws IOException {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getClient().resource(base).path(path).queryParams(params).accept(new String[]{"application/json"}).type("application/json")).get(ClientResponse.class);
        if (resp == null || resp.getStatusInfo().getStatusCode() != ClientResponse.Status.OK.getStatusCode()) {
            String msg = "Response from the timeline reader server is " + (resp == null ? "null" : "not successful, HTTP error code: " + resp.getStatus() + ", Server response:\n" + (String)resp.getEntity(String.class));
            LOG.error(msg);
            throw new IOException(msg);
        }
        TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Client getClient() {
        if (this.webTimelineClient != null) return this.webTimelineClient;
        Class<LogWebService> clazz = LogWebService.class;
        synchronized (LogWebService.class) {
            if (this.webTimelineClient != null) return this.webTimelineClient;
            this.webTimelineClient = this.createTimelineWebClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.webTimelineClient;
        }
    }

    private void setUserName(MultivaluedMap<String, String> params, String user) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            params.add((Object)"user.name", (Object)user);
        }
    }

    static {
        LogWebService.init();
    }

    protected static class ContainerInfo {
        private String nodeHttpAddress;

        ContainerInfo(String nodeHttpAddress) {
            this.nodeHttpAddress = nodeHttpAddress;
        }

        public String getNodeHttpAddress() {
            return this.nodeHttpAddress;
        }
    }

    protected static class AppInfo {
        private YarnApplicationState appState;
        private String user;

        AppInfo(YarnApplicationState appState, String user) {
            this.appState = appState;
            this.user = user;
        }

        public YarnApplicationState getAppState() {
            return this.appState;
        }

        public String getUser() {
            return this.user;
        }
    }
}

