/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.shaded.javax.servlet.DispatcherType;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.BadMessageException;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpFields;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpGenerator;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpHeader;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpMethod;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpScheme;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpStatus;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpVersion;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.MetaData;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.ByteBufferPool;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.ChannelEndPoint;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.Connection;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.EndPoint;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.QuietException;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Connector;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.HttpChannelState;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.HttpConfiguration;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.HttpInput;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.HttpOutput;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.HttpTransport;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Request;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.RequestLog;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.RequestLogCollection;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Response;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Server;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.handler.ContextHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.handler.ErrorHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.Callback;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.SharedBlockingCallback;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannel
implements Runnable,
HttpOutput.Interceptor {
    private static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final AtomicBoolean _committed = new AtomicBoolean();
    private final AtomicBoolean _responseCompleted = new AtomicBoolean();
    private final AtomicLong _requests = new AtomicLong();
    private final Connector _connector;
    private final Executor _executor;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpTransport _transport;
    private final HttpChannelState _state;
    private final Request _request;
    private final Response _response;
    private HttpFields _trailers;
    private final Supplier<HttpFields> _trailerSupplier = () -> this._trailers;
    private final List<Listener> _listeners;
    private MetaData.Response _committedMetaData;
    private RequestLog _requestLog;
    private long _oldIdleTimeout;
    private long _written;

    public HttpChannel(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport) {
        this._connector = connector;
        this._configuration = configuration;
        this._endPoint = endPoint;
        this._transport = transport;
        this._state = new HttpChannelState(this);
        this._request = new Request(this, this.newHttpInput(this._state));
        this._response = new Response(this, this.newHttpOutput());
        this._executor = connector == null ? null : connector.getServer().getThreadPool();
        this._requestLog = connector == null ? null : connector.getServer().getRequestLog();
        ArrayList<Listener> listeners = new ArrayList<Listener>();
        if (connector != null) {
            listeners.addAll(connector.getBeans(Listener.class));
        }
        this._listeners = listeners;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new {} -> {},{},{}", new Object[]{this, this._endPoint, this._endPoint == null ? null : this._endPoint.getConnection(), this._state});
        }
    }

    protected HttpInput newHttpInput(HttpChannelState state) {
        return new HttpInput(state);
    }

    protected HttpOutput newHttpOutput() {
        return new HttpOutput(this);
    }

    public HttpChannelState getState() {
        return this._state;
    }

    public boolean addListener(Listener listener) {
        return this._listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this._listeners.remove(listener);
    }

    public long getBytesWritten() {
        return this._written;
    }

    public long getRequests() {
        return this._requests.get();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpTransport getHttpTransport() {
        return this._transport;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public void setRequestLog(RequestLog requestLog) {
        this._requestLog = requestLog;
    }

    public void addRequestLog(RequestLog requestLog) {
        if (this._requestLog == null) {
            this._requestLog = requestLog;
        } else if (this._requestLog instanceof RequestLogCollection) {
            ((RequestLogCollection)this._requestLog).add(requestLog);
        } else {
            this._requestLog = new RequestLogCollection(this._requestLog, requestLog);
        }
    }

    public MetaData.Response getCommittedMetaData() {
        return this._committedMetaData;
    }

    public long getIdleTimeout() {
        return this._endPoint.getIdleTimeout();
    }

    public void setIdleTimeout(long timeoutMs) {
        this._endPoint.setIdleTimeout(timeoutMs);
    }

    public ByteBufferPool getByteBufferPool() {
        return this._connector.getByteBufferPool();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return this.getHttpTransport().isOptimizedForDirectBuffers();
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public Connection getConnection() {
        return this._endPoint.getConnection();
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    public InetSocketAddress getLocalAddress() {
        return this._endPoint.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._endPoint.getRemoteAddress();
    }

    public void continue100(int available) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void recycle() {
        this._committed.set(false);
        this._responseCompleted.set(false);
        this._request.recycle();
        this._response.recycle();
        this._committedMetaData = null;
        this._requestLog = this._connector == null ? null : this._connector.getServer().getRequestLog();
        this._written = 0L;
        this._trailers = null;
        this._oldIdleTimeout = 0L;
    }

    public void onAsyncWaitForContent() {
    }

    public void onBlockWaitForContent() {
    }

    public void onBlockWaitForContentFailure(Throwable failure) {
        this.getRequest().getHttpInput().failed(failure);
    }

    @Override
    public void run() {
        this.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handle {} ", new Object[]{this, this._request.getHttpURI()});
        }
        HttpChannelState.Action action = this._state.handling();
        block34: while (!this.getServer().isStopped()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} action {}", new Object[]{this, action});
                }
                switch (action) {
                    case TERMINATED: 
                    case WAIT: {
                        break block34;
                    }
                    case NOOP: {
                        break;
                    }
                    case DISPATCH: {
                        if (!this._request.hasMetaData()) {
                            throw new IllegalStateException("state=" + this._state);
                        }
                        this._request.setHandled(false);
                        this._response.getHttpOutput().reopen();
                        try {
                            this._request.setDispatcherType(DispatcherType.REQUEST);
                            this.notifyBeforeDispatch(this._request);
                            List<HttpConfiguration.Customizer> customizers = this._configuration.getCustomizers();
                            if (!customizers.isEmpty()) {
                                for (HttpConfiguration.Customizer customizer : customizers) {
                                    customizer.customize(this.getConnector(), this._configuration, this._request);
                                    if (!this._request.isHandled()) continue;
                                    break;
                                }
                            }
                            if (!this._request.isHandled()) {
                                this.getServer().handle(this);
                            }
                            break;
                        }
                        catch (Throwable x) {
                            this.notifyDispatchFailure(this._request, x);
                            throw x;
                        }
                        finally {
                            this.notifyAfterDispatch(this._request);
                            this._request.setDispatcherType(null);
                        }
                    }
                    case ASYNC_DISPATCH: {
                        this._request.setHandled(false);
                        this._response.getHttpOutput().reopen();
                        try {
                            this._request.setDispatcherType(DispatcherType.ASYNC);
                            this.notifyBeforeDispatch(this._request);
                            this.getServer().handleAsync(this);
                            break;
                        }
                        catch (Throwable x) {
                            this.notifyDispatchFailure(this._request, x);
                            throw x;
                        }
                        finally {
                            this.notifyAfterDispatch(this._request);
                            this._request.setDispatcherType(null);
                        }
                    }
                    case ERROR_DISPATCH: {
                        try {
                            this._response.reset(true);
                            Integer icode = (Integer)this._request.getAttribute("org.apache.hadoop.shaded.javax.servlet.error.status_code");
                            int code = icode != null ? icode : 500;
                            this._response.setStatus(code);
                            this._request.setAttribute("org.apache.hadoop.shaded.javax.servlet.error.status_code", code);
                            this._request.setHandled(false);
                            this._response.getHttpOutput().reopen();
                            try {
                                this._request.setDispatcherType(DispatcherType.ERROR);
                                this.notifyBeforeDispatch(this._request);
                                this.getServer().handle(this);
                                break;
                            }
                            catch (Throwable x) {
                                this.notifyDispatchFailure(this._request, x);
                                throw x;
                            }
                            finally {
                                this.notifyAfterDispatch(this._request);
                                this._request.setDispatcherType(null);
                            }
                        }
                        catch (Throwable x) {
                            Throwable failure;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Could not perform ERROR dispatch, aborting", x);
                            }
                            if ((failure = (Throwable)this._request.getAttribute("org.apache.hadoop.shaded.javax.servlet.error.exception")) == null) {
                                this.minimalErrorResponse(x);
                                break;
                            }
                            if (x != failure) {
                                failure.addSuppressed(x);
                            }
                            this.minimalErrorResponse(failure);
                            break;
                        }
                    }
                    case ASYNC_ERROR: {
                        throw this._state.getAsyncContextEvent().getThrowable();
                    }
                    case READ_PRODUCE: {
                        this._request.getHttpInput().asyncReadProduce();
                        break;
                    }
                    case READ_CALLBACK: {
                        ContextHandler handler = this._state.getContextHandler();
                        if (handler != null) {
                            handler.handle(this._request, this._request.getHttpInput());
                            break;
                        }
                        this._request.getHttpInput().run();
                        break;
                    }
                    case WRITE_CALLBACK: {
                        ContextHandler handler = this._state.getContextHandler();
                        if (handler != null) {
                            handler.handle(this._request, this._response.getHttpOutput());
                            break;
                        }
                        this._response.getHttpOutput().run();
                        break;
                    }
                    case COMPLETE: {
                        try {
                            if (!this._response.isCommitted() && !this._request.isHandled()) {
                                this._response.sendError(404);
                            } else {
                                boolean hasContent;
                                int status = this._response.getStatus();
                                boolean bl = hasContent = !this._request.isHead() && (!HttpMethod.CONNECT.is(this._request.getMethod()) || status != 200) && !HttpStatus.isInformational(status) && status != 204 && status != 304;
                                if (hasContent && !this._response.isContentComplete(this._response.getHttpOutput().getWritten())) {
                                    if (this.isCommitted()) {
                                        this.abort(new IOException("insufficient content written"));
                                    } else {
                                        this._response.sendError(500, "insufficient content written");
                                    }
                                }
                            }
                            this._response.closeOutput();
                            break block34;
                        }
                        finally {
                            this._request.setHandled(true);
                            this._state.onComplete();
                            this.onCompleted();
                        }
                    }
                    default: {
                        throw new IllegalStateException("state=" + this._state);
                    }
                }
            }
            catch (Throwable failure) {
                if ("org.apache.hadoop.shaded.org.eclipse.jetty.continuation.ContinuationThrowable".equals(failure.getClass().getName())) {
                    LOG.ignore(failure);
                }
                this.handleException(failure);
            }
            action = this._state.unhandle();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handle exit, result {}", new Object[]{this, action});
        }
        boolean suspended = action == HttpChannelState.Action.WAIT;
        return !suspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(int code, String reason) {
        try {
            this._response.sendError(code, reason);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not send error " + code + " " + reason, x);
            }
        }
        finally {
            this._state.errorComplete();
        }
    }

    protected void handleException(Throwable failure) {
        Throwable quiet = this.unwrap(failure, QuietException.class);
        Throwable noStack = this.unwrap(failure, BadMessageException.class, IOException.class, TimeoutException.class);
        if (quiet != null || !this.getServer().isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this._request.getRequestURI(), failure);
            }
        } else if (noStack != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this._request.getRequestURI(), failure);
            } else {
                LOG.warn("{} {}", new Object[]{this._request.getRequestURI(), noStack.toString()});
            }
        } else {
            LOG.warn(this._request.getRequestURI(), failure);
        }
        try {
            this._state.onError(failure);
        }
        catch (Throwable e) {
            if (e != failure) {
                failure.addSuppressed(e);
            }
            LOG.warn("ERROR dispatch failed", failure);
            this.minimalErrorResponse(failure);
        }
    }

    protected Throwable unwrap(Throwable failure, Class<?> ... targets) {
        while (failure != null) {
            for (Class<?> x : targets) {
                if (!x.isInstance(failure)) continue;
                return failure;
            }
            failure = failure.getCause();
        }
        return null;
    }

    private void minimalErrorResponse(Throwable failure) {
        try {
            int code = 500;
            Integer status = (Integer)this._request.getAttribute("org.apache.hadoop.shaded.javax.servlet.error.status_code");
            if (status != null) {
                code = status;
            } else {
                Throwable cause = this.unwrap(failure, BadMessageException.class);
                if (cause instanceof BadMessageException) {
                    code = ((BadMessageException)cause).getCode();
                }
            }
            this._response.reset(true);
            this._response.setStatus(code);
            this._response.flushBuffer();
        }
        catch (Throwable x) {
            if (x != failure) {
                failure.addSuppressed(x);
            }
            this.abort(failure);
        }
    }

    public boolean isExpecting100Continue() {
        return false;
    }

    public boolean isExpecting102Processing() {
        return false;
    }

    public String toString() {
        long timeStamp = this._request.getTimeStamp();
        return String.format("%s@%x{r=%s,c=%b,c=%b/%b,a=%s,uri=%s,age=%d}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._requests, this._committed.get(), this.isRequestCompleted(), this.isResponseCompleted(), this._state.getState(), this._request.getHttpURI(), timeStamp == 0L ? 0L : System.currentTimeMillis() - timeStamp});
    }

    public void onRequest(MetaData.Request request) {
        this._requests.incrementAndGet();
        this._request.setTimeStamp(System.currentTimeMillis());
        HttpFields fields = this._response.getHttpFields();
        if (this._configuration.getSendDateHeader() && !fields.contains(HttpHeader.DATE)) {
            fields.put(this._connector.getServer().getDateField());
        }
        long idleTO = this._configuration.getIdleTimeout();
        this._oldIdleTimeout = this.getIdleTimeout();
        if (idleTO >= 0L && this._oldIdleTimeout != idleTO) {
            this.setIdleTimeout(idleTO);
        }
        request.setTrailerSupplier(this._trailerSupplier);
        this._request.setMetaData(request);
        this._request.setSecure(HttpScheme.HTTPS.is(request.getURI().getScheme()));
        this.notifyRequestBegin(this._request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("REQUEST for {} on {}{}{} {} {}{}{}", new Object[]{request.getURIString(), this, System.lineSeparator(), request.getMethod(), request.getURIString(), request.getHttpVersion(), System.lineSeparator(), request.getFields()});
        }
    }

    public boolean onContent(HttpInput.Content content) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onContent {}", new Object[]{this, content});
        }
        this.notifyRequestContent(this._request, content.getByteBuffer());
        return this._request.getHttpInput().addContent(content);
    }

    public boolean onContentComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onContentComplete", new Object[]{this});
        }
        this.notifyRequestContentEnd(this._request);
        return false;
    }

    public void onTrailers(HttpFields trailers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onTrailers {}", new Object[]{this, trailers});
        }
        this._trailers = trailers;
        this.notifyRequestTrailers(this._request);
    }

    public boolean onRequestComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onRequestComplete", new Object[]{this});
        }
        boolean result = this._request.getHttpInput().eof();
        this.notifyRequestEnd(this._request);
        return result;
    }

    public void onCompleted() {
        long idleTO;
        if (LOG.isDebugEnabled()) {
            LOG.debug("COMPLETE for {} written={}", new Object[]{this.getRequest().getRequestURI(), this.getBytesWritten()});
        }
        if (this._requestLog != null) {
            this._requestLog.log(this._request, this._response);
        }
        if ((idleTO = this._configuration.getIdleTimeout()) >= 0L && this.getIdleTimeout() != this._oldIdleTimeout) {
            this.setIdleTimeout(this._oldIdleTimeout);
        }
        this.notifyComplete(this._request);
        this._transport.onCompleted();
    }

    public boolean onEarlyEOF() {
        return this._request.getHttpInput().earlyEOF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBadMessage(BadMessageException failure) {
        HttpChannelState.Action action;
        int status = failure.getCode();
        String reason = failure.getReason();
        if (status < 400 || status > 599) {
            failure = new BadMessageException(400, reason, failure);
        }
        this.notifyRequestFailure(this._request, failure);
        try {
            action = this._state.handling();
        }
        catch (Throwable e) {
            this.abort(e);
            throw failure;
        }
        try {
            if (action == HttpChannelState.Action.DISPATCH) {
                ByteBuffer content = null;
                HttpFields fields = new HttpFields();
                ErrorHandler handler = (ErrorHandler)this.getServer().getBean(ErrorHandler.class);
                if (handler != null) {
                    content = handler.badMessageError(status, reason, fields);
                }
                this.sendResponse(new MetaData.Response(HttpVersion.HTTP_1_1, status, reason, fields, BufferUtil.length((ByteBuffer)content)), content, true);
            }
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        finally {
            try {
                this.onCompleted();
            }
            catch (Throwable e) {
                LOG.debug(e);
                this.abort(e);
            }
        }
    }

    protected boolean sendResponse(MetaData.Response info, ByteBuffer content, boolean complete, Callback callback) {
        boolean committing = this._committed.compareAndSet(false, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendResponse info={} content={} complete={} committing={} callback={}", new Object[]{info, BufferUtil.toDetailString((ByteBuffer)content), complete, committing, callback});
        }
        if (committing) {
            if (info == null) {
                info = this._response.newResponseMetaData();
            }
            this.commit(info);
            int status = info.getStatus();
            SendCallback committed = status < 200 && status >= 100 ? new Send100Callback(callback) : new SendCallback(callback, content, true, complete);
            this.notifyResponseBegin(this._request);
            this._transport.send(info, this._request.isHead(), content, complete, (Callback)committed);
        } else if (info == null) {
            this._transport.send(null, this._request.isHead(), content, complete, (Callback)new SendCallback(callback, content, false, complete));
        } else {
            callback.failed((Throwable)new IllegalStateException("committed"));
        }
        return committing;
    }

    public boolean sendResponse(MetaData.Response info, ByteBuffer content, boolean complete) throws IOException {
        boolean bl;
        block9: {
            SharedBlockingCallback.Blocker blocker = this._response.getHttpOutput().acquireWriteBlockingCallback();
            try {
                boolean committing = this.sendResponse(info, content, complete, (Callback)blocker);
                blocker.block();
                bl = committing;
                if (blocker == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (blocker != null) {
                        try {
                            blocker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable failure) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(failure);
                    }
                    this.abort(failure);
                    throw failure;
                }
            }
            blocker.close();
        }
        return bl;
    }

    protected void commit(MetaData.Response info) {
        this._committedMetaData = info;
        if (LOG.isDebugEnabled()) {
            LOG.debug("COMMIT for {} on {}{}{} {} {}{}{}", new Object[]{this.getRequest().getRequestURI(), this, System.lineSeparator(), info.getStatus(), info.getReason(), info.getHttpVersion(), System.lineSeparator(), info.getFields()});
        }
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    public boolean isRequestCompleted() {
        return this._state.isCompleted();
    }

    public boolean isResponseCompleted() {
        return this._responseCompleted.get();
    }

    public boolean isPersistent() {
        return this._endPoint.isOpen();
    }

    @Override
    public void write(ByteBuffer content, boolean complete, Callback callback) {
        this.sendResponse(null, content, complete, callback);
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
    }

    @Override
    public HttpOutput.Interceptor getNextInterceptor() {
        return null;
    }

    protected void execute(Runnable task) {
        this._executor.execute(task);
    }

    public Scheduler getScheduler() {
        return this._connector.getScheduler();
    }

    public boolean useDirectBuffers() {
        return this.getEndPoint() instanceof ChannelEndPoint;
    }

    public void abort(Throwable failure) {
        this.notifyResponseFailure(this._request, failure);
        this._transport.abort(failure);
    }

    private void notifyRequestBegin(Request request) {
        this.notifyEvent1(listener -> listener::onRequestBegin, request);
    }

    private void notifyBeforeDispatch(Request request) {
        this.notifyEvent1(listener -> listener::onBeforeDispatch, request);
    }

    private void notifyDispatchFailure(Request request, Throwable failure) {
        this.notifyEvent2((Listener listener) -> listener::onDispatchFailure, request, failure);
    }

    private void notifyAfterDispatch(Request request) {
        this.notifyEvent1(listener -> listener::onAfterDispatch, request);
    }

    private void notifyRequestContent(Request request, ByteBuffer content) {
        this.notifyEvent2((Listener listener) -> listener::onRequestContent, request, content);
    }

    private void notifyRequestContentEnd(Request request) {
        this.notifyEvent1(listener -> listener::onRequestContentEnd, request);
    }

    private void notifyRequestTrailers(Request request) {
        this.notifyEvent1(listener -> listener::onRequestTrailers, request);
    }

    private void notifyRequestEnd(Request request) {
        this.notifyEvent1(listener -> listener::onRequestEnd, request);
    }

    private void notifyRequestFailure(Request request, Throwable failure) {
        this.notifyEvent2((Listener listener) -> listener::onRequestFailure, request, failure);
    }

    private void notifyResponseBegin(Request request) {
        this.notifyEvent1(listener -> listener::onResponseBegin, request);
    }

    private void notifyResponseCommit(Request request) {
        this.notifyEvent1(listener -> listener::onResponseCommit, request);
    }

    private void notifyResponseContent(Request request, ByteBuffer content) {
        this.notifyEvent2((Listener listener) -> listener::onResponseContent, request, content);
    }

    private void notifyResponseEnd(Request request) {
        this.notifyEvent1(listener -> listener::onResponseEnd, request);
    }

    private void notifyResponseFailure(Request request, Throwable failure) {
        this.notifyEvent2((Listener listener) -> listener::onResponseFailure, request, failure);
    }

    private void notifyComplete(Request request) {
        this.notifyEvent1(listener -> listener::onComplete, request);
    }

    private void notifyEvent1(Function<Listener, Consumer<Request>> function, Request request) {
        for (Listener listener : this._listeners) {
            try {
                function.apply(listener).accept(request);
            }
            catch (Throwable x) {
                LOG.debug("Failure invoking listener " + listener, x);
            }
        }
    }

    private void notifyEvent2(Function<Listener, BiConsumer<Request, ByteBuffer>> function, Request request, ByteBuffer content) {
        for (Listener listener : this._listeners) {
            ByteBuffer view = content.slice();
            try {
                function.apply(listener).accept(request, view);
            }
            catch (Throwable x) {
                LOG.debug("Failure invoking listener " + listener, x);
            }
        }
    }

    private void notifyEvent2(Function<Listener, BiConsumer<Request, Throwable>> function, Request request, Throwable failure) {
        for (Listener listener : this._listeners) {
            try {
                function.apply(listener).accept(request, failure);
            }
            catch (Throwable x) {
                LOG.debug("Failure invoking listener " + listener, x);
            }
        }
    }

    private class Send100Callback
    extends SendCallback {
        private Send100Callback(Callback callback) {
            super(callback, null, false, false);
        }

        @Override
        public void succeeded() {
            if (HttpChannel.this._committed.compareAndSet(true, false)) {
                super.succeeded();
            } else {
                super.failed(new IllegalStateException());
            }
        }
    }

    private class SendCallback
    extends Callback.Nested {
        private final ByteBuffer _content;
        private final int _length;
        private final boolean _commit;
        private final boolean _complete;

        private SendCallback(Callback callback, ByteBuffer content, boolean commit, boolean complete) {
            super(callback);
            this._content = content == null ? BufferUtil.EMPTY_BUFFER : content.slice();
            this._length = this._content.remaining();
            this._commit = commit;
            this._complete = complete;
        }

        public void succeeded() {
            HttpChannel.this._written += this._length;
            super.succeeded();
            if (this._commit) {
                HttpChannel.this.notifyResponseCommit(HttpChannel.this._request);
            }
            if (this._length > 0) {
                HttpChannel.this.notifyResponseContent(HttpChannel.this._request, this._content);
            }
            if (this._complete) {
                HttpChannel.this._responseCompleted.set(true);
                HttpChannel.this.notifyResponseEnd(HttpChannel.this._request);
            }
        }

        public void failed(final Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Commit failed", x);
            }
            if (x instanceof BadMessageException) {
                HttpChannel.this._transport.send(HttpGenerator.RESPONSE_500_INFO, false, null, true, (Callback)new Callback.Nested(this){

                    public void succeeded() {
                        super.failed(x);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }

                    public void failed(Throwable th) {
                        HttpChannel.this.abort(x);
                        super.failed(x);
                    }
                });
            } else {
                HttpChannel.this.abort(x);
                super.failed(x);
            }
        }
    }

    public static interface Listener {
        default public void onRequestBegin(Request request) {
        }

        default public void onBeforeDispatch(Request request) {
        }

        default public void onDispatchFailure(Request request, Throwable failure) {
        }

        default public void onAfterDispatch(Request request) {
        }

        default public void onRequestContent(Request request, ByteBuffer content) {
        }

        default public void onRequestContentEnd(Request request) {
        }

        default public void onRequestTrailers(Request request) {
        }

        default public void onRequestEnd(Request request) {
        }

        default public void onRequestFailure(Request request, Throwable failure) {
        }

        default public void onResponseBegin(Request request) {
        }

        default public void onResponseCommit(Request request) {
        }

        default public void onResponseContent(Request request, ByteBuffer content) {
        }

        default public void onResponseEnd(Request request) {
        }

        default public void onResponseFailure(Request request, Throwable failure) {
        }

        default public void onComplete(Request request) {
        }
    }
}

