/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageReconstructor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.shaded.org.apache.commons.cli.OptionBuilder;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.shaded.org.apache.commons.cli.PosixParser;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    private static final String HELP_OPT = "-h";
    private static final String HELP_LONGOPT = "--help";
    public static final Logger LOG = LoggerFactory.getLogger(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * ReverseXML: This processor takes an XML file and creates a\n    binary fsimage containing the same elements.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n    -format formats the output result in a human-readable fashion\n     rather than a number of bytes. (false by default)\n  * Web: Run a viewer to expose read-only WebHDFS API.\n    -addr specifies the address to listen. (localhost:5978 by default)\n    It does not support secure mode nor HTTPS.\n  * Delimited (experimental): Generate a text file with all of the elements common\n    to both inodes and inodes-under-construction, separated by a\n    delimiter. The default delimiter is \\t, though this may be\n    changed via the -delimiter argument.\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage or XML file to process.\n\nOptional command line arguments:\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n                       (output to stdout by default)\n                       If the input file was an XML file, we\n                       will also create an <outputFile>.md5 file.\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (XML|FileDistribution|\n                       ReverseXML|Web|Delimited)\n                       The default is Web.\n-delimiter <arg>       Delimiting string to use with Delimited processor.  \n-t,--temp <arg>        Use temporary dir to cache intermediate result to generate\n                       Delimited outputs. If not set, Delimited processor constructs\n                       the namespace in memory before outputting text.\n-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"inputFile");
        options.addOption(OptionBuilder.create((String)"i"));
        options.addOption("o", "outputFile", true, "");
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("maxSize", true, "");
        options.addOption("step", true, "");
        options.addOption("format", false, "");
        options.addOption("addr", true, "");
        options.addOption("delimiter", true, "");
        options.addOption("t", "temp", true, "");
        return options;
    }

    public static void main(String[] args) throws Exception {
        int status = OfflineImageViewerPB.run(args);
        ExitUtil.terminate((int)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int run(String[] args) throws Exception {
        options = OfflineImageViewerPB.buildOptions();
        if (args.length == 0) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        if (args.length == 1 && OfflineImageViewerPB.isHelpOption(args[0])) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: ");
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        if (cmd.hasOption("h")) {
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        inputFile = cmd.getOptionValue("i");
        processor = cmd.getOptionValue("p", "Web");
        outputFile = cmd.getOptionValue("o", "-");
        delimiter = cmd.getOptionValue("delimiter", "\t");
        tempPath = cmd.getOptionValue("t", "");
        conf = new Configuration();
        out = null;
        try {
            out = outputFile.equals("-") != false || "REVERSEXML".equalsIgnoreCase(processor) != false ? System.out : new PrintStream(outputFile, "UTF-8");
            var11_12 = StringUtils.toUpperCase((String)processor);
            var12_16 = -1;
            switch (var11_12.hashCode()) {
                case -796669440: {
                    if (!var11_12.equals("FILEDISTRIBUTION")) break;
                    var12_16 = 0;
                    break;
                }
                case 87031: {
                    if (!var11_12.equals("XML")) break;
                    var12_16 = 1;
                    break;
                }
                case -297081355: {
                    if (!var11_12.equals("REVERSEXML")) break;
                    var12_16 = 2;
                    break;
                }
                case 85812: {
                    if (!var11_12.equals("WEB")) break;
                    var12_16 = 3;
                    break;
                }
                case -1758890535: {
                    if (!var11_12.equals("DELIMITED")) break;
                    var12_16 = 4;
                }
            }
            switch (var12_16) {
                case 0: {
                    maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                    step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                    formatOutput = cmd.hasOption("format");
                    r = new RandomAccessFile(inputFile, "r");
                    var18_24 = null;
                    new FileDistributionCalculator(conf, maxSize, step, formatOutput, out).visit(r);
                    if (r == null) break;
                    if (var18_24 == null) ** GOTO lbl67
                    try {
                        r.close();
                    }
                    catch (Throwable var19_29) {
                        var18_24.addSuppressed(var19_29);
                    }
                    break;
lbl67:
                    // 1 sources

                    r.close();
                    break;
                    catch (Throwable var19_30) {
                        try {
                            var18_24 = var19_30;
                            throw var19_30;
                        }
                        catch (Throwable var20_35) {
                            if (r != null) {
                                if (var18_24 != null) {
                                    try {
                                        r.close();
                                    }
                                    catch (Throwable var21_41) {
                                        var18_24.addSuppressed(var21_41);
                                    }
                                } else {
                                    r.close();
                                }
                            }
                            throw var20_35;
                        }
                    }
                }
                case 1: {
                    r = new RandomAccessFile(inputFile, "r");
                    var18_25 = null;
                    new PBImageXmlWriter(conf, out).visit(r);
                    if (r == null) break;
                    if (var18_25 == null) ** GOTO lbl97
                    try {
                        r.close();
                    }
                    catch (Throwable var19_31) {
                        var18_25.addSuppressed(var19_31);
                    }
                    break;
lbl97:
                    // 1 sources

                    r.close();
                    break;
                    catch (Throwable var19_32) {
                        try {
                            var18_25 = var19_32;
                            throw var19_32;
                        }
                        catch (Throwable var22_43) {
                            if (r != null) {
                                if (var18_25 != null) {
                                    try {
                                        r.close();
                                    }
                                    catch (Throwable var23_46) {
                                        var18_25.addSuppressed(var23_46);
                                    }
                                } else {
                                    r.close();
                                }
                            }
                            throw var22_43;
                        }
                    }
                }
                case 2: {
                    try {
                        OfflineImageReconstructor.run(inputFile, outputFile);
                    }
                    catch (Exception e) {
                        System.err.println("OfflineImageReconstructor failed: " + e.getMessage());
                        e.printStackTrace(System.err);
                        ExitUtil.terminate((int)1);
                    }
                    break;
                }
                case 3: {
                    addr = cmd.getOptionValue("addr", "localhost:5978");
                    viewer = new WebImageViewer(NetUtils.createSocketAddr((String)addr), conf);
                    var19_33 = null;
                    viewer.start(inputFile);
                    if (viewer == null) break;
                    if (var19_33 == null) ** GOTO lbl137
                    try {
                        viewer.close();
                    }
                    catch (Throwable var20_36) {
                        var19_33.addSuppressed(var20_36);
                    }
                    break;
lbl137:
                    // 1 sources

                    viewer.close();
                    break;
                    catch (Throwable var20_37) {
                        try {
                            var19_33 = var20_37;
                            throw var20_37;
                        }
                        catch (Throwable var24_47) {
                            if (viewer != null) {
                                if (var19_33 != null) {
                                    try {
                                        viewer.close();
                                    }
                                    catch (Throwable var25_48) {
                                        var19_33.addSuppressed(var25_48);
                                    }
                                } else {
                                    viewer.close();
                                }
                            }
                            throw var24_47;
                        }
                    }
                }
                case 4: {
                    writer = new PBImageDelimitedTextWriter(out, delimiter, tempPath);
                    var19_34 = null;
                    r = new RandomAccessFile(inputFile, "r");
                    var21_42 = null;
                    try {
                        writer.visit(r);
                    }
                    catch (Throwable var22_45) {
                        var21_42 = var22_45;
                        throw var22_45;
                    }
                    finally {
                        if (r != null) {
                            if (var21_42 != null) {
                                try {
                                    r.close();
                                }
                                catch (Throwable var22_44) {
                                    var21_42.addSuppressed(var22_44);
                                }
                            } else {
                                r.close();
                            }
                        }
                    }
                    if (writer == null) break;
                    if (var19_34 == null) ** GOTO lbl185
                    try {
                        writer.close();
                    }
                    catch (Throwable var20_39) {
                        var19_34.addSuppressed(var20_39);
                    }
                    break;
lbl185:
                    // 1 sources

                    writer.close();
                    break;
                    catch (Throwable var20_40) {
                        try {
                            var19_34 = var20_40;
                            throw var20_40;
                        }
                        catch (Throwable var28_51) {
                            if (writer != null) {
                                if (var19_34 != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (Throwable var29_52) {
                                        var19_34.addSuppressed(var29_52);
                                    }
                                } else {
                                    writer.close();
                                }
                            }
                            throw var28_51;
                        }
                    }
                }
                default: {
                    System.err.println("Invalid processor specified : " + processor);
                    OfflineImageViewerPB.printUsage();
                    var18_28 = -1;
                    return var18_28;
                }
            }
            var11_13 = 0;
            return var11_13;
        }
        catch (EOFException e) {
            System.err.println("Input file ended unexpectedly. Exiting");
        }
        catch (IOException e) {
            System.err.println("Encountered exception.  Exiting: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            if (out != null && out != System.out) {
                out.close();
            }
        }
        return -1;
    }

    private static void printUsage() {
        System.out.println(usage);
    }

    private static boolean isHelpOption(String arg) {
        return arg.equalsIgnoreCase(HELP_OPT) || arg.equalsIgnoreCase(HELP_LONGOPT);
    }
}

