/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.server;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.HttpHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.HttpServer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.HttpServerMonitoringConfig;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.server.jmx.JmxEventListener;

public class ServerConfiguration
extends ServerFilterConfiguration {
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(-1);
    private static final String[] ROOT_MAPPING = new String[]{"/"};
    final Map<HttpHandler, String[]> handlers = new ConcurrentHashMap<HttpHandler, String[]>();
    private final Map<HttpHandler, String[]> unmodifiableHandlers = Collections.unmodifiableMap(this.handlers);
    final List<HttpHandler> orderedHandlers = new LinkedList<HttpHandler>();
    private Set<JmxEventListener> jmxEventListeners = new CopyOnWriteArraySet<JmxEventListener>();
    private final HttpServerMonitoringConfig monitoringConfig = new HttpServerMonitoringConfig();
    private String name;
    final HttpServer instance;
    private boolean jmxEnabled;
    final Object handlersSync = new Object();

    ServerConfiguration(HttpServer instance) {
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpHandler(HttpHandler httpHandler, String ... mapping) {
        Object object = this.handlersSync;
        synchronized (object) {
            if (mapping == null) {
                mapping = ROOT_MAPPING;
            }
            if (this.handlers.put(httpHandler, mapping) != null) {
                this.orderedHandlers.remove(httpHandler);
            }
            this.orderedHandlers.add(httpHandler);
            this.instance.onAddHttpHandler(httpHandler, mapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeHttpHandler(HttpHandler httpHandler) {
        Object object = this.handlersSync;
        synchronized (object) {
            boolean result;
            boolean bl = result = this.handlers.remove(httpHandler) != null;
            if (result) {
                this.orderedHandlers.remove(httpHandler);
                this.instance.onRemoveHttpHandler(httpHandler);
            }
            return result;
        }
    }

    public Map<HttpHandler, String[]> getHttpHandlers() {
        return this.unmodifiableHandlers;
    }

    public HttpServerMonitoringConfig getMonitoringConfig() {
        return this.monitoringConfig;
    }

    public String getName() {
        if (this.name == null) {
            if (!this.instance.isStarted()) {
                return null;
            }
            int count = INSTANCE_COUNT.incrementAndGet();
            this.name = count == 0 ? "HttpServer" : "HttpServer-" + count;
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this.instance.isStarted()) {
            this.name = name;
        }
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        if (this.instance.isStarted()) {
            if (jmxEnabled) {
                this.instance.enableJMX();
                if (!this.jmxEventListeners.isEmpty()) {
                    for (JmxEventListener l : this.jmxEventListeners) {
                        l.jmxEnabled();
                    }
                }
            } else {
                if (!this.jmxEventListeners.isEmpty()) {
                    for (JmxEventListener l : this.jmxEventListeners) {
                        l.jmxDisabled();
                    }
                }
                this.instance.disableJMX();
            }
        }
    }

    public void addJmxEventListener(JmxEventListener listener) {
        if (listener != null) {
            this.jmxEventListeners.add(listener);
        }
    }

    public void removeJmxEventListener(JmxEventListener listener) {
        if (listener != null) {
            this.jmxEventListeners.remove(listener);
        }
    }

    public Set<JmxEventListener> getJmxEventListeners() {
        return this.jmxEventListeners;
    }
}

