/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.zookeeper.CreateMode;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.data.ACL;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKConfigurationStore
extends YarnConfigurationStore {
    public static final Logger LOG = LoggerFactory.getLogger(ZKConfigurationStore.class);
    private long maxLogs;
    @VisibleForTesting
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance(0, 1);
    private Configuration conf;
    private YarnConfigurationStore.LogMutation pendingMutation;
    private static final String ZK_VERSION_PATH = "VERSION";
    private static final String LOGS_PATH = "LOGS";
    private static final String CONF_STORE_PATH = "CONF_STORE";
    private static final String FENCING_PATH = "FENCING";
    private static final String CONF_VERSION_PATH = "CONF_VERSION";
    private static final String NODEEXISTS_MSG = "Encountered NodeExists error. Skipping znode creation since another RM has already created it";
    private String zkVersionPath;
    private String logsPath;
    private String confStorePath;
    private String fencingNodePath;
    private String confVersionPath;
    private ZKCuratorManager zkManager;
    private List<ACL> zkAcl;

    @Override
    public void initialize(Configuration config, Configuration schedConf, RMContext rmContext) throws Exception {
        this.conf = config;
        String znodeParentPath = this.conf.get("yarn.scheduler.configuration.zk-store.parent-path", "/confstore");
        this.maxLogs = this.conf.getLong("yarn.scheduler.configuration.store.max-logs", 1000L);
        this.zkManager = rmContext.getResourceManager().createAndStartZKManager(this.conf);
        this.zkAcl = ZKCuratorManager.getZKAcls((Configuration)this.conf);
        this.zkVersionPath = ZKConfigurationStore.getNodePath(znodeParentPath, ZK_VERSION_PATH);
        this.logsPath = ZKConfigurationStore.getNodePath(znodeParentPath, LOGS_PATH);
        this.confStorePath = ZKConfigurationStore.getNodePath(znodeParentPath, CONF_STORE_PATH);
        this.fencingNodePath = ZKConfigurationStore.getNodePath(znodeParentPath, FENCING_PATH);
        this.confVersionPath = ZKConfigurationStore.getNodePath(znodeParentPath, CONF_VERSION_PATH);
        try {
            this.zkManager.createRootDirRecursively(znodeParentPath, this.zkAcl);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn(NODEEXISTS_MSG, (Throwable)e);
        }
        this.zkManager.delete(this.fencingNodePath);
        if (this.createNewZkPath(this.logsPath)) {
            this.setZkData(this.logsPath, new LinkedList());
        }
        if (this.createNewZkPath(this.confVersionPath)) {
            this.setZkData(this.confVersionPath, String.valueOf(0));
        }
        if (this.createNewZkPath(this.confStorePath)) {
            HashMap mapSchedConf = new HashMap();
            for (Map.Entry entry : schedConf) {
                mapSchedConf.put(entry.getKey(), entry.getValue());
            }
            this.setZkData(this.confStorePath, mapSchedConf);
            long configVersion = this.getConfigVersion() + 1L;
            this.setZkData(this.confVersionPath, String.valueOf(configVersion));
        }
    }

    @Override
    @VisibleForTesting
    protected LinkedList<YarnConfigurationStore.LogMutation> getLogs() throws Exception {
        return (LinkedList)ZKConfigurationStore.unsafeCast(ZKConfigurationStore.deserializeObject(this.getZkData(this.logsPath)));
    }

    @Override
    public Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    public Version getConfStoreVersion() throws Exception {
        if (this.zkManager.exists(this.zkVersionPath)) {
            byte[] data = this.getZkData(this.zkVersionPath);
            return new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom(data));
        }
        return null;
    }

    @Override
    public void format() throws Exception {
        this.zkManager.delete(this.confStorePath);
    }

    @Override
    public synchronized void storeVersion() throws Exception {
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.zkManager.exists(this.zkVersionPath)) {
            this.safeSetZkData(this.zkVersionPath, data);
        } else {
            this.safeCreateZkData(this.zkVersionPath, data);
        }
    }

    @Override
    public void logMutation(YarnConfigurationStore.LogMutation logMutation) throws Exception {
        if (this.maxLogs > 0L) {
            byte[] storedLogs = this.getZkData(this.logsPath);
            LinkedList logs = new LinkedList();
            if (storedLogs != null) {
                logs = (LinkedList)ZKConfigurationStore.unsafeCast(ZKConfigurationStore.deserializeObject(storedLogs));
            }
            logs.add(logMutation);
            if ((long)logs.size() > this.maxLogs) {
                logs.remove(logs.removeFirst());
            }
            this.safeSetZkData(this.logsPath, logs);
        }
        this.pendingMutation = logMutation;
    }

    @Override
    public void confirmMutation(boolean isValid) throws Exception {
        if (isValid) {
            Configuration storedConfigs = this.retrieve();
            HashMap mapConf = new HashMap();
            for (Map.Entry storedConf : storedConfigs) {
                mapConf.put(storedConf.getKey(), storedConf.getValue());
            }
            for (Map.Entry<String, String> confChange : this.pendingMutation.getUpdates().entrySet()) {
                if (confChange.getValue() == null || confChange.getValue().isEmpty()) {
                    mapConf.remove(confChange.getKey());
                    continue;
                }
                mapConf.put(confChange.getKey(), confChange.getValue());
            }
            this.safeSetZkData(this.confStorePath, mapConf);
            long configVersion = this.getConfigVersion() + 1L;
            this.setZkData(this.confVersionPath, String.valueOf(configVersion));
        }
        this.pendingMutation = null;
    }

    @Override
    public synchronized Configuration retrieve() {
        byte[] serializedSchedConf;
        try {
            serializedSchedConf = this.getZkData(this.confStorePath);
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve configuration from zookeeper store", (Throwable)e);
            return null;
        }
        try {
            Map map = (Map)ZKConfigurationStore.unsafeCast(ZKConfigurationStore.deserializeObject(serializedSchedConf));
            Configuration c = new Configuration(false);
            for (Map.Entry e : map.entrySet()) {
                c.set((String)e.getKey(), (String)e.getValue());
            }
            return c;
        }
        catch (Exception e) {
            LOG.error("Exception while deserializing scheduler configuration from store", (Throwable)e);
            return null;
        }
    }

    @Override
    public long getConfigVersion() throws Exception {
        String version = this.zkManager.getStringData(this.confVersionPath);
        if (version == null) {
            throw new IllegalStateException("Config version can not be properly serialized. Check Zookeeper config version path to locate the error!");
        }
        return Long.parseLong(version);
    }

    @Override
    public List<YarnConfigurationStore.LogMutation> getConfirmedConfHistory(long fromId) {
        return null;
    }

    private boolean createNewZkPath(String path) throws Exception {
        if (!this.zkManager.exists(path)) {
            try {
                this.zkManager.create(path, this.zkAcl);
            }
            catch (KeeperException.NodeExistsException e) {
                LOG.warn(NODEEXISTS_MSG, (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    protected byte[] getZkData(String path) throws Exception {
        return this.zkManager.getData(path);
    }

    @VisibleForTesting
    protected void setZkData(String path, byte[] data) throws Exception {
        this.zkManager.setData(path, data, -1);
    }

    private void setZkData(String path, Object data) throws Exception {
        this.setZkData(path, ZKConfigurationStore.serializeObject(data));
    }

    private void setZkData(String path, String data) throws Exception {
        this.zkManager.setData(path, data, -1);
    }

    private void safeSetZkData(String path, byte[] data) throws Exception {
        this.zkManager.safeSetData(path, data, -1, this.zkAcl, this.fencingNodePath);
    }

    private void safeSetZkData(String path, Object data) throws Exception {
        this.safeSetZkData(path, ZKConfigurationStore.serializeObject(data));
    }

    @VisibleForTesting
    protected void safeCreateZkData(String path, byte[] data) throws Exception {
        try {
            this.zkManager.safeCreate(path, data, this.zkAcl, CreateMode.PERSISTENT, this.zkAcl, this.fencingNodePath);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn(NODEEXISTS_MSG, (Throwable)e);
        }
    }

    private static String getNodePath(String root, String nodeName) {
        return ZKCuratorManager.getNodePath((String)root, (String)nodeName);
    }

    /*
     * Exception decompiling
     */
    private static byte[] serializeObject(Object o) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static Object deserializeObject(byte[] bytes) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> T unsafeCast(Object o) throws ClassCastException {
        return (T)o;
    }

    @Override
    public void close() throws IOException {
        if (this.zkManager != null) {
            this.zkManager.close();
        }
    }
}

