/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.io.IOException;
import java.util.IllegalFormatException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.inject.Singleton;
import org.apache.hadoop.shaded.javax.servlet.ServletContext;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.javax.ws.rs.Consumes;
import org.apache.hadoop.shaded.javax.ws.rs.GET;
import org.apache.hadoop.shaded.javax.ws.rs.PUT;
import org.apache.hadoop.shaded.javax.ws.rs.Path;
import org.apache.hadoop.shaded.javax.ws.rs.Produces;
import org.apache.hadoop.shaded.javax.ws.rs.QueryParam;
import org.apache.hadoop.shaded.javax.ws.rs.WebApplicationException;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationAttemptEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ClusterEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ContainerEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.QueueEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.SubApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.UserEntity;
import org.apache.hadoop.yarn.server.timelineservice.collector.NodeTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.metrics.PerNodeAggTimelineCollectorMetrics;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Singleton
@Path(value="/ws/v2/timeline")
public class TimelineCollectorWebService {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCollectorWebService.class);
    @Context
    private ServletContext context;
    private static final PerNodeAggTimelineCollectorMetrics METRICS = PerNodeAggTimelineCollectorMetrics.getInstance();

    @GET
    @Produces(value={"application/json; charset=utf-8"})
    public AboutInfo about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        TimelineCollectorWebService.init(res);
        return new AboutInfo("Timeline Collector API");
    }

    @PUT
    @Path(value="/entities")
    @Consumes(value={"application/json"})
    public Response putEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="async") String async, @QueryParam(value="subappwrite") String isSubAppEntities, @QueryParam(value="appid") String appId, TimelineEntities entities) {
        boolean isAsync;
        TimelineCollectorWebService.init(res);
        UserGroupInformation callerUgi = TimelineCollectorWebService.getUser(req);
        boolean bl = isAsync = async != null && async.trim().equalsIgnoreCase("true");
        if (callerUgi == null) {
            String msg = "The owner of the posted timeline entities is not set";
            LOG.error(msg);
            throw new ForbiddenException(msg);
        }
        long startTime = Time.monotonicNow();
        boolean succeeded = false;
        try {
            ApplicationId appID = TimelineCollectorWebService.parseApplicationId(appId);
            if (appID == null) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response;
            }
            NodeTimelineCollectorManager collectorManager = (NodeTimelineCollectorManager)((Object)this.context.getAttribute("collector.manager"));
            TimelineCollector collector = collectorManager.get(appID);
            if (collector == null) {
                LOG.error("Application: " + appId + " is not found");
                throw new NotFoundException("Application: " + appId + " is not found");
            }
            if (isAsync) {
                collector.putEntitiesAsync(TimelineCollectorWebService.processTimelineEntities(entities, appId, Boolean.valueOf(isSubAppEntities)), callerUgi);
            } else {
                collector.putEntities(TimelineCollectorWebService.processTimelineEntities(entities, appId, Boolean.valueOf(isSubAppEntities)), callerUgi);
            }
            succeeded = true;
            Response response = Response.ok().build();
            return response;
        }
        catch (ForbiddenException | NotFoundException e) {
            throw new WebApplicationException(e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            LOG.error("Error putting entities", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            long latency = Time.monotonicNow() - startTime;
            if (isAsync) {
                METRICS.addAsyncPutEntitiesLatency(latency, succeeded);
            } else {
                METRICS.addPutEntitiesLatency(latency, succeeded);
            }
        }
    }

    @PUT
    @Path(value="/domain")
    @Consumes(value={"application/json"})
    public Response putDomain(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="appid") String appId, TimelineDomain domain) {
        TimelineCollectorWebService.init(res);
        UserGroupInformation callerUgi = TimelineCollectorWebService.getUser(req);
        if (callerUgi == null) {
            String msg = "The owner of the posted timeline entities is not set";
            LOG.error(msg);
            throw new ForbiddenException(msg);
        }
        try {
            ApplicationId appID = TimelineCollectorWebService.parseApplicationId(appId);
            if (appID == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            NodeTimelineCollectorManager collectorManager = (NodeTimelineCollectorManager)((Object)this.context.getAttribute("collector.manager"));
            TimelineCollector collector = collectorManager.get(appID);
            if (collector == null) {
                LOG.error("Application: " + appId + " is not found");
                throw new NotFoundException("Application: " + appId + " is not found");
            }
            domain.setOwner(callerUgi.getShortUserName());
            collector.putDomain(domain, callerUgi);
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            LOG.error("Error putting entities", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static ApplicationId parseApplicationId(String appId) {
        try {
            if (appId != null) {
                return ApplicationId.fromString((String)appId.trim());
            }
            return null;
        }
        catch (IllegalFormatException e) {
            LOG.error("Invalid application ID: " + appId);
            return null;
        }
    }

    private static void init(HttpServletResponse response) {
        response.setContentType(null);
    }

    private static UserGroupInformation getUser(HttpServletRequest req) {
        String remoteUser = req.getRemoteUser();
        UserGroupInformation callerUgi = null;
        if (remoteUser != null) {
            callerUgi = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUgi;
    }

    private static TimelineEntities processTimelineEntities(TimelineEntities entities, String appId, boolean isSubAppWrite) {
        TimelineEntities entitiesToReturn = new TimelineEntities();
        block11: for (TimelineEntity entity : entities.getEntities()) {
            TimelineEntityType type = null;
            try {
                type = TimelineEntityType.valueOf((String)entity.getType());
            }
            catch (IllegalArgumentException e) {
                type = null;
            }
            if (type != null) {
                switch (type) {
                    case YARN_CLUSTER: {
                        entitiesToReturn.addEntity((TimelineEntity)new ClusterEntity(entity));
                        continue block11;
                    }
                    case YARN_FLOW_RUN: {
                        entitiesToReturn.addEntity((TimelineEntity)new FlowRunEntity(entity));
                        continue block11;
                    }
                    case YARN_APPLICATION: {
                        entitiesToReturn.addEntity((TimelineEntity)new ApplicationEntity(entity));
                        continue block11;
                    }
                    case YARN_APPLICATION_ATTEMPT: {
                        entitiesToReturn.addEntity((TimelineEntity)new ApplicationAttemptEntity(entity));
                        continue block11;
                    }
                    case YARN_CONTAINER: {
                        entitiesToReturn.addEntity((TimelineEntity)new ContainerEntity(entity));
                        continue block11;
                    }
                    case YARN_QUEUE: {
                        entitiesToReturn.addEntity((TimelineEntity)new QueueEntity(entity));
                        continue block11;
                    }
                    case YARN_USER: {
                        entitiesToReturn.addEntity((TimelineEntity)new UserEntity(entity));
                        continue block11;
                    }
                }
                continue;
            }
            if (isSubAppWrite) {
                SubApplicationEntity se = new SubApplicationEntity(entity);
                se.setApplicationId(appId);
                entitiesToReturn.addEntity((TimelineEntity)se);
                continue;
            }
            entitiesToReturn.addEntity(entity);
        }
        return entitiesToReturn;
    }

    @XmlRootElement(name="about")
    @XmlAccessorType(value=XmlAccessType.NONE)
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class AboutInfo {
        private String about;

        public AboutInfo() {
        }

        public AboutInfo(String abt) {
            this.about = abt;
        }

        @XmlElement(name="About")
        public String getAbout() {
            return this.about;
        }

        public void setAbout(String abt) {
            this.about = abt;
        }
    }
}

