/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ContainerManager;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.DataTreeBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.Request;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ServerCnxn;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZKDatabase;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.LeaderSessionTracker;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.ProposalRequestProcessor;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;

public class LeaderZooKeeperServer
extends QuorumZooKeeperServer {
    private ContainerManager containerManager;
    CommitProcessor commitProcessor;
    PrepRequestProcessor prepRequestProcessor;

    LeaderZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, zkDb, self);
    }

    public Leader getLeader() {
        return this.self.leader;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        Leader.ToBeAppliedRequestProcessor toBeAppliedProcessor = new Leader.ToBeAppliedRequestProcessor(finalProcessor, this.getLeader());
        this.commitProcessor = new CommitProcessor(toBeAppliedProcessor, Long.toString(this.getServerId()), false, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        ProposalRequestProcessor proposalProcessor = new ProposalRequestProcessor(this, this.commitProcessor);
        proposalProcessor.initialize();
        this.prepRequestProcessor = new PrepRequestProcessor(this, proposalProcessor);
        this.prepRequestProcessor.start();
        this.firstProcessor = new LeaderRequestProcessor(this, this.prepRequestProcessor);
        this.setupContainerManager();
    }

    private synchronized void setupContainerManager() {
        this.containerManager = new ContainerManager(this.getZKDatabase(), this.prepRequestProcessor, Integer.getInteger("znode.container.checkIntervalMs", (int)TimeUnit.MINUTES.toMillis(1L)), Integer.getInteger("znode.container.maxPerMinute", 10000));
    }

    @Override
    public synchronized void startup() {
        super.startup();
        if (this.containerManager != null) {
            this.containerManager.start();
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.containerManager != null) {
            this.containerManager.stop();
        }
        super.shutdown();
    }

    @Override
    public int getGlobalOutstandingLimit() {
        int divisor = this.self.getQuorumSize() > 2 ? this.self.getQuorumSize() - 1 : 1;
        return super.getGlobalOutstandingLimit() / divisor;
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LeaderSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getId(), this.self.areLocalSessionsEnabled(), this.getZooKeeperServerListener());
    }

    public boolean touch(long sess, int to) {
        return this.sessionTracker.touchSession(sess, to);
    }

    public boolean checkIfValidGlobalSession(long sess, int to) {
        if (this.self.areLocalSessionsEnabled() && !this.upgradeableSessionTracker.isGlobalSession(sess)) {
            return false;
        }
        return this.sessionTracker.touchSession(sess, to);
    }

    public void submitLearnerRequest(Request request) {
        this.prepRequestProcessor.processRequest(request);
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(LeaderBean leaderBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", (Throwable)e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = leaderBean;
            MBeanRegistry.getInstance().register(leaderBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Leader leader) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
    }

    @Override
    public String getState() {
        return "leader";
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    @Override
    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException {
        super.revalidateSession(cnxn, sessionId, sessionTimeout);
        try {
            this.setOwner(sessionId, ServerCnxn.me);
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
    }
}

