/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PreDestroy;
import org.apache.hadoop.shaded.javax.servlet.AsyncListener;
import org.apache.hadoop.shaded.javax.servlet.Filter;
import org.apache.hadoop.shaded.javax.servlet.Servlet;
import org.apache.hadoop.shaded.javax.servlet.ServletContextAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.ServletContextListener;
import org.apache.hadoop.shaded.javax.servlet.ServletRequestAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.ServletRequestListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionIdListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpUpgradeHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.apache.hadoop.shaded.org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.apache.hadoop.shaded.org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.MetaData;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.Origin;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.WebAppContext;

public class PreDestroyAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    WebAppContext _context;

    public PreDestroyAnnotationHandler(WebAppContext wac) {
        super(true);
        this._context = wac;
    }

    public void doHandle(Class clazz) {
        if (this.supportsPreDestroy(clazz)) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.isAnnotationPresent(PreDestroy.class)) continue;
                if (m.getParameterCount() != 0) {
                    throw new IllegalStateException(m + " has parameters");
                }
                if (m.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(m + " is not void");
                }
                if (m.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(m + " throws checked exceptions");
                }
                if (Modifier.isStatic(m.getModifiers())) {
                    throw new IllegalStateException(m + " is static");
                }
                MetaData metaData = this._context.getMetaData();
                Origin origin = metaData.getOrigin("pre-destroy");
                if (origin != null && (origin == Origin.WebXml || origin == Origin.WebDefaults || origin == Origin.WebOverride)) {
                    return;
                }
                PreDestroyCallback callback = new PreDestroyCallback(clazz, m.getName());
                LifeCycleCallbackCollection lifecycles = (LifeCycleCallbackCollection)this._context.getAttribute("org.apache.hadoop.shaded.org.eclipse.jetty.lifecyleCallbackCollection");
                if (lifecycles == null) {
                    lifecycles = new LifeCycleCallbackCollection();
                    this._context.setAttribute("org.apache.hadoop.shaded.org.eclipse.jetty.lifecyleCallbackCollection", (Object)lifecycles);
                }
                lifecycles.add(callback);
            }
        }
    }

    public boolean supportsPreDestroy(Class c) {
        return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
    }
}

