/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.zaxxer.hikari.pool.HikariPool;
import org.apache.hadoop.shaded.javax.cache.Cache;
import org.apache.hadoop.shaded.javax.cache.CacheManager;
import org.apache.hadoop.shaded.javax.cache.Caching;
import org.apache.hadoop.shaded.javax.cache.configuration.FactoryBuilder;
import org.apache.hadoop.shaded.javax.cache.configuration.MutableConfiguration;
import org.apache.hadoop.shaded.javax.cache.expiry.CreatedExpiryPolicy;
import org.apache.hadoop.shaded.javax.cache.expiry.Duration;
import org.apache.hadoop.shaded.javax.cache.integration.CacheLoader;
import org.apache.hadoop.shaded.javax.cache.integration.CacheLoaderException;
import org.apache.hadoop.shaded.javax.cache.spi.CachingProvider;
import org.apache.hadoop.shaded.org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreRetriableException;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationStateStoreFacade {
    private static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreFacade.class);
    private static final String GET_SUBCLUSTERS_CACHEID = "getSubClusters";
    private static final String GET_POLICIES_CONFIGURATIONS_CACHEID = "getPoliciesConfigurations";
    private static final FederationStateStoreFacade FACADE = new FederationStateStoreFacade();
    private FederationStateStore stateStore;
    private int cacheTimeToLive;
    private Configuration conf;
    private Cache<Object, Object> cache;
    private SubClusterResolver subclusterResolver;

    private FederationStateStoreFacade() {
        this.initializeFacadeInternal(new Configuration());
    }

    private void initializeFacadeInternal(Configuration config) {
        this.conf = config;
        try {
            this.stateStore = (FederationStateStore)FederationStateStoreFacade.createRetryInstance(this.conf, "yarn.federation.state-store.class", "org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore", FederationStateStore.class, FederationStateStoreFacade.createRetryPolicy(this.conf));
            this.stateStore.init(this.conf);
            this.subclusterResolver = FederationStateStoreFacade.createInstance(this.conf, "yarn.federation.subcluster-resolver.class", "org.apache.hadoop.yarn.server.federation.resolver.DefaultSubClusterResolverImpl", SubClusterResolver.class);
            this.subclusterResolver.load();
            this.initCache();
        }
        catch (YarnException ex) {
            LOG.error("Failed to initialize the FederationStateStoreFacade object", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @VisibleForTesting
    public synchronized void reinitialize(FederationStateStore store, Configuration config) {
        this.conf = config;
        this.stateStore = store;
        this.clearCache();
        this.initCache();
    }

    public static RetryPolicy createRetryPolicy(Configuration conf) {
        RetryPolicy basePolicy = RetryPolicies.exponentialBackoffRetry((int)conf.getInt("yarn.client.failover-retries", 32), (long)conf.getLong("yarn.client.failover-sleep-base-ms", 30000L), (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class<HikariPool.PoolInitializationException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<HikariPool.PoolInitializationException>, RetryPolicy>();
        exceptionToPolicyMap.put(FederationStateStoreRetriableException.class, basePolicy);
        exceptionToPolicyMap.put(CacheLoaderException.class, basePolicy);
        exceptionToPolicyMap.put(HikariPool.PoolInitializationException.class, basePolicy);
        RetryPolicy retryPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        return retryPolicy;
    }

    private boolean isCachingEnabled() {
        return this.cacheTimeToLive > 0;
    }

    private void initCache() {
        this.cacheTimeToLive = this.conf.getInt("yarn.federation.cache-ttl.secs", 300);
        if (this.isCachingEnabled()) {
            CachingProvider jcacheProvider = Caching.getCachingProvider();
            CacheManager jcacheManager = jcacheProvider.getCacheManager();
            this.cache = jcacheManager.getCache(this.getClass().getSimpleName());
            if (this.cache == null) {
                LOG.info("Creating a JCache Manager with name " + this.getClass().getSimpleName());
                Duration cacheExpiry = new Duration(TimeUnit.SECONDS, (long)this.cacheTimeToLive);
                MutableConfiguration configuration = new MutableConfiguration().setStoreByValue(false).setReadThrough(true).setExpiryPolicyFactory(new FactoryBuilder.SingletonFactory<CreatedExpiryPolicy>(new CreatedExpiryPolicy(cacheExpiry))).setCacheLoaderFactory(new FactoryBuilder.SingletonFactory(new CacheLoaderImpl()));
                this.cache = jcacheManager.createCache(this.getClass().getSimpleName(), configuration);
            }
        }
    }

    private void clearCache() {
        CachingProvider jcacheProvider = Caching.getCachingProvider();
        CacheManager jcacheManager = jcacheProvider.getCacheManager();
        jcacheManager.destroyCache(this.getClass().getSimpleName());
        this.cache = null;
    }

    public static FederationStateStoreFacade getInstance() {
        return FACADE;
    }

    public SubClusterInfo getSubCluster(SubClusterId subClusterId) throws YarnException {
        if (this.isCachingEnabled()) {
            return this.getSubClusters(false).get(subClusterId);
        }
        GetSubClusterInfoResponse response = this.stateStore.getSubCluster(GetSubClusterInfoRequest.newInstance(subClusterId));
        if (response == null) {
            return null;
        }
        return response.getSubClusterInfo();
    }

    public SubClusterInfo getSubCluster(SubClusterId subClusterId, boolean flushCache) throws YarnException {
        if (flushCache && this.isCachingEnabled()) {
            LOG.info("Flushing subClusters from cache and rehydrating from store, most likely on account of RM failover.");
            this.cache.remove(this.buildGetSubClustersCacheRequest(false));
        }
        return this.getSubCluster(subClusterId);
    }

    public Map<SubClusterId, SubClusterInfo> getSubClusters(boolean filterInactiveSubClusters) throws YarnException {
        try {
            if (this.isCachingEnabled()) {
                return (Map)this.cache.get(this.buildGetSubClustersCacheRequest(filterInactiveSubClusters));
            }
            return this.buildSubClusterInfoMap(this.stateStore.getSubClusters(GetSubClustersInfoRequest.newInstance(filterInactiveSubClusters)));
        }
        catch (Throwable ex) {
            throw new YarnException(ex);
        }
    }

    public SubClusterPolicyConfiguration getPolicyConfiguration(String queue) throws YarnException {
        if (this.isCachingEnabled()) {
            return this.getPoliciesConfigurations().get(queue);
        }
        GetSubClusterPolicyConfigurationResponse response = this.stateStore.getPolicyConfiguration(GetSubClusterPolicyConfigurationRequest.newInstance(queue));
        if (response == null) {
            return null;
        }
        return response.getPolicyConfiguration();
    }

    public Map<String, SubClusterPolicyConfiguration> getPoliciesConfigurations() throws YarnException {
        try {
            if (this.isCachingEnabled()) {
                return (Map)this.cache.get(this.buildGetPoliciesConfigurationsCacheRequest());
            }
            return this.buildPolicyConfigMap(this.stateStore.getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest.newInstance()));
        }
        catch (Throwable ex) {
            throw new YarnException(ex);
        }
    }

    public SubClusterId addApplicationHomeSubCluster(ApplicationHomeSubCluster appHomeSubCluster) throws YarnException {
        AddApplicationHomeSubClusterResponse response = this.stateStore.addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest.newInstance(appHomeSubCluster));
        return response.getHomeSubCluster();
    }

    public void updateApplicationHomeSubCluster(ApplicationHomeSubCluster appHomeSubCluster) throws YarnException {
        this.stateStore.updateApplicationHomeSubCluster(UpdateApplicationHomeSubClusterRequest.newInstance(appHomeSubCluster));
    }

    public SubClusterId getApplicationHomeSubCluster(ApplicationId appId) throws YarnException {
        GetApplicationHomeSubClusterResponse response = this.stateStore.getApplicationHomeSubCluster(GetApplicationHomeSubClusterRequest.newInstance(appId));
        return response.getApplicationHomeSubCluster().getHomeSubCluster();
    }

    public SubClusterResolver getSubClusterResolver() {
        return this.subclusterResolver;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static <T> Object createRetryInstance(Configuration conf, String configuredClassName, String defaultValue, Class<T> type, RetryPolicy retryPolicy) {
        return RetryProxy.create(type, FederationStateStoreFacade.createInstance(conf, configuredClassName, defaultValue, type), (RetryPolicy)retryPolicy);
    }

    public static <T> T createInstance(Configuration conf, String configuredClassName, String defaultValue, Class<T> type) {
        String className = conf.get(configuredClassName, defaultValue);
        try {
            Class clusterResolverClass = conf.getClassByName(className);
            if (type.isAssignableFrom(clusterResolverClass)) {
                return (T)ReflectionUtils.newInstance((Class)clusterResolverClass, (Configuration)conf);
            }
            throw new YarnRuntimeException("Class: " + className + " not instance of " + type.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate : " + className, (Throwable)e);
        }
    }

    private Map<SubClusterId, SubClusterInfo> buildSubClusterInfoMap(GetSubClustersInfoResponse response) {
        List<SubClusterInfo> subClusters = response.getSubClusters();
        HashMap<SubClusterId, SubClusterInfo> subClustersMap = new HashMap<SubClusterId, SubClusterInfo>(subClusters.size());
        for (SubClusterInfo subCluster : subClusters) {
            subClustersMap.put(subCluster.getSubClusterId(), subCluster);
        }
        return subClustersMap;
    }

    private Object buildGetSubClustersCacheRequest(final boolean filterInactiveSubClusters) {
        String cacheKey = this.buildCacheKey(this.getClass().getSimpleName(), GET_SUBCLUSTERS_CACHEID, Boolean.toString(filterInactiveSubClusters));
        CacheRequest<String, Map<SubClusterId, SubClusterInfo>> cacheRequest = new CacheRequest<String, Map<SubClusterId, SubClusterInfo>>(cacheKey, new Func<String, Map<SubClusterId, SubClusterInfo>>(){

            @Override
            public Map<SubClusterId, SubClusterInfo> invoke(String key) throws Exception {
                GetSubClustersInfoResponse subClusters = FederationStateStoreFacade.this.stateStore.getSubClusters(GetSubClustersInfoRequest.newInstance(filterInactiveSubClusters));
                return FederationStateStoreFacade.this.buildSubClusterInfoMap(subClusters);
            }
        });
        return cacheRequest;
    }

    private Map<String, SubClusterPolicyConfiguration> buildPolicyConfigMap(GetSubClusterPoliciesConfigurationsResponse response) {
        List<SubClusterPolicyConfiguration> policyConfigs = response.getPoliciesConfigs();
        HashMap<String, SubClusterPolicyConfiguration> queuePolicyConfigs = new HashMap<String, SubClusterPolicyConfiguration>();
        for (SubClusterPolicyConfiguration policyConfig : policyConfigs) {
            queuePolicyConfigs.put(policyConfig.getQueue(), policyConfig);
        }
        return queuePolicyConfigs;
    }

    private Object buildGetPoliciesConfigurationsCacheRequest() {
        String cacheKey = this.buildCacheKey(this.getClass().getSimpleName(), GET_POLICIES_CONFIGURATIONS_CACHEID, null);
        CacheRequest<String, Map<String, SubClusterPolicyConfiguration>> cacheRequest = new CacheRequest<String, Map<String, SubClusterPolicyConfiguration>>(cacheKey, new Func<String, Map<String, SubClusterPolicyConfiguration>>(){

            @Override
            public Map<String, SubClusterPolicyConfiguration> invoke(String key) throws Exception {
                GetSubClusterPoliciesConfigurationsResponse policyConfigs = FederationStateStoreFacade.this.stateStore.getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest.newInstance());
                return FederationStateStoreFacade.this.buildPolicyConfigMap(policyConfigs);
            }
        });
        return cacheRequest;
    }

    protected String buildCacheKey(String typeName, String methodName, String argName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(typeName).append(".").append(methodName);
        if (argName != null) {
            buffer.append("::");
            buffer.append(argName);
        }
        return buffer.toString();
    }

    protected static interface Func<T, TResult> {
        public TResult invoke(T var1) throws Exception;
    }

    private static class CacheRequest<K, V> {
        private K key;
        private Func<K, V> func;

        public CacheRequest(K key, Func<K, V> func) {
            this.key = key;
            this.func = func;
        }

        public V getValue() throws Exception {
            return this.func.invoke(this.key);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheRequest other = (CacheRequest)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }

    private static class CacheLoaderImpl<K, V>
    implements CacheLoader<K, V> {
        private CacheLoaderImpl() {
        }

        @Override
        public V load(K key) throws CacheLoaderException {
            try {
                CacheRequest query = (CacheRequest)key;
                assert (query != null);
                return query.getValue();
            }
            catch (Throwable ex) {
                throw new CacheLoaderException(ex);
            }
        }

        @Override
        public Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
            throw new NotImplementedException("Code is not implemented");
        }
    }
}

