/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FSPlacementRule
extends PlacementRule {
    private static final Logger LOG = LoggerFactory.getLogger(FSPlacementRule.class);
    @VisibleForTesting
    protected boolean createQueue = true;
    private QueueManager queueManager;
    private PlacementRule parentRule;

    QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setParentRule(PlacementRule parent) {
        this.parentRule = parent;
    }

    @VisibleForTesting
    public PlacementRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public void setConfig(Object initArg) {
        if (null == initArg) {
            LOG.debug("Null object passed in: no config set");
            return;
        }
        if (initArg instanceof Element) {
            LOG.debug("Setting config from XML");
            this.setConfig((Element)initArg);
        } else if (initArg instanceof Boolean) {
            LOG.debug("Setting config from Boolean");
            this.setConfig((Boolean)initArg);
        } else {
            LOG.info("Unknown object type passed in as config for rule {}: {}", (Object)this.getName(), initArg.getClass());
        }
    }

    protected void setConfig(Element conf) {
        this.createQueue = this.getCreateFlag(conf);
    }

    protected void setConfig(Boolean create) {
        this.createQueue = create;
    }

    @Override
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        if (!(scheduler instanceof FairScheduler)) {
            throw new IOException(this.getName() + " rule can only be configured for the FairScheduler");
        }
        if (this.getParentRule() != null && this.getParentRule().getName().equals(this.getName())) {
            throw new IOException("Parent rule may not be the same type as the child rule: " + this.getName());
        }
        FairScheduler fs = (FairScheduler)scheduler;
        this.queueManager = fs.getQueueManager();
        return true;
    }

    boolean configuredQueue(String queueName) {
        FSQueue queue = this.queueManager.getQueue(queueName);
        return queue != null && !queue.isDynamic();
    }

    public boolean getCreateFlag() {
        return this.createQueue;
    }

    boolean getCreateFlag(Element conf) {
        if (conf != null) {
            String create = conf.getAttribute("create");
            return create.isEmpty() || Boolean.parseBoolean(create);
        }
        return true;
    }
}

