/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePlacementRuleUtils;

public class QueueMappingEntity {
    private String source;
    private String queue;
    private String parentQueue;
    private String fullPath;
    public static final String DELIMITER = ":";

    public QueueMappingEntity(String source, String queue) {
        this.source = source;
        this.queue = queue;
        this.parentQueue = null;
        this.fullPath = queue;
    }

    public QueueMappingEntity(String source, String queue, String parentQueue) {
        this.source = source;
        this.queue = queue;
        this.parentQueue = parentQueue;
        this.fullPath = parentQueue + "." + queue;
    }

    public QueueMappingEntity(String source, QueuePath path) {
        this.source = source;
        this.queue = path.getLeafQueue();
        this.parentQueue = path.getParentQueue();
        this.fullPath = this.parentQueue + "." + this.queue;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getParentQueue() {
        return this.parentQueue;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getSource() {
        return this.source;
    }

    public boolean hasParentQueue() {
        return this.parentQueue != null;
    }

    public QueuePath getQueuePath() {
        return QueuePlacementRuleUtils.extractQueuePath(this.getFullPath());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueueMappingEntity) {
            QueueMappingEntity other = (QueueMappingEntity)obj;
            return other.source.equals(this.source) && other.queue.equals(this.queue);
        }
        return false;
    }

    public String toString() {
        return this.source + DELIMITER + (this.parentQueue != null ? this.parentQueue + "." + this.queue : this.queue);
    }
}

