/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMappingEntity;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;

public final class QueuePlacementRuleUtils {
    public static final String CURRENT_USER_MAPPING = "%user";
    public static final String PRIMARY_GROUP_MAPPING = "%primary_group";
    public static final String SECONDARY_GROUP_MAPPING = "%secondary_group";

    private QueuePlacementRuleUtils() {
    }

    public static void validateQueueMappingUnderParentQueue(CSQueue parentQueue, String parentQueueName, String leafQueuePath) throws IOException {
        if (parentQueue == null) {
            throw new IOException("mapping contains invalid or non-leaf queue [" + leafQueuePath + "] and invalid parent queue [" + parentQueueName + "]");
        }
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IOException("mapping contains leaf queue [" + leafQueuePath + "] and invalid parent queue which does not have auto creation of leaf queues enabled [" + parentQueueName + "]");
        }
        if (!parentQueue.getQueueShortName().equals(parentQueueName) && !parentQueue.getQueuePath().equals(parentQueueName)) {
            throw new IOException("mapping contains invalid or non-leaf queue [" + leafQueuePath + "] and invalid parent queue which does not match existing leaf queue's parent : [" + parentQueueName + "] does not match [ " + parentQueue.getQueueShortName() + "]");
        }
    }

    public static QueueMappingEntity validateAndGetAutoCreatedQueueMapping(CapacitySchedulerQueueManager queueManager, QueueMappingEntity mapping, QueuePath queuePath) throws IOException {
        if (queuePath.hasParentQueue()) {
            QueuePlacementRuleUtils.validateQueueMappingUnderParentQueue(queueManager.getQueue(queuePath.getParentQueue()), queuePath.getParentQueue(), queuePath.getFullPath());
            return new QueueMappingEntity(mapping.getSource(), queuePath.getFullPath(), queuePath.getParentQueue());
        }
        return null;
    }

    public static QueueMappingEntity validateAndGetQueueMapping(CapacitySchedulerQueueManager queueManager, CSQueue queue, QueueMappingEntity mapping, QueuePath queuePath) throws IOException {
        if (!(queue instanceof LeafQueue)) {
            throw new IOException("mapping contains invalid or non-leaf queue : " + mapping.getFullPath());
        }
        if (queue instanceof AutoCreatedLeafQueue && queue.getParent() instanceof ManagedParentQueue) {
            QueueMappingEntity newMapping = QueuePlacementRuleUtils.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
            if (newMapping == null) {
                throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getFullPath());
            }
            return newMapping;
        }
        return mapping;
    }

    public static boolean isStaticQueueMapping(QueueMappingEntity mapping) {
        return !mapping.getQueue().contains(CURRENT_USER_MAPPING) && !mapping.getQueue().contains(PRIMARY_GROUP_MAPPING) && !mapping.getQueue().contains(SECONDARY_GROUP_MAPPING);
    }

    public static QueuePath extractQueuePath(String queuePath) {
        int parentQueueNameEndIndex = queuePath.lastIndexOf(".");
        if (parentQueueNameEndIndex > -1) {
            String parentQueue = queuePath.substring(0, parentQueueNameEndIndex).trim();
            String leafQueue = queuePath.substring(parentQueueNameEndIndex + 1).trim();
            return new QueuePath(parentQueue, leafQueue);
        }
        return new QueuePath(queuePath);
    }

    public static ApplicationPlacementContext getPlacementContext(QueueMappingEntity mapping, CapacitySchedulerQueueManager queueManager) throws IOException {
        return QueuePlacementRuleUtils.getPlacementContext(mapping, mapping.getQueue(), queueManager);
    }

    public static ApplicationPlacementContext getPlacementContext(QueueMappingEntity mapping, String leafQueueName, CapacitySchedulerQueueManager queueManager) throws IOException {
        if (!mapping.hasParentQueue() && queueManager.isAmbiguous(leafQueueName)) {
            throw new IOException("mapping contains ambiguous leaf queue reference " + leafQueueName);
        }
        if (!StringUtils.isEmpty((CharSequence)mapping.getParentQueue())) {
            return new ApplicationPlacementContext(leafQueueName, mapping.getParentQueue());
        }
        return new ApplicationPlacementContext(leafQueueName);
    }
}

