/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.volume.csi;

import org.apache.hadoop.shaded.com.google.common.base.Strings;
import org.apache.hadoop.yarn.server.volume.csi.exception.InvalidVolumeException;

public final class VolumeCapabilityRange {
    private final long minCapacity;
    private final long maxCapacity;
    private final String unit;

    private VolumeCapabilityRange(long minCapacity, long maxCapacity, String unit) {
        this.minCapacity = minCapacity;
        this.maxCapacity = maxCapacity;
        this.unit = unit;
    }

    public long getMinCapacity() {
        return this.minCapacity;
    }

    public long getMaxCapacity() {
        return this.maxCapacity;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        return "MinCapability: " + this.minCapacity + this.unit + ", MaxCapability: " + this.maxCapacity + this.unit;
    }

    public static VolumeCapabilityBuilder newBuilder() {
        return new VolumeCapabilityBuilder();
    }

    public static class VolumeCapabilityBuilder {
        private long minCap = -1L;
        private long maxCap = Long.MAX_VALUE;
        private String unit;

        public VolumeCapabilityBuilder minCapacity(long minCapacity) {
            this.minCap = minCapacity;
            return this;
        }

        public VolumeCapabilityBuilder maxCapacity(long maxCapacity) {
            this.maxCap = maxCapacity;
            return this;
        }

        public VolumeCapabilityBuilder unit(String capacityUnit) {
            this.unit = capacityUnit;
            return this;
        }

        public VolumeCapabilityRange build() throws InvalidVolumeException {
            VolumeCapabilityRange capability = new VolumeCapabilityRange(this.minCap, this.maxCap, this.unit);
            this.validateCapability(capability);
            return capability;
        }

        private void validateCapability(VolumeCapabilityRange capability) throws InvalidVolumeException {
            if (capability.getMinCapacity() < 0L) {
                throw new InvalidVolumeException("Invalid volume capability range, minimal capability must not be less than 0. Capability: " + capability.toString());
            }
            if (Strings.isNullOrEmpty((String)capability.getUnit())) {
                throw new InvalidVolumeException("Invalid volume capability range, capability unit is missing. Capability: " + capability.toString());
            }
        }
    }
}

