/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FCStatisticsBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(FCStatisticsBaseTest.class);
    protected static int blockSize = 512;
    protected static int numBlocks = 1;
    protected final FileContextTestHelper fileContextTestHelper = new FileContextTestHelper();
    protected static FileContext fc = null;

    @Test(timeout=60000L)
    public void testStatisticsOperations() throws Exception {
        final FileSystem.Statistics stats = new FileSystem.Statistics("file");
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        Assert.assertEquals((long)0L, (long)stats.getBytesWritten());
        Assert.assertEquals((long)0L, (long)stats.getWriteOps());
        stats.incrementBytesWritten(1000L);
        Assert.assertEquals((long)1000L, (long)stats.getBytesWritten());
        Assert.assertEquals((long)0L, (long)stats.getWriteOps());
        stats.incrementWriteOps(123);
        Assert.assertEquals((long)123L, (long)stats.getWriteOps());
        Thread thread = new Thread(){

            @Override
            public void run() {
                stats.incrementWriteOps(1);
            }
        };
        thread.start();
        Uninterruptibles.joinUninterruptibly((Thread)thread);
        Assert.assertEquals((long)124L, (long)stats.getWriteOps());
        FileSystem.Statistics stats2 = new FileSystem.Statistics(stats);
        stats.reset();
        Assert.assertEquals((long)0L, (long)stats.getWriteOps());
        Assert.assertEquals((long)0L, (long)stats.getBytesWritten());
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        Assert.assertEquals((long)124L, (long)stats2.getWriteOps());
        Assert.assertEquals((long)1000L, (long)stats2.getBytesWritten());
        Assert.assertEquals((long)0L, (long)stats2.getBytesRead());
    }

    @Test
    public void testStatistics() throws IOException, URISyntaxException {
        URI fsUri = this.getFsUri();
        FileSystem.Statistics stats = FileContext.getStatistics((URI)fsUri);
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        Path filePath = this.fileContextTestHelper.getTestRootPath(fc, "file1");
        FileContextTestHelper.createFile(fc, filePath, numBlocks, blockSize);
        Assert.assertEquals((long)0L, (long)stats.getBytesRead());
        this.verifyWrittenBytes(stats);
        FSDataInputStream fstr = fc.open(filePath);
        byte[] buf = new byte[blockSize];
        int bytesRead = fstr.read(buf, 0, blockSize);
        fstr.read(0L, buf, 0, blockSize);
        Assert.assertEquals((long)blockSize, (long)bytesRead);
        this.verifyReadBytes(stats);
        this.verifyWrittenBytes(stats);
        this.verifyReadBytes(FileContext.getStatistics((URI)this.getFsUri()));
        Map statsMap = FileContext.getAllStatistics();
        URI exactUri = this.getSchemeAuthorityUri();
        this.verifyWrittenBytes((FileSystem.Statistics)statsMap.get(exactUri));
        fc.delete(filePath, true);
    }

    @Test(timeout=70000L)
    public void testStatisticsThreadLocalDataCleanUp() throws Exception {
        final FileSystem.Statistics stats = new FileSystem.Statistics("test");
        int size = 2;
        ExecutorService es = Executors.newFixedThreadPool(2);
        ArrayList<2> tasks = new ArrayList<2>(2);
        for (int i = 0; i < 2; ++i) {
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    stats.incrementReadOps(1);
                    return true;
                }
            });
        }
        es.invokeAll(tasks);
        final AtomicInteger allDataSize = new AtomicInteger(0);
        allDataSize.set(stats.getAllThreadLocalDataSize());
        Assert.assertEquals((long)2L, (long)allDataSize.get());
        Assert.assertEquals((long)2L, (long)stats.getReadOps());
        es.shutdownNow();
        es.awaitTermination(1L, TimeUnit.MINUTES);
        es = null;
        System.gc();
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                int size = stats.getAllThreadLocalDataSize();
                allDataSize.set(size);
                if (size == 0) {
                    return true;
                }
                LOG.warn("not all references have been cleaned up; still " + allDataSize.get() + " references left");
                LOG.warn("triggering another GC");
                System.gc();
                return false;
            }
        }, 500L, 60000L);
        Assert.assertEquals((long)0L, (long)allDataSize.get());
        Assert.assertEquals((long)2L, (long)stats.getReadOps());
    }

    protected abstract void verifyReadBytes(FileSystem.Statistics var1);

    protected abstract void verifyWrittenBytes(FileSystem.Statistics var1);

    protected abstract URI getFsUri();

    protected URI getSchemeAuthorityUri() {
        URI uri = this.getFsUri();
        String SchemeAuthString = uri.getScheme() + "://";
        SchemeAuthString = uri.getAuthority() == null ? SchemeAuthString + "/" : SchemeAuthString + uri.getAuthority();
        return URI.create(SchemeAuthString);
    }
}

