/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostSet;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowDiskTracker;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerTracker;
import org.apache.hadoop.hdfs.server.blockmanagement.StorageTypeStats;
import org.apache.hadoop.hdfs.server.blockmanagement.UnresolvedTopologyException;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockECReconstructionCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockIdCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMappingWithDependency;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.javax.websocket.Nonnull;
import org.apache.hadoop.shaded.javax.websocket.Nullable;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.thirdparty.com.google.common.net.InetAddresses;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeManager {
    static final Logger LOG = LoggerFactory.getLogger(DatanodeManager.class);
    private final Namesystem namesystem;
    private final BlockManager blockManager;
    private final DatanodeAdminManager datanodeAdminManager;
    private final HeartbeatManager heartbeatManager;
    private final FSClusterStats fsClusterStats;
    private volatile long heartbeatIntervalSeconds;
    private volatile int heartbeatRecheckInterval;
    private final Map<String, DatanodeDescriptor> datanodeMap = new HashMap<String, DatanodeDescriptor>();
    private final NetworkTopology networktopology;
    private final Host2NodesMap host2DatanodeMap = new Host2NodesMap();
    private final DNSToSwitchMapping dnsToSwitchMapping;
    private final boolean rejectUnresolvedTopologyDN;
    private final int defaultXferPort;
    private final int defaultInfoPort;
    private final int defaultInfoSecurePort;
    private final int defaultIpcPort;
    private HostConfigManager hostConfigManager;
    private long heartbeatExpireInterval;
    private volatile int blockInvalidateLimit;
    private final long staleInterval;
    private final boolean avoidStaleDataNodesForRead;
    private final boolean readConsiderLoad;
    private final boolean readConsiderStorageType;
    private final boolean avoidStaleDataNodesForWrite;
    private final float ratioUseStaleDataNodesForWrite;
    private volatile int numStaleNodes;
    private volatile int numStaleStorages;
    private final long blocksPerPostponedMisreplicatedBlocksRescan;
    private boolean hasClusterEverBeenMultiRack = false;
    private final boolean checkIpHostnameInRegistration;
    private boolean shouldSendCachingCommands = false;
    private final HashMap<String, Integer> datanodesSoftwareVersions = new HashMap(4, 0.75f);
    private final boolean dataNodePeerStatsEnabled;
    private final boolean dataNodeDiskStatsEnabled;
    private final boolean useDfsNetworkTopology;
    private static final String IP_PORT_SEPARATOR = ":";
    @Nullable
    private final SlowPeerTracker slowPeerTracker;
    private static Set<Node> slowNodesSet = Sets.newConcurrentHashSet();
    private Daemon slowPeerCollectorDaemon;
    private final long slowPeerCollectionInterval;
    private final int maxSlowPeerReportNodes;
    private boolean excludeSlowNodesEnabled;
    @Nullable
    private final SlowDiskTracker slowDiskTracker;
    private final long timeBetweenResendingCachingDirectivesMs;

    DatanodeManager(BlockManager blockManager, Namesystem namesystem, Configuration conf) throws IOException {
        this.namesystem = namesystem;
        this.blockManager = blockManager;
        this.useDfsNetworkTopology = conf.getBoolean("dfs.use.dfs.network.topology", true);
        this.networktopology = this.useDfsNetworkTopology ? DFSNetworkTopology.getInstance(conf) : NetworkTopology.getInstance((Configuration)conf);
        this.heartbeatManager = new HeartbeatManager(namesystem, blockManager, conf);
        this.datanodeAdminManager = new DatanodeAdminManager(namesystem, blockManager, this.heartbeatManager);
        this.fsClusterStats = this.newFSClusterStats();
        this.dataNodePeerStatsEnabled = conf.getBoolean("dfs.datanode.peer.stats.enabled", false);
        this.dataNodeDiskStatsEnabled = Util.isDiskStatsEnabled(conf.getInt("dfs.datanode.fileio.profiling.sampling.percentage", 0));
        Timer timer = new Timer();
        this.slowPeerTracker = this.dataNodePeerStatsEnabled ? new SlowPeerTracker(conf, timer) : null;
        this.excludeSlowNodesEnabled = conf.getBoolean("dfs.namenode.block-placement-policy.exclude-slow-nodes.enabled", false);
        this.maxSlowPeerReportNodes = conf.getInt("dfs.namenode.max.slowpeer.collect.nodes", 5);
        this.slowPeerCollectionInterval = conf.getTimeDuration("dfs.namenode.slowpeer.collect.interval", "30m", TimeUnit.MILLISECONDS);
        if (this.slowPeerTracker != null && this.excludeSlowNodesEnabled) {
            this.startSlowPeerCollector();
        }
        this.slowDiskTracker = this.dataNodeDiskStatsEnabled ? new SlowDiskTracker(conf, timer) : null;
        this.defaultXferPort = NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.address", "0.0.0.0:9866")).getPort();
        this.defaultInfoPort = NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.http.address", "0.0.0.0:9864")).getPort();
        this.defaultInfoSecurePort = NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.https.address", "0.0.0.0:9865")).getPort();
        this.defaultIpcPort = NetUtils.createSocketAddr((String)conf.getTrimmed("dfs.datanode.ipc.address", "0.0.0.0:9867")).getPort();
        this.hostConfigManager = (HostConfigManager)ReflectionUtils.newInstance((Class)conf.getClass("dfs.namenode.hosts.provider.classname", HostFileManager.class, HostConfigManager.class), (Configuration)conf);
        try {
            this.hostConfigManager.refresh();
        }
        catch (IOException e) {
            LOG.error("error reading hosts files: ", (Throwable)e);
        }
        this.dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), (Configuration)conf);
        this.rejectUnresolvedTopologyDN = conf.getBoolean("dfs.namenode.reject-unresolved-dn-topology-mapping", false);
        if (this.dnsToSwitchMapping instanceof CachedDNSToSwitchMapping) {
            ArrayList<String> locations = new ArrayList<String>();
            for (InetSocketAddress addr : this.hostConfigManager.getIncludes()) {
                locations.add(addr.getAddress().getHostAddress());
            }
            this.dnsToSwitchMapping.resolve(locations);
        }
        this.heartbeatIntervalSeconds = conf.getTimeDuration("dfs.heartbeat.interval", 3L, TimeUnit.SECONDS);
        this.heartbeatRecheckInterval = conf.getInt("dfs.namenode.heartbeat.recheck-interval", 300000);
        this.heartbeatExpireInterval = (long)(2 * this.heartbeatRecheckInterval) + 10000L * this.heartbeatIntervalSeconds;
        int configuredBlockInvalidateLimit = conf.getInt("dfs.block.invalidate.limit", 1000);
        int countedBlockInvalidateLimit = 20 * (int)this.heartbeatIntervalSeconds;
        this.blockInvalidateLimit = Math.max(countedBlockInvalidateLimit, configuredBlockInvalidateLimit);
        LOG.info("dfs.block.invalidate.limit: configured=" + configuredBlockInvalidateLimit + ", counted=" + countedBlockInvalidateLimit + ", effected=" + this.blockInvalidateLimit);
        this.checkIpHostnameInRegistration = conf.getBoolean("dfs.namenode.datanode.registration.ip-hostname-check", true);
        LOG.info("dfs.namenode.datanode.registration.ip-hostname-check=" + this.checkIpHostnameInRegistration);
        this.avoidStaleDataNodesForRead = conf.getBoolean("dfs.namenode.avoid.read.stale.datanode", false);
        this.readConsiderLoad = conf.getBoolean("dfs.namenode.read.considerLoad", false);
        this.readConsiderStorageType = conf.getBoolean("dfs.namenode.read.considerStorageType", false);
        if (this.readConsiderLoad && this.readConsiderStorageType) {
            LOG.warn("{} and {} are incompatible and only one can be enabled. Both are currently enabled. {} will be ignored.", new Object[]{"dfs.namenode.read.considerLoad", "dfs.namenode.read.considerStorageType", "dfs.namenode.read.considerStorageType"});
        }
        this.avoidStaleDataNodesForWrite = conf.getBoolean("dfs.namenode.avoid.write.stale.datanode", false);
        this.staleInterval = DatanodeManager.getStaleIntervalFromConf(conf, this.heartbeatExpireInterval);
        this.ratioUseStaleDataNodesForWrite = conf.getFloat("dfs.namenode.write.stale.datanode.ratio", 0.5f);
        Preconditions.checkArgument((this.ratioUseStaleDataNodesForWrite > 0.0f && this.ratioUseStaleDataNodesForWrite <= 1.0f ? 1 : 0) != 0, (Object)("dfs.namenode.write.stale.datanode.ratio = '" + this.ratioUseStaleDataNodesForWrite + "' is invalid. It should be a positive non-zero float value, not greater than 1.0f."));
        this.timeBetweenResendingCachingDirectivesMs = conf.getLong("dfs.namenode.path.based.cache.retry.interval.ms", 30000L);
        this.blocksPerPostponedMisreplicatedBlocksRescan = conf.getLong("dfs.namenode.blocks.per.postponedblocks.rescan", 10000L);
    }

    private void startSlowPeerCollector() {
        if (this.slowPeerCollectorDaemon != null) {
            return;
        }
        this.slowPeerCollectorDaemon = new Daemon(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        slowNodesSet = DatanodeManager.this.getSlowPeers();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to collect slow peers", (Throwable)e);
                    }
                    try {
                        Thread.sleep(DatanodeManager.this.slowPeerCollectionInterval);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Slow peers collection thread interrupted", (Throwable)e);
                        return;
                    }
                }
            }
        });
        this.slowPeerCollectorDaemon.start();
    }

    public void stopSlowPeerCollector() {
        if (this.slowPeerCollectorDaemon == null) {
            return;
        }
        this.slowPeerCollectorDaemon.interrupt();
        try {
            this.slowPeerCollectorDaemon.join();
        }
        catch (InterruptedException e) {
            LOG.error("Slow peers collection thread did not shutdown", (Throwable)e);
        }
    }

    private static long getStaleIntervalFromConf(Configuration conf, long heartbeatExpireInterval) {
        long staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
        Preconditions.checkArgument((staleInterval > 0L ? 1 : 0) != 0, (Object)("dfs.namenode.stale.datanode.interval = '" + staleInterval + "' is invalid. It should be a positive non-zero value."));
        long heartbeatIntervalSeconds = conf.getTimeDuration("dfs.heartbeat.interval", 3L, TimeUnit.SECONDS);
        long minStaleInterval = (long)conf.getInt("dfs.namenode.stale.datanode.minimum.interval", 3) * heartbeatIntervalSeconds * 1000L;
        if (staleInterval < minStaleInterval) {
            LOG.warn("The given interval for marking stale datanode = " + staleInterval + ", which is less than " + 3 + " heartbeat intervals. This may cause too frequent changes of stale states of DataNodes since a heartbeat msg may be missing due to temporary short-term failures. Reset stale interval to " + minStaleInterval + ".");
            staleInterval = minStaleInterval;
        }
        if (staleInterval > heartbeatExpireInterval) {
            LOG.warn("The given interval for marking stale datanode = " + staleInterval + ", which is larger than heartbeat expire interval " + heartbeatExpireInterval + ".");
        }
        return staleInterval;
    }

    void activate(Configuration conf) {
        this.datanodeAdminManager.activate(conf);
        this.heartbeatManager.activate();
    }

    void close() {
        this.datanodeAdminManager.close();
        this.heartbeatManager.close();
        this.stopSlowPeerCollector();
    }

    public NetworkTopology getNetworkTopology() {
        return this.networktopology;
    }

    HeartbeatManager getHeartbeatManager() {
        return this.heartbeatManager;
    }

    @VisibleForTesting
    public DatanodeAdminManager getDatanodeAdminManager() {
        return this.datanodeAdminManager;
    }

    public HostConfigManager getHostConfigManager() {
        return this.hostConfigManager;
    }

    @VisibleForTesting
    public void setHeartbeatExpireInterval(long expiryMs) {
        this.heartbeatExpireInterval = expiryMs;
    }

    @VisibleForTesting
    public FSClusterStats getFSClusterStats() {
        return this.fsClusterStats;
    }

    @VisibleForTesting
    public int getBlockInvalidateLimit() {
        return this.blockInvalidateLimit;
    }

    public DatanodeStatistics getDatanodeStatistics() {
        return this.heartbeatManager;
    }

    private boolean isInactive(DatanodeInfo datanode) {
        return datanode.isDecommissioned() || this.avoidStaleDataNodesForRead && datanode.isStale(this.staleInterval);
    }

    public void sortLocatedBlocks(String targetHost, List<LocatedBlock> locatedBlocks) {
        DFSUtil.ServiceComparator comparator = this.avoidStaleDataNodesForRead ? new DFSUtil.ServiceAndStaleComparator(this.staleInterval) : new DFSUtil.ServiceComparator();
        for (LocatedBlock lb : locatedBlocks) {
            if (lb.isStriped()) {
                this.sortLocatedStripedBlock(lb, comparator);
                continue;
            }
            this.sortLocatedBlock(lb, targetHost, comparator);
        }
    }

    private void sortLocatedStripedBlock(LocatedBlock lb, Comparator<DatanodeInfo> comparator) {
        int i;
        DatanodeInfoWithStorage[] di = lb.getLocations();
        HashMap<DatanodeInfoWithStorage, Byte> locToIndex = new HashMap<DatanodeInfoWithStorage, Byte>();
        HashMap<DatanodeInfoWithStorage, Token> locToToken = new HashMap<DatanodeInfoWithStorage, Token>();
        LocatedStripedBlock lsb = (LocatedStripedBlock)lb;
        for (i = 0; i < di.length; ++i) {
            locToIndex.put(di[i], lsb.getBlockIndices()[i]);
            locToToken.put(di[i], lsb.getBlockTokens()[i]);
        }
        Arrays.sort(di, comparator);
        lb.updateCachedStorageInfo();
        for (i = 0; i < di.length; ++i) {
            lsb.getBlockIndices()[i] = (Byte)locToIndex.get(di[i]);
            lsb.getBlockTokens()[i] = (Token)locToToken.get(di[i]);
        }
    }

    private void sortLocatedBlock(LocatedBlock lb, String targetHost, Comparator<DatanodeInfo> comparator) {
        int lastActiveIndex;
        boolean nonDatanodeReader = false;
        DatanodeDescriptor client = this.getDatanodeByHost(targetHost);
        if (client == null) {
            nonDatanodeReader = true;
            ArrayList<String> hosts = new ArrayList<String>(1);
            hosts.add(targetHost);
            List resolvedHosts = this.dnsToSwitchMapping.resolve(hosts);
            if (resolvedHosts != null && !resolvedHosts.isEmpty()) {
                String rName = (String)resolvedHosts.get(0);
                if (rName != null) {
                    client = new NodeBase(rName + "/" + targetHost);
                }
            } else {
                LOG.error("Node Resolution failed. Please make sure that rack awareness scripts are functional.");
            }
        }
        DatanodeInfoWithStorage[] di = lb.getLocations();
        Arrays.sort(di, comparator);
        for (lastActiveIndex = di.length - 1; lastActiveIndex > 0 && this.isInactive((DatanodeInfo)di[lastActiveIndex]); --lastActiveIndex) {
        }
        int activeLen = lastActiveIndex + 1;
        if (nonDatanodeReader) {
            this.networktopology.sortByDistanceUsingNetworkLocation((Node)client, (Node[])lb.getLocations(), activeLen, this.createSecondaryNodeSorter());
        } else {
            this.networktopology.sortByDistance((Node)client, (Node[])lb.getLocations(), activeLen, this.createSecondaryNodeSorter());
        }
        lb.moveProvidedToEnd(activeLen);
        lb.updateCachedStorageInfo();
    }

    private Consumer<List<DatanodeInfoWithStorage>> createSecondaryNodeSorter() {
        Comparator<DatanodeInfoWithStorage> comp;
        Consumer<List> secondarySort = null;
        if (this.readConsiderStorageType) {
            comp = Comparator.comparing(DatanodeInfoWithStorage::getStorageType);
            secondarySort = list -> Collections.sort(list, comp);
        }
        if (this.readConsiderLoad) {
            comp = Comparator.comparingInt(DatanodeInfo::getXceiverCount);
            secondarySort = list -> Collections.sort(list, comp);
        }
        return secondarySort;
    }

    public DatanodeDescriptor getDatanodeByHost(String host) {
        return this.host2DatanodeMap.getDatanodeByHost(host);
    }

    public DatanodeDescriptor getDatanodeByXferAddr(String host, int xferPort) {
        return this.host2DatanodeMap.getDatanodeByXferAddr(host, xferPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DatanodeDescriptor> getDatanodes() {
        HashSet<DatanodeDescriptor> datanodes;
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            datanodes = new HashSet<DatanodeDescriptor>(this.datanodeMap.values());
        }
        return datanodes;
    }

    public Host2NodesMap getHost2DatanodeMap() {
        return this.host2DatanodeMap;
    }

    DatanodeDescriptor getDatanodeDescriptor(String address) {
        int xferPort;
        DatanodeID dnId = this.parseDNFromHostsEntry(address);
        String host = dnId.getIpAddr();
        DatanodeDescriptor node = this.getDatanodeByXferAddr(host, xferPort = dnId.getXferPort());
        if (node == null) {
            node = this.getDatanodeByHost(host);
        }
        if (node == null) {
            String networkLocation = this.resolveNetworkLocationWithFallBackToDefaultLocation(dnId);
            List rackNodes = this.getNetworkTopology().getDatanodesInRack(networkLocation);
            if (rackNodes != null) {
                for (Node rackNode : rackNodes) {
                    if (!((DatanodeDescriptor)rackNode).getIpAddr().equals(host)) continue;
                    node = (DatanodeDescriptor)rackNode;
                    break;
                }
                if (node == null && !rackNodes.isEmpty()) {
                    node = (DatanodeDescriptor)((Object)rackNodes.get(ThreadLocalRandom.current().nextInt(rackNodes.size())));
                }
            }
            if (node == null) {
                node = (DatanodeDescriptor)this.getNetworkTopology().chooseRandom("");
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeDescriptor getDatanode(String datanodeUuid) {
        if (datanodeUuid == null) {
            return null;
        }
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            return this.datanodeMap.get(datanodeUuid);
        }
    }

    public DatanodeDescriptor getDatanode(DatanodeID nodeID) throws UnregisteredNodeException {
        DatanodeDescriptor node = this.getDatanode(nodeID.getDatanodeUuid());
        if (node == null) {
            return null;
        }
        if (!node.getXferAddr().equals(nodeID.getXferAddr())) {
            UnregisteredNodeException e = new UnregisteredNodeException(nodeID, node);
            NameNode.stateChangeLog.error("BLOCK* NameSystem.getDatanode: " + e.getLocalizedMessage());
            throw e;
        }
        return node;
    }

    public DatanodeStorageInfo[] getDatanodeStorageInfos(DatanodeID[] datanodeID, String[] storageIDs, String format, Object ... args) throws UnregisteredNodeException {
        String[] stringArray = storageIDs = storageIDs == null ? new String[]{} : storageIDs;
        if (datanodeID.length != storageIDs.length) {
            String err = (storageIDs.length == 0 ? "Missing storageIDs: It is likely that the HDFS client, who made this call, is running in an older version of Hadoop(pre-2.0.0-alpha)  which does not support storageIDs." : "Length mismatched: storageIDs.length=" + storageIDs.length + " != ") + " datanodeID.length=" + datanodeID.length;
            throw new HadoopIllegalArgumentException(err + ", " + String.format(format, args));
        }
        if (datanodeID.length == 0) {
            return null;
        }
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[datanodeID.length];
        for (int i = 0; i < datanodeID.length; ++i) {
            if (datanodeID[i].equals((Object)DatanodeID.EMPTY_DATANODE_ID)) {
                storages[i] = null;
                continue;
            }
            DatanodeDescriptor dd = this.getDatanode(datanodeID[i]);
            if (dd == null) continue;
            storages[i] = dd.getStorageInfo(storageIDs[i]);
        }
        return storages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void datanodeDump(PrintWriter out) {
        TreeMap<String, DatanodeDescriptor> sortedDatanodeMap;
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            sortedDatanodeMap = new TreeMap<String, DatanodeDescriptor>(this.datanodeMap);
        }
        out.println("Metasave: Number of datanodes: " + sortedDatanodeMap.size());
        for (DatanodeDescriptor node : sortedDatanodeMap.values()) {
            out.println(node.dumpDatanode());
        }
    }

    private void removeDatanode(DatanodeDescriptor nodeInfo) {
        this.removeDatanode(nodeInfo, true);
    }

    private void removeDatanode(DatanodeDescriptor nodeInfo, boolean removeBlocksFromBlocksMap) {
        assert (this.namesystem.hasWriteLock());
        this.heartbeatManager.removeDatanode(nodeInfo);
        if (removeBlocksFromBlocksMap) {
            this.blockManager.removeBlocksAssociatedTo(nodeInfo);
        }
        this.networktopology.remove((Node)nodeInfo);
        this.decrementVersionCount(nodeInfo.getSoftwareVersion());
        this.blockManager.getBlockReportLeaseManager().unregister(nodeInfo);
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove datanode " + (Object)((Object)nodeInfo));
        }
        this.blockManager.checkSafeMode();
    }

    public void removeDatanode(DatanodeID node) throws UnregisteredNodeException {
        this.namesystem.writeLock();
        try {
            DatanodeDescriptor descriptor = this.getDatanode(node);
            if (descriptor != null) {
                this.removeDatanode(descriptor, true);
            } else {
                NameNode.stateChangeLog.warn("BLOCK* removeDatanode: " + node + " does not exist");
            }
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    void removeDeadDatanode(DatanodeID nodeID, boolean removeBlocksFromBlockMap) {
        DatanodeDescriptor d;
        try {
            d = this.getDatanode(nodeID);
        }
        catch (IOException e) {
            d = null;
        }
        if (d != null && this.isDatanodeDead(d)) {
            NameNode.stateChangeLog.info("BLOCK* removeDeadDatanode: lost heartbeat from " + (Object)((Object)d) + ", removeBlocksFromBlockMap " + removeBlocksFromBlockMap);
            this.removeDatanode(d, removeBlocksFromBlockMap);
        }
    }

    boolean isDatanodeDead(DatanodeDescriptor node) {
        return node.getLastUpdateMonotonic() < Time.monotonicNow() - this.heartbeatExpireInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDatanode(DatanodeDescriptor node) {
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            this.host2DatanodeMap.remove(this.datanodeMap.put(node.getDatanodeUuid(), node));
        }
        this.networktopology.add((Node)node);
        this.host2DatanodeMap.add(node);
        this.checkIfClusterIsNowMultiRack(node);
        this.resolveUpgradeDomain(node);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getClass().getSimpleName() + ".addDatanode: node " + (Object)((Object)node) + " is added to datanodeMap.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wipeDatanode(DatanodeID node) {
        String key = node.getDatanodeUuid();
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            this.host2DatanodeMap.remove(this.datanodeMap.remove(key));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getClass().getSimpleName() + ".wipeDatanode(" + node + "): storage " + key + " is removed from datanodeMap.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementVersionCount(String version) {
        if (version == null) {
            return;
        }
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            Integer count = this.datanodesSoftwareVersions.get(version);
            count = count == null ? 1 : count + 1;
            this.datanodesSoftwareVersions.put(version, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementVersionCount(String version) {
        if (version == null) {
            return;
        }
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            Integer count = this.datanodesSoftwareVersions.get(version);
            if (count != null) {
                if (count > 1) {
                    this.datanodesSoftwareVersions.put(version, count - 1);
                } else {
                    this.datanodesSoftwareVersions.remove(version);
                }
            }
        }
    }

    private boolean shouldCountVersion(DatanodeDescriptor node) {
        return node.getSoftwareVersion() != null && node.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countSoftwareVersions() {
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            this.datanodesSoftwareVersions.clear();
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                if (!this.shouldCountVersion(dn)) continue;
                Integer num = this.datanodesSoftwareVersions.get(dn.getSoftwareVersion());
                num = num == null ? 1 : num + 1;
                this.datanodesSoftwareVersions.put(dn.getSoftwareVersion(), num);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Integer> getDatanodesSoftwareVersions() {
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            return new HashMap<String, Integer>(this.datanodesSoftwareVersions);
        }
    }

    void resolveUpgradeDomain(DatanodeDescriptor node) {
        String upgradeDomain = this.hostConfigManager.getUpgradeDomain((DatanodeID)node);
        if (upgradeDomain != null && upgradeDomain.length() > 0) {
            node.setUpgradeDomain(upgradeDomain);
        }
    }

    private String resolveNetworkLocationWithFallBackToDefaultLocation(DatanodeID node) {
        String networkLocation;
        try {
            networkLocation = this.resolveNetworkLocation(node);
        }
        catch (UnresolvedTopologyException e) {
            LOG.error("Unresolved topology mapping. Using /default-rack for host " + node.getHostName());
            networkLocation = "/default-rack";
        }
        return networkLocation;
    }

    private String resolveNetworkLocation(DatanodeID node) throws UnresolvedTopologyException {
        ArrayList<String> names = new ArrayList<String>(1);
        if (this.dnsToSwitchMapping instanceof CachedDNSToSwitchMapping) {
            names.add(node.getIpAddr());
        } else {
            names.add(node.getHostName());
        }
        List<String> rName = this.resolveNetworkLocation(names);
        if (rName == null) {
            LOG.error("The resolve call returned null!");
            throw new UnresolvedTopologyException("Unresolved topology mapping for host " + node.getHostName());
        }
        String networkLocation = rName.get(0);
        return networkLocation;
    }

    public List<String> resolveNetworkLocation(List<String> names) {
        return this.dnsToSwitchMapping.resolve(names);
    }

    private List<String> getNetworkDependenciesWithDefault(DatanodeInfo node) {
        List<String> dependencies;
        try {
            dependencies = this.getNetworkDependencies(node);
        }
        catch (UnresolvedTopologyException e) {
            LOG.error("Unresolved dependency mapping for host " + node.getHostName() + ". Continuing with an empty dependency list");
            dependencies = Collections.emptyList();
        }
        return dependencies;
    }

    private List<String> getNetworkDependencies(DatanodeInfo node) throws UnresolvedTopologyException {
        List dependencies = Collections.emptyList();
        if (this.dnsToSwitchMapping instanceof DNSToSwitchMappingWithDependency && (dependencies = ((DNSToSwitchMappingWithDependency)this.dnsToSwitchMapping).getDependency(node.getHostName())) == null) {
            LOG.error("The dependency call returned null for host " + node.getHostName());
            throw new UnresolvedTopologyException("The dependency call returned null for host " + node.getHostName());
        }
        return dependencies;
    }

    private static void removeDecomNodeFromList(List<DatanodeDescriptor> nodeList) {
        Iterator<DatanodeDescriptor> it = nodeList.iterator();
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            if (!node.isDecommissioned()) continue;
            it.remove();
        }
    }

    void startAdminOperationIfNecessary(DatanodeDescriptor nodeReg) {
        long maintenanceExpireTimeInMS = this.hostConfigManager.getMaintenanceExpirationTimeInMS((DatanodeID)nodeReg);
        if (this.getHostConfigManager().isExcluded((DatanodeID)nodeReg)) {
            this.datanodeAdminManager.startDecommission(nodeReg);
        } else if (DatanodeDescriptor.maintenanceNotExpired((long)maintenanceExpireTimeInMS)) {
            this.datanodeAdminManager.startMaintenance(nodeReg, maintenanceExpireTimeInMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatanode(DatanodeRegistration nodeReg) throws DisallowedDatanodeException, UnresolvedTopologyException {
        InetAddress dnAddress = Server.getRemoteIp();
        if (dnAddress != null) {
            String hostname = dnAddress.getHostName();
            String ip = dnAddress.getHostAddress();
            if (this.checkIpHostnameInRegistration && !DatanodeManager.isNameResolved(dnAddress)) {
                String message = "hostname cannot be resolved (ip=" + ip + ", hostname=" + hostname + ")";
                LOG.warn("Unresolved datanode registration: " + message);
                throw new DisallowedDatanodeException(nodeReg, message);
            }
            nodeReg.setIpAddr(ip);
            nodeReg.setPeerHostName(hostname);
        }
        try {
            nodeReg.setExportedKeys(this.blockManager.getBlockKeys());
            if (!this.hostConfigManager.isIncluded(nodeReg)) {
                throw new DisallowedDatanodeException(nodeReg);
            }
            NameNode.stateChangeLog.info("BLOCK* registerDatanode: from " + nodeReg + " storage " + nodeReg.getDatanodeUuid());
            DatanodeDescriptor nodeS = this.getDatanode(nodeReg.getDatanodeUuid());
            DatanodeDescriptor nodeN = this.host2DatanodeMap.getDatanodeByXferAddr(nodeReg.getIpAddr(), nodeReg.getXferPort());
            if (nodeN != null && nodeN != nodeS) {
                NameNode.LOG.info("BLOCK* registerDatanode: " + (Object)((Object)nodeN));
                this.removeDatanode(nodeN);
                this.wipeDatanode((DatanodeID)nodeN);
                nodeN = null;
            }
            if (nodeS != null) {
                if (nodeN == nodeS) {
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug("BLOCK* registerDatanode: node restarted.");
                    }
                } else {
                    NameNode.stateChangeLog.info("BLOCK* registerDatanode: " + (Object)((Object)nodeS) + " is replaced by " + nodeReg + " with the same storageID " + nodeReg.getDatanodeUuid());
                }
                boolean success = false;
                try {
                    this.getNetworkTopology().remove((Node)nodeS);
                    if (this.shouldCountVersion(nodeS)) {
                        this.decrementVersionCount(nodeS.getSoftwareVersion());
                    }
                    nodeS.updateRegInfo(nodeReg);
                    nodeS.setSoftwareVersion(nodeReg.getSoftwareVersion());
                    nodeS.setDisallowed(false);
                    if (this.rejectUnresolvedTopologyDN) {
                        nodeS.setNetworkLocation(this.resolveNetworkLocation((DatanodeID)nodeS));
                        nodeS.setDependentHostNames(this.getNetworkDependencies(nodeS));
                    } else {
                        nodeS.setNetworkLocation(this.resolveNetworkLocationWithFallBackToDefaultLocation((DatanodeID)nodeS));
                        nodeS.setDependentHostNames(this.getNetworkDependenciesWithDefault(nodeS));
                    }
                    this.getNetworkTopology().add((Node)nodeS);
                    this.resolveUpgradeDomain(nodeS);
                    this.heartbeatManager.register(nodeS);
                    this.incrementVersionCount(nodeS.getSoftwareVersion());
                    this.startAdminOperationIfNecessary(nodeS);
                    success = true;
                }
                finally {
                    if (!success) {
                        this.removeDatanode(nodeS);
                        this.wipeDatanode((DatanodeID)nodeS);
                        this.countSoftwareVersions();
                    }
                }
                return;
            }
            DatanodeDescriptor nodeDescr = new DatanodeDescriptor(nodeReg, "/default-rack");
            boolean success = false;
            try {
                if (this.rejectUnresolvedTopologyDN) {
                    nodeDescr.setNetworkLocation(this.resolveNetworkLocation((DatanodeID)nodeDescr));
                    nodeDescr.setDependentHostNames(this.getNetworkDependencies(nodeDescr));
                } else {
                    nodeDescr.setNetworkLocation(this.resolveNetworkLocationWithFallBackToDefaultLocation((DatanodeID)nodeDescr));
                    nodeDescr.setDependentHostNames(this.getNetworkDependenciesWithDefault(nodeDescr));
                }
                nodeDescr.setSoftwareVersion(nodeReg.getSoftwareVersion());
                this.resolveUpgradeDomain(nodeDescr);
                this.addDatanode(nodeDescr);
                this.blockManager.getBlockReportLeaseManager().register(nodeDescr);
                this.heartbeatManager.addDatanode(nodeDescr);
                this.heartbeatManager.updateDnStat(nodeDescr);
                this.incrementVersionCount(nodeReg.getSoftwareVersion());
                this.startAdminOperationIfNecessary(nodeDescr);
                success = true;
            }
            finally {
                if (!success) {
                    this.removeDatanode(nodeDescr);
                    this.wipeDatanode((DatanodeID)nodeDescr);
                    this.countSoftwareVersions();
                }
            }
        }
        catch (NetworkTopology.InvalidTopologyException e) {
            ArrayList<String> invalidNodeNames = new ArrayList<String>(3);
            invalidNodeNames.add(nodeReg.getIpAddr());
            invalidNodeNames.add(nodeReg.getHostName());
            invalidNodeNames.add(nodeReg.getPeerHostName());
            this.dnsToSwitchMapping.reloadCachedMappings(invalidNodeNames);
            throw e;
        }
    }

    public void refreshNodes(Configuration conf) throws IOException {
        this.refreshHostsReader(conf);
        this.namesystem.writeLock();
        try {
            this.refreshDatanodes();
            this.countSoftwareVersions();
        }
        finally {
            this.namesystem.writeUnlock();
        }
    }

    private void refreshHostsReader(Configuration conf) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
            this.hostConfigManager.setConf(conf);
        }
        this.hostConfigManager.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDatanodes() {
        HashMap<String, DatanodeDescriptor> copy;
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            copy = new HashMap<String, DatanodeDescriptor>(this.datanodeMap);
        }
        for (DatanodeDescriptor node : copy.values()) {
            if (!this.hostConfigManager.isIncluded((DatanodeID)node)) {
                node.setDisallowed(true);
            } else {
                long maintenanceExpireTimeInMS = this.hostConfigManager.getMaintenanceExpirationTimeInMS((DatanodeID)node);
                if (DatanodeDescriptor.maintenanceNotExpired((long)maintenanceExpireTimeInMS)) {
                    this.datanodeAdminManager.startMaintenance(node, maintenanceExpireTimeInMS);
                } else if (this.hostConfigManager.isExcluded((DatanodeID)node)) {
                    this.datanodeAdminManager.startDecommission(node);
                } else {
                    this.datanodeAdminManager.stopMaintenance(node);
                    this.datanodeAdminManager.stopDecommission(node);
                }
            }
            node.setUpgradeDomain(this.hostConfigManager.getUpgradeDomain((DatanodeID)node));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLiveDataNodes() {
        int numLive = 0;
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                if (this.isDatanodeDead(dn)) continue;
                ++numLive;
            }
        }
        return numLive;
    }

    public int getNumDeadDataNodes() {
        return this.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumOfDataNodes() {
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            return this.datanodeMap.size();
        }
    }

    public List<DatanodeDescriptor> getDecommissioningNodes() {
        return this.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DECOMMISSIONING);
    }

    public List<DatanodeDescriptor> getEnteringMaintenanceNodes() {
        return this.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ENTERING_MAINTENANCE);
    }

    public boolean shouldAvoidStaleDataNodesForWrite() {
        return this.avoidStaleDataNodesForWrite && (float)this.numStaleNodes <= (float)this.heartbeatManager.getLiveDatanodeCount() * this.ratioUseStaleDataNodesForWrite;
    }

    public long getBlocksPerPostponedMisreplicatedBlocksRescan() {
        return this.blocksPerPostponedMisreplicatedBlocksRescan;
    }

    long getStaleInterval() {
        return this.staleInterval;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatIntervalSeconds;
    }

    public long getHeartbeatRecheckInterval() {
        return this.heartbeatRecheckInterval;
    }

    void setNumStaleNodes(int numStaleNodes) {
        this.numStaleNodes = numStaleNodes;
    }

    public int getNumStaleNodes() {
        return this.numStaleNodes;
    }

    public int getNumStaleStorages() {
        return this.numStaleStorages;
    }

    void setNumStaleStorages(int numStaleStorages) {
        this.numStaleStorages = numStaleStorages;
    }

    public void fetchDatanodes(List<DatanodeDescriptor> live, List<DatanodeDescriptor> dead, boolean removeDecommissionNode) {
        if (live == null && dead == null) {
            throw new HadoopIllegalArgumentException("Both live and dead lists are null");
        }
        List<DatanodeDescriptor> results = this.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        for (DatanodeDescriptor node : results) {
            if (this.isDatanodeDead(node)) {
                if (dead == null) continue;
                dead.add(node);
                continue;
            }
            if (live == null) continue;
            live.add(node);
        }
        if (removeDecommissionNode) {
            if (live != null) {
                DatanodeManager.removeDecomNodeFromList(live);
            }
            if (dead != null) {
                DatanodeManager.removeDecomNodeFromList(dead);
            }
        }
    }

    @VisibleForTesting
    void checkIfClusterIsNowMultiRack(DatanodeDescriptor node) {
        if (!this.hasClusterEverBeenMultiRack && this.networktopology.getNumOfRacks() > 1) {
            String message = "DN " + (Object)((Object)node) + " joining cluster has expanded a formerly single-rack cluster to be multi-rack. ";
            if (this.blockManager.isPopulatingReplQueues()) {
                message = message + "Re-checking all blocks for replication, since they should now be replicated cross-rack";
                LOG.info(message);
            } else {
                message = message + "Not checking for mis-replicated blocks because this NN is not yet processing repl queues.";
                LOG.debug(message);
            }
            this.hasClusterEverBeenMultiRack = true;
            if (this.blockManager.isPopulatingReplQueues()) {
                this.blockManager.processMisReplicatedBlocks();
            }
        }
    }

    private DatanodeID parseDNFromHostsEntry(String hostLine) {
        DatanodeID dnId;
        int port;
        String hostStr;
        int idx = hostLine.indexOf(58);
        if (-1 == idx) {
            hostStr = hostLine;
            port = 9866;
        } else {
            hostStr = hostLine.substring(0, idx);
            port = Integer.parseInt(hostLine.substring(idx + 1));
        }
        if (InetAddresses.isInetAddress((String)hostStr)) {
            dnId = new DatanodeID(hostStr, "", "", port, 9864, 9865, 9867);
        } else {
            String ipAddr = "";
            try {
                ipAddr = InetAddress.getByName(hostStr).getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.warn("Invalid hostname " + hostStr + " in hosts file");
            }
            dnId = new DatanodeID(ipAddr, hostStr, "", port, 9864, 9865, 9867);
        }
        return dnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DatanodeDescriptor> getDatanodeListForReport(HdfsConstants.DatanodeReportType type) {
        ArrayList<DatanodeDescriptor> nodes;
        boolean listLiveNodes = type == HdfsConstants.DatanodeReportType.ALL || type == HdfsConstants.DatanodeReportType.LIVE;
        boolean listDeadNodes = type == HdfsConstants.DatanodeReportType.ALL || type == HdfsConstants.DatanodeReportType.DEAD;
        boolean listDecommissioningNodes = type == HdfsConstants.DatanodeReportType.ALL || type == HdfsConstants.DatanodeReportType.DECOMMISSIONING;
        boolean listEnteringMaintenanceNodes = type == HdfsConstants.DatanodeReportType.ALL || type == HdfsConstants.DatanodeReportType.ENTERING_MAINTENANCE;
        boolean listInMaintenanceNodes = type == HdfsConstants.DatanodeReportType.ALL || type == HdfsConstants.DatanodeReportType.IN_MAINTENANCE;
        HostSet foundNodes = new HostSet();
        Iterable<InetSocketAddress> includedNodes = this.hostConfigManager.getIncludes();
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            nodes = new ArrayList<DatanodeDescriptor>(this.datanodeMap.size());
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                boolean isDead = this.isDatanodeDead(dn);
                boolean isDecommissioning = dn.isDecommissionInProgress();
                boolean isEnteringMaintenance = dn.isEnteringMaintenance();
                boolean isInMaintenance = dn.isInMaintenance();
                if ((listLiveNodes && !isDead || listDeadNodes && isDead || listDecommissioningNodes && isDecommissioning || listEnteringMaintenanceNodes && isEnteringMaintenance || listInMaintenanceNodes && isInMaintenance) && this.hostConfigManager.isIncluded((DatanodeID)dn)) {
                    nodes.add(dn);
                }
                foundNodes.add(dn.getResolvedAddress());
            }
        }
        Collections.sort(nodes);
        if (listDeadNodes) {
            for (InetSocketAddress addr : includedNodes) {
                DatanodeDescriptor dn;
                if (foundNodes.matchedBy(addr)) continue;
                dn = new DatanodeDescriptor(new DatanodeID(addr.getAddress().getHostAddress(), addr.getHostName(), "", addr.getPort() == 0 ? this.defaultXferPort : addr.getPort(), this.defaultInfoPort, this.defaultInfoSecurePort, this.defaultIpcPort));
                this.setDatanodeDead(dn);
                if (this.hostConfigManager.isExcluded((DatanodeID)dn)) {
                    dn.setDecommissioned();
                }
                nodes.add(dn);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getDatanodeListForReport with includedNodes = " + this.hostConfigManager.getIncludes() + ", excludedNodes = " + this.hostConfigManager.getExcludes() + ", foundNodes = " + foundNodes + ", nodes = " + nodes);
        }
        return nodes;
    }

    private static boolean isNameResolved(InetAddress address) {
        String ip;
        String hostname = address.getHostName();
        return !hostname.equals(ip = address.getHostAddress()) || NetUtils.isLocalAddress((InetAddress)address);
    }

    private void setDatanodeDead(DatanodeDescriptor node) {
        node.setLastUpdate(0L);
        node.setLastUpdateMonotonic(0L);
    }

    private BlockRecoveryCommand getBlockRecoveryCommand(String blockPoolId, DatanodeDescriptor nodeinfo) throws IOException {
        BlockInfo[] blocks = nodeinfo.getLeaseRecoveryCommand(Integer.MAX_VALUE);
        if (blocks == null) {
            return null;
        }
        BlockRecoveryCommand brCommand = new BlockRecoveryCommand(blocks.length);
        for (BlockInfo b : blocks) {
            BlockRecoveryCommand.RecoveringBlock rBlock;
            DatanodeInfo[] recoveryInfos;
            ExtendedBlock primaryBlock;
            BlockUnderConstructionFeature uc = b.getUnderConstructionFeature();
            if (uc == null) {
                throw new IOException("Recovery block " + (Object)((Object)b) + "where it is not under construction.");
            }
            DatanodeStorageInfo[] storages = uc.getExpectedStorageLocations();
            ArrayList<DatanodeStorageInfo> recoveryLocations = new ArrayList<DatanodeStorageInfo>(storages.length);
            for (DatanodeStorageInfo storage : storages) {
                if (storage.getDatanodeDescriptor().isStale(this.staleInterval)) continue;
                recoveryLocations.add(storage);
            }
            boolean truncateRecovery = uc.getTruncateBlock() != null;
            boolean copyOnTruncateRecovery = truncateRecovery && uc.getTruncateBlock().getBlockId() != b.getBlockId();
            ExtendedBlock extendedBlock = primaryBlock = copyOnTruncateRecovery ? new ExtendedBlock(blockPoolId, (Block)uc.getTruncateBlock()) : new ExtendedBlock(blockPoolId, (Block)b);
            if (recoveryLocations.size() > 1) {
                if (recoveryLocations.size() != storages.length) {
                    LOG.info("Skipped stale nodes for recovery : " + (storages.length - recoveryLocations.size()));
                }
                recoveryInfos = DatanodeStorageInfo.toDatanodeInfos(recoveryLocations);
            } else {
                recoveryInfos = DatanodeStorageInfo.toDatanodeInfos(storages);
            }
            if (truncateRecovery) {
                BlockInfo recoveryBlock = copyOnTruncateRecovery ? b : uc.getTruncateBlock();
                rBlock = new BlockRecoveryCommand.RecoveringBlock(primaryBlock, recoveryInfos, recoveryBlock);
            } else {
                rBlock = new BlockRecoveryCommand.RecoveringBlock(primaryBlock, recoveryInfos, uc.getBlockRecoveryId());
                if (b.isStriped()) {
                    rBlock = new BlockRecoveryCommand.RecoveringStripedBlock(rBlock, uc.getBlockIndices(), ((BlockInfoStriped)b).getErasureCodingPolicy());
                }
            }
            brCommand.add(rBlock);
        }
        return brCommand;
    }

    private void addCacheCommands(String blockPoolId, DatanodeDescriptor nodeinfo, List<DatanodeCommand> cmds) {
        boolean sendingCachingCommands = false;
        long nowMs = Time.monotonicNow();
        if (this.shouldSendCachingCommands && nowMs - nodeinfo.getLastCachingDirectiveSentTimeMs() >= this.timeBetweenResendingCachingDirectivesMs) {
            DatanodeCommand pendingUncacheCommand;
            DatanodeCommand pendingCacheCommand = this.getCacheCommand(nodeinfo.getPendingCached(), 9, blockPoolId);
            if (pendingCacheCommand != null) {
                cmds.add(pendingCacheCommand);
                sendingCachingCommands = true;
            }
            if ((pendingUncacheCommand = this.getCacheCommand(nodeinfo.getPendingUncached(), 10, blockPoolId)) != null) {
                cmds.add(pendingUncacheCommand);
                sendingCachingCommands = true;
            }
            if (sendingCachingCommands) {
                nodeinfo.setLastCachingDirectiveSentTimeMs(nowMs);
            }
        }
    }

    public DatanodeCommand[] handleHeartbeat(DatanodeRegistration nodeReg, StorageReport[] reports, String blockPoolId, long cacheCapacity, long cacheUsed, int xceiverCount, int maxTransfers, int failedVolumes, VolumeFailureSummary volumeFailureSummary, @Nonnull SlowPeerReports slowPeers, @Nonnull SlowDiskReports slowDisks) throws IOException {
        Map slowPeersMap;
        Block[] blks;
        int totalECBlocks;
        DatanodeDescriptor nodeinfo;
        try {
            nodeinfo = this.getDatanode(nodeReg);
        }
        catch (UnregisteredNodeException e) {
            return new DatanodeCommand[]{RegisterCommand.REGISTER};
        }
        if (nodeinfo != null && nodeinfo.isDisallowed()) {
            this.setDatanodeDead(nodeinfo);
            throw new DisallowedDatanodeException((DatanodeID)nodeinfo);
        }
        if (nodeinfo == null || !nodeinfo.isRegistered()) {
            return new DatanodeCommand[]{RegisterCommand.REGISTER};
        }
        this.heartbeatManager.updateHeartbeat(nodeinfo, reports, cacheCapacity, cacheUsed, xceiverCount, failedVolumes, volumeFailureSummary);
        if (this.namesystem.isInSafeMode()) {
            return new DatanodeCommand[0];
        }
        BlockRecoveryCommand brCommand = this.getBlockRecoveryCommand(blockPoolId, nodeinfo);
        if (brCommand != null) {
            return new DatanodeCommand[]{brCommand};
        }
        ArrayList<DatanodeCommand> cmds = new ArrayList<DatanodeCommand>();
        int totalReplicateBlocks = nodeinfo.getNumberOfReplicateBlocks();
        int totalBlocks = totalReplicateBlocks + (totalECBlocks = nodeinfo.getNumberOfBlocksToBeErasureCoded());
        if (totalBlocks > 0) {
            List<BlockECReconstructionCommand.BlockECReconstructionInfo> pendingECList;
            List<DatanodeDescriptor.BlockTargetPair> pendingList;
            int numReplicationTasks = (int)Math.ceil((double)(totalReplicateBlocks * maxTransfers) / (double)totalBlocks);
            int numECTasks = (int)Math.ceil((double)(totalECBlocks * maxTransfers) / (double)totalBlocks);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pending replication tasks: " + numReplicationTasks + " erasure-coded tasks: " + numECTasks);
            }
            if ((pendingList = nodeinfo.getReplicationCommand(numReplicationTasks)) != null && !pendingList.isEmpty()) {
                Iterator<DatanodeDescriptor.BlockTargetPair> iterator = pendingList.iterator();
                while (iterator.hasNext()) {
                    DatanodeDescriptor.BlockTargetPair cmd = iterator.next();
                    if (cmd.block == null || cmd.block.getNumBytes() != Long.MAX_VALUE) continue;
                    DatanodeStorageInfo.decrementBlocksScheduled(cmd.targets);
                    iterator.remove();
                }
                if (!pendingList.isEmpty()) {
                    cmds.add(new BlockCommand(1, blockPoolId, pendingList));
                }
            }
            if ((pendingECList = nodeinfo.getErasureCodeCommand(numECTasks)) != null && !pendingECList.isEmpty()) {
                cmds.add(new BlockECReconstructionCommand(11, pendingECList));
            }
        }
        if ((blks = nodeinfo.getInvalidateBlocks(this.blockInvalidateLimit)) != null) {
            cmds.add(new BlockCommand(2, blockPoolId, blks));
        }
        this.addCacheCommands(blockPoolId, nodeinfo, cmds);
        this.blockManager.addKeyUpdateCommand(cmds, nodeinfo);
        if (nodeinfo.getBalancerBandwidth() > 0L) {
            cmds.add(new BalancerBandwidthCommand(nodeinfo.getBalancerBandwidth()));
            nodeinfo.setBalancerBandwidth(0L);
        }
        if (this.slowPeerTracker != null && !(slowPeersMap = slowPeers.getSlowPeers()).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DataNode " + nodeReg + " reported slow peers: " + slowPeersMap);
            }
            for (String slowNodeId : slowPeersMap.keySet()) {
                this.slowPeerTracker.addReport(slowNodeId, nodeReg.getIpcAddr(false));
            }
        }
        if (this.slowDiskTracker != null) {
            if (!slowDisks.getSlowDisks().isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DataNode " + nodeReg + " reported slow disks: " + slowDisks.getSlowDisks());
                }
                this.slowDiskTracker.addSlowDiskReport(nodeReg.getIpcAddr(false), slowDisks);
            }
            this.slowDiskTracker.checkAndUpdateReportIfNecessary();
        }
        if (!cmds.isEmpty()) {
            return cmds.toArray(new DatanodeCommand[cmds.size()]);
        }
        return new DatanodeCommand[0];
    }

    public void handleLifeline(DatanodeRegistration nodeReg, StorageReport[] reports, String blockPoolId, long cacheCapacity, long cacheUsed, int xceiverCount, int maxTransfers, int failedVolumes, VolumeFailureSummary volumeFailureSummary) throws IOException {
        DatanodeDescriptor nodeinfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received handleLifeline from nodeReg = " + nodeReg);
        }
        if ((nodeinfo = this.getDatanode(nodeReg)) == null || !nodeinfo.isRegistered()) {
            return;
        }
        if (nodeinfo.isDisallowed()) {
            return;
        }
        this.heartbeatManager.updateLifeline(nodeinfo, reports, cacheCapacity, cacheUsed, xceiverCount, failedVolumes, volumeFailureSummary);
    }

    private DatanodeCommand getCacheCommand(DatanodeDescriptor.CachedBlocksList list, int action, String poolId) {
        int length = list.size();
        if (length == 0) {
            return null;
        }
        long[] blockIds = new long[length];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CachedBlock cachedBlock = (CachedBlock)iterator.next();
            blockIds[i++] = cachedBlock.getBlockId();
        }
        return new BlockIdCommand(action, poolId, blockIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            for (DatanodeDescriptor nodeInfo : this.datanodeMap.values()) {
                nodeInfo.setBalancerBandwidth(bandwidth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllDatanodesStale() {
        LOG.info("Marking all datanodes as stale");
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
                    storage.markStaleAfterFailover();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingQueues() {
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                dn.clearBlockQueues();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLastCachingDirectiveSentTime() {
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                dn.setLastCachingDirectiveSentTimeMs(0L);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.host2DatanodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingCachingCommands() {
        DatanodeManager datanodeManager = this;
        synchronized (datanodeManager) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                dn.getPendingCached().clear();
                dn.getPendingUncached().clear();
            }
        }
    }

    public void setShouldSendCachingCommands(boolean shouldSendCachingCommands) {
        this.shouldSendCachingCommands = shouldSendCachingCommands;
    }

    FSClusterStats newFSClusterStats() {
        return new FSClusterStats(){

            @Override
            public int getTotalLoad() {
                return DatanodeManager.this.heartbeatManager.getXceiverCount();
            }

            @Override
            public boolean isAvoidingStaleDataNodesForWrite() {
                return DatanodeManager.this.shouldAvoidStaleDataNodesForWrite();
            }

            @Override
            public int getNumDatanodesInService() {
                return DatanodeManager.this.heartbeatManager.getNumDatanodesInService();
            }

            @Override
            public double getInServiceXceiverAverage() {
                double avgLoad = 0.0;
                int nodes = this.getNumDatanodesInService();
                if (nodes != 0) {
                    int xceivers = DatanodeManager.this.heartbeatManager.getInServiceXceiverCount();
                    avgLoad = (double)xceivers / (double)nodes;
                }
                return avgLoad;
            }

            @Override
            public Map<StorageType, StorageTypeStats> getStorageTypeStats() {
                return DatanodeManager.this.heartbeatManager.getStorageTypeStats();
            }
        };
    }

    public void setHeartbeatInterval(long intervalSeconds) {
        this.setHeartbeatInterval(intervalSeconds, this.heartbeatRecheckInterval);
    }

    public void setHeartbeatRecheckInterval(int recheckInterval) {
        this.setHeartbeatInterval(this.heartbeatIntervalSeconds, recheckInterval);
    }

    private void setHeartbeatInterval(long intervalSeconds, int recheckInterval) {
        this.heartbeatIntervalSeconds = intervalSeconds;
        this.heartbeatRecheckInterval = recheckInterval;
        this.heartbeatExpireInterval = 2L * (long)recheckInterval + 10000L * intervalSeconds;
        this.blockInvalidateLimit = Math.max(20 * (int)intervalSeconds, this.blockInvalidateLimit);
    }

    public String getSlowPeersReport() {
        return this.slowPeerTracker != null ? this.slowPeerTracker.getJson() : null;
    }

    public Set<Node> getSlowPeers() {
        Set slowPeersSet = Sets.newConcurrentHashSet();
        if (this.slowPeerTracker == null) {
            return slowPeersSet;
        }
        ArrayList<String> slowNodes = this.slowPeerTracker.getSlowNodes(this.maxSlowPeerReportNodes);
        for (String slowNode : slowNodes) {
            String ipAddr;
            DatanodeDescriptor datanodeByHost;
            if (StringUtils.isBlank((CharSequence)slowNode) || !slowNode.contains(IP_PORT_SEPARATOR) || (datanodeByHost = this.host2DatanodeMap.getDatanodeByHost(ipAddr = slowNode.split(IP_PORT_SEPARATOR)[0])) == null) continue;
            slowPeersSet.add(datanodeByHost);
        }
        return slowPeersSet;
    }

    public static Set<Node> getSlowNodes() {
        return slowNodesSet;
    }

    @VisibleForTesting
    public SlowPeerTracker getSlowPeerTracker() {
        return this.slowPeerTracker;
    }

    @VisibleForTesting
    public SlowDiskTracker getSlowDiskTracker() {
        return this.slowDiskTracker;
    }

    public String getSlowDisksReport() {
        return this.slowDiskTracker != null ? this.slowDiskTracker.getSlowDiskReportAsJsonString() : null;
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) {
        List<DatanodeDescriptor> datanodes = this.getDatanodeListForReport(type);
        DatanodeStorageReport[] reports = new DatanodeStorageReport[datanodes.size()];
        for (int i = 0; i < reports.length; ++i) {
            DatanodeDescriptor d = datanodes.get(i);
            reports[i] = new DatanodeStorageReport(new DatanodeInfo.DatanodeInfoBuilder().setFrom((DatanodeInfo)d).build(), d.getStorageReports());
        }
        return reports;
    }
}

