/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core.spi.store;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.org.ehcache.Cache;
import org.apache.hadoop.shaded.org.ehcache.ValueSupplier;
import org.apache.hadoop.shaded.org.ehcache.config.EvictionAdvisor;
import org.apache.hadoop.shaded.org.ehcache.config.ResourcePools;
import org.apache.hadoop.shaded.org.ehcache.config.ResourceType;
import org.apache.hadoop.shaded.org.ehcache.core.spi.function.BiFunction;
import org.apache.hadoop.shaded.org.ehcache.core.spi.function.Function;
import org.apache.hadoop.shaded.org.ehcache.core.spi.function.NullaryFunction;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.ConfigurationChangeSupport;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.StoreAccessException;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.events.StoreEventSource;
import org.apache.hadoop.shaded.org.ehcache.expiry.Expiry;
import org.apache.hadoop.shaded.org.ehcache.spi.serialization.Serializer;
import org.apache.hadoop.shaded.org.ehcache.spi.service.PluralService;
import org.apache.hadoop.shaded.org.ehcache.spi.service.Service;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;

public interface Store<K, V>
extends ConfigurationChangeSupport {
    public ValueHolder<V> get(K var1) throws StoreAccessException;

    public boolean containsKey(K var1) throws StoreAccessException;

    public PutStatus put(K var1, V var2) throws StoreAccessException;

    public ValueHolder<V> putIfAbsent(K var1, V var2) throws StoreAccessException;

    public boolean remove(K var1) throws StoreAccessException;

    public RemoveStatus remove(K var1, V var2) throws StoreAccessException;

    public ValueHolder<V> replace(K var1, V var2) throws StoreAccessException;

    public ReplaceStatus replace(K var1, V var2, V var3) throws StoreAccessException;

    public void clear() throws StoreAccessException;

    public StoreEventSource<K, V> getStoreEventSource();

    public Iterator<Cache.Entry<K, ValueHolder<V>>> iterator();

    public ValueHolder<V> compute(K var1, BiFunction<? super K, ? super V, ? extends V> var2) throws StoreAccessException;

    public ValueHolder<V> compute(K var1, BiFunction<? super K, ? super V, ? extends V> var2, NullaryFunction<Boolean> var3) throws StoreAccessException;

    public ValueHolder<V> computeIfAbsent(K var1, Function<? super K, ? extends V> var2) throws StoreAccessException;

    public Map<K, ValueHolder<V>> bulkCompute(Set<? extends K> var1, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> var2) throws StoreAccessException;

    public Map<K, ValueHolder<V>> bulkCompute(Set<? extends K> var1, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> var2, NullaryFunction<Boolean> var3) throws StoreAccessException;

    public Map<K, ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> var1, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> var2) throws StoreAccessException;

    public static enum ReplaceStatus {
        HIT,
        MISS_PRESENT,
        MISS_NOT_PRESENT;

    }

    public static enum RemoveStatus {
        REMOVED,
        KEY_PRESENT,
        KEY_MISSING;

    }

    public static enum PutStatus {
        PUT,
        UPDATE,
        NOOP;

    }

    public static interface Iterator<T> {
        public boolean hasNext();

        public T next() throws StoreAccessException;
    }

    public static interface Configuration<K, V> {
        public Class<K> getKeyType();

        public Class<V> getValueType();

        public EvictionAdvisor<? super K, ? super V> getEvictionAdvisor();

        public ClassLoader getClassLoader();

        public Expiry<? super K, ? super V> getExpiry();

        public ResourcePools getResourcePools();

        public Serializer<K> getKeySerializer();

        public Serializer<V> getValueSerializer();

        public int getDispatcherConcurrency();
    }

    @PluralService
    public static interface Provider
    extends Service {
        public <K, V> Store<K, V> createStore(Configuration<K, V> var1, ServiceConfiguration<?> ... var2);

        public void releaseStore(Store<?, ?> var1);

        public void initStore(Store<?, ?> var1);

        public int rank(Set<ResourceType<?>> var1, Collection<ServiceConfiguration<?>> var2);
    }

    public static interface ValueHolder<V>
    extends ValueSupplier<V> {
        public static final long NO_EXPIRE = -1L;

        public long creationTime(TimeUnit var1);

        public long expirationTime(TimeUnit var1);

        public boolean isExpired(long var1, TimeUnit var3);

        public long lastAccessTime(TimeUnit var1);

        public float hitRate(long var1, TimeUnit var3);

        public long hits();

        public long getId();
    }
}

