/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;

class DelegatingInvocationHandler<T>
implements InvocationHandler {
    private volatile boolean initialized;
    private T delegate;

    DelegatingInvocationHandler() {
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Preconditions.checkState((boolean)this.initialized, (Object)"This is a proxy used to support circular references. The object we're proxying is not constructed yet. Please wait until after injection has completed to use this object.");
            Preconditions.checkNotNull(this.delegate, (Object)"This is a proxy used to support circular references. The object we're  proxying is initialized to null. No methods can be called.");
            return method.invoke(this.delegate, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    void setDelegate(T delegate) {
        this.delegate = delegate;
        this.initialized = true;
    }
}

