/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.datamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"sortedQueue", "volumeCount", "idealUsed"})
public class DiskBalancerVolumeSet {
    private static final Logger LOG = LoggerFactory.getLogger(DiskBalancerVolumeSet.class);
    private final int maxDisks = 256;
    @JsonProperty(value="transient")
    private boolean isTransient;
    private Set<DiskBalancerVolume> volumes;
    @JsonIgnore
    private TreeSet<DiskBalancerVolume> sortedQueue;
    private String storageType;
    private String setID;
    private double idealUsed;

    public DiskBalancerVolumeSet() {
        this.setID = UUID.randomUUID().toString();
    }

    public DiskBalancerVolumeSet(boolean isTransient) {
        this.isTransient = isTransient;
        this.volumes = new HashSet<DiskBalancerVolume>(256);
        this.sortedQueue = new TreeSet<DiskBalancerVolume>(new MinHeap());
        this.storageType = null;
        this.setID = UUID.randomUUID().toString();
    }

    public DiskBalancerVolumeSet(DiskBalancerVolumeSet volumeSet) {
        this.isTransient = volumeSet.isTransient();
        this.storageType = volumeSet.storageType;
        this.volumes = new HashSet<DiskBalancerVolume>(volumeSet.volumes);
        this.sortedQueue = new TreeSet<DiskBalancerVolume>(new MinHeap());
        this.setID = UUID.randomUUID().toString();
    }

    @JsonProperty(value="transient")
    public boolean isTransient() {
        return this.isTransient;
    }

    @JsonProperty(value="transient")
    public void setTransient(boolean transientValue) {
        this.isTransient = transientValue;
    }

    public void computeVolumeDataDensity() {
        long totalCapacity = 0L;
        long totalUsed = 0L;
        this.sortedQueue.clear();
        for (DiskBalancerVolume volume : this.volumes) {
            if (volume.isFailed() || volume.isSkip()) continue;
            if (volume.computeEffectiveCapacity() < 0L) {
                this.skipMisConfiguredVolume(volume);
                continue;
            }
            totalCapacity += volume.computeEffectiveCapacity();
            totalUsed += volume.getUsed();
        }
        if (totalCapacity != 0L) {
            this.idealUsed = this.truncateDecimals((double)totalUsed / (double)totalCapacity);
        }
        for (DiskBalancerVolume volume : this.volumes) {
            if (volume.isFailed() || volume.isSkip()) continue;
            double dfsUsedRatio = this.truncateDecimals((double)volume.getUsed() / (double)volume.computeEffectiveCapacity());
            volume.setVolumeDataDensity(this.idealUsed - dfsUsedRatio);
            this.sortedQueue.add(volume);
        }
    }

    private double truncateDecimals(double value) {
        int multiplier = 10000;
        return (double)((long)(value * 10000.0)) / 10000.0;
    }

    private void skipMisConfiguredVolume(DiskBalancerVolume volume) {
        String errMessage = String.format("Real capacity is negative.This usually points to some kind of mis-configuration.%nCapacity : %d Reserved : %d realCap = capacity - reserved = %d.%nSkipping this volume from all processing. type : %s id :%s", volume.getCapacity(), volume.getReserved(), volume.computeEffectiveCapacity(), volume.getStorageType(), volume.getUuid());
        LOG.error(errMessage);
        volume.setSkip(true);
    }

    @JsonIgnore
    public int getVolumeCount() {
        return this.volumes.size();
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String typeOfStorage) {
        this.storageType = typeOfStorage;
    }

    public void addVolume(DiskBalancerVolume volume) throws Exception {
        Preconditions.checkNotNull((Object)volume, (Object)"volume cannot be null");
        Preconditions.checkState((this.isTransient() == volume.isTransient() ? 1 : 0) != 0, (Object)"Mismatch in volumeSet and volume's transient properties.");
        if (this.storageType == null) {
            Preconditions.checkState(((long)this.volumes.size() == 0L ? 1 : 0) != 0, (Object)("Storage Type is Null but volume size is " + this.volumes.size()));
            this.storageType = volume.getStorageType();
        } else {
            Preconditions.checkState((boolean)this.storageType.equals(volume.getStorageType()), (Object)"Adding wrong type of disk to this volume set");
        }
        this.volumes.add(volume);
        this.computeVolumeDataDensity();
    }

    public List<DiskBalancerVolume> getVolumes() {
        return new ArrayList<DiskBalancerVolume>(this.volumes);
    }

    @JsonIgnore
    public TreeSet<DiskBalancerVolume> getSortedQueue() {
        return this.sortedQueue;
    }

    public boolean isBalancingNeeded(double thresholdPercentage) {
        double threshold = thresholdPercentage / 100.0;
        if (this.volumes == null || this.volumes.size() <= 1) {
            return false;
        }
        for (DiskBalancerVolume vol : this.volumes) {
            boolean notSkip;
            boolean bl = notSkip = !vol.isFailed() && !vol.isTransient() && !vol.isSkip();
            Double absDensity = this.truncateDecimals(Math.abs(vol.getVolumeDataDensity()));
            if (!(absDensity > threshold) || !notSkip) continue;
            return true;
        }
        return false;
    }

    public void removeVolume(DiskBalancerVolume volume) {
        this.volumes.remove(volume);
        this.sortedQueue.remove(volume);
    }

    public String getSetID() {
        return this.setID;
    }

    public void setSetID(String volID) {
        this.setID = volID;
    }

    @JsonIgnore
    public double getIdealUsed() {
        return this.idealUsed;
    }

    static class MinHeap
    implements Comparator<DiskBalancerVolume>,
    Serializable {
        MinHeap() {
        }

        @Override
        public int compare(DiskBalancerVolume first, DiskBalancerVolume second) {
            return Double.compare(second.getVolumeDataDensity(), first.getVolumeDataDensity());
        }
    }
}

