/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.streams;

import java.io.IOException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.GrizzlyFuture;
import org.apache.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Transformer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.Attribute;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.CompositeBuffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.MemoryManager;
import org.apache.hadoop.shaded.org.glassfish.grizzly.streams.BufferedOutput;
import org.apache.hadoop.shaded.org.glassfish.grizzly.streams.Output;

public class TransformerOutput
extends BufferedOutput {
    private final Attribute<CompositeBuffer> outputBufferAttr;
    protected final Transformer<Buffer, Buffer> transformer;
    protected final Output underlyingOutput;
    protected final MemoryManager memoryManager;
    protected final AttributeStorage attributeStorage;

    public TransformerOutput(Transformer<Buffer, Buffer> transformer, Output underlyingOutput, Connection connection) {
        this(transformer, underlyingOutput, connection.getTransport().getMemoryManager(), connection);
    }

    public TransformerOutput(Transformer<Buffer, Buffer> transformer, Output underlyingOutput, MemoryManager memoryManager, AttributeStorage attributeStorage) {
        this.transformer = transformer;
        this.underlyingOutput = underlyingOutput;
        this.memoryManager = memoryManager;
        this.attributeStorage = attributeStorage;
        this.outputBufferAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("TransformerOutput-" + transformer.getName());
    }

    @Override
    protected GrizzlyFuture<Integer> flush0(Buffer buffer, CompletionHandler<Integer> completionHandler) throws IOException {
        if (buffer != null) {
            CompositeBuffer savedBuffer = this.outputBufferAttr.get(this.attributeStorage);
            if (savedBuffer != null) {
                savedBuffer.append(buffer);
                buffer = savedBuffer;
            }
            do {
                TransformationResult<Buffer, Buffer> result;
                TransformationResult.Status status;
                if ((status = (result = this.transformer.transform(this.attributeStorage, buffer)).getStatus()) == TransformationResult.Status.COMPLETE) {
                    Buffer outputBuffer = result.getMessage();
                    this.underlyingOutput.write(outputBuffer);
                    this.transformer.release(this.attributeStorage);
                    continue;
                }
                if (status == TransformationResult.Status.INCOMPLETE) {
                    buffer.compact();
                    if (!buffer.isComposite()) {
                        buffer = CompositeBuffer.newBuffer(this.memoryManager, buffer);
                    }
                    this.outputBufferAttr.set(this.attributeStorage, (CompositeBuffer)buffer);
                    return ReadyFutureImpl.create(new IllegalStateException("Can not flush data: Insufficient input data for transformer"));
                }
                if (status != TransformationResult.Status.ERROR) continue;
                this.transformer.release(this.attributeStorage);
                throw new IOException("Transformation exception: " + result.getErrorDescription());
            } while (buffer.hasRemaining());
            return this.underlyingOutput.flush(completionHandler);
        }
        return ZERO_READY_FUTURE;
    }

    @Override
    protected Buffer newBuffer(int size) {
        return this.memoryManager.allocate(size);
    }

    @Override
    protected Buffer reallocateBuffer(Buffer oldBuffer, int size) {
        return this.memoryManager.reallocate(oldBuffer, size);
    }

    @Override
    protected void onClosed() throws IOException {
    }
}

