/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.DataWriter;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppendOp
extends Operation {
    private static final Logger LOG = LoggerFactory.getLogger(AppendOp.class);

    AppendOp(ConfigExtractor cfg, Random rnd) {
        super(AppendOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getAppendFile() {
        Path fn = this.getFinder().getFile();
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OperationOutput> run(FileSystem fs) {
        List<OperationOutput> out = super.run(fs);
        OutputStream os = null;
        try {
            Path fn = this.getAppendFile();
            Range<Long> appendSizeRange = this.getConfig().getAppendSize();
            if (this.getConfig().shouldAppendUseBlockSize()) {
                appendSizeRange = this.getConfig().getBlockSize();
            }
            long appendSize = Range.betweenPositive(this.getRandom(), appendSizeRange);
            long timeTaken = 0L;
            long bytesAppended = 0L;
            DataWriter writer = new DataWriter(this.getRandom());
            LOG.info("Attempting to append to file at " + fn + " of size " + Helper.toByteInfo(appendSize));
            long startTime = Timer.now();
            os = fs.append(fn);
            timeTaken += Timer.elapsed(startTime);
            DataWriter.GenerateOutput stats = writer.writeSegment(appendSize, os);
            timeTaken += stats.getTimeTaken();
            startTime = Timer.now();
            os.close();
            os = null;
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "bytes_written", bytesAppended += stats.getBytesWritten()));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", timeTaken += Timer.elapsed(startTime)));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", 1L));
            LOG.info("Appended " + Helper.toByteInfo(bytesAppended) + " to file " + fn + " in " + timeTaken + " milliseconds");
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", 1L));
            LOG.warn("Error with appending", (Throwable)e);
        }
        catch (IOException | UnsupportedOperationException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
            LOG.warn("Error with appending", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.warn("Error with closing append stream", (Throwable)e);
                }
            }
        }
        return out;
    }
}

